/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.ConnectionNotification;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse;

public class DescribeVpcEndpointConnectionNotificationsPublisher
implements SdkPublisher<DescribeVpcEndpointConnectionNotificationsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVpcEndpointConnectionNotificationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVpcEndpointConnectionNotificationsPublisher(Ec2AsyncClient client, DescribeVpcEndpointConnectionNotificationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVpcEndpointConnectionNotificationsPublisher(Ec2AsyncClient client, DescribeVpcEndpointConnectionNotificationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVpcEndpointConnectionNotificationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVpcEndpointConnectionNotificationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConnectionNotification> connectionNotificationSet() {
        Function<DescribeVpcEndpointConnectionNotificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectionNotificationSet() != null) {
                return response.connectionNotificationSet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeVpcEndpointConnectionNotificationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeVpcEndpointConnectionNotificationsResponseFetcher
    implements AsyncPageFetcher<DescribeVpcEndpointConnectionNotificationsResponse> {
        private DescribeVpcEndpointConnectionNotificationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcEndpointConnectionNotificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVpcEndpointConnectionNotificationsResponse> nextPage(DescribeVpcEndpointConnectionNotificationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcEndpointConnectionNotificationsPublisher.this.client.describeVpcEndpointConnectionNotifications(DescribeVpcEndpointConnectionNotificationsPublisher.this.firstRequest);
            }
            return DescribeVpcEndpointConnectionNotificationsPublisher.this.client.describeVpcEndpointConnectionNotifications((DescribeVpcEndpointConnectionNotificationsRequest)((Object)DescribeVpcEndpointConnectionNotificationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

