function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { defaultsDeep } from 'lodash';
import ace from 'brace';
import 'brace/mode/json';
import { OpenSearchSqlHighlightRules } from './opensearch_sql_highlight_rules';
import { ScriptHighlightRules } from './script_highlight_rules';
const {
  JsonHighlightRules
} = ace.acequire('ace/mode/json_highlight_rules');
const oop = ace.acequire('ace/lib/oop');
const jsonRules = function (root) {
  root = root ? root : 'json';
  const rules = {};
  const xJsonRules = [{
    token: ['variable', 'whitespace', 'ace.punctuation.colon', 'whitespace', 'punctuation.start_triple_quote'],
    regex: '("(?:[^"]*_)?script"|"inline"|"source")(\\s*?)(:)(\\s*?)(""")',
    next: 'script-start',
    merge: false,
    push: true
  }, {
    token: 'variable',
    // single line
    regex: '["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'
  }, {
    token: 'punctuation.start_triple_quote',
    regex: '"""',
    next: 'string_literal',
    merge: false,
    push: true
  }, {
    token: 'string',
    // single line
    regex: '["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'
  }, {
    token: 'constant.numeric',
    // hex
    regex: '0[xX][0-9a-fA-F]+\\b'
  }, {
    token: 'constant.numeric',
    // float
    regex: '[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b'
  }, {
    token: 'constant.language.boolean',
    regex: '(?:true|false)\\b'
  }, {
    token: 'invalid.illegal',
    // single quoted strings are not allowed
    regex: "['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"
  }, {
    token: 'invalid.illegal',
    // comments are not allowed
    regex: '\\/\\/.*$'
  }, {
    token: 'paren.lparen',
    merge: false,
    regex: '{',
    next: root,
    push: true
  }, {
    token: 'paren.lparen',
    merge: false,
    regex: '[[(]'
  }, {
    token: 'paren.rparen',
    merge: false,
    regex: '[\\])]'
  }, {
    token: 'paren.rparen',
    regex: '}',
    merge: false,
    next: 'pop'
  }, {
    token: 'punctuation.comma',
    regex: ','
  }, {
    token: 'punctuation.colon',
    regex: ':'
  }, {
    token: 'whitespace',
    regex: '\\s+'
  }, {
    token: 'text',
    regex: '.+?'
  }];
  rules[root] = xJsonRules;
  rules[root + '-sql'] = [{
    token: ['variable', 'whitespace', 'ace.punctuation.colon', 'whitespace', 'punctuation.start_triple_quote'],
    regex: '("query")(\\s*?)(:)(\\s*?)(""")',
    next: 'sql-start',
    merge: false,
    push: true
  }].concat(xJsonRules);
  rules.string_literal = [{
    token: 'punctuation.end_triple_quote',
    regex: '"""',
    next: 'pop'
  }, {
    token: 'multi_string',
    regex: '.'
  }];
  return rules;
};
export function XJsonHighlightRules() {
  this.$rules = _objectSpread({}, jsonRules('start'));
  this.embedRules(ScriptHighlightRules, 'script-', [{
    token: 'punctuation.end_triple_quote',
    regex: '"""',
    next: 'pop'
  }]);
  this.embedRules(OpenSearchSqlHighlightRules, 'sql-', [{
    token: 'punctuation.end_triple_quote',
    regex: '"""',
    next: 'pop'
  }]);
}
oop.inherits(XJsonHighlightRules, JsonHighlightRules);
export function addToRules(otherRules, embedUnder) {
  otherRules.$rules = defaultsDeep(otherRules.$rules, jsonRules(embedUnder));
  otherRules.embedRules(ScriptHighlightRules, 'script-', [{
    token: 'punctuation.end_triple_quote',
    regex: '"""',
    next: 'pop'
  }]);
  otherRules.embedRules(OpenSearchSqlHighlightRules, 'sql-', [{
    token: 'punctuation.end_triple_quote',
    regex: '"""',
    next: 'pop'
  }]);
}