/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.setup;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.support.clustermanager.AcknowledgedRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.replication.metadata.store.ReplicationContext;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B!\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/opensearch/replication/action/setup/SetupChecksRequest;", "Lorg/opensearch/action/support/clustermanager/AcknowledgedRequest;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "followerContext", "Lorg/opensearch/replication/metadata/store/ReplicationContext;", "leaderContext", "connectionName", "", "<init>", "(Lorg/opensearch/replication/metadata/store/ReplicationContext;Lorg/opensearch/replication/metadata/store/ReplicationContext;Ljava/lang/String;)V", "inp", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getFollowerContext", "()Lorg/opensearch/replication/metadata/store/ReplicationContext;", "getLeaderContext", "getConnectionName", "()Ljava/lang/String;", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "opensearch-cross-cluster-replication"})
public final class SetupChecksRequest
extends AcknowledgedRequest<SetupChecksRequest>
implements ToXContentObject {
    @NotNull
    private final ReplicationContext followerContext;
    @NotNull
    private final ReplicationContext leaderContext;
    @NotNull
    private final String connectionName;

    @NotNull
    public final ReplicationContext getFollowerContext() {
        return this.followerContext;
    }

    @NotNull
    public final ReplicationContext getLeaderContext() {
        return this.leaderContext;
    }

    @NotNull
    public final String getConnectionName() {
        return this.connectionName;
    }

    public SetupChecksRequest(@NotNull ReplicationContext followerContext, @NotNull ReplicationContext leaderContext, @NotNull String connectionName) {
        Intrinsics.checkNotNullParameter((Object)followerContext, (String)"followerContext");
        Intrinsics.checkNotNullParameter((Object)leaderContext, (String)"leaderContext");
        Intrinsics.checkNotNullParameter((Object)connectionName, (String)"connectionName");
        this.followerContext = followerContext;
        this.leaderContext = leaderContext;
        this.connectionName = connectionName;
    }

    public SetupChecksRequest(@NotNull StreamInput inp) {
        Intrinsics.checkNotNullParameter((Object)inp, (String)"inp");
        super(inp);
        this.followerContext = new ReplicationContext(inp);
        this.leaderContext = new ReplicationContext(inp);
        String string = inp.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        this.connectionName = string;
    }

    @Nullable
    public ActionRequestValidationException validate() {
        return null;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super.writeTo(out);
        this.followerContext.writeTo(out);
        this.leaderContext.writeTo(out);
        out.writeString(this.connectionName);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        builder.field("follower_context", (ToXContent)this.followerContext);
        builder.field("leader_context", (ToXContent)this.leaderContext);
        builder.field("connection_name", this.connectionName);
        XContentBuilder xContentBuilder = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }
}

