/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.cluster.routing.Murmur3HashFunction;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0003j\u0002`\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/alerting/core/ShardNodes;", "", "localNodeId", "", "activeShardNodeIds", "", "<init>", "(Ljava/lang/String;Ljava/util/Collection;)V", "getLocalNodeId", "()Ljava/lang/String;", "circle", "Ljava/util/TreeMap;", "", "isOwningNode", "", "id", "Lorg/opensearch/alerting/core/JobId;", "Companion", "alerting-core"})
final class ShardNodes {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String localNodeId;
    @NotNull
    private final TreeMap<Integer, String> circle;
    private static final int VIRTUAL_NODE_COUNT = 100;

    public ShardNodes(@NotNull String localNodeId, @NotNull Collection<String> activeShardNodeIds) {
        Intrinsics.checkNotNullParameter((Object)localNodeId, (String)"localNodeId");
        Intrinsics.checkNotNullParameter(activeShardNodeIds, (String)"activeShardNodeIds");
        this.localNodeId = localNodeId;
        this.circle = new TreeMap();
        for (String node : activeShardNodeIds) {
            for (int i = 0; i < 100; ++i) {
                ((Map)this.circle).put(Murmur3HashFunction.hash((String)(node + i)), node);
            }
        }
    }

    @NotNull
    public final String getLocalNodeId() {
        return this.localNodeId;
    }

    public final boolean isOwningNode(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        if (this.circle.isEmpty()) {
            return false;
        }
        int hash = Murmur3HashFunction.hash((String)id);
        Map.Entry<Integer, String> entry = this.circle.higherEntry(hash);
        if (entry == null) {
            entry = this.circle.firstEntry();
        }
        String nodeId = entry.getValue();
        return Intrinsics.areEqual((Object)this.localNodeId, (Object)nodeId);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/alerting/core/ShardNodes$Companion;", "", "<init>", "()V", "VIRTUAL_NODE_COUNT", "", "alerting-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

