// A Bison parser, made by GNU Bison 3.8.2.

// Skeleton implementation for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.



// First part of user prologue.
#line 107 "../nix/src/libexpr/parser.y"


/* The parser is very performance sensitive and loses out on a lot
   of performance even with basic stdlib assertions. Since those don't
   affect ABI we can disable those just for this file. */
#if defined(_GLIBCXX_ASSERTIONS) && !defined(_GLIBCXX_DEBUG)
#undef _GLIBCXX_ASSERTIONS
#endif

#include "parser-scanner-decls.hh"

YY_DECL;

using namespace nix;

#define CUR_POS state->at(yylhs.location)

void parser::BisonParser::error(const location_type &loc_, const std::string &error)
{
    auto loc = loc_;
    if (std::string_view(error).starts_with("syntax error, unexpected end of file")) {
        loc.beginOffset = loc.endOffset;
    }
    throw ParseError({
        .msg = HintFmt(error),
        .pos = state->positions[state->at(loc)]
    });
}

#define SET_DOC_POS(lambda, pos) setDocPosition(state->lexerState, lambda, state->at(pos))
static void setDocPosition(const LexerState & lexerState, ExprLambda * lambda, PosIdx start) {
    auto it = lexerState.positionToDocComment.find(start);
    if (it != lexerState.positionToDocComment.end()) {
        lambda->setDocComment(it->second);
    }
}

static Expr * makeCall(Exprs & exprs, PosIdx pos, Expr * fn, Expr * arg) {
    if (auto e2 = dynamic_cast<ExprCall *>(fn)) {
        e2->args->push_back(arg);
        return fn;
    }
    return exprs.add<ExprCall>(pos, fn, {arg});
}



#line 89 "src/libexpr/parser-tab.cc"


#include "parser-tab.hh"




#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> // FIXME: INFRINGES ON USER NAME SPACE.
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif


// Whether we are compiled with exception support.
#ifndef YY_EXCEPTIONS
# if defined __GNUC__ && !defined __EXCEPTIONS
#  define YY_EXCEPTIONS 0
# else
#  define YY_EXCEPTIONS 1
# endif
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K].location)
/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

# ifndef YYLLOC_DEFAULT
#  define YYLLOC_DEFAULT(Current, Rhs, N)                               \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).begin  = YYRHSLOC (Rhs, 1).begin;                   \
          (Current).end    = YYRHSLOC (Rhs, N).end;                     \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).begin = (Current).end = YYRHSLOC (Rhs, 0).end;      \
        }                                                               \
    while (false)
# endif


// Enable debugging if requested.
#if YYDEBUG

// A pseudo ostream that takes yydebug_ into account.
# define YYCDEBUG if (yydebug_) (*yycdebug_)

# define YY_SYMBOL_PRINT(Title, Symbol)         \
  do {                                          \
    if (yydebug_)                               \
    {                                           \
      *yycdebug_ << Title << ' ';               \
      yy_print_ (*yycdebug_, Symbol);           \
      *yycdebug_ << '\n';                       \
    }                                           \
  } while (false)

# define YY_REDUCE_PRINT(Rule)          \
  do {                                  \
    if (yydebug_)                       \
      yy_reduce_print_ (Rule);          \
  } while (false)

# define YY_STACK_PRINT()               \
  do {                                  \
    if (yydebug_)                       \
      yy_stack_print_ ();                \
  } while (false)

#else // !YYDEBUG

# define YYCDEBUG if (false) std::cerr
# define YY_SYMBOL_PRINT(Title, Symbol)  YY_USE (Symbol)
# define YY_REDUCE_PRINT(Rule)           static_cast<void> (0)
# define YY_STACK_PRINT()                static_cast<void> (0)

#endif // !YYDEBUG

#define yyerrok         (yyerrstatus_ = 0)
#define yyclearin       (yyla.clear ())

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYRECOVERING()  (!!yyerrstatus_)

#line 3 "../nix/src/libexpr/parser.y"
namespace nix { namespace parser  {
#line 187 "src/libexpr/parser-tab.cc"

  /// Build a parser object.
   BisonParser :: BisonParser  (void * scanner_yyarg, nix::ParserState * state_yyarg)
#if YYDEBUG
    : yydebug_ (false),
      yycdebug_ (&std::cerr),
#else
    :
#endif
      scanner (scanner_yyarg),
      state (state_yyarg)
  {}

   BisonParser ::~ BisonParser  ()
  {}

   BisonParser ::syntax_error::~syntax_error () YY_NOEXCEPT YY_NOTHROW
  {}

  /*---------.
  | symbol.  |
  `---------*/

  // basic_symbol.
  template <typename Base>
   BisonParser ::basic_symbol<Base>::basic_symbol (const basic_symbol& that)
    : Base (that)
    , value ()
    , location (that.location)
  {
    switch (this->kind ())
    {
      case symbol_kind::S_start: // start
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_function: // expr_function
      case symbol_kind::S_expr_if: // expr_if
      case symbol_kind::S_expr_pipe_from: // expr_pipe_from
      case symbol_kind::S_expr_pipe_into: // expr_pipe_into
      case symbol_kind::S_expr_op: // expr_op
      case symbol_kind::S_expr_app: // expr_app
      case symbol_kind::S_expr_select: // expr_select
      case symbol_kind::S_expr_simple: // expr_simple
      case symbol_kind::S_path_start: // path_start
        value.copy< Expr * > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_binds: // binds
      case symbol_kind::S_binds1: // binds1
        value.copy< ExprAttrs * > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_formal: // formal
        value.copy< Formal > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_formal_set: // formal_set
      case symbol_kind::S_formals: // formals
        value.copy< FormalsBuilder > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_FLOAT_LIT: // "floating-point literal"
        value.copy< NixFloat > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_INT_LIT: // "integer"
        value.copy< NixInt > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ID: // "identifier"
      case symbol_kind::S_STR: // "string"
      case symbol_kind::S_IND_STR: // "indented string"
      case symbol_kind::S_PATH: // "path"
      case symbol_kind::S_HPATH: // "'~/…' path"
      case symbol_kind::S_SPATH: // "'<…>' path"
      case symbol_kind::S_PATH_END: // "end of path"
      case symbol_kind::S_URI: // "URI"
      case symbol_kind::S_attr: // attr
        value.copy< StringToken > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_string_parts: // string_parts
      case symbol_kind::S_string_attr: // string_attr
        value.copy< ToBeStringyExpr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_list: // list
        value.copy< std::pmr::vector<Expr *> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_attrpath: // attrpath
        value.copy< std::vector<AttrName> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_attrs: // attrs
        value.copy< std::vector<std::pair<AttrName, PosIdx>> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_string_parts_interpolated: // string_parts_interpolated
        value.copy< std::vector<std::pair<PosIdx, Expr *>> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ind_string_parts: // ind_string_parts
        value.copy< std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

  }




  template <typename Base>
   BisonParser ::symbol_kind_type
   BisonParser ::basic_symbol<Base>::type_get () const YY_NOEXCEPT
  {
    return this->kind ();
  }


  template <typename Base>
  bool
   BisonParser ::basic_symbol<Base>::empty () const YY_NOEXCEPT
  {
    return this->kind () == symbol_kind::S_YYEMPTY;
  }

  template <typename Base>
  void
   BisonParser ::basic_symbol<Base>::move (basic_symbol& s)
  {
    super_type::move (s);
    switch (this->kind ())
    {
      case symbol_kind::S_start: // start
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_function: // expr_function
      case symbol_kind::S_expr_if: // expr_if
      case symbol_kind::S_expr_pipe_from: // expr_pipe_from
      case symbol_kind::S_expr_pipe_into: // expr_pipe_into
      case symbol_kind::S_expr_op: // expr_op
      case symbol_kind::S_expr_app: // expr_app
      case symbol_kind::S_expr_select: // expr_select
      case symbol_kind::S_expr_simple: // expr_simple
      case symbol_kind::S_path_start: // path_start
        value.move< Expr * > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_binds: // binds
      case symbol_kind::S_binds1: // binds1
        value.move< ExprAttrs * > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_formal: // formal
        value.move< Formal > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_formal_set: // formal_set
      case symbol_kind::S_formals: // formals
        value.move< FormalsBuilder > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_FLOAT_LIT: // "floating-point literal"
        value.move< NixFloat > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_INT_LIT: // "integer"
        value.move< NixInt > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_ID: // "identifier"
      case symbol_kind::S_STR: // "string"
      case symbol_kind::S_IND_STR: // "indented string"
      case symbol_kind::S_PATH: // "path"
      case symbol_kind::S_HPATH: // "'~/…' path"
      case symbol_kind::S_SPATH: // "'<…>' path"
      case symbol_kind::S_PATH_END: // "end of path"
      case symbol_kind::S_URI: // "URI"
      case symbol_kind::S_attr: // attr
        value.move< StringToken > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_string_parts: // string_parts
      case symbol_kind::S_string_attr: // string_attr
        value.move< ToBeStringyExpr > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_list: // list
        value.move< std::pmr::vector<Expr *> > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_attrpath: // attrpath
        value.move< std::vector<AttrName> > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_attrs: // attrs
        value.move< std::vector<std::pair<AttrName, PosIdx>> > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_string_parts_interpolated: // string_parts_interpolated
        value.move< std::vector<std::pair<PosIdx, Expr *>> > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_ind_string_parts: // ind_string_parts
        value.move< std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > (YY_MOVE (s.value));
        break;

      default:
        break;
    }

    location = YY_MOVE (s.location);
  }

  // by_kind.
   BisonParser ::by_kind::by_kind () YY_NOEXCEPT
    : kind_ (symbol_kind::S_YYEMPTY)
  {}

#if 201103L <= YY_CPLUSPLUS
   BisonParser ::by_kind::by_kind (by_kind&& that) YY_NOEXCEPT
    : kind_ (that.kind_)
  {
    that.clear ();
  }
#endif

   BisonParser ::by_kind::by_kind (const by_kind& that) YY_NOEXCEPT
    : kind_ (that.kind_)
  {}

   BisonParser ::by_kind::by_kind (token_kind_type t) YY_NOEXCEPT
    : kind_ (yytranslate_ (t))
  {}



  void
   BisonParser ::by_kind::clear () YY_NOEXCEPT
  {
    kind_ = symbol_kind::S_YYEMPTY;
  }

  void
   BisonParser ::by_kind::move (by_kind& that)
  {
    kind_ = that.kind_;
    that.clear ();
  }

   BisonParser ::symbol_kind_type
   BisonParser ::by_kind::kind () const YY_NOEXCEPT
  {
    return kind_;
  }


   BisonParser ::symbol_kind_type
   BisonParser ::by_kind::type_get () const YY_NOEXCEPT
  {
    return this->kind ();
  }



  // by_state.
   BisonParser ::by_state::by_state () YY_NOEXCEPT
    : state (empty_state)
  {}

   BisonParser ::by_state::by_state (const by_state& that) YY_NOEXCEPT
    : state (that.state)
  {}

  void
   BisonParser ::by_state::clear () YY_NOEXCEPT
  {
    state = empty_state;
  }

  void
   BisonParser ::by_state::move (by_state& that)
  {
    state = that.state;
    that.clear ();
  }

   BisonParser ::by_state::by_state (state_type s) YY_NOEXCEPT
    : state (s)
  {}

   BisonParser ::symbol_kind_type
   BisonParser ::by_state::kind () const YY_NOEXCEPT
  {
    if (state == empty_state)
      return symbol_kind::S_YYEMPTY;
    else
      return YY_CAST (symbol_kind_type, yystos_[+state]);
  }

   BisonParser ::stack_symbol_type::stack_symbol_type ()
  {}

   BisonParser ::stack_symbol_type::stack_symbol_type (YY_RVREF (stack_symbol_type) that)
    : super_type (YY_MOVE (that.state), YY_MOVE (that.location))
  {
    switch (that.kind ())
    {
      case symbol_kind::S_start: // start
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_function: // expr_function
      case symbol_kind::S_expr_if: // expr_if
      case symbol_kind::S_expr_pipe_from: // expr_pipe_from
      case symbol_kind::S_expr_pipe_into: // expr_pipe_into
      case symbol_kind::S_expr_op: // expr_op
      case symbol_kind::S_expr_app: // expr_app
      case symbol_kind::S_expr_select: // expr_select
      case symbol_kind::S_expr_simple: // expr_simple
      case symbol_kind::S_path_start: // path_start
        value.YY_MOVE_OR_COPY< Expr * > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_binds: // binds
      case symbol_kind::S_binds1: // binds1
        value.YY_MOVE_OR_COPY< ExprAttrs * > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_formal: // formal
        value.YY_MOVE_OR_COPY< Formal > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_formal_set: // formal_set
      case symbol_kind::S_formals: // formals
        value.YY_MOVE_OR_COPY< FormalsBuilder > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_FLOAT_LIT: // "floating-point literal"
        value.YY_MOVE_OR_COPY< NixFloat > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_INT_LIT: // "integer"
        value.YY_MOVE_OR_COPY< NixInt > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ID: // "identifier"
      case symbol_kind::S_STR: // "string"
      case symbol_kind::S_IND_STR: // "indented string"
      case symbol_kind::S_PATH: // "path"
      case symbol_kind::S_HPATH: // "'~/…' path"
      case symbol_kind::S_SPATH: // "'<…>' path"
      case symbol_kind::S_PATH_END: // "end of path"
      case symbol_kind::S_URI: // "URI"
      case symbol_kind::S_attr: // attr
        value.YY_MOVE_OR_COPY< StringToken > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_string_parts: // string_parts
      case symbol_kind::S_string_attr: // string_attr
        value.YY_MOVE_OR_COPY< ToBeStringyExpr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_list: // list
        value.YY_MOVE_OR_COPY< std::pmr::vector<Expr *> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_attrpath: // attrpath
        value.YY_MOVE_OR_COPY< std::vector<AttrName> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_attrs: // attrs
        value.YY_MOVE_OR_COPY< std::vector<std::pair<AttrName, PosIdx>> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_string_parts_interpolated: // string_parts_interpolated
        value.YY_MOVE_OR_COPY< std::vector<std::pair<PosIdx, Expr *>> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ind_string_parts: // ind_string_parts
        value.YY_MOVE_OR_COPY< std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

#if 201103L <= YY_CPLUSPLUS
    // that is emptied.
    that.state = empty_state;
#endif
  }

   BisonParser ::stack_symbol_type::stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) that)
    : super_type (s, YY_MOVE (that.location))
  {
    switch (that.kind ())
    {
      case symbol_kind::S_start: // start
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_function: // expr_function
      case symbol_kind::S_expr_if: // expr_if
      case symbol_kind::S_expr_pipe_from: // expr_pipe_from
      case symbol_kind::S_expr_pipe_into: // expr_pipe_into
      case symbol_kind::S_expr_op: // expr_op
      case symbol_kind::S_expr_app: // expr_app
      case symbol_kind::S_expr_select: // expr_select
      case symbol_kind::S_expr_simple: // expr_simple
      case symbol_kind::S_path_start: // path_start
        value.move< Expr * > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_binds: // binds
      case symbol_kind::S_binds1: // binds1
        value.move< ExprAttrs * > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_formal: // formal
        value.move< Formal > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_formal_set: // formal_set
      case symbol_kind::S_formals: // formals
        value.move< FormalsBuilder > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_FLOAT_LIT: // "floating-point literal"
        value.move< NixFloat > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_INT_LIT: // "integer"
        value.move< NixInt > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ID: // "identifier"
      case symbol_kind::S_STR: // "string"
      case symbol_kind::S_IND_STR: // "indented string"
      case symbol_kind::S_PATH: // "path"
      case symbol_kind::S_HPATH: // "'~/…' path"
      case symbol_kind::S_SPATH: // "'<…>' path"
      case symbol_kind::S_PATH_END: // "end of path"
      case symbol_kind::S_URI: // "URI"
      case symbol_kind::S_attr: // attr
        value.move< StringToken > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_string_parts: // string_parts
      case symbol_kind::S_string_attr: // string_attr
        value.move< ToBeStringyExpr > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_list: // list
        value.move< std::pmr::vector<Expr *> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_attrpath: // attrpath
        value.move< std::vector<AttrName> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_attrs: // attrs
        value.move< std::vector<std::pair<AttrName, PosIdx>> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_string_parts_interpolated: // string_parts_interpolated
        value.move< std::vector<std::pair<PosIdx, Expr *>> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ind_string_parts: // ind_string_parts
        value.move< std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

    // that is emptied.
    that.kind_ = symbol_kind::S_YYEMPTY;
  }

#if YY_CPLUSPLUS < 201103L
   BisonParser ::stack_symbol_type&
   BisonParser ::stack_symbol_type::operator= (const stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_start: // start
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_function: // expr_function
      case symbol_kind::S_expr_if: // expr_if
      case symbol_kind::S_expr_pipe_from: // expr_pipe_from
      case symbol_kind::S_expr_pipe_into: // expr_pipe_into
      case symbol_kind::S_expr_op: // expr_op
      case symbol_kind::S_expr_app: // expr_app
      case symbol_kind::S_expr_select: // expr_select
      case symbol_kind::S_expr_simple: // expr_simple
      case symbol_kind::S_path_start: // path_start
        value.copy< Expr * > (that.value);
        break;

      case symbol_kind::S_binds: // binds
      case symbol_kind::S_binds1: // binds1
        value.copy< ExprAttrs * > (that.value);
        break;

      case symbol_kind::S_formal: // formal
        value.copy< Formal > (that.value);
        break;

      case symbol_kind::S_formal_set: // formal_set
      case symbol_kind::S_formals: // formals
        value.copy< FormalsBuilder > (that.value);
        break;

      case symbol_kind::S_FLOAT_LIT: // "floating-point literal"
        value.copy< NixFloat > (that.value);
        break;

      case symbol_kind::S_INT_LIT: // "integer"
        value.copy< NixInt > (that.value);
        break;

      case symbol_kind::S_ID: // "identifier"
      case symbol_kind::S_STR: // "string"
      case symbol_kind::S_IND_STR: // "indented string"
      case symbol_kind::S_PATH: // "path"
      case symbol_kind::S_HPATH: // "'~/…' path"
      case symbol_kind::S_SPATH: // "'<…>' path"
      case symbol_kind::S_PATH_END: // "end of path"
      case symbol_kind::S_URI: // "URI"
      case symbol_kind::S_attr: // attr
        value.copy< StringToken > (that.value);
        break;

      case symbol_kind::S_string_parts: // string_parts
      case symbol_kind::S_string_attr: // string_attr
        value.copy< ToBeStringyExpr > (that.value);
        break;

      case symbol_kind::S_list: // list
        value.copy< std::pmr::vector<Expr *> > (that.value);
        break;

      case symbol_kind::S_attrpath: // attrpath
        value.copy< std::vector<AttrName> > (that.value);
        break;

      case symbol_kind::S_attrs: // attrs
        value.copy< std::vector<std::pair<AttrName, PosIdx>> > (that.value);
        break;

      case symbol_kind::S_string_parts_interpolated: // string_parts_interpolated
        value.copy< std::vector<std::pair<PosIdx, Expr *>> > (that.value);
        break;

      case symbol_kind::S_ind_string_parts: // ind_string_parts
        value.copy< std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > (that.value);
        break;

      default:
        break;
    }

    location = that.location;
    return *this;
  }

   BisonParser ::stack_symbol_type&
   BisonParser ::stack_symbol_type::operator= (stack_symbol_type& that)
  {
    state = that.state;
    switch (that.kind ())
    {
      case symbol_kind::S_start: // start
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_function: // expr_function
      case symbol_kind::S_expr_if: // expr_if
      case symbol_kind::S_expr_pipe_from: // expr_pipe_from
      case symbol_kind::S_expr_pipe_into: // expr_pipe_into
      case symbol_kind::S_expr_op: // expr_op
      case symbol_kind::S_expr_app: // expr_app
      case symbol_kind::S_expr_select: // expr_select
      case symbol_kind::S_expr_simple: // expr_simple
      case symbol_kind::S_path_start: // path_start
        value.move< Expr * > (that.value);
        break;

      case symbol_kind::S_binds: // binds
      case symbol_kind::S_binds1: // binds1
        value.move< ExprAttrs * > (that.value);
        break;

      case symbol_kind::S_formal: // formal
        value.move< Formal > (that.value);
        break;

      case symbol_kind::S_formal_set: // formal_set
      case symbol_kind::S_formals: // formals
        value.move< FormalsBuilder > (that.value);
        break;

      case symbol_kind::S_FLOAT_LIT: // "floating-point literal"
        value.move< NixFloat > (that.value);
        break;

      case symbol_kind::S_INT_LIT: // "integer"
        value.move< NixInt > (that.value);
        break;

      case symbol_kind::S_ID: // "identifier"
      case symbol_kind::S_STR: // "string"
      case symbol_kind::S_IND_STR: // "indented string"
      case symbol_kind::S_PATH: // "path"
      case symbol_kind::S_HPATH: // "'~/…' path"
      case symbol_kind::S_SPATH: // "'<…>' path"
      case symbol_kind::S_PATH_END: // "end of path"
      case symbol_kind::S_URI: // "URI"
      case symbol_kind::S_attr: // attr
        value.move< StringToken > (that.value);
        break;

      case symbol_kind::S_string_parts: // string_parts
      case symbol_kind::S_string_attr: // string_attr
        value.move< ToBeStringyExpr > (that.value);
        break;

      case symbol_kind::S_list: // list
        value.move< std::pmr::vector<Expr *> > (that.value);
        break;

      case symbol_kind::S_attrpath: // attrpath
        value.move< std::vector<AttrName> > (that.value);
        break;

      case symbol_kind::S_attrs: // attrs
        value.move< std::vector<std::pair<AttrName, PosIdx>> > (that.value);
        break;

      case symbol_kind::S_string_parts_interpolated: // string_parts_interpolated
        value.move< std::vector<std::pair<PosIdx, Expr *>> > (that.value);
        break;

      case symbol_kind::S_ind_string_parts: // ind_string_parts
        value.move< std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > (that.value);
        break;

      default:
        break;
    }

    location = that.location;
    // that is emptied.
    that.state = empty_state;
    return *this;
  }
#endif

  template <typename Base>
  void
   BisonParser ::yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const
  {
    if (yymsg)
      YY_SYMBOL_PRINT (yymsg, yysym);
  }

#if YYDEBUG
  template <typename Base>
  void
   BisonParser ::yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const
  {
    std::ostream& yyoutput = yyo;
    YY_USE (yyoutput);
    if (yysym.empty ())
      yyo << "empty symbol";
    else
      {
        symbol_kind_type yykind = yysym.kind ();
        yyo << (yykind < YYNTOKENS ? "token" : "nterm")
            << ' ' << yysym.name () << " ("
            << yysym.location << ": ";
        YY_USE (yykind);
        yyo << ')';
      }
  }
#endif

  void
   BisonParser ::yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym)
  {
    if (m)
      YY_SYMBOL_PRINT (m, sym);
    yystack_.push (YY_MOVE (sym));
  }

  void
   BisonParser ::yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym)
  {
#if 201103L <= YY_CPLUSPLUS
    yypush_ (m, stack_symbol_type (s, std::move (sym)));
#else
    stack_symbol_type ss (s, sym);
    yypush_ (m, ss);
#endif
  }

  void
   BisonParser ::yypop_ (int n) YY_NOEXCEPT
  {
    yystack_.pop (n);
  }

#if YYDEBUG
  std::ostream&
   BisonParser ::debug_stream () const
  {
    return *yycdebug_;
  }

  void
   BisonParser ::set_debug_stream (std::ostream& o)
  {
    yycdebug_ = &o;
  }


   BisonParser ::debug_level_type
   BisonParser ::debug_level () const
  {
    return yydebug_;
  }

  void
   BisonParser ::set_debug_level (debug_level_type l)
  {
    yydebug_ = l;
  }
#endif // YYDEBUG

   BisonParser ::state_type
   BisonParser ::yy_lr_goto_state_ (state_type yystate, int yysym)
  {
    int yyr = yypgoto_[yysym - YYNTOKENS] + yystate;
    if (0 <= yyr && yyr <= yylast_ && yycheck_[yyr] == yystate)
      return yytable_[yyr];
    else
      return yydefgoto_[yysym - YYNTOKENS];
  }

  bool
   BisonParser ::yy_pact_value_is_default_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yypact_ninf_;
  }

  bool
   BisonParser ::yy_table_value_is_error_ (int yyvalue) YY_NOEXCEPT
  {
    return yyvalue == yytable_ninf_;
  }

  int
   BisonParser ::operator() ()
  {
    return parse ();
  }

  int
   BisonParser ::parse ()
  {
    int yyn;
    /// Length of the RHS of the rule being reduced.
    int yylen = 0;

    // Error handling.
    int yynerrs_ = 0;
    int yyerrstatus_ = 0;

    /// The lookahead symbol.
    symbol_type yyla;

    /// The locations where the error started and ended.
    stack_symbol_type yyerror_range[3];

    /// The return value of parse ().
    int yyresult;

#if YY_EXCEPTIONS
    try
#endif // YY_EXCEPTIONS
      {
    YYCDEBUG << "Starting parse\n";


    /* Initialize the stack.  The initial state will be set in
       yynewstate, since the latter expects the semantical and the
       location values to have been already stored, initialize these
       stacks with a primary value.  */
    yystack_.clear ();
    yypush_ (YY_NULLPTR, 0, YY_MOVE (yyla));

  /*-----------------------------------------------.
  | yynewstate -- push a new symbol on the stack.  |
  `-----------------------------------------------*/
  yynewstate:
    YYCDEBUG << "Entering state " << int (yystack_[0].state) << '\n';
    YY_STACK_PRINT ();

    // Accept?
    if (yystack_[0].state == yyfinal_)
      YYACCEPT;

    goto yybackup;


  /*-----------.
  | yybackup.  |
  `-----------*/
  yybackup:
    // Try to take a decision without lookahead.
    yyn = yypact_[+yystack_[0].state];
    if (yy_pact_value_is_default_ (yyn))
      goto yydefault;

    // Read a lookahead token.
    if (yyla.empty ())
      {
        YYCDEBUG << "Reading a token\n";
#if YY_EXCEPTIONS
        try
#endif // YY_EXCEPTIONS
          {
            yyla.kind_ = yytranslate_ (yylex (&yyla.value, &yyla.location, scanner, state));
          }
#if YY_EXCEPTIONS
        catch (const syntax_error& yyexc)
          {
            YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
            error (yyexc);
            goto yyerrlab1;
          }
#endif // YY_EXCEPTIONS
      }
    YY_SYMBOL_PRINT ("Next token is", yyla);

    if (yyla.kind () == symbol_kind::S_YYerror)
    {
      // The scanner already issued an error message, process directly
      // to error recovery.  But do not keep the error token as
      // lookahead, it is too special and may lead us to an endless
      // loop in error recovery. */
      yyla.kind_ = symbol_kind::S_YYUNDEF;
      goto yyerrlab1;
    }

    /* If the proper action on seeing token YYLA.TYPE is to reduce or
       to detect an error, take that action.  */
    yyn += yyla.kind ();
    if (yyn < 0 || yylast_ < yyn || yycheck_[yyn] != yyla.kind ())
      {
        goto yydefault;
      }

    // Reduce or error.
    yyn = yytable_[yyn];
    if (yyn <= 0)
      {
        if (yy_table_value_is_error_ (yyn))
          goto yyerrlab;
        yyn = -yyn;
        goto yyreduce;
      }

    // Count tokens shifted since error; after three, turn off error status.
    if (yyerrstatus_)
      --yyerrstatus_;

    // Shift the lookahead token.
    yypush_ ("Shifting", state_type (yyn), YY_MOVE (yyla));
    goto yynewstate;


  /*-----------------------------------------------------------.
  | yydefault -- do the default action for the current state.  |
  `-----------------------------------------------------------*/
  yydefault:
    yyn = yydefact_[+yystack_[0].state];
    if (yyn == 0)
      goto yyerrlab;
    goto yyreduce;


  /*-----------------------------.
  | yyreduce -- do a reduction.  |
  `-----------------------------*/
  yyreduce:
    yylen = yyr2_[yyn];
    {
      stack_symbol_type yylhs;
      yylhs.state = yy_lr_goto_state_ (yystack_[yylen].state, yyr1_[yyn]);
      /* Variants are always initialized to an empty instance of the
         correct type. The default '$$ = $1' action is NOT applied
         when using variants.  */
      switch (yyr1_[yyn])
    {
      case symbol_kind::S_start: // start
      case symbol_kind::S_expr: // expr
      case symbol_kind::S_expr_function: // expr_function
      case symbol_kind::S_expr_if: // expr_if
      case symbol_kind::S_expr_pipe_from: // expr_pipe_from
      case symbol_kind::S_expr_pipe_into: // expr_pipe_into
      case symbol_kind::S_expr_op: // expr_op
      case symbol_kind::S_expr_app: // expr_app
      case symbol_kind::S_expr_select: // expr_select
      case symbol_kind::S_expr_simple: // expr_simple
      case symbol_kind::S_path_start: // path_start
        yylhs.value.emplace< Expr * > ();
        break;

      case symbol_kind::S_binds: // binds
      case symbol_kind::S_binds1: // binds1
        yylhs.value.emplace< ExprAttrs * > ();
        break;

      case symbol_kind::S_formal: // formal
        yylhs.value.emplace< Formal > ();
        break;

      case symbol_kind::S_formal_set: // formal_set
      case symbol_kind::S_formals: // formals
        yylhs.value.emplace< FormalsBuilder > ();
        break;

      case symbol_kind::S_FLOAT_LIT: // "floating-point literal"
        yylhs.value.emplace< NixFloat > ();
        break;

      case symbol_kind::S_INT_LIT: // "integer"
        yylhs.value.emplace< NixInt > ();
        break;

      case symbol_kind::S_ID: // "identifier"
      case symbol_kind::S_STR: // "string"
      case symbol_kind::S_IND_STR: // "indented string"
      case symbol_kind::S_PATH: // "path"
      case symbol_kind::S_HPATH: // "'~/…' path"
      case symbol_kind::S_SPATH: // "'<…>' path"
      case symbol_kind::S_PATH_END: // "end of path"
      case symbol_kind::S_URI: // "URI"
      case symbol_kind::S_attr: // attr
        yylhs.value.emplace< StringToken > ();
        break;

      case symbol_kind::S_string_parts: // string_parts
      case symbol_kind::S_string_attr: // string_attr
        yylhs.value.emplace< ToBeStringyExpr > ();
        break;

      case symbol_kind::S_list: // list
        yylhs.value.emplace< std::pmr::vector<Expr *> > ();
        break;

      case symbol_kind::S_attrpath: // attrpath
        yylhs.value.emplace< std::vector<AttrName> > ();
        break;

      case symbol_kind::S_attrs: // attrs
        yylhs.value.emplace< std::vector<std::pair<AttrName, PosIdx>> > ();
        break;

      case symbol_kind::S_string_parts_interpolated: // string_parts_interpolated
        yylhs.value.emplace< std::vector<std::pair<PosIdx, Expr *>> > ();
        break;

      case symbol_kind::S_ind_string_parts: // ind_string_parts
        yylhs.value.emplace< std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > ();
        break;

      default:
        break;
    }


      // Default location.
      {
        stack_type::slice range (yystack_, yylen);
        YYLLOC_DEFAULT (yylhs.location, range, yylen);
        yyerror_range[1].location = yylhs.location;
      }

      // Perform the reduction.
      YY_REDUCE_PRINT (yyn);
#if YY_EXCEPTIONS
      try
#endif // YY_EXCEPTIONS
        {
          switch (yyn)
            {
  case 2: // start: expr
#line 223 "../nix/src/libexpr/parser.y"
            {
  state->result = yystack_[0].value.as < Expr * > ();

  // This parser does not use yynerrs; suppress the warning.
  (void) yynerrs_;
}
#line 1193 "src/libexpr/parser-tab.cc"
    break;

  case 3: // start: "start of REPL bindings" binds1
#line 229 "../nix/src/libexpr/parser.y"
                       {
  state->result = yystack_[0].value.as < ExprAttrs * > ();
  (void) yynerrs_;
}
#line 1202 "src/libexpr/parser-tab.cc"
    break;

  case 4: // expr: expr_function
#line 234 "../nix/src/libexpr/parser.y"
      { yylhs.value.as < Expr * > () = yystack_[0].value.as < Expr * > (); }
#line 1208 "src/libexpr/parser-tab.cc"
    break;

  case 5: // expr_function: "identifier" ':' expr_function
#line 238 "../nix/src/libexpr/parser.y"
    { auto me = state->exprs.add<ExprLambda>(CUR_POS, state->symbols.create(yystack_[2].value.as < StringToken > ()), yystack_[0].value.as < Expr * > ());
      yylhs.value.as < Expr * > () = me;
      SET_DOC_POS(me, yystack_[2].location);
    }
#line 1217 "src/libexpr/parser-tab.cc"
    break;

  case 6: // expr_function: formal_set ':' expr_function
#line 243 "../nix/src/libexpr/parser.y"
    {
      state->validateFormals(yystack_[2].value.as < FormalsBuilder > ());
      auto me = state->exprs.add<ExprLambda>(state->positions, state->exprs.alloc, CUR_POS, yystack_[2].value.as < FormalsBuilder > (), yystack_[0].value.as < Expr * > ());
      yylhs.value.as < Expr * > () = me;
      SET_DOC_POS(me, yystack_[2].location);
    }
#line 1228 "src/libexpr/parser-tab.cc"
    break;

  case 7: // expr_function: formal_set '@' "identifier" ':' expr_function
#line 250 "../nix/src/libexpr/parser.y"
    {
      auto arg = state->symbols.create(yystack_[2].value.as < StringToken > ());
      state->validateFormals(yystack_[4].value.as < FormalsBuilder > (), CUR_POS, arg);
      auto me = state->exprs.add<ExprLambda>(state->positions, state->exprs.alloc, CUR_POS, arg, yystack_[4].value.as < FormalsBuilder > (), yystack_[0].value.as < Expr * > ());
      yylhs.value.as < Expr * > () = me;
      SET_DOC_POS(me, yystack_[4].location);
    }
#line 1240 "src/libexpr/parser-tab.cc"
    break;

  case 8: // expr_function: "identifier" '@' formal_set ':' expr_function
#line 258 "../nix/src/libexpr/parser.y"
    {
      auto arg = state->symbols.create(yystack_[4].value.as < StringToken > ());
      state->validateFormals(yystack_[2].value.as < FormalsBuilder > (), CUR_POS, arg);
      auto me = state->exprs.add<ExprLambda>(state->positions, state->exprs.alloc, CUR_POS, arg, yystack_[2].value.as < FormalsBuilder > (), yystack_[0].value.as < Expr * > ());
      yylhs.value.as < Expr * > () = me;
      SET_DOC_POS(me, yystack_[4].location);
    }
#line 1252 "src/libexpr/parser-tab.cc"
    break;

  case 9: // expr_function: "'assert'" expr ';' expr_function
#line 266 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = state->exprs.add<ExprAssert>(CUR_POS, yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()); }
#line 1258 "src/libexpr/parser-tab.cc"
    break;

  case 10: // expr_function: "'with'" expr ';' expr_function
#line 268 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = state->exprs.add<ExprWith>(CUR_POS, yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()); }
#line 1264 "src/libexpr/parser-tab.cc"
    break;

  case 11: // expr_function: "'let'" binds "'in'" expr_function
#line 270 "../nix/src/libexpr/parser.y"
    { if (!yystack_[2].value.as < ExprAttrs * > ()->dynamicAttrs->empty())
        throw ParseError({
            .msg = HintFmt("dynamic attributes not allowed in let"),
            .pos = state->positions[CUR_POS]
        });
      yylhs.value.as < Expr * > () = state->exprs.add<ExprLet>(yystack_[2].value.as < ExprAttrs * > (), yystack_[0].value.as < Expr * > ());
    }
#line 1276 "src/libexpr/parser-tab.cc"
    break;

  case 12: // expr_function: expr_if
#line 277 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = yystack_[0].value.as < Expr * > (); }
#line 1282 "src/libexpr/parser-tab.cc"
    break;

  case 13: // expr_if: "'if'" expr "'then'" expr "'else'" expr
#line 281 "../nix/src/libexpr/parser.y"
                                { yylhs.value.as < Expr * > () = state->exprs.add<ExprIf>(CUR_POS, yystack_[4].value.as < Expr * > (), yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()); }
#line 1288 "src/libexpr/parser-tab.cc"
    break;

  case 14: // expr_if: expr_pipe_from
#line 282 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = yystack_[0].value.as < Expr * > (); }
#line 1294 "src/libexpr/parser-tab.cc"
    break;

  case 15: // expr_if: expr_pipe_into
#line 283 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = yystack_[0].value.as < Expr * > (); }
#line 1300 "src/libexpr/parser-tab.cc"
    break;

  case 16: // expr_if: expr_op
#line 284 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = yystack_[0].value.as < Expr * > (); }
#line 1306 "src/libexpr/parser-tab.cc"
    break;

  case 17: // expr_pipe_from: expr_op "'<|'" expr_pipe_from
#line 288 "../nix/src/libexpr/parser.y"
                                     { yylhs.value.as < Expr * > () = makeCall(state->exprs, state->at(yystack_[1].location), yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()); }
#line 1312 "src/libexpr/parser-tab.cc"
    break;

  case 18: // expr_pipe_from: expr_op "'<|'" expr_op
#line 289 "../nix/src/libexpr/parser.y"
                                     { yylhs.value.as < Expr * > () = makeCall(state->exprs, state->at(yystack_[1].location), yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()); }
#line 1318 "src/libexpr/parser-tab.cc"
    break;

  case 19: // expr_pipe_into: expr_pipe_into "'|>'" expr_op
#line 293 "../nix/src/libexpr/parser.y"
                                     { yylhs.value.as < Expr * > () = makeCall(state->exprs, state->at(yystack_[1].location), yystack_[0].value.as < Expr * > (), yystack_[2].value.as < Expr * > ()); }
#line 1324 "src/libexpr/parser-tab.cc"
    break;

  case 20: // expr_pipe_into: expr_op "'|>'" expr_op
#line 294 "../nix/src/libexpr/parser.y"
                                     { yylhs.value.as < Expr * > () = makeCall(state->exprs, state->at(yystack_[1].location), yystack_[0].value.as < Expr * > (), yystack_[2].value.as < Expr * > ()); }
#line 1330 "src/libexpr/parser-tab.cc"
    break;

  case 21: // expr_op: '!' expr_op
#line 298 "../nix/src/libexpr/parser.y"
                          { yylhs.value.as < Expr * > () = state->exprs.add<ExprOpNot>(yystack_[0].value.as < Expr * > ()); }
#line 1336 "src/libexpr/parser-tab.cc"
    break;

  case 22: // expr_op: '-' expr_op
#line 299 "../nix/src/libexpr/parser.y"
                             { yylhs.value.as < Expr * > () = state->exprs.add<ExprCall>(CUR_POS, state->exprs.add<ExprVar>(state->s.sub), {state->exprs.add<ExprInt>(0), yystack_[0].value.as < Expr * > ()}); }
#line 1342 "src/libexpr/parser-tab.cc"
    break;

  case 23: // expr_op: expr_op "'=='" expr_op
#line 300 "../nix/src/libexpr/parser.y"
                       { yylhs.value.as < Expr * > () = state->exprs.add<ExprOpEq>(yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()); }
#line 1348 "src/libexpr/parser-tab.cc"
    break;

  case 24: // expr_op: expr_op "'!='" expr_op
#line 301 "../nix/src/libexpr/parser.y"
                        { yylhs.value.as < Expr * > () = state->exprs.add<ExprOpNEq>(yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()); }
#line 1354 "src/libexpr/parser-tab.cc"
    break;

  case 25: // expr_op: expr_op '<' expr_op
#line 302 "../nix/src/libexpr/parser.y"
                        { yylhs.value.as < Expr * > () = state->exprs.add<ExprCall>(state->at(yystack_[1].location), state->exprs.add<ExprVar>(state->s.lessThan), {yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()}); }
#line 1360 "src/libexpr/parser-tab.cc"
    break;

  case 26: // expr_op: expr_op "'<='" expr_op
#line 303 "../nix/src/libexpr/parser.y"
                        { yylhs.value.as < Expr * > () = state->exprs.add<ExprOpNot>(state->exprs.add<ExprCall>(state->at(yystack_[1].location), state->exprs.add<ExprVar>(state->s.lessThan), {yystack_[0].value.as < Expr * > (), yystack_[2].value.as < Expr * > ()})); }
#line 1366 "src/libexpr/parser-tab.cc"
    break;

  case 27: // expr_op: expr_op '>' expr_op
#line 304 "../nix/src/libexpr/parser.y"
                        { yylhs.value.as < Expr * > () = state->exprs.add<ExprCall>(state->at(yystack_[1].location), state->exprs.add<ExprVar>(state->s.lessThan), {yystack_[0].value.as < Expr * > (), yystack_[2].value.as < Expr * > ()}); }
#line 1372 "src/libexpr/parser-tab.cc"
    break;

  case 28: // expr_op: expr_op "'>='" expr_op
#line 305 "../nix/src/libexpr/parser.y"
                        { yylhs.value.as < Expr * > () = state->exprs.add<ExprOpNot>(state->exprs.add<ExprCall>(state->at(yystack_[1].location), state->exprs.add<ExprVar>(state->s.lessThan), {yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()})); }
#line 1378 "src/libexpr/parser-tab.cc"
    break;

  case 29: // expr_op: expr_op "'&&'" expr_op
#line 306 "../nix/src/libexpr/parser.y"
                        { yylhs.value.as < Expr * > () = state->exprs.add<ExprOpAnd>(state->at(yystack_[1].location), yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()); }
#line 1384 "src/libexpr/parser-tab.cc"
    break;

  case 30: // expr_op: expr_op "'||'" expr_op
#line 307 "../nix/src/libexpr/parser.y"
                       { yylhs.value.as < Expr * > () = state->exprs.add<ExprOpOr>(state->at(yystack_[1].location), yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()); }
#line 1390 "src/libexpr/parser-tab.cc"
    break;

  case 31: // expr_op: expr_op "'->'" expr_op
#line 308 "../nix/src/libexpr/parser.y"
                         { yylhs.value.as < Expr * > () = state->exprs.add<ExprOpImpl>(state->at(yystack_[1].location), yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()); }
#line 1396 "src/libexpr/parser-tab.cc"
    break;

  case 32: // expr_op: expr_op "'//'" expr_op
#line 309 "../nix/src/libexpr/parser.y"
                           { yylhs.value.as < Expr * > () = state->exprs.add<ExprOpUpdate>(state->at(yystack_[1].location), yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()); }
#line 1402 "src/libexpr/parser-tab.cc"
    break;

  case 33: // expr_op: expr_op '?' attrpath
#line 310 "../nix/src/libexpr/parser.y"
                         { yylhs.value.as < Expr * > () = state->exprs.add<ExprOpHasAttr>(state->exprs.alloc, yystack_[2].value.as < Expr * > (), yystack_[0].value.as < std::vector<AttrName> > ()); }
#line 1408 "src/libexpr/parser-tab.cc"
    break;

  case 34: // expr_op: expr_op '+' expr_op
#line 312 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = state->exprs.add<ExprConcatStrings>(state->exprs.alloc, state->at(yystack_[1].location), false, {{state->at(yystack_[2].location), yystack_[2].value.as < Expr * > ()}, {state->at(yystack_[0].location), yystack_[0].value.as < Expr * > ()}}); }
#line 1414 "src/libexpr/parser-tab.cc"
    break;

  case 35: // expr_op: expr_op '-' expr_op
#line 313 "../nix/src/libexpr/parser.y"
                        { yylhs.value.as < Expr * > () = state->exprs.add<ExprCall>(state->at(yystack_[1].location), state->exprs.add<ExprVar>(state->s.sub), {yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()}); }
#line 1420 "src/libexpr/parser-tab.cc"
    break;

  case 36: // expr_op: expr_op '*' expr_op
#line 314 "../nix/src/libexpr/parser.y"
                        { yylhs.value.as < Expr * > () = state->exprs.add<ExprCall>(state->at(yystack_[1].location), state->exprs.add<ExprVar>(state->s.mul), {yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()}); }
#line 1426 "src/libexpr/parser-tab.cc"
    break;

  case 37: // expr_op: expr_op '/' expr_op
#line 315 "../nix/src/libexpr/parser.y"
                        { yylhs.value.as < Expr * > () = state->exprs.add<ExprCall>(state->at(yystack_[1].location), state->exprs.add<ExprVar>(state->s.div), {yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()}); }
#line 1432 "src/libexpr/parser-tab.cc"
    break;

  case 38: // expr_op: expr_op "'++'" expr_op
#line 316 "../nix/src/libexpr/parser.y"
                           { yylhs.value.as < Expr * > () = state->exprs.add<ExprOpConcatLists>(state->at(yystack_[1].location), yystack_[2].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()); }
#line 1438 "src/libexpr/parser-tab.cc"
    break;

  case 39: // expr_op: expr_app
#line 317 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = yystack_[0].value.as < Expr * > (); }
#line 1444 "src/libexpr/parser-tab.cc"
    break;

  case 40: // expr_app: expr_app expr_select
#line 321 "../nix/src/libexpr/parser.y"
                         { yylhs.value.as < Expr * > () = makeCall(state->exprs, CUR_POS, yystack_[1].value.as < Expr * > (), yystack_[0].value.as < Expr * > ()); yystack_[0].value.as < Expr * > ()->warnIfCursedOr(state->symbols, state->positions); }
#line 1450 "src/libexpr/parser-tab.cc"
    break;

  case 41: // expr_app: expr_select
#line 326 "../nix/src/libexpr/parser.y"
                { yylhs.value.as < Expr * > () = yystack_[0].value.as < Expr * > (); yylhs.value.as < Expr * > ()->resetCursedOr(); }
#line 1456 "src/libexpr/parser-tab.cc"
    break;

  case 42: // expr_select: expr_simple '.' attrpath
#line 331 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = state->exprs.add<ExprSelect>(state->exprs.alloc, CUR_POS, yystack_[2].value.as < Expr * > (), yystack_[0].value.as < std::vector<AttrName> > (), nullptr); }
#line 1462 "src/libexpr/parser-tab.cc"
    break;

  case 43: // expr_select: expr_simple '.' attrpath "'or'" expr_select
#line 333 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = state->exprs.add<ExprSelect>(state->exprs.alloc, CUR_POS, yystack_[4].value.as < Expr * > (), yystack_[2].value.as < std::vector<AttrName> > (), yystack_[0].value.as < Expr * > ()); yystack_[0].value.as < Expr * > ()->warnIfCursedOr(state->symbols, state->positions); }
#line 1468 "src/libexpr/parser-tab.cc"
    break;

  case 44: // expr_select: expr_simple "'or'"
#line 342 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = state->exprs.add<ExprCall>(CUR_POS, yystack_[1].value.as < Expr * > (), {state->exprs.add<ExprVar>(CUR_POS, state->s.or_)}, state->positions.add(state->origin, yylhs.location.endOffset)); }
#line 1474 "src/libexpr/parser-tab.cc"
    break;

  case 45: // expr_select: expr_simple
#line 343 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = yystack_[0].value.as < Expr * > (); }
#line 1480 "src/libexpr/parser-tab.cc"
    break;

  case 46: // expr_simple: "identifier"
#line 347 "../nix/src/libexpr/parser.y"
       {
      std::string_view s = "__curPos";
      if (yystack_[0].value.as < StringToken > ().l == s.size() && strncmp(yystack_[0].value.as < StringToken > ().p, s.data(), s.size()) == 0)
          yylhs.value.as < Expr * > () = state->exprs.add<ExprPos>(CUR_POS);
      else
          yylhs.value.as < Expr * > () = state->exprs.add<ExprVar>(CUR_POS, state->symbols.create(yystack_[0].value.as < StringToken > ()));
  }
#line 1492 "src/libexpr/parser-tab.cc"
    break;

  case 47: // expr_simple: "integer"
#line 354 "../nix/src/libexpr/parser.y"
            { yylhs.value.as < Expr * > () = state->exprs.add<ExprInt>(yystack_[0].value.as < NixInt > ()); }
#line 1498 "src/libexpr/parser-tab.cc"
    break;

  case 48: // expr_simple: "floating-point literal"
#line 355 "../nix/src/libexpr/parser.y"
              { yylhs.value.as < Expr * > () = state->exprs.add<ExprFloat>(yystack_[0].value.as < NixFloat > ()); }
#line 1504 "src/libexpr/parser-tab.cc"
    break;

  case 49: // expr_simple: '"' string_parts '"'
#line 356 "../nix/src/libexpr/parser.y"
                         { yylhs.value.as < Expr * > () = yystack_[1].value.as < ToBeStringyExpr > ().toExpr(state->exprs); }
#line 1510 "src/libexpr/parser-tab.cc"
    break;

  case 50: // expr_simple: "start of an indented string" ind_string_parts "end of an indented string"
#line 357 "../nix/src/libexpr/parser.y"
                                                      {
      yylhs.value.as < Expr * > () = state->stripIndentation(CUR_POS, yystack_[1].value.as < std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > ());
  }
#line 1518 "src/libexpr/parser-tab.cc"
    break;

  case 51: // expr_simple: path_start "end of path"
#line 360 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = yystack_[1].value.as < Expr * > (); }
#line 1524 "src/libexpr/parser-tab.cc"
    break;

  case 52: // expr_simple: path_start string_parts_interpolated "end of path"
#line 361 "../nix/src/libexpr/parser.y"
                                                  {
      yystack_[1].value.as < std::vector<std::pair<PosIdx, Expr *>> > ().insert(yystack_[1].value.as < std::vector<std::pair<PosIdx, Expr *>> > ().begin(), {state->at(yystack_[2].location), yystack_[2].value.as < Expr * > ()});
      yylhs.value.as < Expr * > () = state->exprs.add<ExprConcatStrings>(state->exprs.alloc, CUR_POS, false, yystack_[1].value.as < std::vector<std::pair<PosIdx, Expr *>> > ());
  }
#line 1533 "src/libexpr/parser-tab.cc"
    break;

  case 53: // expr_simple: "'<…>' path"
#line 365 "../nix/src/libexpr/parser.y"
          {
      std::string_view path(yystack_[0].value.as < StringToken > ().p + 1, yystack_[0].value.as < StringToken > ().l - 2);
      yylhs.value.as < Expr * > () = state->exprs.add<ExprCall>(CUR_POS,
          state->exprs.add<ExprVar>(state->s.findFile),
          {state->exprs.add<ExprVar>(state->s.nixPath),
           state->exprs.add<ExprString>(state->exprs.alloc, path)});
  }
#line 1545 "src/libexpr/parser-tab.cc"
    break;

  case 54: // expr_simple: "URI"
#line 372 "../nix/src/libexpr/parser.y"
        {
      diagnose(state->settings.lintUrlLiterals, [&](bool fatal) -> std::optional<ParseError> {
          return ParseError({
              .msg = HintFmt("URL literals are %s. Consider using a string literal \"%s\" instead",
                  fatal ? "disallowed" : "discouraged",
                  std::string_view(yystack_[0].value.as < StringToken > ().p, yystack_[0].value.as < StringToken > ().l)),
              .pos = state->positions[CUR_POS]
          });
      });
      yylhs.value.as < Expr * > () = state->exprs.add<ExprString>(state->exprs.alloc, yystack_[0].value.as < StringToken > ());
  }
#line 1561 "src/libexpr/parser-tab.cc"
    break;

  case 55: // expr_simple: '(' expr ')'
#line 383 "../nix/src/libexpr/parser.y"
                 { yylhs.value.as < Expr * > () = yystack_[1].value.as < Expr * > (); }
#line 1567 "src/libexpr/parser-tab.cc"
    break;

  case 56: // expr_simple: "'let'" '{' binds '}'
#line 387 "../nix/src/libexpr/parser.y"
    { yystack_[1].value.as < ExprAttrs * > ()->recursive = true; yystack_[1].value.as < ExprAttrs * > ()->pos = CUR_POS; yylhs.value.as < Expr * > () = state->exprs.add<ExprSelect>(state->exprs.alloc, noPos, yystack_[1].value.as < ExprAttrs * > (), state->s.body); }
#line 1573 "src/libexpr/parser-tab.cc"
    break;

  case 57: // expr_simple: "'rec'" '{' binds '}'
#line 389 "../nix/src/libexpr/parser.y"
    { yystack_[1].value.as < ExprAttrs * > ()->recursive = true; yystack_[1].value.as < ExprAttrs * > ()->pos = CUR_POS; yylhs.value.as < Expr * > () = yystack_[1].value.as < ExprAttrs * > (); }
#line 1579 "src/libexpr/parser-tab.cc"
    break;

  case 58: // expr_simple: '{' binds1 '}'
#line 391 "../nix/src/libexpr/parser.y"
    { yystack_[1].value.as < ExprAttrs * > ()->pos = CUR_POS; yylhs.value.as < Expr * > () = yystack_[1].value.as < ExprAttrs * > (); }
#line 1585 "src/libexpr/parser-tab.cc"
    break;

  case 59: // expr_simple: '{' '}'
#line 393 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < Expr * > () = state->exprs.add<ExprAttrs>(CUR_POS); }
#line 1591 "src/libexpr/parser-tab.cc"
    break;

  case 60: // expr_simple: '[' list ']'
#line 394 "../nix/src/libexpr/parser.y"
                 { yylhs.value.as < Expr * > () = state->exprs.add<ExprList>(state->exprs.alloc, yystack_[1].value.as < std::pmr::vector<Expr *> > ()); }
#line 1597 "src/libexpr/parser-tab.cc"
    break;

  case 61: // string_parts: "string"
#line 398 "../nix/src/libexpr/parser.y"
        { yylhs.value.as < ToBeStringyExpr > () = {yystack_[0].value.as < StringToken > ()}; }
#line 1603 "src/libexpr/parser-tab.cc"
    break;

  case 62: // string_parts: string_parts_interpolated
#line 399 "../nix/src/libexpr/parser.y"
                              { yylhs.value.as < ToBeStringyExpr > () = {state->exprs.add<ExprConcatStrings>(state->exprs.alloc, CUR_POS, true, yystack_[0].value.as < std::vector<std::pair<PosIdx, Expr *>> > ())}; }
#line 1609 "src/libexpr/parser-tab.cc"
    break;

  case 63: // string_parts: %empty
#line 400 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < ToBeStringyExpr > () = {std::string_view()}; }
#line 1615 "src/libexpr/parser-tab.cc"
    break;

  case 64: // string_parts_interpolated: string_parts_interpolated "string"
#line 405 "../nix/src/libexpr/parser.y"
  { yylhs.value.as < std::vector<std::pair<PosIdx, Expr *>> > () = std::move(yystack_[1].value.as < std::vector<std::pair<PosIdx, Expr *>> > ()); yylhs.value.as < std::vector<std::pair<PosIdx, Expr *>> > ().emplace_back(state->at(yystack_[0].location), state->exprs.add<ExprString>(state->exprs.alloc, yystack_[0].value.as < StringToken > ())); }
#line 1621 "src/libexpr/parser-tab.cc"
    break;

  case 65: // string_parts_interpolated: string_parts_interpolated "'${'" expr '}'
#line 406 "../nix/src/libexpr/parser.y"
                                                    { yylhs.value.as < std::vector<std::pair<PosIdx, Expr *>> > () = std::move(yystack_[3].value.as < std::vector<std::pair<PosIdx, Expr *>> > ()); yylhs.value.as < std::vector<std::pair<PosIdx, Expr *>> > ().emplace_back(state->at(yystack_[2].location), yystack_[1].value.as < Expr * > ()); }
#line 1627 "src/libexpr/parser-tab.cc"
    break;

  case 66: // string_parts_interpolated: "'${'" expr '}'
#line 407 "../nix/src/libexpr/parser.y"
                          { yylhs.value.as < std::vector<std::pair<PosIdx, Expr *>> > ().emplace_back(state->at(yystack_[2].location), yystack_[1].value.as < Expr * > ()); }
#line 1633 "src/libexpr/parser-tab.cc"
    break;

  case 67: // string_parts_interpolated: "string" "'${'" expr '}'
#line 408 "../nix/src/libexpr/parser.y"
                              {
      yylhs.value.as < std::vector<std::pair<PosIdx, Expr *>> > ().emplace_back(state->at(yystack_[3].location), state->exprs.add<ExprString>(state->exprs.alloc, yystack_[3].value.as < StringToken > ()));
      yylhs.value.as < std::vector<std::pair<PosIdx, Expr *>> > ().emplace_back(state->at(yystack_[2].location), yystack_[1].value.as < Expr * > ());
    }
#line 1642 "src/libexpr/parser-tab.cc"
    break;

  case 68: // path_start: "path"
#line 415 "../nix/src/libexpr/parser.y"
         {
    std::string_view literal({yystack_[0].value.as < StringToken > ().p, yystack_[0].value.as < StringToken > ().l});

    if (literal.front() == '/') {
        diagnose(state->settings.lintAbsolutePathLiterals, [&](bool) -> std::optional<ParseError> {
            return ParseError({
                .msg = HintFmt("absolute path literals are not portable. Consider replacing path literal '%s' by a string, relative path, or parameter", literal),
                .pos = state->positions[CUR_POS]
            });
        });

        /* Absolute paths are always interpreted relative to the
           root filesystem accessor, rather than the accessor of the
           current Nix expression. */
        auto path = canonPath(literal).string();
        /* add back in the trailing '/' to the first segment */
        if (literal.size() > 1 && literal.back() == '/')
          path += '/';
        yylhs.value.as < Expr * > () = state->exprs.add<ExprPath>(state->exprs.alloc, state->rootFS, path);
    } else {
        /* check for short path literals */
        diagnose(state->settings.lintShortPathLiterals, [&](bool) -> std::optional<ParseError> {
            if (literal.front() != '.')
                return ParseError({
                    .msg = HintFmt("relative path literal '%s' should be prefixed with '.' for clarity: './%s'", literal, literal),
                    .pos = state->positions[CUR_POS]
                });
            return std::nullopt;
        });

        auto basePath = std::filesystem::path(state->basePath.path.abs());
        auto path = absPath(literal, &basePath).string();
        /* add back in the trailing '/' to the first segment */
        if (literal.size() > 1 && literal.back() == '/')
          path += '/';
        yylhs.value.as < Expr * > () = state->exprs.add<ExprPath>(state->exprs.alloc, state->basePath.accessor, path);
    }
  }
#line 1685 "src/libexpr/parser-tab.cc"
    break;

  case 69: // path_start: "'~/…' path"
#line 453 "../nix/src/libexpr/parser.y"
          {
    std::string_view literal(yystack_[0].value.as < StringToken > ().p, yystack_[0].value.as < StringToken > ().l);
    if (state->settings.pureEval) {
        throw Error(
            "the path '%s' can not be resolved in pure mode",
            literal
        );
    }
    diagnose(state->settings.lintAbsolutePathLiterals, [&](bool) -> std::optional<ParseError> {
        return ParseError({
            .msg = HintFmt("home path literals are not portable. Consider replacing path literal '%s' by a string, relative path, or parameter", literal),
            .pos = state->positions[CUR_POS]
        });
    });
    auto path(getHome().string() + std::string(yystack_[0].value.as < StringToken > ().p + 1, yystack_[0].value.as < StringToken > ().l - 1));
    yylhs.value.as < Expr * > () = state->exprs.add<ExprPath>(state->exprs.alloc, state->rootFS, path);
  }
#line 1707 "src/libexpr/parser-tab.cc"
    break;

  case 70: // ind_string_parts: ind_string_parts "indented string"
#line 473 "../nix/src/libexpr/parser.y"
                             { yylhs.value.as < std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > () = std::move(yystack_[1].value.as < std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > ()); yylhs.value.as < std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > ().emplace_back(state->at(yystack_[0].location), yystack_[0].value.as < StringToken > ()); }
#line 1713 "src/libexpr/parser-tab.cc"
    break;

  case 71: // ind_string_parts: ind_string_parts "'${'" expr '}'
#line 474 "../nix/src/libexpr/parser.y"
                                           { yylhs.value.as < std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > () = std::move(yystack_[3].value.as < std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > ()); yylhs.value.as < std::vector<std::pair<PosIdx, std::variant<Expr *, StringToken>>> > ().emplace_back(state->at(yystack_[2].location), yystack_[1].value.as < Expr * > ()); }
#line 1719 "src/libexpr/parser-tab.cc"
    break;

  case 72: // ind_string_parts: %empty
#line 475 "../nix/src/libexpr/parser.y"
    { }
#line 1725 "src/libexpr/parser-tab.cc"
    break;

  case 73: // binds: binds1
#line 479 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < ExprAttrs * > () = yystack_[0].value.as < ExprAttrs * > (); }
#line 1731 "src/libexpr/parser-tab.cc"
    break;

  case 74: // binds: %empty
#line 480 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < ExprAttrs * > () = state->exprs.add<ExprAttrs>(); }
#line 1737 "src/libexpr/parser-tab.cc"
    break;

  case 75: // binds1: binds1 attrpath '=' expr ';'
#line 485 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < ExprAttrs * > () = yystack_[4].value.as < ExprAttrs * > ();
      state->addAttr(yylhs.value.as < ExprAttrs * > (), std::move(yystack_[3].value.as < std::vector<AttrName> > ()), yystack_[3].location, yystack_[1].value.as < Expr * > (), yystack_[1].location);
    }
#line 1745 "src/libexpr/parser-tab.cc"
    break;

  case 76: // binds1: binds "'inherit'" attrs ';'
#line 489 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < ExprAttrs * > () = yystack_[3].value.as < ExprAttrs * > ();
      for (auto & [i, iPos] : yystack_[1].value.as < std::vector<std::pair<AttrName, PosIdx>> > ()) {
          if (yystack_[3].value.as < ExprAttrs * > ()->attrs->find(i.symbol) != yystack_[3].value.as < ExprAttrs * > ()->attrs->end())
              state->dupAttr(i.symbol, iPos, (*yystack_[3].value.as < ExprAttrs * > ()->attrs)[i.symbol].pos);
          yystack_[3].value.as < ExprAttrs * > ()->attrs->emplace(
              i.symbol,
              ExprAttrs::AttrDef(state->exprs.add<ExprVar>(iPos, i.symbol), iPos, ExprAttrs::AttrDef::Kind::Inherited));
      }
    }
#line 1759 "src/libexpr/parser-tab.cc"
    break;

  case 77: // binds1: binds "'inherit'" '(' expr ')' attrs ';'
#line 499 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < ExprAttrs * > () = yystack_[6].value.as < ExprAttrs * > ();
      if (!yystack_[6].value.as < ExprAttrs * > ()->inheritFromExprs)
          yystack_[6].value.as < ExprAttrs * > ()->inheritFromExprs = std::make_unique<std::pmr::vector<Expr *>>();
      yystack_[6].value.as < ExprAttrs * > ()->inheritFromExprs->push_back(yystack_[3].value.as < Expr * > ());
      auto from = state->exprs.add<ExprInheritFrom>(state->at(yystack_[3].location), yystack_[6].value.as < ExprAttrs * > ()->inheritFromExprs->size() - 1);
      for (auto & [i, iPos] : yystack_[1].value.as < std::vector<std::pair<AttrName, PosIdx>> > ()) {
          if (yystack_[6].value.as < ExprAttrs * > ()->attrs->find(i.symbol) != yystack_[6].value.as < ExprAttrs * > ()->attrs->end())
              state->dupAttr(i.symbol, iPos, (*yystack_[6].value.as < ExprAttrs * > ()->attrs)[i.symbol].pos);
          yystack_[6].value.as < ExprAttrs * > ()->attrs->emplace(
              i.symbol,
              ExprAttrs::AttrDef(
                  state->exprs.add<ExprSelect>(state->exprs.alloc, iPos, from, i.symbol),
                  iPos,
                  ExprAttrs::AttrDef::Kind::InheritedFrom));
      }
    }
#line 1780 "src/libexpr/parser-tab.cc"
    break;

  case 78: // binds1: attrpath '=' expr ';'
#line 516 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < ExprAttrs * > () = state->exprs.add<ExprAttrs>();
      state->addAttr(yylhs.value.as < ExprAttrs * > (), std::move(yystack_[3].value.as < std::vector<AttrName> > ()), yystack_[3].location, yystack_[1].value.as < Expr * > (), yystack_[1].location);
    }
#line 1788 "src/libexpr/parser-tab.cc"
    break;

  case 79: // attrs: attrs attr
#line 522 "../nix/src/libexpr/parser.y"
               { yylhs.value.as < std::vector<std::pair<AttrName, PosIdx>> > () = std::move(yystack_[1].value.as < std::vector<std::pair<AttrName, PosIdx>> > ()); yylhs.value.as < std::vector<std::pair<AttrName, PosIdx>> > ().emplace_back(state->symbols.create(yystack_[0].value.as < StringToken > ()), state->at(yystack_[0].location)); }
#line 1794 "src/libexpr/parser-tab.cc"
    break;

  case 80: // attrs: attrs string_attr
#line 524 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < std::vector<std::pair<AttrName, PosIdx>> > () = std::move(yystack_[1].value.as < std::vector<std::pair<AttrName, PosIdx>> > ());
      yystack_[0].value.as < ToBeStringyExpr > ().visit(overloaded{
          [&](std::string_view str) { yylhs.value.as < std::vector<std::pair<AttrName, PosIdx>> > ().emplace_back(state->symbols.create(str), state->at(yystack_[0].location)); },
          [&](Expr * expr) {
                throw ParseError({
                    .msg = HintFmt("dynamic attributes not allowed in inherit"),
                    .pos = state->positions[state->at(yystack_[0].location)]
                });
          }}
      );
    }
#line 1810 "src/libexpr/parser-tab.cc"
    break;

  case 81: // attrs: %empty
#line 535 "../nix/src/libexpr/parser.y"
    { }
#line 1816 "src/libexpr/parser-tab.cc"
    break;

  case 82: // attrpath: attrpath '.' attr
#line 539 "../nix/src/libexpr/parser.y"
                      { yylhs.value.as < std::vector<AttrName> > () = std::move(yystack_[2].value.as < std::vector<AttrName> > ()); yylhs.value.as < std::vector<AttrName> > ().emplace_back(state->symbols.create(yystack_[0].value.as < StringToken > ())); }
#line 1822 "src/libexpr/parser-tab.cc"
    break;

  case 83: // attrpath: attrpath '.' string_attr
#line 541 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < std::vector<AttrName> > () = std::move(yystack_[2].value.as < std::vector<AttrName> > ());
      yystack_[0].value.as < ToBeStringyExpr > ().visit(overloaded{
          [&](std::string_view str) { yylhs.value.as < std::vector<AttrName> > ().emplace_back(state->symbols.create(str)); },
          [&](Expr * expr) { yylhs.value.as < std::vector<AttrName> > ().emplace_back(expr); }}
      );
    }
#line 1833 "src/libexpr/parser-tab.cc"
    break;

  case 84: // attrpath: attr
#line 547 "../nix/src/libexpr/parser.y"
         { yylhs.value.as < std::vector<AttrName> > ().emplace_back(state->symbols.create(yystack_[0].value.as < StringToken > ())); }
#line 1839 "src/libexpr/parser-tab.cc"
    break;

  case 85: // attrpath: string_attr
#line 549 "../nix/src/libexpr/parser.y"
    { yystack_[0].value.as < ToBeStringyExpr > ().visit(overloaded{
          [&](std::string_view str) { yylhs.value.as < std::vector<AttrName> > ().emplace_back(state->symbols.create(str)); },
          [&](Expr * expr) { yylhs.value.as < std::vector<AttrName> > ().emplace_back(expr); }}
      );
    }
#line 1849 "src/libexpr/parser-tab.cc"
    break;

  case 86: // attr: "identifier"
#line 557 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < StringToken > () = yystack_[0].value.as < StringToken > (); }
#line 1855 "src/libexpr/parser-tab.cc"
    break;

  case 87: // attr: "'or'"
#line 558 "../nix/src/libexpr/parser.y"
          { yylhs.value.as < StringToken > () = {"or", 2}; }
#line 1861 "src/libexpr/parser-tab.cc"
    break;

  case 88: // string_attr: '"' string_parts '"'
#line 562 "../nix/src/libexpr/parser.y"
                         { yylhs.value.as < ToBeStringyExpr > () = std::move(yystack_[1].value.as < ToBeStringyExpr > ()); }
#line 1867 "src/libexpr/parser-tab.cc"
    break;

  case 89: // string_attr: "'${'" expr '}'
#line 563 "../nix/src/libexpr/parser.y"
                          { yylhs.value.as < ToBeStringyExpr > () = {yystack_[1].value.as < Expr * > ()}; }
#line 1873 "src/libexpr/parser-tab.cc"
    break;

  case 90: // list: list expr_select
#line 567 "../nix/src/libexpr/parser.y"
                     { yylhs.value.as < std::pmr::vector<Expr *> > () = std::move(yystack_[1].value.as < std::pmr::vector<Expr *> > ()); yylhs.value.as < std::pmr::vector<Expr *> > ().push_back(yystack_[0].value.as < Expr * > ()); /* !!! dangerous */; yystack_[0].value.as < Expr * > ()->warnIfCursedOr(state->symbols, state->positions); }
#line 1879 "src/libexpr/parser-tab.cc"
    break;

  case 91: // list: %empty
#line 568 "../nix/src/libexpr/parser.y"
    { }
#line 1885 "src/libexpr/parser-tab.cc"
    break;

  case 92: // formal_set: '{' formals ',' "'...'" '}'
#line 572 "../nix/src/libexpr/parser.y"
                                 { yylhs.value.as < FormalsBuilder > () = std::move(yystack_[3].value.as < FormalsBuilder > ()); yylhs.value.as < FormalsBuilder > ().ellipsis = true; }
#line 1891 "src/libexpr/parser-tab.cc"
    break;

  case 93: // formal_set: '{' "'...'" '}'
#line 573 "../nix/src/libexpr/parser.y"
                                                           { yylhs.value.as < FormalsBuilder > ().ellipsis = true; }
#line 1897 "src/libexpr/parser-tab.cc"
    break;

  case 94: // formal_set: '{' formals ',' '}'
#line 574 "../nix/src/libexpr/parser.y"
                                 { yylhs.value.as < FormalsBuilder > () = std::move(yystack_[2].value.as < FormalsBuilder > ()); yylhs.value.as < FormalsBuilder > ().ellipsis = false; }
#line 1903 "src/libexpr/parser-tab.cc"
    break;

  case 95: // formal_set: '{' formals '}'
#line 575 "../nix/src/libexpr/parser.y"
                                 { yylhs.value.as < FormalsBuilder > () = std::move(yystack_[1].value.as < FormalsBuilder > ()); yylhs.value.as < FormalsBuilder > ().ellipsis = false; }
#line 1909 "src/libexpr/parser-tab.cc"
    break;

  case 96: // formal_set: '{' '}'
#line 576 "../nix/src/libexpr/parser.y"
                                                           { yylhs.value.as < FormalsBuilder > ().ellipsis = false; }
#line 1915 "src/libexpr/parser-tab.cc"
    break;

  case 97: // formals: formals ',' formal
#line 581 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < FormalsBuilder > () = std::move(yystack_[2].value.as < FormalsBuilder > ()); yylhs.value.as < FormalsBuilder > ().formals.emplace_back(std::move(yystack_[0].value.as < Formal > ())); }
#line 1921 "src/libexpr/parser-tab.cc"
    break;

  case 98: // formals: formal
#line 583 "../nix/src/libexpr/parser.y"
    { yylhs.value.as < FormalsBuilder > ().formals.emplace_back(std::move(yystack_[0].value.as < Formal > ())); }
#line 1927 "src/libexpr/parser-tab.cc"
    break;

  case 99: // formal: "identifier"
#line 587 "../nix/src/libexpr/parser.y"
       { yylhs.value.as < Formal > () = Formal{CUR_POS, state->symbols.create(yystack_[0].value.as < StringToken > ()), 0}; }
#line 1933 "src/libexpr/parser-tab.cc"
    break;

  case 100: // formal: "identifier" '?' expr
#line 588 "../nix/src/libexpr/parser.y"
                { yylhs.value.as < Formal > () = Formal{CUR_POS, state->symbols.create(yystack_[2].value.as < StringToken > ()), yystack_[0].value.as < Expr * > ()}; }
#line 1939 "src/libexpr/parser-tab.cc"
    break;


#line 1943 "src/libexpr/parser-tab.cc"

            default:
              break;
            }
        }
#if YY_EXCEPTIONS
      catch (const syntax_error& yyexc)
        {
          YYCDEBUG << "Caught exception: " << yyexc.what() << '\n';
          error (yyexc);
          YYERROR;
        }
#endif // YY_EXCEPTIONS
      YY_SYMBOL_PRINT ("-> $$ =", yylhs);
      yypop_ (yylen);
      yylen = 0;

      // Shift the result of the reduction.
      yypush_ (YY_NULLPTR, YY_MOVE (yylhs));
    }
    goto yynewstate;


  /*--------------------------------------.
  | yyerrlab -- here on detecting error.  |
  `--------------------------------------*/
  yyerrlab:
    // If not already recovering from an error, report this error.
    if (!yyerrstatus_)
      {
        ++yynerrs_;
        context yyctx (*this, yyla);
        std::string msg = yysyntax_error_ (yyctx);
        error (yyla.location, YY_MOVE (msg));
      }


    yyerror_range[1].location = yyla.location;
    if (yyerrstatus_ == 3)
      {
        /* If just tried and failed to reuse lookahead token after an
           error, discard it.  */

        // Return failure if at end of input.
        if (yyla.kind () == symbol_kind::S_YYEOF)
          YYABORT;
        else if (!yyla.empty ())
          {
            yy_destroy_ ("Error: discarding", yyla);
            yyla.clear ();
          }
      }

    // Else will try to reuse lookahead token after shifting the error token.
    goto yyerrlab1;


  /*---------------------------------------------------.
  | yyerrorlab -- error raised explicitly by YYERROR.  |
  `---------------------------------------------------*/
  yyerrorlab:
    /* Pacify compilers when the user code never invokes YYERROR and
       the label yyerrorlab therefore never appears in user code.  */
    if (false)
      YYERROR;

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYERROR.  */
    yypop_ (yylen);
    yylen = 0;
    YY_STACK_PRINT ();
    goto yyerrlab1;


  /*-------------------------------------------------------------.
  | yyerrlab1 -- common code for both syntax error and YYERROR.  |
  `-------------------------------------------------------------*/
  yyerrlab1:
    yyerrstatus_ = 3;   // Each real token shifted decrements this.
    // Pop stack until we find a state that shifts the error token.
    for (;;)
      {
        yyn = yypact_[+yystack_[0].state];
        if (!yy_pact_value_is_default_ (yyn))
          {
            yyn += symbol_kind::S_YYerror;
            if (0 <= yyn && yyn <= yylast_
                && yycheck_[yyn] == symbol_kind::S_YYerror)
              {
                yyn = yytable_[yyn];
                if (0 < yyn)
                  break;
              }
          }

        // Pop the current state because it cannot handle the error token.
        if (yystack_.size () == 1)
          YYABORT;

        yyerror_range[1].location = yystack_[0].location;
        yy_destroy_ ("Error: popping", yystack_[0]);
        yypop_ ();
        YY_STACK_PRINT ();
      }
    {
      stack_symbol_type error_token;

      yyerror_range[2].location = yyla.location;
      YYLLOC_DEFAULT (error_token.location, yyerror_range, 2);

      // Shift the error token.
      error_token.state = state_type (yyn);
      yypush_ ("Shifting", YY_MOVE (error_token));
    }
    goto yynewstate;


  /*-------------------------------------.
  | yyacceptlab -- YYACCEPT comes here.  |
  `-------------------------------------*/
  yyacceptlab:
    yyresult = 0;
    goto yyreturn;


  /*-----------------------------------.
  | yyabortlab -- YYABORT comes here.  |
  `-----------------------------------*/
  yyabortlab:
    yyresult = 1;
    goto yyreturn;


  /*-----------------------------------------------------.
  | yyreturn -- parsing is finished, return the result.  |
  `-----------------------------------------------------*/
  yyreturn:
    if (!yyla.empty ())
      yy_destroy_ ("Cleanup: discarding lookahead", yyla);

    /* Do not reclaim the symbols of the rule whose action triggered
       this YYABORT or YYACCEPT.  */
    yypop_ (yylen);
    YY_STACK_PRINT ();
    while (1 < yystack_.size ())
      {
        yy_destroy_ ("Cleanup: popping", yystack_[0]);
        yypop_ ();
      }

    return yyresult;
  }
#if YY_EXCEPTIONS
    catch (...)
      {
        YYCDEBUG << "Exception caught: cleaning lookahead and stack\n";
        // Do not try to display the values of the reclaimed symbols,
        // as their printers might throw an exception.
        if (!yyla.empty ())
          yy_destroy_ (YY_NULLPTR, yyla);

        while (1 < yystack_.size ())
          {
            yy_destroy_ (YY_NULLPTR, yystack_[0]);
            yypop_ ();
          }
        throw;
      }
#endif // YY_EXCEPTIONS
  }

  void
   BisonParser ::error (const syntax_error& yyexc)
  {
    error (yyexc.location, yyexc.what ());
  }

  const char *
   BisonParser ::symbol_name (symbol_kind_type yysymbol)
  {
    static const char *const yy_sname[] =
    {
    "end of file", "error", "invalid token", "identifier", "string",
  "indented string", "integer", "floating-point literal", "path",
  "'~/…' path", "'<…>' path", "end of path", "URI", "'if'", "'then'",
  "'else'", "'assert'", "'with'", "'let'", "'in'", "'rec'", "'inherit'",
  "'=='", "'!='", "'<='", "'>='", "'//'", "'++'", "'&&'", "'||'", "'->'",
  "'or'", "'<|'", "'|>'", "'${'", "start of an indented string",
  "end of an indented string", "'...'", "start of REPL bindings", "'<'",
  "'>'", "NOT", "'+'", "'-'", "'*'", "'/'", "'?'", "NEGATE", "':'", "'@'",
  "';'", "'!'", "'.'", "'\"'", "'('", "')'", "'{'", "'}'", "'['", "']'",
  "'='", "','", "$accept", "start", "expr", "expr_function", "expr_if",
  "expr_pipe_from", "expr_pipe_into", "expr_op", "expr_app", "expr_select",
  "expr_simple", "string_parts", "string_parts_interpolated", "path_start",
  "ind_string_parts", "binds", "binds1", "attrs", "attrpath", "attr",
  "string_attr", "list", "formal_set", "formals", "formal", YY_NULLPTR
    };
    return yy_sname[yysymbol];
  }



  //  BisonParser ::context.
   BisonParser ::context::context (const  BisonParser & yyparser, const symbol_type& yyla)
    : yyparser_ (yyparser)
    , yyla_ (yyla)
  {}

  int
   BisonParser ::context::expected_tokens (symbol_kind_type yyarg[], int yyargn) const
  {
    // Actual number of expected tokens
    int yycount = 0;

    const int yyn = yypact_[+yyparser_.yystack_[0].state];
    if (!yy_pact_value_is_default_ (yyn))
      {
        /* Start YYX at -YYN if negative to avoid negative indexes in
           YYCHECK.  In other words, skip the first -YYN actions for
           this state because they are default actions.  */
        const int yyxbegin = yyn < 0 ? -yyn : 0;
        // Stay within bounds of both yycheck and yytname.
        const int yychecklim = yylast_ - yyn + 1;
        const int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
        for (int yyx = yyxbegin; yyx < yyxend; ++yyx)
          if (yycheck_[yyx + yyn] == yyx && yyx != symbol_kind::S_YYerror
              && !yy_table_value_is_error_ (yytable_[yyx + yyn]))
            {
              if (!yyarg)
                ++yycount;
              else if (yycount == yyargn)
                return 0;
              else
                yyarg[yycount++] = YY_CAST (symbol_kind_type, yyx);
            }
      }

    if (yyarg && yycount == 0 && 0 < yyargn)
      yyarg[0] = symbol_kind::S_YYEMPTY;
    return yycount;
  }






  int
   BisonParser ::yy_syntax_error_arguments_ (const context& yyctx,
                                                 symbol_kind_type yyarg[], int yyargn) const
  {
    /* There are many possibilities here to consider:
       - If this state is a consistent state with a default action, then
         the only way this function was invoked is if the default action
         is an error action.  In that case, don't check for expected
         tokens because there are none.
       - The only way there can be no lookahead present (in yyla) is
         if this state is a consistent state with a default action.
         Thus, detecting the absence of a lookahead is sufficient to
         determine that there is no unexpected or expected token to
         report.  In that case, just report a simple "syntax error".
       - Don't assume there isn't a lookahead just because this state is
         a consistent state with a default action.  There might have
         been a previous inconsistent state, consistent state with a
         non-default action, or user semantic action that manipulated
         yyla.  (However, yyla is currently not documented for users.)
       - Of course, the expected token list depends on states to have
         correct lookahead information, and it depends on the parser not
         to perform extra reductions after fetching a lookahead from the
         scanner and before detecting a syntax error.  Thus, state merging
         (from LALR or IELR) and default reductions corrupt the expected
         token list.  However, the list is correct for canonical LR with
         one exception: it will still contain any token that will not be
         accepted due to an error action in a later state.
    */

    if (!yyctx.lookahead ().empty ())
      {
        if (yyarg)
          yyarg[0] = yyctx.token ();
        int yyn = yyctx.expected_tokens (yyarg ? yyarg + 1 : yyarg, yyargn - 1);
        return yyn + 1;
      }
    return 0;
  }

  // Generate an error message.
  std::string
   BisonParser ::yysyntax_error_ (const context& yyctx) const
  {
    // Its maximum.
    enum { YYARGS_MAX = 5 };
    // Arguments of yyformat.
    symbol_kind_type yyarg[YYARGS_MAX];
    int yycount = yy_syntax_error_arguments_ (yyctx, yyarg, YYARGS_MAX);

    char const* yyformat = YY_NULLPTR;
    switch (yycount)
      {
#define YYCASE_(N, S)                         \
        case N:                               \
          yyformat = S;                       \
        break
      default: // Avoid compiler warnings.
        YYCASE_ (0, YY_("syntax error"));
        YYCASE_ (1, YY_("syntax error, unexpected %s"));
        YYCASE_ (2, YY_("syntax error, unexpected %s, expecting %s"));
        YYCASE_ (3, YY_("syntax error, unexpected %s, expecting %s or %s"));
        YYCASE_ (4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
        YYCASE_ (5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
      }

    std::string yyres;
    // Argument number.
    std::ptrdiff_t yyi = 0;
    for (char const* yyp = yyformat; *yyp; ++yyp)
      if (yyp[0] == '%' && yyp[1] == 's' && yyi < yycount)
        {
          yyres += symbol_name (yyarg[yyi++]);
          ++yyp;
        }
      else
        yyres += *yyp;
    return yyres;
  }


  const signed char  BisonParser ::yypact_ninf_ = -105;

  const signed char  BisonParser ::yytable_ninf_ = -100;

  const short
   BisonParser ::yypact_[] =
  {
     158,    68,  -105,  -105,  -105,  -105,  -105,  -105,   182,   182,
     182,   226,   -32,  -105,    11,   212,   212,     3,   182,    50,
    -105,    30,  -105,  -105,  -105,  -105,     6,   277,   236,  -105,
       0,    75,    71,   182,    29,    57,    61,    63,  -105,  -105,
     182,     3,    11,    80,    11,   -19,  -105,  -105,    11,    15,
     102,    94,  -105,    92,    23,  -105,   242,    90,   182,    74,
      21,    96,   -23,    95,    73,    25,    39,  -105,     9,  -105,
     212,   212,   212,   212,   212,   212,   212,   212,   212,   212,
     212,   212,   212,   212,   212,   212,   212,   212,    11,  -105,
    -105,    11,    90,  -105,    84,   182,   146,  -105,    32,   106,
     182,   182,   182,   101,   107,   -10,   182,   105,    46,    11,
     182,     1,  -105,   182,  -105,  -105,   182,   112,  -105,  -105,
     182,  -105,   182,  -105,  -105,  -105,    33,  -105,  -105,   327,
     361,   361,   392,   392,   397,    64,   369,   336,   327,  -105,
     302,   327,   392,   392,   135,   135,    64,    64,   111,    52,
    -105,  -105,   124,   131,  -105,   182,   167,  -105,  -105,  -105,
    -105,  -105,  -105,   182,   153,   182,  -105,  -105,   133,  -105,
     129,   140,  -105,   147,  -105,   148,  -105,  -105,   236,   182,
    -105,   182,   152,  -105,  -105,  -105,   160,  -105,  -105,  -105,
    -105,  -105,  -105,  -105,  -105,  -105,  -105,   228,  -105
  };

  const signed char
   BisonParser ::yydefact_[] =
  {
       0,    46,    47,    48,    68,    69,    53,    54,     0,     0,
       0,    74,     0,    72,    74,     0,     0,    63,     0,    74,
      91,     0,     2,     4,    12,    14,    15,    16,    39,    41,
      45,     0,     0,     0,     0,     0,     0,     0,    86,    87,
       0,    63,    74,     0,    73,     0,    84,    85,    74,     0,
       0,     3,    46,     0,    74,    22,    21,    61,     0,     0,
      62,     0,    86,     0,    59,    73,     0,    98,     0,     1,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    40,
      44,     0,     0,    51,     0,     0,     0,     5,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    81,     0,     0,
       0,     0,    70,     0,    50,    59,     0,     0,    49,    64,
       0,    55,     0,    93,    58,    95,     0,    60,    90,    19,
      23,    24,    26,    28,    32,    38,    29,    30,    31,    17,
      18,    20,    25,    27,    34,    35,    36,    37,    33,    42,
      52,     6,     0,    99,    96,     0,     0,     9,    10,    89,
      88,    56,    11,     0,     0,     0,    82,    83,     0,    57,
       0,     0,    66,     0,   100,     0,    94,    97,     0,     0,
       8,     0,     0,    76,    79,    80,     0,    78,    71,    67,
      65,    92,    43,     7,    13,    81,    75,     0,    77
  };

  const short
   BisonParser ::yypgoto_[] =
  {
    -105,  -105,    -8,   -29,  -105,   128,  -105,    59,  -105,   -25,
    -105,   172,   192,  -105,  -105,    -2,    -6,    31,   207,  -104,
    -103,  -105,   193,  -105,   108
  };

  const unsigned char
   BisonParser ::yydefgoto_[] =
  {
       0,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    59,    60,    31,    49,    50,    44,   164,    45,    46,
      47,    68,    32,    66,    67
  };

  const short
   BisonParser ::yytable_[] =
  {
      35,    36,    37,    89,    97,   166,   167,    57,    51,    43,
      61,   107,    52,    65,    38,     2,     3,     4,     5,     6,
     112,     7,   107,   122,    48,   119,    38,    53,    38,    12,
      69,    90,   103,   109,   -99,   153,   153,    58,   -99,    70,
     105,   110,    39,   128,    13,    40,   111,   161,    65,   113,
     117,   114,    91,    62,    39,   120,    39,    40,   169,    40,
     184,   185,    17,    18,    41,    54,   151,    20,   127,    63,
     175,   100,   157,   158,    55,    56,    41,   162,    41,    92,
     115,    39,   124,   178,    40,    98,    93,    63,   119,   154,
     176,    76,   156,   184,   185,   150,   125,    38,   109,   106,
     126,   107,   168,    41,   109,   170,   165,    64,   171,    58,
      88,   101,   173,   102,   174,   -73,    33,    34,   120,    95,
      96,   -96,   -96,   107,   116,    39,   180,   118,    40,   129,
     130,   131,   132,   133,   134,   135,   136,   137,   138,   140,
     141,   142,   143,   144,   145,   146,   147,    41,    42,   152,
     193,   121,   123,   192,   155,   182,    38,   186,   159,   163,
     160,     1,    76,   109,     2,     3,     4,     5,     6,   172,
       7,     8,   179,   194,     9,    10,    11,   122,    12,    86,
      87,    88,   181,   187,    39,     1,   188,    40,     2,     3,
       4,     5,     6,    13,     7,     8,    14,   189,     9,    10,
      11,    15,    12,   183,   190,   191,    41,   195,   139,    16,
     196,    17,    18,   104,    19,    52,    20,    13,     2,     3,
       4,     5,     6,    94,     7,    15,   197,    99,     0,    38,
      53,    38,    12,    16,   177,    17,    18,     0,    19,    52,
      20,     0,     2,     3,     4,     5,     6,    13,     7,     0,
       0,   108,     0,     0,    53,    15,    12,    39,   108,    39,
      40,     0,    40,    16,     0,    17,    18,     0,    54,    76,
      20,    13,   108,     0,     0,     0,     0,     0,   198,    41,
       0,    41,    42,     0,    84,    85,    86,    87,    88,    17,
      18,     0,    54,     0,    20,   148,     0,     0,   149,    71,
      72,    73,    74,    75,    76,    77,    78,    79,     0,    80,
      81,     0,     0,     0,     0,     0,    82,    83,     0,    84,
      85,    86,    87,    88,    71,    72,    73,    74,    75,    76,
      77,    78,    79,     0,    80,     0,     0,     0,     0,     0,
       0,    82,    83,     0,    84,    85,    86,    87,    88,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    71,    72,
      73,    74,    75,    76,    77,     0,    82,    83,     0,    84,
      85,    86,    87,    88,     0,    82,    83,     0,    84,    85,
      86,    87,    88,  -100,  -100,    73,    74,    75,    76,     0,
       0,    71,    72,    73,    74,    75,    76,     0,     0,     0,
      82,    83,     0,    84,    85,    86,    87,    88,    82,    83,
       0,    84,    85,    86,    87,    88,  -100,  -100,    75,    76,
       0,     0,     0,    75,    76,     0,     0,     0,     0,     0,
       0,  -100,  -100,     0,    84,    85,    86,    87,    88,    84,
      85,    86,    87,    88
  };

  const short
   BisonParser ::yycheck_[] =
  {
       8,     9,    10,    28,    33,   109,   109,     4,    14,    11,
      18,    21,     3,    19,     3,     6,     7,     8,     9,    10,
       5,    12,    21,    46,    56,     4,     3,    18,     3,    20,
       0,    31,    40,    52,    57,     3,     3,    34,    61,    33,
      42,    60,    31,    68,    35,    34,    48,    57,    54,    34,
      58,    36,    52,     3,    31,    34,    31,    34,    57,    34,
     164,   164,    53,    54,    53,    56,    95,    58,    59,    37,
      37,    14,   101,   102,    15,    16,    53,   106,    53,     4,
      57,    31,    57,    31,    34,    56,    11,    37,     4,    57,
      57,    27,   100,   197,   197,    11,    57,     3,    52,    19,
      61,    21,   110,    53,    52,   113,    60,    57,   116,    34,
      46,    50,   120,    50,   122,    21,    48,    49,    34,    48,
      49,    48,    49,    21,    34,    31,   155,    53,    34,    70,
      71,    72,    73,    74,    75,    76,    77,    78,    79,    80,
      81,    82,    83,    84,    85,    86,    87,    53,    56,     3,
     179,    55,    57,   178,    48,   163,     3,   165,    57,    54,
      53,     3,    27,    52,     6,     7,     8,     9,    10,    57,
      12,    13,    48,   181,    16,    17,    18,    46,    20,    44,
      45,    46,    15,    50,    31,     3,    57,    34,     6,     7,
       8,     9,    10,    35,    12,    13,    38,    57,    16,    17,
      18,    43,    20,    50,    57,    57,    53,    55,    80,    51,
      50,    53,    54,    41,    56,     3,    58,    35,     6,     7,
       8,     9,    10,    31,    12,    43,   195,    34,    -1,     3,
      18,     3,    20,    51,   126,    53,    54,    -1,    56,     3,
      58,    -1,     6,     7,     8,     9,    10,    35,    12,    -1,
      -1,    44,    -1,    -1,    18,    43,    20,    31,    51,    31,
      34,    -1,    34,    51,    -1,    53,    54,    -1,    56,    27,
      58,    35,    65,    -1,    -1,    -1,    -1,    -1,    50,    53,
      -1,    53,    56,    -1,    42,    43,    44,    45,    46,    53,
      54,    -1,    56,    -1,    58,    88,    -1,    -1,    91,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    -1,    32,
      33,    -1,    -1,    -1,    -1,    -1,    39,    40,    -1,    42,
      43,    44,    45,    46,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    32,    -1,    -1,    -1,    -1,    -1,
      -1,    39,    40,    -1,    42,    43,    44,    45,    46,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    22,    23,
      24,    25,    26,    27,    28,    -1,    39,    40,    -1,    42,
      43,    44,    45,    46,    -1,    39,    40,    -1,    42,    43,
      44,    45,    46,    22,    23,    24,    25,    26,    27,    -1,
      -1,    22,    23,    24,    25,    26,    27,    -1,    -1,    -1,
      39,    40,    -1,    42,    43,    44,    45,    46,    39,    40,
      -1,    42,    43,    44,    45,    46,    24,    25,    26,    27,
      -1,    -1,    -1,    26,    27,    -1,    -1,    -1,    -1,    -1,
      -1,    39,    40,    -1,    42,    43,    44,    45,    46,    42,
      43,    44,    45,    46
  };

  const signed char
   BisonParser ::yystos_[] =
  {
       0,     3,     6,     7,     8,     9,    10,    12,    13,    16,
      17,    18,    20,    35,    38,    43,    51,    53,    54,    56,
      58,    63,    64,    65,    66,    67,    68,    69,    70,    71,
      72,    75,    84,    48,    49,    64,    64,    64,     3,    31,
      34,    53,    56,    77,    78,    80,    81,    82,    56,    76,
      77,    78,     3,    18,    56,    69,    69,     4,    34,    73,
      74,    64,     3,    37,    57,    78,    85,    86,    83,     0,
      33,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      32,    33,    39,    40,    42,    43,    44,    45,    46,    71,
      31,    52,     4,    11,    74,    48,    49,    65,    56,    84,
      14,    50,    50,    64,    73,    77,    19,    21,    80,    52,
      60,    77,     5,    34,    36,    57,    34,    64,    53,     4,
      34,    55,    46,    57,    57,    57,    61,    59,    71,    69,
      69,    69,    69,    69,    69,    69,    69,    69,    69,    67,
      69,    69,    69,    69,    69,    69,    69,    69,    80,    80,
      11,    65,     3,     3,    57,    48,    64,    65,    65,    57,
      53,    57,    65,    54,    79,    60,    81,    82,    64,    57,
      64,    64,    57,    64,    64,    37,    57,    86,    31,    48,
      65,    15,    64,    50,    81,    82,    64,    50,    57,    57,
      57,    57,    71,    65,    64,    55,    50,    79,    50
  };

  const signed char
   BisonParser ::yyr1_[] =
  {
       0,    62,    63,    63,    64,    65,    65,    65,    65,    65,
      65,    65,    65,    66,    66,    66,    66,    67,    67,    68,
      68,    69,    69,    69,    69,    69,    69,    69,    69,    69,
      69,    69,    69,    69,    69,    69,    69,    69,    69,    69,
      70,    70,    71,    71,    71,    71,    72,    72,    72,    72,
      72,    72,    72,    72,    72,    72,    72,    72,    72,    72,
      72,    73,    73,    73,    74,    74,    74,    74,    75,    75,
      76,    76,    76,    77,    77,    78,    78,    78,    78,    79,
      79,    79,    80,    80,    80,    80,    81,    81,    82,    82,
      83,    83,    84,    84,    84,    84,    84,    85,    85,    86,
      86
  };

  const signed char
   BisonParser ::yyr2_[] =
  {
       0,     2,     1,     2,     1,     3,     3,     5,     5,     4,
       4,     4,     1,     6,     1,     1,     1,     3,     3,     3,
       3,     2,     2,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     1,
       2,     1,     3,     5,     2,     1,     1,     1,     1,     3,
       3,     2,     3,     1,     1,     3,     4,     4,     3,     2,
       3,     1,     1,     0,     2,     4,     3,     4,     1,     1,
       2,     4,     0,     1,     0,     5,     4,     7,     4,     2,
       2,     0,     3,     3,     1,     1,     1,     1,     3,     3,
       2,     0,     5,     3,     4,     3,     2,     3,     1,     1,
       3
  };




#if YYDEBUG
  const short
   BisonParser ::yyrline_[] =
  {
       0,   223,   223,   229,   234,   237,   242,   249,   257,   265,
     267,   269,   277,   281,   282,   283,   284,   288,   289,   293,
     294,   298,   299,   300,   301,   302,   303,   304,   305,   306,
     307,   308,   309,   310,   311,   313,   314,   315,   316,   317,
     321,   326,   330,   332,   341,   343,   347,   354,   355,   356,
     357,   360,   361,   365,   372,   383,   386,   388,   390,   392,
     394,   398,   399,   400,   404,   406,   407,   408,   415,   453,
     473,   474,   475,   479,   480,   484,   488,   498,   515,   522,
     523,   535,   539,   540,   547,   548,   557,   558,   562,   563,
     567,   568,   572,   573,   574,   575,   576,   580,   582,   587,
     588
  };

  void
   BisonParser ::yy_stack_print_ () const
  {
    *yycdebug_ << "Stack now";
    for (stack_type::const_iterator
           i = yystack_.begin (),
           i_end = yystack_.end ();
         i != i_end; ++i)
      *yycdebug_ << ' ' << int (i->state);
    *yycdebug_ << '\n';
  }

  void
   BisonParser ::yy_reduce_print_ (int yyrule) const
  {
    int yylno = yyrline_[yyrule];
    int yynrhs = yyr2_[yyrule];
    // Print the symbols being reduced, and their result.
    *yycdebug_ << "Reducing stack by rule " << yyrule - 1
               << " (line " << yylno << "):\n";
    // The symbols being reduced.
    for (int yyi = 0; yyi < yynrhs; yyi++)
      YY_SYMBOL_PRINT ("   $" << yyi + 1 << " =",
                       yystack_[(yynrhs) - (yyi + 1)]);
  }
#endif // YYDEBUG

   BisonParser ::symbol_kind_type
   BisonParser ::yytranslate_ (int t) YY_NOEXCEPT
  {
    // YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to
    // TOKEN-NUM as returned by yylex.
    static
    const signed char
    translate_table[] =
    {
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    51,    53,     2,     2,     2,     2,     2,
      54,    55,    44,    42,    61,    43,    52,    45,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    48,    50,
      39,    60,    40,    46,    49,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    58,     2,    59,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    56,     2,    57,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    41,    47
    };
    // Last valid token kind.
    const int code_max = 295;

    if (t <= 0)
      return symbol_kind::S_YYEOF;
    else if (t <= code_max)
      return static_cast <symbol_kind_type> (translate_table[t]);
    else
      return symbol_kind::S_YYUNDEF;
  }

#line 3 "../nix/src/libexpr/parser.y"
} } //  ::nix::parser 
#line 2599 "src/libexpr/parser-tab.cc"

#line 591 "../nix/src/libexpr/parser.y"


#include "nix/expr/eval.hh"


namespace nix {

Expr * parseExprFromBuf(
    char * text,
    size_t length,
    Pos::Origin origin,
    const SourcePath & basePath,
    Exprs & exprs,
    SymbolTable & symbols,
    const EvalSettings & settings,
    PosTable & positions,
    DocCommentMap & docComments,
    const ref<SourceAccessor> rootFS)
{
    yyscan_t scanner;
    LexerState lexerState {
        .positionToDocComment = docComments,
        .positions = positions,
        .origin = positions.addOrigin(origin, length),
    };
    ParserState state {
        .lexerState = lexerState,
        .exprs = exprs,
        .symbols = symbols,
        .positions = positions,
        .basePath = basePath,
        .origin = lexerState.origin,
        .rootFS = rootFS,
        .settings = settings,
    };

    yylex_init_extra(&lexerState, &scanner);
    Finally _destroy([&] { yylex_destroy(scanner); });

    yy_scan_buffer(text, length, scanner);
    Parser parser(scanner, &state);
    parser.parse();

    return state.result;
}

ExprAttrs * parseReplBindingsFromBuf(
    char * text,
    size_t length,
    Pos::Origin origin,
    const SourcePath & basePath,
    Exprs & exprs,
    SymbolTable & symbols,
    const EvalSettings & settings,
    PosTable & positions,
    DocCommentMap & docComments,
    const ref<SourceAccessor> rootFS)
{
    yyscan_t scanner;
    LexerState lexerState {
        .positionToDocComment = docComments,
        .positions = positions,
        .origin = positions.addOrigin(origin, length),
    };
    ParserState state {
        .lexerState = lexerState,
        .exprs = exprs,
        .symbols = symbols,
        .positions = positions,
        .basePath = basePath,
        .origin = lexerState.origin,
        .rootFS = rootFS,
        .settings = settings,
    };

    yylex_init_extra(&lexerState, &scanner);
    Finally _destroy([&] { yylex_destroy(scanner); });

    yy_scan_buffer(text, length, scanner);
    setReplBindingsMode(scanner);
    Parser parser(scanner, &state);
    parser.parse();

    assert(state.result);
    // state.result is Expr *, but the REPL_BINDINGS grammar rule
    // always produces an ExprAttrs via the binds1 production.
    auto bindings = dynamic_cast<ExprAttrs *>(state.result);
    assert(bindings);
    return bindings;
}


}
#pragma GCC diagnostic pop // end ignored "-Wswitch-enum"
