/*
 * libssc: Library to expose Qualcomm Sensor Core sensors
 * Copyright (C) 2022-2026 Dylan Van Assche
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef _LIBSSC_VERSION_H_
#define _LIBSSC_VERSION_H_

/**
 * LIBSSC_MAJOR_VERSION:
 *
 * The major version number of the libssc
 * which this source is compiled against.
 *
 * Since: 0.0.1
 */
#define LIBSSC_MAJOR_VERSION (0)

/**
 * LIBSSC_MINOR_VERSION:
 *
 * The minor version number of the libssc
 * which this source is compiled against.
 *
 * Since: 0.0.1
 */
#define LIBSSC_MINOR_VERSION (4)

/**
 * LIBSSC_PATCH_VERSION:
 *
 * The patch version number of the libssc
 * which this source is compiled against.
 *
 * Since: 0.0.1
 */
#define LIBSSC_PATCH_VERSION (1)

/**
 * LIBSSC_CHECK_VERSION:
 * @major: major version (e.g. 1 for version 1.2.3)
 * @minor: minor version (e.g. 2 for version 1.2.3)
 * @patch: patch version (e.g. 3 for version 1.2.3)
 *
 * Checks the version of the libssc that is being compilex against.
 *
 * Returns: %TRUE if the version of header files is equal or newer than the passed-in values.
 *
 * Since: 0.0.1
 */
#define LIBSSC_CHECK_VERSION(major,minor,patch) \
	(LIBSSC_MAJOR_VERSION > (major) || \
	(LIBSSC_MAJOR_VERSION == (major) && LIBSSC_MINOR_VERSION > (minor)) || \
	(LIBSSC_MAJOR_VERSION == (major) && LIBSSC_MINOR_VERSION == (minor) && LIBSSC_PATCH_VERSION >= (patch)))

#endif /* _LIBSSC_VERSION_H_ */
