/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.List;
import org.hibernate.dialect.function.json.ExpressionTypeHelper;
import org.hibernate.dialect.function.xml.XmlExistsFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerXmlExistsFunction
extends XmlExistsFunction {
    public SQLServerXmlExistsFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression xmlDocument = (Expression)sqlAstArguments.get(1);
        boolean needsCast = !ExpressionTypeHelper.isXml(xmlDocument);
        sqlAppender.appendSql('(');
        if (needsCast) {
            sqlAppender.appendSql("cast(");
        }
        sqlAstArguments.get(1).accept(walker);
        if (needsCast) {
            sqlAppender.appendSql(" as xml)");
        }
        sqlAppender.appendSql(".exist(");
        sqlAstArguments.get(0).accept(walker);
        sqlAppender.appendSql(")=1)");
    }
}

