/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.GridWidget;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.extractors.DataAggregatorFactory;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ExtractorsHelper;
import com.intellij.database.run.ui.Aggregator;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableAggregatorWidgetHelper
implements GridWidget.GridWidgetHelper {
    private static final char ABBREVIATION_SUFFIX = '\u2026';
    private static final char RETURN_SYMBOL = '\u23ce';
    private static final int MAX_LENGTH = 50;
    private final DataGrid myGrid;
    private Aggregator myAggregator;

    public TableAggregatorWidgetHelper(@NotNull ResultView table2, @NotNull DataGrid grid) {
        if (table2 == null) {
            TableAggregatorWidgetHelper.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            TableAggregatorWidgetHelper.$$$reportNull$$$0(1);
        }
        this.myGrid = grid;
        List scripts = DataExtractorFactories.getAggregatorScripts((ExtractorsHelper)ExtractorsHelper.getInstance((CoreGrid)this.myGrid), GridUtil::suggestPlugin);
        DataGridSettings settings = GridUtil.getSettings(grid);
        String chosenAggregatorName = Objects.requireNonNullElse(settings == null ? null : settings.getWidgetAggregator(), "SUM.groovy");
        table2.getComponent().putClientProperty("ResultViewAggregatorWidgetHelper", this);
        for (DataAggregatorFactory script : scripts) {
            if (!StringUtil.equals((CharSequence)script.getName(), (CharSequence)chosenAggregatorName)) continue;
            ApplicationManager.getApplication().invokeLater(() -> {
                ExtractorConfig config = ExtractorsHelper.getInstance((CoreGrid)grid).createExtractorConfig((CoreGrid)grid, grid.getObjectFormatter());
                DataExtractor extractor = script.createAggregator(config);
                if (extractor == null) {
                    return;
                }
                this.myAggregator = new Aggregator(grid, extractor, script.getSimpleName(), script.getName());
            });
        }
    }

    public void setAggregator(@Nullable Aggregator aggregator) {
        this.myAggregator = aggregator;
    }

    @Nullable
    public Aggregator getAggregator() {
        return this.myAggregator;
    }

    @Override
    public @NotNull CompletableFuture<@NlsContexts.Label String> getText() {
        if (this.myGrid.isEmpty()) {
            CompletableFuture<String> completableFuture = CompletableFuture.completedFuture("");
            if (completableFuture == null) {
                TableAggregatorWidgetHelper.$$$reportNull$$$0(2);
            }
            return completableFuture;
        }
        @NlsContexts.Label @NlsSafe StringBuilder sb = new StringBuilder();
        if (this.myAggregator != null) {
            boolean hasSelectedValues;
            sb.append(this.myAggregator.getSimpleName());
            sb.append(": ");
            SelectionModel selectionModel = this.myGrid.getSelectionModel();
            boolean bl = hasSelectedValues = selectionModel.getSelectedColumnCount() * selectionModel.getSelectedRowCount() != 0;
            if (hasSelectedValues) {
                CompletionStage completionStage = this.myAggregator.update().thenApply(result -> {
                    sb.append(result.getText());
                    return TableAggregatorWidgetHelper.cleanup(sb.toString());
                });
                if (completionStage == null) {
                    TableAggregatorWidgetHelper.$$$reportNull$$$0(3);
                }
                return completionStage;
            }
            sb.append(DataGridBundle.message((String)"label.aggregator.not.enough.values", (Object[])new Object[0]));
            CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(sb.toString());
            if (completableFuture == null) {
                TableAggregatorWidgetHelper.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }
        CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(DataGridBundle.message((String)"label.aggregator.not.chosen", (Object[])new Object[0]));
        if (completableFuture == null) {
            TableAggregatorWidgetHelper.$$$reportNull$$$0(5);
        }
        return completableFuture;
    }

    @NlsContexts.Label
    private static String cleanup(@NlsContexts.Label @NotNull String s) {
        String result;
        if (s == null) {
            TableAggregatorWidgetHelper.$$$reportNull$$$0(6);
        }
        return (result = s.replaceAll("\n", String.valueOf('\u23ce'))).length() > 50 ? result.substring(0, 50) + "\u2026" : result;
    }

    @NotNull
    public CompletableFuture<String> getResultText() {
        CompletionStage<String> completionStage = this.myAggregator != null ? this.myAggregator.update().thenApply(res -> res.getText()) : CompletableFuture.completedFuture("");
        if (completionStage == null) {
            TableAggregatorWidgetHelper.$$$reportNull$$$0(7);
        }
        return completionStage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/TableAggregatorWidgetHelper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/TableAggregatorWidgetHelper";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cleanup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7 -> new IllegalStateException(string);
        };
    }
}

