/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.ui.impl;

import com.intellij.debugger.streams.core.trace.CollectionTreeBuilder;
import com.intellij.debugger.streams.core.trace.DebuggerCommandLauncher;
import com.intellij.debugger.streams.core.trace.GenericEvaluationContext;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.Value;
import com.intellij.debugger.streams.core.ui.LinkedValuesMapping;
import com.intellij.debugger.streams.core.ui.TraceController;
import com.intellij.debugger.streams.core.ui.ValueWithPosition;
import com.intellij.debugger.streams.core.ui.ValuesPositionsListener;
import com.intellij.debugger.streams.core.ui.impl.CollectionTree;
import com.intellij.debugger.streams.core.ui.impl.CollectionView;
import com.intellij.debugger.streams.core.ui.impl.FlatView;
import com.intellij.debugger.streams.core.ui.impl.MappingPane;
import com.intellij.debugger.streams.core.ui.impl.PositionsAwareCollectionView;
import com.intellij.debugger.streams.core.ui.impl.ValueWithPositionImpl;
import com.intellij.debugger.streams.core.wrapper.StreamCall;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bB5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0014\u0010\u0018\u001a\u00020\u0019*\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004H\u0002R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/debugger/streams/core/ui/impl/FlatView;", "Ljavax/swing/JPanel;", "controllers", "", "Lcom/intellij/debugger/streams/core/ui/TraceController;", "launcher", "Lcom/intellij/debugger/streams/core/trace/DebuggerCommandLauncher;", "context", "Lcom/intellij/debugger/streams/core/trace/GenericEvaluationContext;", "builder", "Lcom/intellij/debugger/streams/core/trace/CollectionTreeBuilder;", "debugName", "", "<init>", "(Ljava/util/List;Lcom/intellij/debugger/streams/core/trace/DebuggerCommandLauncher;Lcom/intellij/debugger/streams/core/trace/GenericEvaluationContext;Lcom/intellij/debugger/streams/core/trace/CollectionTreeBuilder;Ljava/lang/String;)V", "myPool", "", "Lcom/intellij/debugger/streams/core/trace/TraceElement;", "Lcom/intellij/debugger/streams/core/ui/impl/ValueWithPositionImpl;", "add", "Ljava/awt/Component;", "component", "getValue", "element", "resolve", "Lcom/intellij/debugger/streams/core/ui/impl/FlatView$LinkedValuesWithPositions;", "nextController", "LinkedValuesWithPositions", "intellij.debugger.streams.core"})
@SourceDebugExtension(value={"SMAP\nFlatView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlatView.kt\ncom/intellij/debugger/streams/core/ui/impl/FlatView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1563#2:123\n1634#2,3:124\n1563#2:127\n1634#2,3:128\n1563#2:132\n1634#2,3:133\n1#3:131\n*S KotlinDebug\n*F\n+ 1 FlatView.kt\ncom/intellij/debugger/streams/core/ui/impl/FlatView\n*L\n33#1:123\n33#1:124,3\n64#1:127\n64#1:128,3\n110#1:132\n110#1:133,3\n*E\n"})
public class FlatView
extends JPanel {
    @NotNull
    private final Map<TraceElement, ValueWithPositionImpl> myPool;

    /*
     * WARNING - void declaration
     */
    public FlatView(@NotNull List<? extends TraceController> controllers, @NotNull DebuggerCommandLauncher launcher, @NotNull GenericEvaluationContext context, @NotNull CollectionTreeBuilder builder, @NotNull String debugName) {
        ValueWithPositionImpl $this$mapTo$iv$iv;
        StreamCall nextCall;
        List<ValueWithPositionImpl> valuesBefore;
        boolean bl;
        Intrinsics.checkNotNullParameter(controllers, (String)"controllers");
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
        super(new GridLayout(1, 2 * controllers.size() - 1));
        this.myPool = new LinkedHashMap();
        boolean bl2 = bl = !((Collection)controllers).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Ref.ObjectRef prevMappingPane = new Ref.ObjectRef();
        List<ValueWithPositionImpl> lastValues = null;
        Iterator iterator = ((Iterable)controllers.subList(0, controllers.size() - 1)).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            void $this$map$iv;
            int index = n++;
            TraceController controller = (TraceController)iterator.next();
            LinkedValuesWithPositions linkedValuesWithPositions = this.resolve(controller, controllers.get(index + 1));
            valuesBefore = linkedValuesWithPositions.component1();
            List<ValueWithPositionImpl> valuesAfter = linkedValuesWithPositions.component2();
            LinkedValuesMapping mapping = linkedValuesWithPositions.component3();
            if (controller.getNextCall() == null) {
                throw new IllegalStateException("intermediate state should know about next call".toString());
            }
            String string = nextCall.getTabTitle();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTabTitle(...)");
            String string2 = nextCall.getTabTooltip();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTabTooltip(...)");
            final MappingPane mappingPane = new MappingPane(string, string2, valuesBefore, mapping, controller);
            Iterable iterable = valuesBefore;
            Value value = controller.getStreamResult();
            boolean $i$f$map = false;
            void var21_30 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                ValueWithPositionImpl valueWithPositionImpl = (ValueWithPositionImpl)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(it.getTraceElement());
            }
            CollectionTree tree = CollectionTree.create(value, (List)destination$iv$iv, launcher, context, builder, debugName + "FlatView#controller#" + index);
            Intrinsics.checkNotNull((Object)tree);
            PositionsAwareCollectionView view = new PositionsAwareCollectionView(tree, valuesBefore);
            controller.register(view);
            view.addValuesPositionsListener(new ValuesPositionsListener(){

                @Override
                public void valuesPositionsChanged() {
                    mappingPane.repaint();
                }
            });
            final MappingPane prevMapping = (MappingPane)prevMappingPane.element;
            if (prevMapping != null) {
                view.addValuesPositionsListener(new ValuesPositionsListener(){

                    @Override
                    public void valuesPositionsChanged() {
                        prevMapping.repaint();
                    }
                });
                prevMapping.addMouseWheelListener(arg_0 -> FlatView._init_$lambda$1(view, arg_0));
            }
            mappingPane.addMouseWheelListener(arg_0 -> FlatView._init_$lambda$2(view, arg_0));
            this.add(view);
            this.add(mappingPane);
            prevMappingPane.element = mappingPane;
            lastValues = valuesAfter;
        }
        List<ValueWithPositionImpl> list = lastValues;
        if (list != null) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            List<ValueWithPositionImpl> it = list;
            boolean bl4 = false;
            TraceController lastController = (TraceController)CollectionsKt.last(controllers);
            valuesBefore = it;
            Value value = lastController.getStreamResult();
            boolean $i$f$map = false;
            nextCall = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                $this$mapTo$iv$iv = (ValueWithPositionImpl)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(it2.getTraceElement());
            }
            CollectionTree tree = CollectionTree.create(value, (List)destination$iv$iv, launcher, context, builder, debugName + "FlatView#lastValues#CollectionTree");
            Intrinsics.checkNotNull((Object)tree);
            PositionsAwareCollectionView view = new PositionsAwareCollectionView(tree, it);
            lastController.register(view);
            view.addValuesPositionsListener(new ValuesPositionsListener((Ref.ObjectRef<MappingPane>)prevMappingPane){
                final /* synthetic */ Ref.ObjectRef<MappingPane> $prevMappingPane;
                {
                    this.$prevMappingPane = $prevMappingPane;
                }

                public void valuesPositionsChanged() {
                    block0: {
                        MappingPane mappingPane = (MappingPane)this.$prevMappingPane.element;
                        if (mappingPane == null) break block0;
                        mappingPane.repaint();
                    }
                }
            });
            MappingPane mappingPane = (MappingPane)prevMappingPane.element;
            if (mappingPane != null) {
                MappingPane it3 = mappingPane;
                boolean bl6 = false;
                it3.addMouseWheelListener(arg_0 -> FlatView.lambda$3$1$0(view, arg_0));
            }
            this.add(view);
        }
        if (controllers.size() == 1) {
            TraceController controller = controllers.get(0);
            CollectionTree tree = CollectionTree.create(controller.getStreamResult(), controller.getTrace(), launcher, context, builder, "FlatView#singleController");
            CollectionView view = new CollectionView(tree);
            this.add(view);
            controller.register(view);
        }
    }

    @Override
    @NotNull
    public final Component add(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Component component2 = super.add(component);
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"add(...)");
        return component2;
    }

    private final ValueWithPositionImpl getValue(TraceElement element) {
        ValueWithPositionImpl valueWithPositionImpl = this.myPool.computeIfAbsent(element, arg_0 -> FlatView.getValue$lambda$0(getValue.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)valueWithPositionImpl, (String)"computeIfAbsent(...)");
        return valueWithPositionImpl;
    }

    /*
     * WARNING - void declaration
     */
    private final LinkedValuesWithPositions resolve(TraceController $this$resolve, TraceController nextController) {
        void $this$mapTo$iv$iv;
        List prevValues = new ArrayList();
        Map mapping = new LinkedHashMap();
        for (TraceElement traceElement : $this$resolve.getTrace()) {
            Intrinsics.checkNotNull((Object)traceElement);
            ValueWithPositionImpl prevValue = this.getValue(traceElement);
            ((Collection)prevValues).add(prevValue);
            for (TraceElement nextElement : $this$resolve.getNextValues(traceElement)) {
                Intrinsics.checkNotNull((Object)nextElement);
                ValueWithPositionImpl nextValue = this.getValue(nextElement);
                Set set = mapping.computeIfAbsent(prevValue, arg_0 -> FlatView.resolve$lambda$1(FlatView::resolve$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
                ((Collection)set).add(nextValue);
                Set set2 = mapping.computeIfAbsent(nextValue, arg_0 -> FlatView.resolve$lambda$3(FlatView::resolve$lambda$2, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"computeIfAbsent(...)");
                ((Collection)set2).add(prevValue);
            }
        }
        Map resultMapping = new LinkedHashMap();
        for (ValueWithPositionImpl key : mapping.keySet()) {
            Object v = mapping.get(key);
            Intrinsics.checkNotNull(v);
            resultMapping.put(key, CollectionsKt.toList((Iterable)((Iterable)v)));
        }
        List<TraceElement> list = nextController.getTrace();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getTrace(...)");
        Iterable iterable = list;
        List list2 = prevValues;
        boolean $i$f$map = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TraceElement traceElement = (TraceElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(this.getValue((TraceElement)it));
        }
        LinkedValuesMapping linkedValuesMapping = new LinkedValuesMapping(resultMapping){
            final /* synthetic */ Map<ValueWithPosition, List<ValueWithPosition>> $resultMapping;
            {
                this.$resultMapping = $resultMapping;
            }

            public List<ValueWithPosition> getLinkedValues(ValueWithPosition value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return this.$resultMapping.get(value);
            }
        };
        List list3 = (List)destination$iv$iv;
        List list4 = list2;
        return new LinkedValuesWithPositions(list4, list3, linkedValuesMapping);
    }

    private static final void _init_$lambda$1(PositionsAwareCollectionView $view, MouseWheelEvent e) {
        $view.getInstancesTree().dispatchEvent(e);
    }

    private static final void _init_$lambda$2(PositionsAwareCollectionView $view, MouseWheelEvent e) {
        $view.getInstancesTree().dispatchEvent(e);
    }

    private static final void lambda$3$1$0(PositionsAwareCollectionView $view, MouseWheelEvent e) {
        $view.getInstancesTree().dispatchEvent(e);
    }

    private static final ValueWithPositionImpl getValue$lambda$0(Function1 $tmp0, Object p0) {
        return (ValueWithPositionImpl)$tmp0.invoke(p0);
    }

    private static final Set resolve$lambda$0(ValueWithPositionImpl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set resolve$lambda$1(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set resolve$lambda$2(ValueWithPositionImpl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set resolve$lambda$3(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/debugger/streams/core/ui/impl/FlatView$LinkedValuesWithPositions;", "", "valuesBefore", "", "Lcom/intellij/debugger/streams/core/ui/impl/ValueWithPositionImpl;", "valuesAfter", "mapping", "Lcom/intellij/debugger/streams/core/ui/LinkedValuesMapping;", "<init>", "(Ljava/util/List;Ljava/util/List;Lcom/intellij/debugger/streams/core/ui/LinkedValuesMapping;)V", "getValuesBefore", "()Ljava/util/List;", "getValuesAfter", "getMapping", "()Lcom/intellij/debugger/streams/core/ui/LinkedValuesMapping;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.debugger.streams.core"})
    private static final class LinkedValuesWithPositions {
        @NotNull
        private final List<ValueWithPositionImpl> valuesBefore;
        @NotNull
        private final List<ValueWithPositionImpl> valuesAfter;
        @NotNull
        private final LinkedValuesMapping mapping;

        public LinkedValuesWithPositions(@NotNull List<ValueWithPositionImpl> valuesBefore, @NotNull List<ValueWithPositionImpl> valuesAfter, @NotNull LinkedValuesMapping mapping) {
            Intrinsics.checkNotNullParameter(valuesBefore, (String)"valuesBefore");
            Intrinsics.checkNotNullParameter(valuesAfter, (String)"valuesAfter");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            this.valuesBefore = valuesBefore;
            this.valuesAfter = valuesAfter;
            this.mapping = mapping;
        }

        @NotNull
        public final List<ValueWithPositionImpl> getValuesBefore() {
            return this.valuesBefore;
        }

        @NotNull
        public final List<ValueWithPositionImpl> getValuesAfter() {
            return this.valuesAfter;
        }

        @NotNull
        public final LinkedValuesMapping getMapping() {
            return this.mapping;
        }

        @NotNull
        public final List<ValueWithPositionImpl> component1() {
            return this.valuesBefore;
        }

        @NotNull
        public final List<ValueWithPositionImpl> component2() {
            return this.valuesAfter;
        }

        @NotNull
        public final LinkedValuesMapping component3() {
            return this.mapping;
        }

        @NotNull
        public final LinkedValuesWithPositions copy(@NotNull List<ValueWithPositionImpl> valuesBefore, @NotNull List<ValueWithPositionImpl> valuesAfter, @NotNull LinkedValuesMapping mapping) {
            Intrinsics.checkNotNullParameter(valuesBefore, (String)"valuesBefore");
            Intrinsics.checkNotNullParameter(valuesAfter, (String)"valuesAfter");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            return new LinkedValuesWithPositions(valuesBefore, valuesAfter, mapping);
        }

        public static /* synthetic */ LinkedValuesWithPositions copy$default(LinkedValuesWithPositions linkedValuesWithPositions, List list, List list2, LinkedValuesMapping linkedValuesMapping, int n, Object object) {
            if ((n & 1) != 0) {
                list = linkedValuesWithPositions.valuesBefore;
            }
            if ((n & 2) != 0) {
                list2 = linkedValuesWithPositions.valuesAfter;
            }
            if ((n & 4) != 0) {
                linkedValuesMapping = linkedValuesWithPositions.mapping;
            }
            return linkedValuesWithPositions.copy(list, list2, linkedValuesMapping);
        }

        @NotNull
        public String toString() {
            return "LinkedValuesWithPositions(valuesBefore=" + this.valuesBefore + ", valuesAfter=" + this.valuesAfter + ", mapping=" + this.mapping + ")";
        }

        public int hashCode() {
            int result = ((Object)this.valuesBefore).hashCode();
            result = result * 31 + ((Object)this.valuesAfter).hashCode();
            result = result * 31 + this.mapping.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LinkedValuesWithPositions)) {
                return false;
            }
            LinkedValuesWithPositions linkedValuesWithPositions = (LinkedValuesWithPositions)other;
            if (!Intrinsics.areEqual(this.valuesBefore, linkedValuesWithPositions.valuesBefore)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.valuesAfter, linkedValuesWithPositions.valuesAfter)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.mapping, (Object)linkedValuesWithPositions.mapping);
        }
    }
}

