/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.style;

import com.intellij.codeInsight.intention.CustomizableIntentionAction;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.grazie.utils.HighlightingUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.StringOperation;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextLevelFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements CustomizableIntentionAction {
    private final long stamp;
    @FileModifier.SafeFieldForPreview
    private final List<StringOperation> allChanges;
    private final String text;

    public TextLevelFix(@NotNull PsiElement scope, String text, List<StringOperation> allChanges) {
        if (scope == null) {
            TextLevelFix.$$$reportNull$$$0(0);
        }
        super(scope);
        this.text = text;
        this.allChanges = allChanges;
        this.stamp = scope.getContainingFile().getModificationStamp();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TextLevelFix.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            TextLevelFix.$$$reportNull$$$0(2);
        }
        if (startElement == null) {
            TextLevelFix.$$$reportNull$$$0(3);
        }
        if (endElement == null) {
            TextLevelFix.$$$reportNull$$$0(4);
        }
        HighlightingUtil.applyTextChanges(psiFile.getViewProvider().getDocument(), this.allChanges);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            TextLevelFix.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            TextLevelFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            TextLevelFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            TextLevelFix.$$$reportNull$$$0(8);
        }
        return this.stamp == psiFile.getModificationStamp();
    }

    @IntentionName
    @NotNull
    public String getText() {
        String string = this.text;
        if (string == null) {
            TextLevelFix.$$$reportNull$$$0(9);
        }
        return string;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            TextLevelFix.$$$reportNull$$$0(10);
        }
        return string;
    }

    public boolean isShowSubmenu() {
        return false;
    }

    @NotNull
    public List<CustomizableIntentionAction.RangeToHighlight> getRangesToHighlight(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            TextLevelFix.$$$reportNull$$$0(11);
        }
        if (file == null) {
            TextLevelFix.$$$reportNull$$$0(12);
        }
        List<CustomizableIntentionAction.RangeToHighlight> list = this.allChanges.stream().map(r -> r.getRange()).map(r -> r.getLength() > 0 || file.getTextLength() == 0 ? r : (r.getEndOffset() < file.getTextLength() ? new TextRange(r.getStartOffset(), r.getEndOffset() + 1) : new TextRange(r.getStartOffset() - 1, r.getEndOffset()))).filter(r -> r.getLength() > 0).map(r -> new CustomizableIntentionAction.RangeToHighlight((PsiElement)file, r, EditorColors.SEARCH_RESULT_ATTRIBUTES)).toList();
        if (list == null) {
            TextLevelFix.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/style/TextLevelFix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/style/TextLevelFix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRangesToHighlight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 13 -> new IllegalStateException(string);
        };
    }
}

