import type * as express from "express";
import * as passport from "passport";
import { Profile, SamlConfig } from "@node-saml/node-saml";
export interface AuthenticateOptions extends passport.AuthenticateOptions {
    samlFallback?: "login-request" | "logout-request";
    additionalParams?: Record<string, any>;
}
export interface StrategyOptions {
    name?: string;
    passReqToCallback?: boolean;
}
export type User = Record<string, unknown>;
export interface RequestWithUser extends express.Request {
    samlLogoutRequest: Profile;
    user: User;
}
export type VerifiedCallback = (err: Error | null, user?: Record<string, unknown>, info?: Record<string, unknown>) => void;
export type VerifyWithRequest = (req: express.Request, profile: Profile | null, done: VerifiedCallback) => void;
export type VerifyWithoutRequest = (profile: Profile | null, done: VerifiedCallback) => void;
export type PassportSamlConfig = SamlConfig & StrategyOptions;
export type StrategyOptionsCallback = (err: Error | null, samlOptions?: Partial<PassportSamlConfig>) => void;
interface BaseMultiStrategyConfig {
    getSamlOptions(req: express.Request, callback: StrategyOptionsCallback): void;
}
export type MultiStrategyConfig = Partial<PassportSamlConfig> & StrategyOptions & BaseMultiStrategyConfig;
export declare class ErrorWithXmlStatus extends Error {
    readonly xmlStatus: string;
    constructor(message: string, xmlStatus: string);
}
export {};
