/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.jacoco.plugins;

import java.io.Serializable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConsumableConfiguration;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.TestSuiteName;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JvmTestSuitePlugin;
import org.gradle.api.plugins.ReportingBasePlugin;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.Report;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.jacoco.JacocoAgentJar;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.testing.base.TestingExtension;
import org.gradle.testing.jacoco.plugins.JacocoPluginExtension;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.gradle.testing.jacoco.tasks.JacocoBase;
import org.gradle.testing.jacoco.tasks.JacocoCoverageVerification;
import org.gradle.testing.jacoco.tasks.JacocoReport;

public abstract class JacocoPlugin
implements Plugin<Project> {
    public static final String DEFAULT_JACOCO_VERSION = "0.8.14";
    public static final String AGENT_CONFIGURATION_NAME = "jacocoAgent";
    public static final String ANT_CONFIGURATION_NAME = "jacocoAnt";
    public static final String PLUGIN_EXTENSION_NAME = "jacoco";
    private final Instantiator instantiator;
    private ProjectInternal project;

    @Inject
    public JacocoPlugin(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(ReportingBasePlugin.class);
        this.project = (ProjectInternal)project;
        this.addJacocoConfigurations();
        JacocoAgentJar agent = (JacocoAgentJar)this.instantiator.newInstance(JacocoAgentJar.class, new Object[]{this.project.getServices().get(FileOperations.class)});
        JacocoPluginExtension extension = (JacocoPluginExtension)project.getExtensions().create(PLUGIN_EXTENSION_NAME, JacocoPluginExtension.class, new Object[]{project, agent});
        extension.setToolVersion(DEFAULT_JACOCO_VERSION);
        ReportingExtension reportingExtension = (ReportingExtension)project.getExtensions().getByName("reporting");
        extension.getReportsDirectory().convention(reportingExtension.getBaseDirectory().dir(PLUGIN_EXTENSION_NAME));
        this.configureAgentDependencies(agent, extension);
        this.configureTaskClasspathDefaults(extension);
        this.applyToDefaultTasks(extension);
        this.configureJacocoReportsDefaults(extension);
        this.addDefaultReportAndCoverageVerificationTasks(extension);
        JacocoPlugin.configureCoverageDataElementsVariants(project);
    }

    private static void configureCoverageDataElementsVariants(Project project) {
        project.getPlugins().withType(JvmTestSuitePlugin.class, p -> {
            TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
            testing.getSuites().withType(JvmTestSuite.class).configureEach(suite -> {
                NamedDomainObjectProvider<ConsumableConfiguration> jacocoResultsVariant = JacocoPlugin.createCoverageDataVariant((ProjectInternal)project, suite);
                suite.getTargets().configureEach(target -> jacocoResultsVariant.configure(variant -> {
                    Provider resultsDir = target.getTestTask().map(task -> ((JacocoTaskExtension)task.getExtensions().getByType(JacocoTaskExtension.class)).getDestinationFile());
                    variant.getOutgoing().artifact((Object)resultsDir, artifact -> artifact.setType("binary"));
                }));
            });
        });
    }

    private static NamedDomainObjectProvider<ConsumableConfiguration> createCoverageDataVariant(ProjectInternal project, JvmTestSuite suite) {
        String variantName = String.format("coverageDataElementsFor%s", StringUtils.capitalize((String)suite.getName()));
        return project.getConfigurations().consumable(variantName, conf -> {
            conf.setDescription("Binary results containing Jacoco test coverage for all targets in the '" + suite.getName() + "' Test Suite.");
            ObjectFactory objects = project.getObjects();
            conf.attributes(attributes -> {
                attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objects.named(Category.class, "verification")));
                attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, (Object)((VerificationType)objects.named(VerificationType.class, "jacoco-coverage")));
                attributes.attribute(TestSuiteName.TEST_SUITE_NAME_ATTRIBUTE, (Object)((TestSuiteName)objects.named(TestSuiteName.class, suite.getName())));
            });
        });
    }

    private void addJacocoConfigurations() {
        RoleBasedConfigurationContainerInternal configurations = this.project.getConfigurations();
        configurations.resolvableDependencyScopeLocked(AGENT_CONFIGURATION_NAME, agentConf -> agentConf.setDescription("The Jacoco agent to use to get coverage data."));
        configurations.resolvableDependencyScopeLocked(ANT_CONFIGURATION_NAME, antConf -> antConf.setDescription("The Jacoco ant tasks to use to get execute Gradle tasks."));
    }

    private void configureAgentDependencies(JacocoAgentJar jacocoAgentJar, JacocoPluginExtension extension) {
        Configuration config = this.project.getConfigurations().getAt(AGENT_CONFIGURATION_NAME);
        jacocoAgentJar.setAgentConf((FileCollection)config);
        config.defaultDependencies(dependencies -> dependencies.add((Object)this.project.getDependencies().create((Object)("org.jacoco:org.jacoco.agent:" + extension.getToolVersion()))));
    }

    private void configureTaskClasspathDefaults(JacocoPluginExtension extension) {
        Configuration config = this.project.getConfigurations().getAt(ANT_CONFIGURATION_NAME);
        this.project.getTasks().withType(JacocoBase.class).configureEach(task -> task.setJacocoClasspath((FileCollection)config));
        config.defaultDependencies(dependencies -> dependencies.add((Object)this.project.getDependencies().create((Object)("org.jacoco:org.jacoco.ant:" + extension.getToolVersion()))));
    }

    private void applyToDefaultTasks(JacocoPluginExtension extension) {
        this.project.getTasks().withType(Test.class).configureEach(extension::applyTo);
    }

    private void configureJacocoReportsDefaults(JacocoPluginExtension extension) {
        this.project.getTasks().withType(JacocoReport.class).configureEach(reportTask -> this.configureJacocoReportDefaults(extension, (JacocoReport)((Object)reportTask)));
    }

    private void configureJacocoReportDefaults(JacocoPluginExtension extension, JacocoReport reportTask) {
        reportTask.getReports().all(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)report -> report.getRequired().convention((Object)report.getName().equals("html"))));
        DirectoryProperty reportsDir = extension.getReportsDirectory();
        reportTask.getReports().all(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)report -> {
            if (report.getOutputType().equals((Object)Report.OutputType.DIRECTORY)) {
                ((DirectoryReport)report).getOutputLocation().convention(reportsDir.dir(reportTask.getName() + "/" + report.getName()));
            } else {
                ((SingleFileReport)report).getOutputLocation().convention(reportsDir.file(reportTask.getName() + "/" + reportTask.getName() + "." + report.getName()));
            }
        }));
    }

    private void addDefaultReportAndCoverageVerificationTasks(JacocoPluginExtension extension) {
        this.project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            TestingExtension testing = (TestingExtension)this.project.getExtensions().getByType(TestingExtension.class);
            JvmTestSuite defaultTestSuite = (JvmTestSuite)testing.getSuites().withType(JvmTestSuite.class).getByName("test");
            defaultTestSuite.getTargets().configureEach(target -> {
                TaskProvider testTask = target.getTestTask();
                this.addDefaultReportTask(extension, (TaskProvider<? extends Task>)testTask);
                this.addDefaultCoverageVerificationTask((TaskProvider<? extends Task>)testTask);
            });
        });
    }

    private void addDefaultReportTask(JacocoPluginExtension extension, TaskProvider<? extends Task> testTaskProvider) {
        String testTaskName = testTaskProvider.getName();
        this.project.getTasks().register(PLUGIN_EXTENSION_NAME + StringUtils.capitalize((String)testTaskName) + "Report", JacocoReport.class, reportTask -> {
            reportTask.setGroup("verification");
            reportTask.setDescription(String.format("Generates code coverage report for the %s task.", testTaskName));
            reportTask.executionData((Task)testTaskProvider.get());
            reportTask.sourceSets((SourceSet)((SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class)).getByName("main"));
            DirectoryProperty reportsDir = extension.getReportsDirectory();
            reportTask.getReports().all(SerializableLambdas.action((SerializableLambdas.SerializableAction & Serializable)report -> {
                if (report.getOutputType().equals((Object)Report.OutputType.DIRECTORY)) {
                    ((DirectoryReport)report).getOutputLocation().convention(reportsDir.dir(testTaskName + "/" + report.getName()));
                } else {
                    ((SingleFileReport)report).getOutputLocation().convention(reportsDir.file(testTaskName + "/" + reportTask.getName() + "." + report.getName()));
                }
            }));
        });
    }

    private void addDefaultCoverageVerificationTask(TaskProvider<? extends Task> testTaskProvider) {
        this.project.getTasks().register(PLUGIN_EXTENSION_NAME + StringUtils.capitalize((String)testTaskProvider.getName()) + "CoverageVerification", JacocoCoverageVerification.class, coverageVerificationTask -> {
            coverageVerificationTask.setGroup("verification");
            coverageVerificationTask.setDescription(String.format("Verifies code coverage metrics based on specified rules for the %s task.", testTaskProvider.getName()));
            coverageVerificationTask.executionData((Task)testTaskProvider.get());
            coverageVerificationTask.sourceSets((SourceSet)((SourceSetContainer)this.project.getExtensions().getByType(SourceSetContainer.class)).getByName("main"));
        });
    }
}

