/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DataInCodeEntry
implements StructConverter {
    public static final int SIZE = 8;
    private long offset;
    private int length;
    private short kind;

    public DataInCodeEntry(BinaryReader reader) throws IOException {
        this.offset = reader.readNextUnsignedInt();
        this.length = reader.readNextUnsignedShort();
        this.kind = reader.readNextShort();
    }

    public long getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public short getKind() {
        return this.kind;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("data_in_code_entry", 0);
        struct.add(DWORD, "offset", "from mach_header to start of data range");
        struct.add(WORD, "length", "number of bytes in data range");
        struct.add(WORD, "kind", "DICE_KIND_DATA=1, DICE_KIND_JUMP_TABLE8=2, DICE_KIND_JUMP_TABLE16=3, DICE_KIND_JUMP_TABLE32=4, DICE_KIND_ABS_JUMP_TABLE32=5");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

