/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.format.dwarf.DIEAggregate;
import ghidra.app.util.bin.format.dwarf.DWARFTag;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFNumericAttribute;

public record DWARFSourceInfo(String filename, int lineNum) {
    public static DWARFSourceInfo create(DIEAggregate diea) {
        String file = null;
        for (DIEAggregate currentDIEA = diea; currentDIEA != null && (file = currentDIEA.getSourceFile()) == null; currentDIEA = currentDIEA.getParent()) {
        }
        if (file == null) {
            return null;
        }
        DWARFNumericAttribute declLineAttr = diea.findAttributeInChildren(DWARFAttribute.DW_AT_decl_line, DWARFTag.DW_TAG_formal_parameter, DWARFNumericAttribute.class);
        if (declLineAttr == null) {
            return null;
        }
        int lineNum = (int)declLineAttr.getUnsignedValue();
        return new DWARFSourceInfo(file, lineNum);
    }

    public static DWARFSourceInfo getSourceInfoWithFallbackToParent(DIEAggregate diea) {
        DIEAggregate declParent;
        DWARFSourceInfo dsi = DWARFSourceInfo.create(diea);
        if (dsi == null && (declParent = diea.getDeclParent()) != null) {
            dsi = DWARFSourceInfo.create(declParent);
        }
        return dsi;
    }

    public static String getDescriptionStr(DIEAggregate diea) {
        DWARFSourceInfo sourceInfo = DWARFSourceInfo.create(diea);
        return sourceInfo != null ? sourceInfo.getDescriptionStr() : null;
    }

    public String getDescriptionStr() {
        return this.filename + ":" + this.lineNum;
    }

    @Override
    public String toString() {
        return "DWARFSourceInfo [filename=" + this.filename + ", lineNum=" + this.lineNum + "]";
    }
}

