/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.tablechooser;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.tablechooser.AddressableRowObject;
import ghidra.app.tablechooser.ColumnDisplay;
import ghidra.app.tablechooser.ColumnDisplayDynamicTableColumnAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.field.AddressTableColumn;
import ghidra.util.task.TaskMonitor;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;

public class TableChooserTableModel
extends AddressBasedTableModel<AddressableRowObject> {
    Set<AddressableRowObject> myPrivateList = new HashSet<AddressableRowObject>();

    public TableChooserTableModel(String title, ServiceProvider serviceProvider, Program program, TaskMonitor monitor) {
        super(title, serviceProvider, program, monitor);
    }

    public synchronized void addObject(AddressableRowObject rowObject) {
        this.myPrivateList.add(rowObject);
        super.addObject((Object)rowObject);
    }

    public synchronized void removeObject(AddressableRowObject obj) {
        this.myPrivateList.remove(obj);
        super.removeObject((Object)obj);
    }

    public synchronized boolean containsObject(AddressableRowObject obj) {
        return this.myPrivateList.contains(obj);
    }

    @Override
    public Address getAddress(int row) {
        return ((AddressableRowObject)this.getRowObject(row)).getAddress();
    }

    protected synchronized void doLoad(Accumulator<AddressableRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        accumulator.addAll(this.myPrivateList);
    }

    public <T> void addCustomColumn(ColumnDisplay<T> columnDisplay) {
        this.addTableColumn((DynamicTableColumn)new ColumnDisplayDynamicTableColumnAdapter<T>(columnDisplay));
    }

    protected Comparator<AddressableRowObject> createSortComparator(int columnIndex) {
        DynamicTableColumn column = this.getColumn(columnIndex);
        if (!(column instanceof ColumnDisplayDynamicTableColumnAdapter)) {
            return super.createSortComparator(columnIndex);
        }
        return (ColumnDisplayDynamicTableColumnAdapter)column;
    }

    @Override
    protected TableColumnDescriptor<AddressableRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new AddressTableColumn()), 1, true);
        return descriptor;
    }
}

