/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.DockingUtils;
import docking.action.DockingAction;
import docking.actions.KeyBindingUtils;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.main.datatree.DataTreeDragNDropHandler;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.LinkFileInfo;
import ghidra.framework.model.LinkedDomainFolder;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;

public class DataTree
extends GTree {
    private boolean isActive;
    private DataTreeDragNDropHandler dragNDropHandler;

    DataTree(FrontEndTool tool, GTreeNode root) {
        super(root);
        this.setName("Data Tree");
        this.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        if (tool != null) {
            this.dragNDropHandler = new DataTreeDragNDropHandler(tool, this, this.isActive);
            this.setDragNDropHandler(this.dragNDropHandler);
        }
        this.initializeKeyEvents();
    }

    private void initializeKeyEvents() {
        KeyBindingUtils.clearKeyBinding((JComponent)this.getJTree(), (KeyStroke)KeyStroke.getKeyStroke(67, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        KeyBindingUtils.clearKeyBinding((JComponent)this.getJTree(), (KeyStroke)KeyStroke.getKeyStroke(86, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        KeyBindingUtils.clearKeyBinding((JComponent)this.getJTree(), (KeyStroke)KeyStroke.getKeyStroke(88, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
    }

    protected boolean isAddToPopup(DockingAction action) {
        String name;
        switch (name = action.getName()) {
            case "Tree Expand All": 
            case "Tree Expand Node": 
            case "Tree Collapse Node": {
                return false;
            }
        }
        return true;
    }

    void setProjectActive(boolean isActive) {
        if (this.dragNDropHandler != null) {
            this.dragNDropHandler.setProjectActive(isActive);
        }
    }

    public void clearSelection() {
        this.getJTree().clearSelection();
    }

    public int getSelectionCount() {
        return this.getJTree().getSelectionCount();
    }

    public GTreeNode getLastSelectedPathComponent() {
        return (GTreeNode)this.getJTree().getLastSelectedPathComponent();
    }

    public void removeSelectionPath(TreePath path) {
        this.getJTree().removeSelectionPath(path);
    }

    public void stopEditing() {
        this.getJTree().stopEditing();
    }

    public static DomainFolder getRealInternalFolderForNode(GTreeNode node) {
        DomainFolder folder = null;
        if (node instanceof DomainFolderNode) {
            DomainFolderNode folderNode = (DomainFolderNode)node;
            folder = folderNode.getDomainFolder();
        } else if (node instanceof DomainFileNode) {
            DomainFileNode fileNode = (DomainFileNode)node;
            if (fileNode.isFolderLink()) {
                folder = DataTree.getLinkedFolder(fileNode);
            } else {
                GTreeNode parent = node.getParent();
                if (parent instanceof DomainFolderNode) {
                    DomainFolderNode folderNode = (DomainFolderNode)parent;
                    folder = folderNode.getDomainFolder();
                } else if (parent instanceof DomainFileNode) {
                    DomainFileNode parentFileNode = (DomainFileNode)parent;
                    folder = DataTree.getLinkedFolder(parentFileNode);
                }
            }
        }
        if (folder instanceof LinkedDomainFolder) {
            LinkedDomainFolder linkedFolder = (LinkedDomainFolder)folder;
            try {
                folder = linkedFolder.getRealFolder();
            }
            catch (IOException e) {
                folder = null;
            }
        }
        return folder;
    }

    private static DomainFolder getLinkedFolder(DomainFileNode fileNode) {
        LinkFileInfo linkInfo = fileNode.getDomainFile().getLinkInfo();
        if (linkInfo == null) {
            return null;
        }
        LinkHandler.LinkStatus linkStatus = linkInfo.getLinkStatus(null);
        if (linkStatus != LinkHandler.LinkStatus.INTERNAL) {
            return null;
        }
        return linkInfo.getLinkedFolder();
    }
}

