/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.datastruct.Accumulator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;

public class FilteringAccumulatorWrapper<T>
implements Accumulator<T> {
    private Accumulator<T> accumulator;
    private Predicate<T> predicate;

    public FilteringAccumulatorWrapper(Accumulator<T> accumulator, Predicate<T> passesFilterPredicate) {
        this.predicate = passesFilterPredicate;
        this.accumulator = Objects.requireNonNull(accumulator);
    }

    private boolean passesFilter(T t) {
        return this.predicate.test(t);
    }

    @Override
    public Iterator<T> iterator() {
        return this.accumulator.iterator();
    }

    @Override
    public void add(T t) {
        if (this.passesFilter(t)) {
            this.accumulator.add(t);
        }
    }

    @Override
    public void addAll(Collection<T> collection) {
        collection.forEach(t -> {
            if (this.passesFilter(t)) {
                this.accumulator.add(t);
            }
        });
    }

    @Override
    public boolean contains(T t) {
        return this.accumulator.contains(t);
    }

    @Override
    public Collection<T> get() {
        return this.accumulator.get();
    }

    @Override
    public int size() {
        return this.accumulator.size();
    }
}

