/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.util.VTAssociationStatusException;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class RejectMatchTask
extends VtTask {
    private final List<VTMatch> matches;

    public RejectMatchTask(VTSession session, List<VTMatch> matches) {
        super("Reject Matches", session);
        this.matches = matches;
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) throws Exception {
        this.rejectMatches(monitor);
        return true;
    }

    private void rejectMatches(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Updating status for matches");
        monitor.initialize((long)this.matches.size());
        for (VTMatch match : this.matches) {
            monitor.checkCancelled();
            VTAssociation association = match.getAssociation();
            VTAssociationStatus status = association.getStatus();
            if (status == VTAssociationStatus.ACCEPTED || status == VTAssociationStatus.REJECTED) continue;
            try {
                association.setRejected();
            }
            catch (VTAssociationStatusException e) {
                throw new AssertException("Should have been given an association that is not blocked - current status: " + String.valueOf((Object)association.getStatus()));
            }
            monitor.incrementProgress(1L);
        }
        monitor.setProgress((long)this.matches.size());
    }

    private class ErrorStatus {
        private List<Exception> exceptions = new ArrayList<Exception>();

        private ErrorStatus(RejectMatchTask rejectMatchTask) {
        }

        boolean hasErrors() {
            return this.exceptions.size() > 0;
        }
    }
}

