/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.DBRecord;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.MemoryBlockSourceInfoDB;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.mem.MemoryBlockType;
import java.io.IOException;

abstract class SubMemoryBlock
implements Comparable<SubMemoryBlock> {
    protected final MemoryMapDBAdapter adapter;
    protected final DBRecord record;
    protected long subBlockLength;
    protected long subBlockOffset;

    protected SubMemoryBlock(MemoryMapDBAdapter adapter, DBRecord record) {
        this.adapter = adapter;
        this.record = record;
        this.subBlockOffset = record.getLongValue(3);
        this.subBlockLength = record.getLongValue(2);
    }

    public abstract boolean isInitialized();

    public final long getParentBlockID() {
        return this.record.getLongValue(0);
    }

    public final long getStartingOffset() {
        return this.subBlockOffset;
    }

    public final long getLength() {
        return this.subBlockLength;
    }

    public final boolean contains(long memBlockOffset) {
        return memBlockOffset >= this.subBlockOffset && memBlockOffset < this.subBlockOffset + this.subBlockLength;
    }

    public abstract byte getByte(long var1) throws IndexOutOfBoundsException, MemoryAccessException, IOException;

    public abstract int getBytes(long var1, byte[] var3, int var4, int var5) throws IndexOutOfBoundsException, MemoryAccessException, IOException;

    public abstract void putByte(long var1, byte var3) throws IndexOutOfBoundsException, MemoryAccessException, IOException;

    public abstract int putBytes(long var1, byte[] var3, int var4, int var5) throws IndexOutOfBoundsException, MemoryAccessException, IOException;

    public void delete() throws IOException {
        this.adapter.deleteSubBlock(this.record.getKey());
    }

    protected void setLength(long length) throws IOException {
        this.subBlockLength = length;
        this.record.setLongValue(2, length);
        this.adapter.updateSubBlockRecord(this.record);
    }

    protected abstract boolean join(SubMemoryBlock var1) throws IOException;

    protected boolean isMapped() {
        return false;
    }

    protected MemoryBlockType getType() {
        return MemoryBlockType.DEFAULT;
    }

    protected final MemoryBlockSourceInfo getSourceInfo(MemoryBlock block) {
        return new MemoryBlockSourceInfoDB(block, this);
    }

    protected abstract SubMemoryBlock split(long var1) throws IndexOutOfBoundsException, IOException;

    protected void setParentIdAndStartingOffset(long key, long startingOffset) throws IOException {
        this.subBlockOffset = startingOffset;
        this.record.setLongValue(0, key);
        this.record.setLongValue(3, startingOffset);
        this.adapter.updateSubBlockRecord(this.record);
    }

    protected abstract String getDescription();

    protected boolean uses(FileBytes fileBytes) {
        return false;
    }

    @Override
    public int compareTo(SubMemoryBlock o) {
        long result = this.getStartingOffset() - o.getStartingOffset();
        if (result == 0L) {
            return 0;
        }
        return result > 0L ? 1 : -1;
    }
}

