/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.apport;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.ElfLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.file.formats.dump.DumpFile;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.apport.ApportHeader;
import ghidra.file.formats.dump.apport.DecodedProvider;
import ghidra.file.formats.dump.apport.MemoryInfo;
import ghidra.framework.store.LockException;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Apport
extends DumpFile {
    public static final int SIGNATURE = 1651470928;
    ApportHeader header;
    private MessageLog log;

    public Apport(DumpFileReader reader, ProgramBasedDataTypeManager dtm, List<Option> options, TaskMonitor monitor, LoadSpec loadSpec, MessageLog log) throws CancelledException, IOException {
        super(reader, dtm, options, monitor);
        this.log = log;
        this.program.setExecutableFormat("Portable Executable (PE)");
        this.initManagerList(null);
        this.header = new ApportHeader(reader, 0L, monitor);
        boolean createBlocks = OptionUtils.getBooleanOptionValue((String)"Create Memory Blocks", options, (boolean)true);
        if (createBlocks) {
            this.createBlocksFromElf(loadSpec, monitor);
        }
        this.buildStructures(loadSpec, monitor);
    }

    @Override
    public boolean joinBlocksEnabled() {
        return false;
    }

    public ApportHeader getFileHeader() {
        return this.header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBlocksFromElf(LoadSpec loadSpec, TaskMonitor monitor) throws IOException, CancelledException {
        Object consumer = new Object();
        try (DecodedProvider provider = new DecodedProvider(this, this.reader.getByteProvider(), monitor);){
            ElfLoader elfLoader = new ElfLoader();
            Option base = new Option("Image Base", (Object)Long.toHexString(this.header.getMemoryInfo(0).getBaseAddress()));
            this.options.add(base);
            this.program.addConsumer(consumer);
            Loader.ImporterSettings settings = new Loader.ImporterSettings((ByteProvider)provider, this.program.getName(), null, null, false, loadSpec, this.options, consumer, this.log, monitor);
            elfLoader.load(this.program, settings);
        }
        finally {
            this.program.release(consumer);
        }
        Memory memory = this.program.getMemory();
        Address minAddress = memory.getMinAddress();
        Listing listing = this.program.getListing();
        ProgramModule root = listing.getDefaultRootModule();
        Group[] children = root.getChildren();
        try {
            for (int i = 0; i < this.header.getMemoryRegionCount(); ++i) {
                Address addr;
                MemoryBlock block;
                MemoryInfo minfo = this.header.getMemoryInfo(i);
                String id = minfo.getDescription();
                if (id == null) {
                    id = "Memory";
                }
                if ((block = memory.getBlock(addr = minAddress.getNewAddress(minfo.getBaseAddress()))) == null) continue;
                String name = block.getName();
                block.setName(id);
                boolean renamed = false;
                try {
                    Group fragment = children[root.getIndex(name)];
                    if (fragment != null) {
                        fragment.setName(i + ":" + id);
                        renamed = true;
                    }
                }
                catch (DuplicateNameException duplicateNameException) {
                    // empty catch block
                }
                if (renamed) continue;
                Msg.error((Object)this, (Object)("Failed to rename module: " + name));
            }
        }
        catch (LockException e) {
            throw new IOException(e);
        }
    }

    private void buildStructures(LoadSpec loadSpec, TaskMonitor monitor) throws IOException {
        DataType dt = this.header.toDataType();
        try {
            ByteProvider byteProvider = this.reader.getByteProvider();
            MemoryBlock headerBlock = MemoryBlockUtils.createInitializedBlock((Program)this.program, (boolean)true, (String)"DumpHeader", (Address)AddressSpace.OTHER_SPACE.getMinAddress(), (InputStream)byteProvider.getInputStream(0L), (long)dt.getLength(), (String)byteProvider.getName(), (String)"Apport", (boolean)true, (boolean)true, (boolean)false, (MessageLog)this.log, (TaskMonitor)monitor);
            this.program.getListing().createData(headerBlock.getStart(), dt, dt.getLength());
        }
        catch (AddressOverflowException e) {
            throw new AssertException((Throwable)e);
        }
        catch (CodeUnitInsertionException e) {
            Msg.warn((Object)this, (Object)e.getMessage());
        }
    }

    public static String getMachineType(DumpFileReader reader) throws IOException {
        ApportHeader header = new ApportHeader(reader, 0L, TaskMonitor.DUMMY);
        return header.getMachineImageType();
    }

    @Override
    public FileBytes getFileBytes(TaskMonitor monitor) throws IOException, CancelledException {
        return null;
    }

    public static Collection<? extends Option> getDefaultOptions(DumpFileReader reader) {
        ArrayList<Option> list = new ArrayList<Option>();
        list.add(new Option("Create Memory Blocks", (Object)true, Boolean.class, "-loader-createMemoryBlocks"));
        return list;
    }
}

