/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.math;

import com.jogamp.math.FloatUtil;
import com.jogamp.math.FovHVHalves;
import com.jogamp.math.Quaternion;
import com.jogamp.math.Ray;
import com.jogamp.math.Recti;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.Frustum;
import java.nio.FloatBuffer;

public final class Matrix4f {
    private float m00;
    private float m10;
    private float m20;
    private float m30;
    private float m01;
    private float m11;
    private float m21;
    private float m31;
    private float m02;
    private float m12;
    private float m22;
    private float m32;
    private float m03;
    private float m13;
    private float m23;
    private float m33;
    final Stack stack = new Stack(0, 256);

    public Matrix4f() {
        this.m33 = 1.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
    }

    public Matrix4f(Matrix4f matrix4f) {
        this.load(matrix4f);
    }

    public Matrix4f(float[] fArray) {
        this.load(fArray);
    }

    public Matrix4f(float[] fArray, int n) {
        this.load(fArray, n);
    }

    public Matrix4f(FloatBuffer floatBuffer) {
        this.load(floatBuffer);
    }

    public void set(int n, float f) {
        switch (n) {
            case 0: {
                this.m00 = f;
                break;
            }
            case 1: {
                this.m10 = f;
                break;
            }
            case 2: {
                this.m20 = f;
                break;
            }
            case 3: {
                this.m30 = f;
                break;
            }
            case 4: {
                this.m01 = f;
                break;
            }
            case 5: {
                this.m11 = f;
                break;
            }
            case 6: {
                this.m21 = f;
                break;
            }
            case 7: {
                this.m31 = f;
                break;
            }
            case 8: {
                this.m02 = f;
                break;
            }
            case 9: {
                this.m12 = f;
                break;
            }
            case 10: {
                this.m22 = f;
                break;
            }
            case 11: {
                this.m32 = f;
                break;
            }
            case 12: {
                this.m03 = f;
                break;
            }
            case 13: {
                this.m13 = f;
                break;
            }
            case 14: {
                this.m23 = f;
                break;
            }
            case 15: {
                this.m33 = f;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public final Matrix4f loadIdentity() {
        this.m33 = 1.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
        this.m32 = 0.0f;
        this.m31 = 0.0f;
        this.m30 = 0.0f;
        this.m23 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m13 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m03 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        return this;
    }

    public Matrix4f load(Matrix4f matrix4f) {
        this.m00 = matrix4f.m00;
        this.m10 = matrix4f.m10;
        this.m20 = matrix4f.m20;
        this.m30 = matrix4f.m30;
        this.m01 = matrix4f.m01;
        this.m11 = matrix4f.m11;
        this.m21 = matrix4f.m21;
        this.m31 = matrix4f.m31;
        this.m02 = matrix4f.m02;
        this.m12 = matrix4f.m12;
        this.m22 = matrix4f.m22;
        this.m32 = matrix4f.m32;
        this.m03 = matrix4f.m03;
        this.m13 = matrix4f.m13;
        this.m23 = matrix4f.m23;
        this.m33 = matrix4f.m33;
        return this;
    }

    public Matrix4f load(float[] fArray) {
        this.m00 = fArray[0];
        this.m10 = fArray[1];
        this.m20 = fArray[2];
        this.m30 = fArray[3];
        this.m01 = fArray[4];
        this.m11 = fArray[5];
        this.m21 = fArray[6];
        this.m31 = fArray[7];
        this.m02 = fArray[8];
        this.m12 = fArray[9];
        this.m22 = fArray[10];
        this.m32 = fArray[11];
        this.m03 = fArray[12];
        this.m13 = fArray[13];
        this.m23 = fArray[14];
        this.m33 = fArray[15];
        return this;
    }

    public Matrix4f load(float[] fArray, int n) {
        this.m00 = fArray[n + 0 + 0];
        this.m10 = fArray[n + 1 + 0];
        this.m20 = fArray[n + 2 + 0];
        this.m30 = fArray[n + 3 + 0];
        this.m01 = fArray[n + 0 + 4];
        this.m11 = fArray[n + 1 + 4];
        this.m21 = fArray[n + 2 + 4];
        this.m31 = fArray[n + 3 + 4];
        this.m02 = fArray[n + 0 + 8];
        this.m12 = fArray[n + 1 + 8];
        this.m22 = fArray[n + 2 + 8];
        this.m32 = fArray[n + 3 + 8];
        this.m03 = fArray[n + 0 + 12];
        this.m13 = fArray[n + 1 + 12];
        this.m23 = fArray[n + 2 + 12];
        this.m33 = fArray[n + 3 + 12];
        return this;
    }

    public Matrix4f load(FloatBuffer floatBuffer) {
        this.m00 = floatBuffer.get();
        this.m10 = floatBuffer.get();
        this.m20 = floatBuffer.get();
        this.m30 = floatBuffer.get();
        this.m01 = floatBuffer.get();
        this.m11 = floatBuffer.get();
        this.m21 = floatBuffer.get();
        this.m31 = floatBuffer.get();
        this.m02 = floatBuffer.get();
        this.m12 = floatBuffer.get();
        this.m22 = floatBuffer.get();
        this.m32 = floatBuffer.get();
        this.m03 = floatBuffer.get();
        this.m13 = floatBuffer.get();
        this.m23 = floatBuffer.get();
        this.m33 = floatBuffer.get();
        return this;
    }

    public float get(int n) {
        switch (n) {
            case 0: {
                return this.m00;
            }
            case 1: {
                return this.m10;
            }
            case 2: {
                return this.m20;
            }
            case 3: {
                return this.m30;
            }
            case 4: {
                return this.m01;
            }
            case 5: {
                return this.m11;
            }
            case 6: {
                return this.m21;
            }
            case 7: {
                return this.m31;
            }
            case 8: {
                return this.m02;
            }
            case 9: {
                return this.m12;
            }
            case 10: {
                return this.m22;
            }
            case 11: {
                return this.m32;
            }
            case 12: {
                return this.m03;
            }
            case 13: {
                return this.m13;
            }
            case 14: {
                return this.m23;
            }
            case 15: {
                return this.m33;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public Vec4f getColumn(int n, Vec4f vec4f) {
        vec4f.set(this.get(0 + n * 4), this.get(1 + n * 4), this.get(2 + n * 4), this.get(3 + n * 4));
        return vec4f;
    }

    public Vec3f getColumn(int n, Vec3f vec3f) {
        vec3f.set(this.get(0 + n * 4), this.get(1 + n * 4), this.get(2 + n * 4));
        return vec3f;
    }

    public Vec4f getRow(int n, Vec4f vec4f) {
        vec4f.set(this.get(n + 0), this.get(n + 4), this.get(n + 8), this.get(n + 12));
        return vec4f;
    }

    public Vec3f getRow(int n, Vec3f vec3f) {
        vec3f.set(this.get(n + 0), this.get(n + 4), this.get(n + 8));
        return vec3f;
    }

    public float[] get(float[] fArray, int n) {
        fArray[n + 0 + 0] = this.m00;
        fArray[n + 1 + 0] = this.m10;
        fArray[n + 2 + 0] = this.m20;
        fArray[n + 3 + 0] = this.m30;
        fArray[n + 0 + 4] = this.m01;
        fArray[n + 1 + 4] = this.m11;
        fArray[n + 2 + 4] = this.m21;
        fArray[n + 3 + 4] = this.m31;
        fArray[n + 0 + 8] = this.m02;
        fArray[n + 1 + 8] = this.m12;
        fArray[n + 2 + 8] = this.m22;
        fArray[n + 3 + 8] = this.m32;
        fArray[n + 0 + 12] = this.m03;
        fArray[n + 1 + 12] = this.m13;
        fArray[n + 2 + 12] = this.m23;
        fArray[n + 3 + 12] = this.m33;
        return fArray;
    }

    public float[] get(float[] fArray) {
        fArray[0] = this.m00;
        fArray[1] = this.m10;
        fArray[2] = this.m20;
        fArray[3] = this.m30;
        fArray[4] = this.m01;
        fArray[5] = this.m11;
        fArray[6] = this.m21;
        fArray[7] = this.m31;
        fArray[8] = this.m02;
        fArray[9] = this.m12;
        fArray[10] = this.m22;
        fArray[11] = this.m32;
        fArray[12] = this.m03;
        fArray[13] = this.m13;
        fArray[14] = this.m23;
        fArray[15] = this.m33;
        return fArray;
    }

    public FloatBuffer get(FloatBuffer floatBuffer) {
        floatBuffer.put(this.m00);
        floatBuffer.put(this.m10);
        floatBuffer.put(this.m20);
        floatBuffer.put(this.m30);
        floatBuffer.put(this.m01);
        floatBuffer.put(this.m11);
        floatBuffer.put(this.m21);
        floatBuffer.put(this.m31);
        floatBuffer.put(this.m02);
        floatBuffer.put(this.m12);
        floatBuffer.put(this.m22);
        floatBuffer.put(this.m32);
        floatBuffer.put(this.m03);
        floatBuffer.put(this.m13);
        floatBuffer.put(this.m23);
        floatBuffer.put(this.m33);
        return floatBuffer;
    }

    public float determinant() {
        float f = 0.0f;
        f += this.m00 * (this.m11 * (this.m22 * this.m33 - this.m23 * this.m32) - this.m12 * (this.m21 * this.m33 - this.m23 * this.m31) + this.m13 * (this.m21 * this.m32 - this.m22 * this.m31));
        f -= this.m01 * (this.m10 * (this.m22 * this.m33 - this.m23 * this.m32) - this.m12 * (this.m20 * this.m33 - this.m23 * this.m30) + this.m13 * (this.m20 * this.m32 - this.m22 * this.m30));
        f += this.m02 * (this.m10 * (this.m21 * this.m33 - this.m23 * this.m31) - this.m11 * (this.m20 * this.m33 - this.m23 * this.m30) + this.m13 * (this.m20 * this.m31 - this.m21 * this.m30));
        return f -= this.m03 * (this.m10 * (this.m21 * this.m32 - this.m22 * this.m31) - this.m11 * (this.m20 * this.m32 - this.m22 * this.m30) + this.m12 * (this.m20 * this.m31 - this.m21 * this.m30));
    }

    public final Matrix4f transpose() {
        float f = this.m10;
        this.m10 = this.m01;
        this.m01 = f;
        f = this.m20;
        this.m20 = this.m02;
        this.m02 = f;
        f = this.m30;
        this.m30 = this.m03;
        this.m03 = f;
        f = this.m21;
        this.m21 = this.m12;
        this.m12 = f;
        f = this.m31;
        this.m31 = this.m13;
        this.m13 = f;
        f = this.m32;
        this.m32 = this.m23;
        this.m23 = f;
        return this;
    }

    public final Matrix4f transpose(Matrix4f matrix4f) {
        if (matrix4f == this) {
            return this.transpose();
        }
        this.m00 = matrix4f.m00;
        this.m10 = matrix4f.m01;
        this.m20 = matrix4f.m02;
        this.m30 = matrix4f.m03;
        this.m01 = matrix4f.m10;
        this.m11 = matrix4f.m11;
        this.m21 = matrix4f.m12;
        this.m31 = matrix4f.m13;
        this.m02 = matrix4f.m20;
        this.m12 = matrix4f.m21;
        this.m22 = matrix4f.m22;
        this.m32 = matrix4f.m23;
        this.m03 = matrix4f.m30;
        this.m13 = matrix4f.m31;
        this.m23 = matrix4f.m32;
        this.m33 = matrix4f.m33;
        return this;
    }

    public boolean invert() {
        float f;
        try {
            f = this.mulScale();
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
        float f2 = this.m00 * f;
        float f3 = this.m10 * f;
        float f4 = this.m20 * f;
        float f5 = this.m30 * f;
        float f6 = this.m01 * f;
        float f7 = this.m11 * f;
        float f8 = this.m21 * f;
        float f9 = this.m31 * f;
        float f10 = this.m02 * f;
        float f11 = this.m12 * f;
        float f12 = this.m22 * f;
        float f13 = this.m32 * f;
        float f14 = this.m03 * f;
        float f15 = this.m13 * f;
        float f16 = this.m23 * f;
        float f17 = this.m33 * f;
        float f18 = f7 * (f12 * f17 - f16 * f13) - f11 * (f8 * f17 - f16 * f9) + f15 * (f8 * f13 - f12 * f9);
        float f19 = -(f3 * (f12 * f17 - f16 * f13) - f11 * (f4 * f17 - f16 * f5) + f15 * (f4 * f13 - f12 * f5));
        float f20 = f3 * (f8 * f17 - f16 * f9) - f7 * (f4 * f17 - f16 * f5) + f15 * (f4 * f9 - f8 * f5);
        float f21 = -(f3 * (f8 * f13 - f12 * f9) - f7 * (f4 * f13 - f12 * f5) + f11 * (f4 * f9 - f8 * f5));
        float f22 = -(f6 * (f12 * f17 - f16 * f13) - f10 * (f8 * f17 - f16 * f9) + f14 * (f8 * f13 - f12 * f9));
        float f23 = f2 * (f12 * f17 - f16 * f13) - f10 * (f4 * f17 - f16 * f5) + f14 * (f4 * f13 - f12 * f5);
        float f24 = -(f2 * (f8 * f17 - f16 * f9) - f6 * (f4 * f17 - f16 * f5) + f14 * (f4 * f9 - f8 * f5));
        float f25 = f2 * (f8 * f13 - f12 * f9) - f6 * (f4 * f13 - f12 * f5) + f10 * (f4 * f9 - f8 * f5);
        float f26 = f6 * (f11 * f17 - f15 * f13) - f10 * (f7 * f17 - f15 * f9) + f14 * (f7 * f13 - f11 * f9);
        float f27 = -(f2 * (f11 * f17 - f15 * f13) - f10 * (f3 * f17 - f15 * f5) + f14 * (f3 * f13 - f11 * f5));
        float f28 = f2 * (f7 * f17 - f15 * f9) - f6 * (f3 * f17 - f15 * f5) + f14 * (f3 * f9 - f7 * f5);
        float f29 = -(f2 * (f7 * f13 - f11 * f9) - f6 * (f3 * f13 - f11 * f5) + f10 * (f3 * f9 - f7 * f5));
        float f30 = -(f6 * (f11 * f16 - f15 * f12) - f10 * (f7 * f16 - f15 * f8) + f14 * (f7 * f12 - f11 * f8));
        float f31 = f2 * (f11 * f16 - f15 * f12) - f10 * (f3 * f16 - f15 * f4) + f14 * (f3 * f12 - f11 * f4);
        float f32 = -(f2 * (f7 * f16 - f15 * f8) - f6 * (f3 * f16 - f15 * f4) + f14 * (f3 * f8 - f7 * f4));
        float f33 = f2 * (f7 * f12 - f11 * f8) - f6 * (f3 * f12 - f11 * f4) + f10 * (f3 * f8 - f7 * f4);
        float f34 = (f2 * f18 + f6 * f19 + f10 * f20 + f14 * f21) / f;
        if (0.0f == f34) {
            return false;
        }
        float f35 = 1.0f / f34;
        this.m00 = f18 * f35;
        this.m10 = f19 * f35;
        this.m20 = f20 * f35;
        this.m30 = f21 * f35;
        this.m01 = f22 * f35;
        this.m11 = f23 * f35;
        this.m21 = f24 * f35;
        this.m31 = f25 * f35;
        this.m02 = f26 * f35;
        this.m12 = f27 * f35;
        this.m22 = f28 * f35;
        this.m32 = f29 * f35;
        this.m03 = f30 * f35;
        this.m13 = f31 * f35;
        this.m23 = f32 * f35;
        this.m33 = f33 * f35;
        return true;
    }

    public boolean invert(Matrix4f matrix4f) {
        float f;
        try {
            f = matrix4f.mulScale();
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
        float f2 = matrix4f.m00 * f;
        float f3 = matrix4f.m10 * f;
        float f4 = matrix4f.m20 * f;
        float f5 = matrix4f.m30 * f;
        float f6 = matrix4f.m01 * f;
        float f7 = matrix4f.m11 * f;
        float f8 = matrix4f.m21 * f;
        float f9 = matrix4f.m31 * f;
        float f10 = matrix4f.m02 * f;
        float f11 = matrix4f.m12 * f;
        float f12 = matrix4f.m22 * f;
        float f13 = matrix4f.m32 * f;
        float f14 = matrix4f.m03 * f;
        float f15 = matrix4f.m13 * f;
        float f16 = matrix4f.m23 * f;
        float f17 = matrix4f.m33 * f;
        float f18 = f7 * (f12 * f17 - f16 * f13) - f11 * (f8 * f17 - f16 * f9) + f15 * (f8 * f13 - f12 * f9);
        float f19 = -(f3 * (f12 * f17 - f16 * f13) - f11 * (f4 * f17 - f16 * f5) + f15 * (f4 * f13 - f12 * f5));
        float f20 = f3 * (f8 * f17 - f16 * f9) - f7 * (f4 * f17 - f16 * f5) + f15 * (f4 * f9 - f8 * f5);
        float f21 = -(f3 * (f8 * f13 - f12 * f9) - f7 * (f4 * f13 - f12 * f5) + f11 * (f4 * f9 - f8 * f5));
        float f22 = -(f6 * (f12 * f17 - f16 * f13) - f10 * (f8 * f17 - f16 * f9) + f14 * (f8 * f13 - f12 * f9));
        float f23 = f2 * (f12 * f17 - f16 * f13) - f10 * (f4 * f17 - f16 * f5) + f14 * (f4 * f13 - f12 * f5);
        float f24 = -(f2 * (f8 * f17 - f16 * f9) - f6 * (f4 * f17 - f16 * f5) + f14 * (f4 * f9 - f8 * f5));
        float f25 = f2 * (f8 * f13 - f12 * f9) - f6 * (f4 * f13 - f12 * f5) + f10 * (f4 * f9 - f8 * f5);
        float f26 = f6 * (f11 * f17 - f15 * f13) - f10 * (f7 * f17 - f15 * f9) + f14 * (f7 * f13 - f11 * f9);
        float f27 = -(f2 * (f11 * f17 - f15 * f13) - f10 * (f3 * f17 - f15 * f5) + f14 * (f3 * f13 - f11 * f5));
        float f28 = f2 * (f7 * f17 - f15 * f9) - f6 * (f3 * f17 - f15 * f5) + f14 * (f3 * f9 - f7 * f5);
        float f29 = -(f2 * (f7 * f13 - f11 * f9) - f6 * (f3 * f13 - f11 * f5) + f10 * (f3 * f9 - f7 * f5));
        float f30 = -(f6 * (f11 * f16 - f15 * f12) - f10 * (f7 * f16 - f15 * f8) + f14 * (f7 * f12 - f11 * f8));
        float f31 = f2 * (f11 * f16 - f15 * f12) - f10 * (f3 * f16 - f15 * f4) + f14 * (f3 * f12 - f11 * f4);
        float f32 = -(f2 * (f7 * f16 - f15 * f8) - f6 * (f3 * f16 - f15 * f4) + f14 * (f3 * f8 - f7 * f4));
        float f33 = f2 * (f7 * f12 - f11 * f8) - f6 * (f3 * f12 - f11 * f4) + f10 * (f3 * f8 - f7 * f4);
        float f34 = (f2 * f18 + f6 * f19 + f10 * f20 + f14 * f21) / f;
        if (0.0f == f34) {
            return false;
        }
        float f35 = 1.0f / f34;
        this.m00 = f18 * f35;
        this.m10 = f19 * f35;
        this.m20 = f20 * f35;
        this.m30 = f21 * f35;
        this.m01 = f22 * f35;
        this.m11 = f23 * f35;
        this.m21 = f24 * f35;
        this.m31 = f25 * f35;
        this.m02 = f26 * f35;
        this.m12 = f27 * f35;
        this.m22 = f28 * f35;
        this.m32 = f29 * f35;
        this.m03 = f30 * f35;
        this.m13 = f31 * f35;
        this.m23 = f32 * f35;
        this.m33 = f33 * f35;
        return true;
    }

    private final float mulScale() {
        float f;
        float f2 = f = Math.abs(this.m00);
        f = Math.abs(this.m01);
        if (f > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m02)) > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m03)) > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m10)) > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m11)) > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m12)) > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m13)) > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m20)) > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m21)) > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m22)) > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m23)) > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m30)) > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m31)) > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m32)) > f2) {
            f2 = f;
        }
        if ((f = Math.abs(this.m33)) > f2) {
            f2 = f;
        }
        return 1.0f / f2;
    }

    public final Matrix4f mul(Matrix4f matrix4f) {
        float f = this.m00;
        float f2 = this.m01;
        float f3 = this.m02;
        float f4 = this.m03;
        this.m00 = f * matrix4f.m00 + f2 * matrix4f.m10 + f3 * matrix4f.m20 + f4 * matrix4f.m30;
        this.m01 = f * matrix4f.m01 + f2 * matrix4f.m11 + f3 * matrix4f.m21 + f4 * matrix4f.m31;
        this.m02 = f * matrix4f.m02 + f2 * matrix4f.m12 + f3 * matrix4f.m22 + f4 * matrix4f.m32;
        this.m03 = f * matrix4f.m03 + f2 * matrix4f.m13 + f3 * matrix4f.m23 + f4 * matrix4f.m33;
        f = this.m10;
        f2 = this.m11;
        f3 = this.m12;
        f4 = this.m13;
        this.m10 = f * matrix4f.m00 + f2 * matrix4f.m10 + f3 * matrix4f.m20 + f4 * matrix4f.m30;
        this.m11 = f * matrix4f.m01 + f2 * matrix4f.m11 + f3 * matrix4f.m21 + f4 * matrix4f.m31;
        this.m12 = f * matrix4f.m02 + f2 * matrix4f.m12 + f3 * matrix4f.m22 + f4 * matrix4f.m32;
        this.m13 = f * matrix4f.m03 + f2 * matrix4f.m13 + f3 * matrix4f.m23 + f4 * matrix4f.m33;
        f = this.m20;
        f2 = this.m21;
        f3 = this.m22;
        f4 = this.m23;
        this.m20 = f * matrix4f.m00 + f2 * matrix4f.m10 + f3 * matrix4f.m20 + f4 * matrix4f.m30;
        this.m21 = f * matrix4f.m01 + f2 * matrix4f.m11 + f3 * matrix4f.m21 + f4 * matrix4f.m31;
        this.m22 = f * matrix4f.m02 + f2 * matrix4f.m12 + f3 * matrix4f.m22 + f4 * matrix4f.m32;
        this.m23 = f * matrix4f.m03 + f2 * matrix4f.m13 + f3 * matrix4f.m23 + f4 * matrix4f.m33;
        f = this.m30;
        f2 = this.m31;
        f3 = this.m32;
        f4 = this.m33;
        this.m30 = f * matrix4f.m00 + f2 * matrix4f.m10 + f3 * matrix4f.m20 + f4 * matrix4f.m30;
        this.m31 = f * matrix4f.m01 + f2 * matrix4f.m11 + f3 * matrix4f.m21 + f4 * matrix4f.m31;
        this.m32 = f * matrix4f.m02 + f2 * matrix4f.m12 + f3 * matrix4f.m22 + f4 * matrix4f.m32;
        this.m33 = f * matrix4f.m03 + f2 * matrix4f.m13 + f3 * matrix4f.m23 + f4 * matrix4f.m33;
        return this;
    }

    public final Matrix4f mul(Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.m00 = matrix4f.m00 * matrix4f2.m00 + matrix4f.m01 * matrix4f2.m10 + matrix4f.m02 * matrix4f2.m20 + matrix4f.m03 * matrix4f2.m30;
        this.m01 = matrix4f.m00 * matrix4f2.m01 + matrix4f.m01 * matrix4f2.m11 + matrix4f.m02 * matrix4f2.m21 + matrix4f.m03 * matrix4f2.m31;
        this.m02 = matrix4f.m00 * matrix4f2.m02 + matrix4f.m01 * matrix4f2.m12 + matrix4f.m02 * matrix4f2.m22 + matrix4f.m03 * matrix4f2.m32;
        this.m03 = matrix4f.m00 * matrix4f2.m03 + matrix4f.m01 * matrix4f2.m13 + matrix4f.m02 * matrix4f2.m23 + matrix4f.m03 * matrix4f2.m33;
        this.m10 = matrix4f.m10 * matrix4f2.m00 + matrix4f.m11 * matrix4f2.m10 + matrix4f.m12 * matrix4f2.m20 + matrix4f.m13 * matrix4f2.m30;
        this.m11 = matrix4f.m10 * matrix4f2.m01 + matrix4f.m11 * matrix4f2.m11 + matrix4f.m12 * matrix4f2.m21 + matrix4f.m13 * matrix4f2.m31;
        this.m12 = matrix4f.m10 * matrix4f2.m02 + matrix4f.m11 * matrix4f2.m12 + matrix4f.m12 * matrix4f2.m22 + matrix4f.m13 * matrix4f2.m32;
        this.m13 = matrix4f.m10 * matrix4f2.m03 + matrix4f.m11 * matrix4f2.m13 + matrix4f.m12 * matrix4f2.m23 + matrix4f.m13 * matrix4f2.m33;
        this.m20 = matrix4f.m20 * matrix4f2.m00 + matrix4f.m21 * matrix4f2.m10 + matrix4f.m22 * matrix4f2.m20 + matrix4f.m23 * matrix4f2.m30;
        this.m21 = matrix4f.m20 * matrix4f2.m01 + matrix4f.m21 * matrix4f2.m11 + matrix4f.m22 * matrix4f2.m21 + matrix4f.m23 * matrix4f2.m31;
        this.m22 = matrix4f.m20 * matrix4f2.m02 + matrix4f.m21 * matrix4f2.m12 + matrix4f.m22 * matrix4f2.m22 + matrix4f.m23 * matrix4f2.m32;
        this.m23 = matrix4f.m20 * matrix4f2.m03 + matrix4f.m21 * matrix4f2.m13 + matrix4f.m22 * matrix4f2.m23 + matrix4f.m23 * matrix4f2.m33;
        this.m30 = matrix4f.m30 * matrix4f2.m00 + matrix4f.m31 * matrix4f2.m10 + matrix4f.m32 * matrix4f2.m20 + matrix4f.m33 * matrix4f2.m30;
        this.m31 = matrix4f.m30 * matrix4f2.m01 + matrix4f.m31 * matrix4f2.m11 + matrix4f.m32 * matrix4f2.m21 + matrix4f.m33 * matrix4f2.m31;
        this.m32 = matrix4f.m30 * matrix4f2.m02 + matrix4f.m31 * matrix4f2.m12 + matrix4f.m32 * matrix4f2.m22 + matrix4f.m33 * matrix4f2.m32;
        this.m33 = matrix4f.m30 * matrix4f2.m03 + matrix4f.m31 * matrix4f2.m13 + matrix4f.m32 * matrix4f2.m23 + matrix4f.m33 * matrix4f2.m33;
        return this;
    }

    public final Vec4f mulVec4f(Vec4f vec4f, Vec4f vec4f2) {
        float f = vec4f.x();
        float f2 = vec4f.y();
        float f3 = vec4f.z();
        float f4 = vec4f.w();
        vec4f2.set(f * this.m00 + f2 * this.m01 + f3 * this.m02 + f4 * this.m03, f * this.m10 + f2 * this.m11 + f3 * this.m12 + f4 * this.m13, f * this.m20 + f2 * this.m21 + f3 * this.m22 + f4 * this.m23, f * this.m30 + f2 * this.m31 + f3 * this.m32 + f4 * this.m33);
        return vec4f2;
    }

    public final Vec4f mulVec4f(Vec4f vec4f) {
        float f = vec4f.x();
        float f2 = vec4f.y();
        float f3 = vec4f.z();
        float f4 = vec4f.w();
        vec4f.set(f * this.m00 + f2 * this.m01 + f3 * this.m02 + f4 * this.m03, f * this.m10 + f2 * this.m11 + f3 * this.m12 + f4 * this.m13, f * this.m20 + f2 * this.m21 + f3 * this.m22 + f4 * this.m23, f * this.m30 + f2 * this.m31 + f3 * this.m32 + f4 * this.m33);
        return vec4f;
    }

    public final Vec3f mulVec3f(Vec3f vec3f, Vec3f vec3f2) {
        float f = vec3f.x();
        float f2 = vec3f.y();
        float f3 = vec3f.z();
        vec3f2.set(f * this.m00 + f2 * this.m01 + f3 * this.m02 + 1.0f * this.m03, f * this.m10 + f2 * this.m11 + f3 * this.m12 + 1.0f * this.m13, f * this.m20 + f2 * this.m21 + f3 * this.m22 + 1.0f * this.m23);
        return vec3f2;
    }

    public final Vec3f mulVec3f(Vec3f vec3f) {
        float f = vec3f.x();
        float f2 = vec3f.y();
        float f3 = vec3f.z();
        vec3f.set(f * this.m00 + f2 * this.m01 + f3 * this.m02 + 1.0f * this.m03, f * this.m10 + f2 * this.m11 + f3 * this.m12 + 1.0f * this.m13, f * this.m20 + f2 * this.m21 + f3 * this.m22 + 1.0f * this.m23);
        return vec3f;
    }

    public final Matrix4f setToTranslation(float f, float f2, float f3) {
        this.m33 = 1.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
        this.m03 = f;
        this.m13 = f2;
        this.m23 = f3;
        this.m32 = 0.0f;
        this.m31 = 0.0f;
        this.m30 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        return this;
    }

    public final Matrix4f setToTranslation(Vec3f vec3f) {
        return this.setToTranslation(vec3f.x(), vec3f.y(), vec3f.z());
    }

    public final Matrix4f setToScale(float f, float f2, float f3) {
        this.m33 = 1.0f;
        this.m00 = f;
        this.m11 = f2;
        this.m22 = f3;
        this.m32 = 0.0f;
        this.m31 = 0.0f;
        this.m30 = 0.0f;
        this.m23 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m13 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m03 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        return this;
    }

    public final Matrix4f setToScale(Vec3f vec3f) {
        return this.setToScale(vec3f.x(), vec3f.y(), vec3f.z());
    }

    public final Matrix4f setToRotationAxis(float f, float f2, float f3, float f4) {
        float f5 = FloatUtil.cos(f);
        float f6 = 1.0f - f5;
        float f7 = FloatUtil.sin(f);
        Vec3f vec3f = new Vec3f(f2, f3, f4).normalize();
        f2 = vec3f.x();
        f3 = vec3f.y();
        f4 = vec3f.z();
        float f8 = f2 * f3;
        float f9 = f2 * f4;
        float f10 = f2 * f7;
        float f11 = f3 * f7;
        float f12 = f3 * f4;
        float f13 = f4 * f7;
        this.m00 = f2 * f2 * f6 + f5;
        this.m10 = f8 * f6 + f13;
        this.m20 = f9 * f6 - f11;
        this.m30 = 0.0f;
        this.m01 = f8 * f6 - f13;
        this.m11 = f3 * f3 * f6 + f5;
        this.m21 = f12 * f6 + f10;
        this.m31 = 0.0f;
        this.m02 = f9 * f6 + f11;
        this.m12 = f12 * f6 - f10;
        this.m22 = f4 * f4 * f6 + f5;
        this.m32 = 0.0f;
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m33 = 1.0f;
        return this;
    }

    public final Matrix4f setToRotationAxis(float f, Vec3f vec3f) {
        return this.setToRotationAxis(f, vec3f.x(), vec3f.y(), vec3f.z());
    }

    public Matrix4f setToRotationEuler(float f, float f2, float f3) {
        float f4 = FloatUtil.cos(f2);
        float f5 = FloatUtil.sin(f2);
        float f6 = FloatUtil.cos(f3);
        float f7 = FloatUtil.sin(f3);
        float f8 = FloatUtil.cos(f);
        float f9 = FloatUtil.sin(f);
        this.m00 = f4 * f6;
        this.m10 = f7;
        this.m20 = -f5 * f6;
        this.m30 = 0.0f;
        this.m01 = f5 * f9 - f4 * f7 * f8;
        this.m11 = f6 * f8;
        this.m21 = f5 * f7 * f8 + f4 * f9;
        this.m31 = 0.0f;
        this.m02 = f4 * f7 * f9 + f5 * f8;
        this.m12 = -f6 * f9;
        this.m22 = -f5 * f7 * f9 + f4 * f8;
        this.m32 = 0.0f;
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m33 = 1.0f;
        return this;
    }

    public Matrix4f setToRotationEuler(Vec3f vec3f) {
        return this.setToRotationEuler(vec3f.x(), vec3f.y(), vec3f.z());
    }

    public final Matrix4f setToRotation(Quaternion quaternion) {
        float f = quaternion.magnitudeSquared();
        if (FloatUtil.isZero(f)) {
            this.loadIdentity();
            return this;
        }
        float f2 = FloatUtil.isEqual(1.0f, f) ? 2.0f : 2.0f / f;
        float f3 = quaternion.x();
        float f4 = quaternion.y();
        float f5 = quaternion.z();
        float f6 = quaternion.w();
        float f7 = f2 * f3;
        float f8 = f2 * f4;
        float f9 = f2 * f5;
        float f10 = f3 * f7;
        float f11 = f3 * f8;
        float f12 = f3 * f9;
        float f13 = f7 * f6;
        float f14 = f4 * f8;
        float f15 = f4 * f9;
        float f16 = f8 * f6;
        float f17 = f5 * f9;
        float f18 = f9 * f6;
        this.m00 = 1.0f - (f14 + f17);
        this.m01 = f11 - f18;
        this.m02 = f12 + f16;
        this.m03 = 0.0f;
        this.m10 = f11 + f18;
        this.m11 = 1.0f - (f10 + f17);
        this.m12 = f15 - f13;
        this.m13 = 0.0f;
        this.m20 = f12 - f16;
        this.m21 = f15 + f13;
        this.m22 = 1.0f - (f10 + f14);
        this.m23 = 0.0f;
        this.m32 = 0.0f;
        this.m31 = 0.0f;
        this.m30 = 0.0f;
        this.m33 = 1.0f;
        return this;
    }

    public final Quaternion getRotation(Quaternion quaternion) {
        return quaternion.setFromMat(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
    }

    public Matrix4f setToOrtho(float f, float f2, float f3, float f4, float f5, float f6) {
        this.m30 = 0.0f;
        this.m20 = 0.0f;
        this.m10 = 0.0f;
        this.m31 = 0.0f;
        this.m21 = 0.0f;
        this.m01 = 0.0f;
        this.m32 = 0.0f;
        this.m12 = 0.0f;
        this.m02 = 0.0f;
        float f7 = f2 - f;
        float f8 = f4 - f3;
        float f9 = f6 - f5;
        float f10 = -1.0f * (f2 + f) / f7;
        float f11 = -1.0f * (f4 + f3) / f8;
        float f12 = -1.0f * (f6 + f5) / f9;
        this.m00 = 2.0f / f7;
        this.m11 = 2.0f / f8;
        this.m22 = -2.0f / f9;
        this.m03 = f10;
        this.m13 = f11;
        this.m23 = f12;
        this.m33 = 1.0f;
        return this;
    }

    public Matrix4f setToFrustum(float f, float f2, float f3, float f4, float f5, float f6) throws IllegalArgumentException {
        if (f5 <= 0.0f || f6 <= f5) {
            throw new IllegalArgumentException("Requirements zNear > 0 and zFar > zNear, but zNear " + f5 + ", zFar " + f6);
        }
        if (f == f2 || f4 == f3) {
            throw new IllegalArgumentException("GL_INVALID_VALUE: top,bottom and left,right must not be equal");
        }
        this.m30 = 0.0f;
        this.m20 = 0.0f;
        this.m10 = 0.0f;
        this.m31 = 0.0f;
        this.m21 = 0.0f;
        this.m01 = 0.0f;
        this.m13 = 0.0f;
        this.m03 = 0.0f;
        float f7 = 2.0f * f5;
        float f8 = f2 - f;
        float f9 = f4 - f3;
        float f10 = f6 - f5;
        float f11 = (f2 + f) / f8;
        float f12 = (f4 + f3) / f9;
        float f13 = -1.0f * (f6 + f5) / f10;
        float f14 = -2.0f * (f6 * f5) / f10;
        this.m00 = f7 / f8;
        this.m11 = f7 / f9;
        this.m02 = f11;
        this.m12 = f12;
        this.m22 = f13;
        this.m32 = -1.0f;
        this.m23 = f14;
        this.m33 = 0.0f;
        return this;
    }

    public Matrix4f setToPerspective(float f, float f2, float f3, float f4) throws IllegalArgumentException {
        float f5 = FloatUtil.tan(f / 2.0f) * f3;
        float f6 = -1.0f * f5;
        float f7 = f2 * f6;
        float f8 = f2 * f5;
        return this.setToFrustum(f7, f8, f6, f5, f3, f4);
    }

    public Matrix4f setToPerspective(FovHVHalves fovHVHalves, float f, float f2) throws IllegalArgumentException {
        FovHVHalves fovHVHalves2 = fovHVHalves.toTangents();
        float f3 = fovHVHalves2.top * f;
        float f4 = -1.0f * fovHVHalves2.bottom * f;
        float f5 = -1.0f * fovHVHalves2.left * f;
        float f6 = fovHVHalves2.right * f;
        return this.setToFrustum(f5, f6, f4, f3, f, f2);
    }

    public Frustum getFrustum(Frustum frustum) {
        Frustum.Plane plane = frustum.getPlanes()[0];
        plane.n.set(this.m30 + this.m00, this.m31 + this.m01, this.m32 + this.m02);
        plane.d = this.m33 + this.m03;
        plane = frustum.getPlanes()[1];
        plane.n.set(this.m30 - this.m00, this.m31 - this.m01, this.m32 - this.m02);
        plane.d = this.m33 - this.m03;
        plane = frustum.getPlanes()[2];
        plane.n.set(this.m30 + this.m10, this.m31 + this.m11, this.m32 + this.m12);
        plane.d = this.m33 + this.m13;
        plane = frustum.getPlanes()[3];
        plane.n.set(this.m30 - this.m10, this.m31 - this.m11, this.m32 - this.m12);
        plane.d = this.m33 - this.m13;
        plane = frustum.getPlanes()[4];
        plane.n.set(this.m30 + this.m20, this.m31 + this.m21, this.m32 + this.m22);
        plane.d = this.m33 + this.m23;
        plane = frustum.getPlanes()[5];
        plane.n.set(this.m30 - this.m20, this.m31 - this.m21, this.m32 - this.m22);
        plane.d = this.m33 - this.m23;
        for (int i = 0; i < 6; ++i) {
            Frustum.Plane plane2 = frustum.getPlanes()[i];
            Vec3f vec3f = plane2.n;
            float f = 1.0f / vec3f.length();
            vec3f.scale(f);
            plane2.d *= f;
        }
        return frustum;
    }

    public Matrix4f setToLookAt(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Matrix4f matrix4f) {
        Vec3f vec3f4 = new Vec3f(vec3f2.x() - vec3f.x(), vec3f2.y() - vec3f.y(), vec3f2.z() - vec3f.z()).normalize();
        Vec3f vec3f5 = vec3f4.cross(vec3f3).normalize();
        Vec3f vec3f6 = vec3f5.cross(vec3f4);
        this.m00 = vec3f5.x();
        this.m10 = vec3f6.x();
        this.m20 = -vec3f4.x();
        this.m30 = 0.0f;
        this.m01 = vec3f5.y();
        this.m11 = vec3f6.y();
        this.m21 = -vec3f4.y();
        this.m31 = 0.0f;
        this.m02 = vec3f5.z();
        this.m12 = vec3f6.z();
        this.m22 = -vec3f4.z();
        this.m32 = 0.0f;
        this.m03 = 0.0f;
        this.m13 = 0.0f;
        this.m23 = 0.0f;
        this.m33 = 1.0f;
        return this.mul(matrix4f.setToTranslation(-vec3f.x(), -vec3f.y(), -vec3f.z()));
    }

    public Matrix4f setToPick(float f, float f2, float f3, float f4, Recti recti, Matrix4f matrix4f) {
        if (f3 <= 0.0f || f4 <= 0.0f) {
            return null;
        }
        this.setToTranslation(((float)recti.width() - 2.0f * (f - (float)recti.x())) / f3, ((float)recti.height() - 2.0f * (f2 - (float)recti.y())) / f4, 0.0f);
        matrix4f.setToScale((float)recti.width() / f3, (float)recti.height() / f4, 1.0f);
        return this.mul(matrix4f);
    }

    public final Matrix4f rotate(float f, float f2, float f3, float f4, Matrix4f matrix4f) {
        return this.mul(matrix4f.setToRotationAxis(f, f2, f3, f4));
    }

    public final Matrix4f rotate(float f, Vec3f vec3f, Matrix4f matrix4f) {
        return this.mul(matrix4f.setToRotationAxis(f, vec3f));
    }

    public final Matrix4f rotate(Quaternion quaternion, Matrix4f matrix4f) {
        return this.mul(matrix4f.setToRotation(quaternion));
    }

    public final Matrix4f translate(float f, float f2, float f3, Matrix4f matrix4f) {
        return this.mul(matrix4f.setToTranslation(f, f2, f3));
    }

    public final Matrix4f translate(Vec3f vec3f, Matrix4f matrix4f) {
        return this.mul(matrix4f.setToTranslation(vec3f));
    }

    public final Matrix4f scale(float f, float f2, float f3, Matrix4f matrix4f) {
        return this.mul(matrix4f.setToScale(f, f2, f3));
    }

    public final Matrix4f scale(float f, Matrix4f matrix4f) {
        return this.mul(matrix4f.setToScale(f, f, f));
    }

    public final void push() {
        this.stack.push(this);
    }

    public final void pop() {
        this.stack.pop(this);
    }

    public boolean isEqual(Matrix4f matrix4f, float f) {
        if (this == matrix4f) {
            return true;
        }
        return FloatUtil.isEqual(this.m00, matrix4f.m00, f) && FloatUtil.isEqual(this.m01, matrix4f.m01, f) && FloatUtil.isEqual(this.m02, matrix4f.m02, f) && FloatUtil.isEqual(this.m03, matrix4f.m03, f) && FloatUtil.isEqual(this.m10, matrix4f.m10, f) && FloatUtil.isEqual(this.m11, matrix4f.m11, f) && FloatUtil.isEqual(this.m12, matrix4f.m12, f) && FloatUtil.isEqual(this.m13, matrix4f.m13, f) && FloatUtil.isEqual(this.m20, matrix4f.m20, f) && FloatUtil.isEqual(this.m21, matrix4f.m21, f) && FloatUtil.isEqual(this.m22, matrix4f.m22, f) && FloatUtil.isEqual(this.m23, matrix4f.m23, f) && FloatUtil.isEqual(this.m30, matrix4f.m30, f) && FloatUtil.isEqual(this.m31, matrix4f.m31, f) && FloatUtil.isEqual(this.m32, matrix4f.m32, f) && FloatUtil.isEqual(this.m33, matrix4f.m33, f);
    }

    public boolean isEqual(Matrix4f matrix4f) {
        return this.isEqual(matrix4f, 1.1920929E-7f);
    }

    public boolean equals(Object object) {
        if (object instanceof Matrix4f) {
            return this.isEqual((Matrix4f)object, 1.1920929E-7f);
        }
        return false;
    }

    public static boolean mapObjToWin(Vec3f vec3f, Matrix4f matrix4f, Matrix4f matrix4f2, Recti recti, Vec3f vec3f2) {
        Vec4f vec4f = new Vec4f(vec3f, 1.0f);
        Vec4f vec4f2 = matrix4f.mulVec4f(vec4f, new Vec4f());
        Vec4f vec4f3 = matrix4f2.mulVec4f(vec4f2, vec4f);
        if (vec4f3.w() == 0.0f) {
            return false;
        }
        float f = 1.0f / vec4f3.w() * 0.5f;
        vec4f3.scale(f).add(0.5f, 0.5f, 0.5f, 0.0f);
        vec3f2.set(vec4f3.x() * (float)recti.width() + (float)recti.x(), vec4f3.y() * (float)recti.height() + (float)recti.y(), vec4f3.z());
        return true;
    }

    public static boolean mapObjToWin(Vec3f vec3f, Matrix4f matrix4f, Recti recti, Vec3f vec3f2) {
        Vec4f vec4f = new Vec4f(vec3f, 1.0f);
        Vec4f vec4f2 = matrix4f.mulVec4f(vec4f, new Vec4f());
        if (vec4f2.w() == 0.0f) {
            return false;
        }
        float f = 1.0f / vec4f2.w() * 0.5f;
        vec4f2.scale(f).add(0.5f, 0.5f, 0.5f, 0.0f);
        vec3f2.set(vec4f2.x() * (float)recti.width() + (float)recti.x(), vec4f2.y() * (float)recti.height() + (float)recti.y(), vec4f2.z());
        return true;
    }

    public static boolean mapWinToObj(float f, float f2, float f3, Matrix4f matrix4f, Matrix4f matrix4f2, Recti recti, Vec3f vec3f, Matrix4f matrix4f3) {
        Matrix4f matrix4f4 = matrix4f3.mul(matrix4f2, matrix4f);
        if (!matrix4f4.invert()) {
            return false;
        }
        Vec4f vec4f = new Vec4f(f, f2, f3, 1.0f);
        vec4f.add(-recti.x(), -recti.y(), 0.0f, 0.0f).mul(1.0f / (float)recti.width(), 1.0f / (float)recti.height(), 1.0f, 1.0f);
        vec4f.mul(2.0f, 2.0f, 2.0f, 1.0f).add(-1.0f, -1.0f, -1.0f, 0.0f);
        Vec4f vec4f2 = matrix4f4.mulVec4f(vec4f, new Vec4f());
        if (vec4f2.w() == 0.0f) {
            return false;
        }
        vec3f.set(vec4f2.scale(1.0f / vec4f2.w()));
        return true;
    }

    public static boolean mapWinToObj(float f, float f2, float f3, Matrix4f matrix4f, Recti recti, Vec3f vec3f) {
        if (null == matrix4f) {
            return false;
        }
        Vec4f vec4f = new Vec4f(f, f2, f3, 1.0f);
        vec4f.add(-recti.x(), -recti.y(), 0.0f, 0.0f).mul(1.0f / (float)recti.width(), 1.0f / (float)recti.height(), 1.0f, 1.0f);
        vec4f.mul(2.0f, 2.0f, 2.0f, 1.0f).add(-1.0f, -1.0f, -1.0f, 0.0f);
        Vec4f vec4f2 = matrix4f.mulVec4f(vec4f, new Vec4f());
        if (vec4f2.w() == 0.0f) {
            return false;
        }
        vec3f.set(vec4f2.scale(1.0f / vec4f2.w()));
        return true;
    }

    public static boolean mapWinToObj(float f, float f2, float f3, float f4, Matrix4f matrix4f, Recti recti, Vec3f vec3f, Vec3f vec3f2) {
        if (null == matrix4f) {
            return false;
        }
        Vec4f vec4f = new Vec4f(f, f2, f3, 1.0f);
        vec4f.add(-recti.x(), -recti.y(), 0.0f, 0.0f).mul(1.0f / (float)recti.width(), 1.0f / (float)recti.height(), 1.0f, 1.0f);
        vec4f.mul(2.0f, 2.0f, 2.0f, 1.0f).add(-1.0f, -1.0f, -1.0f, 0.0f);
        Vec4f vec4f2 = matrix4f.mulVec4f(vec4f, new Vec4f());
        if (vec4f2.w() == 0.0f) {
            return false;
        }
        vec3f.set(vec4f2.scale(1.0f / vec4f2.w()));
        vec4f.setZ(f4 * 2.0f - 1.0f);
        matrix4f.mulVec4f(vec4f, vec4f2);
        if (vec4f2.w() == 0.0f) {
            return false;
        }
        vec3f2.set(vec4f2.scale(1.0f / vec4f2.w()));
        return true;
    }

    public static boolean mapWinToObj4(float f, float f2, float f3, float f4, Matrix4f matrix4f, Matrix4f matrix4f2, Recti recti, float f5, float f6, Vec4f vec4f, Matrix4f matrix4f3) {
        Matrix4f matrix4f4 = matrix4f3.mul(matrix4f2, matrix4f);
        if (!matrix4f4.invert()) {
            return false;
        }
        Vec4f vec4f2 = new Vec4f(f, f2, f3, f4);
        vec4f2.add(-recti.x(), -recti.y(), -f5, 0.0f).mul(1.0f / (float)recti.width(), 1.0f / (float)recti.height(), 1.0f / (f6 - f5), 1.0f);
        vec4f2.mul(2.0f, 2.0f, 2.0f, 1.0f).add(-1.0f, -1.0f, -1.0f, 0.0f);
        matrix4f4.mulVec4f(vec4f2, vec4f);
        return vec4f.w() != 0.0f;
    }

    public static boolean mapWinToObj4(float f, float f2, float f3, float f4, Matrix4f matrix4f, Recti recti, float f5, float f6, Vec4f vec4f) {
        if (null == matrix4f) {
            return false;
        }
        Vec4f vec4f2 = new Vec4f(f, f2, f3, f4);
        vec4f2.add(-recti.x(), -recti.y(), -f5, 0.0f).mul(1.0f / (float)recti.width(), 1.0f / (float)recti.height(), 1.0f / (f6 - f5), 1.0f);
        vec4f2.mul(2.0f, 2.0f, 2.0f, 1.0f).add(-1.0f, -1.0f, -1.0f, 0.0f);
        matrix4f.mulVec4f(vec4f2, vec4f);
        return vec4f.w() != 0.0f;
    }

    public static boolean mapWinToRay(float f, float f2, float f3, float f4, Matrix4f matrix4f, Matrix4f matrix4f2, Recti recti, Ray ray, Matrix4f matrix4f3) {
        Matrix4f matrix4f4 = matrix4f3.mul(matrix4f2, matrix4f);
        if (!matrix4f4.invert()) {
            return false;
        }
        if (Matrix4f.mapWinToObj(f, f2, f3, f4, matrix4f4, recti, ray.orig, ray.dir)) {
            ray.dir.sub(ray.orig).normalize();
            return true;
        }
        return false;
    }

    public static boolean mapWinToRay(float f, float f2, float f3, float f4, Matrix4f matrix4f, Recti recti, Ray ray) {
        if (Matrix4f.mapWinToObj(f, f2, f3, f4, matrix4f, recti, ray.orig, ray.dir)) {
            ray.dir.sub(ray.orig).normalize();
            return true;
        }
        return false;
    }

    public StringBuilder toString(StringBuilder stringBuilder, String string, String string2) {
        float[] fArray = new float[16];
        this.get(fArray);
        return FloatUtil.matrixToString(stringBuilder, string, string2, fArray, 0, 4, 4, false);
    }

    public String toString() {
        return this.toString(null, null, "%10.5f").toString();
    }

    private static class Stack {
        private int position = 0;
        private float[] buffer;
        private final int growSize;

        public Stack(int n, int n2) {
            this.growSize = n2;
            this.buffer = new float[n];
        }

        private final void growIfNecessary(int n) throws IndexOutOfBoundsException {
            if (this.position + n > this.buffer.length) {
                if (0 >= this.growSize) {
                    throw new IndexOutOfBoundsException("Out of fixed stack size: " + this);
                }
                float[] fArray = new float[this.buffer.length + Math.max(n, this.growSize)];
                System.arraycopy(this.buffer, 0, fArray, 0, this.position);
                this.buffer = fArray;
            }
        }

        public final Matrix4f push(Matrix4f matrix4f) throws IndexOutOfBoundsException {
            this.growIfNecessary(16);
            matrix4f.get(this.buffer, this.position);
            this.position += 16;
            return matrix4f;
        }

        public final Matrix4f pop(Matrix4f matrix4f) throws IndexOutOfBoundsException {
            this.position -= 16;
            matrix4f.load(this.buffer, this.position);
            return matrix4f;
        }
    }
}

