/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;

public abstract class ES6Iterator
extends IdScriptableObject {
    private static final long serialVersionUID = 2438373029140003950L;
    protected boolean exhausted = false;
    private String tag;
    private static final int Id_next = 1;
    private static final int SymbolId_iterator = 2;
    private static final int SymbolId_toStringTag = 3;
    private static final int MAX_PROTOTYPE_ID = 3;
    public static final String NEXT_METHOD = "next";
    public static final String DONE_PROPERTY = "done";
    public static final String RETURN_PROPERTY = "return";
    public static final String VALUE_PROPERTY = "value";
    public static final String RETURN_METHOD = "return";

    protected static void init(ScriptableObject scriptableObject, boolean bl, IdScriptableObject idScriptableObject, String string) {
        if (scriptableObject != null) {
            idScriptableObject.setParentScope(scriptableObject);
            idScriptableObject.setPrototype(ES6Iterator.getObjectPrototype(scriptableObject));
        }
        idScriptableObject.activatePrototypeMap(3);
        if (bl) {
            idScriptableObject.sealObject();
        }
        if (scriptableObject != null) {
            scriptableObject.associateValue(string, idScriptableObject);
        }
    }

    protected ES6Iterator() {
    }

    protected ES6Iterator(Scriptable scriptable, String string) {
        this.tag = string;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        this.setParentScope(scriptable2);
        IdScriptableObject idScriptableObject = (IdScriptableObject)ScriptableObject.getTopScopeValue(scriptable2, string);
        this.setPrototype(idScriptableObject);
    }

    @Override
    protected void initPrototypeId(int n) {
        switch (n) {
            case 1: {
                this.initPrototypeMethod(this.getTag(), n, NEXT_METHOD, 0);
                return;
            }
            case 2: {
                this.initPrototypeMethod((Object)this.getTag(), n, SymbolKey.ITERATOR, "[Symbol.iterator]", 3);
                return;
            }
            case 3: {
                this.initPrototypeValue(3, SymbolKey.TO_STRING_TAG, (Object)this.getClassName(), 3);
                return;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(this.getTag())) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        ES6Iterator eS6Iterator = ES6Iterator.ensureType(scriptable2, ES6Iterator.class, idFunctionObject);
        switch (n) {
            case 1: {
                return eS6Iterator.next(context, scriptable);
            }
            case 2: {
                return eS6Iterator;
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    @Override
    protected int findPrototypeId(Symbol symbol) {
        if (SymbolKey.ITERATOR.equals(symbol)) {
            return 2;
        }
        if (SymbolKey.TO_STRING_TAG.equals(symbol)) {
            return 3;
        }
        return 0;
    }

    @Override
    protected int findPrototypeId(String string) {
        if (NEXT_METHOD.equals(string)) {
            return 1;
        }
        return 0;
    }

    protected abstract boolean isDone(Context var1, Scriptable var2);

    protected abstract Object nextValue(Context var1, Scriptable var2);

    protected Object next(Context context, Scriptable scriptable) {
        boolean bl;
        Object object = Undefined.instance;
        boolean bl2 = bl = this.isDone(context, scriptable) || this.exhausted;
        if (!bl) {
            object = this.nextValue(context, scriptable);
        } else {
            this.exhausted = true;
        }
        return ES6Iterator.makeIteratorResult(context, scriptable, bl, object);
    }

    protected String getTag() {
        return this.tag;
    }

    static Scriptable makeIteratorResult(Context context, Scriptable scriptable, Boolean bl) {
        return ES6Iterator.makeIteratorResult(context, scriptable, bl, Undefined.instance);
    }

    static Scriptable makeIteratorResult(Context context, Scriptable scriptable, Boolean bl, Object object) {
        Scriptable scriptable2 = context.newObject(scriptable);
        ScriptableObject.putProperty(scriptable2, VALUE_PROPERTY, object);
        ScriptableObject.putProperty(scriptable2, DONE_PROPERTY, (Object)bl);
        return scriptable2;
    }
}

