/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.ControllerPopupMenuListener;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.core.ui.components.PopupDialog;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.features.link.Connectors;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.ui.NodeSelector;
import org.freeplane.view.swing.ui.RectangleMemorizer;

public class DefaultMapMouseListener
implements IMouseListener {
    protected int originX = -1;
    protected int originY = -1;
    private RectangleMemorizer rectangleMemorizer = new RectangleMemorizer();

    protected void handlePopup(MouseEvent e) {
        if (Compat.isPopupTrigger(e)) {
            Component popupForModel;
            Component popup = null;
            MapView mapView = (MapView)Controller.getCurrentController().getMapViewManager().getMapViewComponent();
            ModeController modeController = Controller.getCurrentController().getModeController();
            if (this.isMapViewWithOriginalConectosAvailable(mapView)) {
                Object obj = mapView.detectObject(e.getPoint());
                popupForModel = LinkController.getController(modeController).getPopupForModel(obj);
            } else {
                popupForModel = null;
            }
            if (popupForModel != null) {
                ControllerPopupMenuListener popupListener = new ControllerPopupMenuListener();
                popupForModel.addHierarchyListener(popupListener);
                popup = popupForModel;
            } else {
                popup = modeController.getUserInputListenerFactory().getMapPopup();
            }
            Component component = e.getComponent();
            if (popup instanceof JPopupMenu) {
                ((JPopupMenu)popup).show(component, e.getX(), e.getY());
            } else {
                Component window = popup instanceof Window ? popup : PopupDialog.createOptionPanelPopupDialog(popup);
                Point eventLocation = e.getPoint();
                SwingUtilities.convertPointToScreen(eventLocation, e.getComponent());
                UITools.setBounds(window, eventLocation.x, eventLocation.y, window.getWidth(), window.getHeight());
                window.setVisible(true);
            }
            e.consume();
        }
    }

    private boolean isMapViewWithOriginalConectosAvailable(MapView mapView) {
        return mapView != null && mapView.getClientProperty(Connectors.class) == null;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        NodeModel selected;
        Object source = e.getSource();
        if (!(source instanceof MapView)) {
            return;
        }
        MapView map = (MapView)source;
        Controller controller = map.getModeController().getController();
        IMapSelection selection = controller.getSelection();
        if (selection != null && (selected = selection.getSelected()) != null) {
            controller.getMapViewManager().getComponent(selected).requestFocusInWindow();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getComponent() instanceof MapView) {
            NodeSelector.mapViewSelector.handleMouseEvent(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getComponent() instanceof MapView) {
            NodeSelector.mapViewSelector.handleMouseEvent(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean isCtrlEvent;
        MapView mapView = MapView.getMapView(e.getComponent());
        if (mapView != null) {
            mapView.select();
        }
        if (Compat.isPopupTrigger(e)) {
            this.handlePopup(e);
            e.consume();
            return;
        }
        if (!SwingUtilities.getWindowAncestor(e.getComponent()).isFocused() || mapView != null && !mapView.isValid()) {
            return;
        }
        boolean bl = isCtrlEvent = Compat.isCtrlEvent(e) || Compat.isCtrlShiftEvent(e);
        if (isCtrlEvent && e.getButton() == 1 || !isCtrlEvent && e.getButton() == 3) {
            this.rectangleMemorizer.mousePressed(e);
        }
        if (!isCtrlEvent && e.getButton() == 1) {
            if (mapView != null) {
                mapView.setMoveCursor(true);
                this.originX = e.getX();
                this.originY = e.getY();
            }
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.rectangleMemorizer.mouseReleased(e);
        if (e.isConsumed()) {
            return;
        }
        MapView mapView = MapView.getMapView(e.getComponent());
        if (mapView != null) {
            mapView.setMoveCursor(false);
        }
        this.originX = -1;
        this.originY = -1;
        this.handlePopup(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.rectangleMemorizer.mouseDragged(e);
        if (e.isConsumed()) {
            return;
        }
        if (this.originX == -1) {
            return;
        }
        JComponent component = (JComponent)e.getComponent();
        MapView mapView = MapView.getMapView(component);
        if (mapView == null) {
            return;
        }
        if (this.originX >= 0) {
            Rectangle r;
            int dx = this.originX - e.getX();
            int dy = this.originY - e.getY();
            Rectangle visibleRect = component.getVisibleRect();
            boolean isEventPointVisible = visibleRect.contains(r = new Rectangle(e.getX(), e.getY(), 1, 1));
            if (isEventPointVisible) {
                mapView.scrollBy(dx, dy);
            } else {
                mapView.scrollBy(dx / 3, dy / 3);
                this.originX += dx / 3;
                this.originY += dy / 3;
            }
            e.consume();
        }
    }
}

