/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.content;

import java.util.List;
import java.util.Objects;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.ai.tools.content.AttributesContent;
import org.freeplane.plugin.ai.tools.content.AttributesContentReader;
import org.freeplane.plugin.ai.tools.content.EditableContent;
import org.freeplane.plugin.ai.tools.content.EditableContentReader;
import org.freeplane.plugin.ai.tools.content.IconsContent;
import org.freeplane.plugin.ai.tools.content.IconsContentReader;
import org.freeplane.plugin.ai.tools.content.NodeContentPreset;
import org.freeplane.plugin.ai.tools.content.NodeContentRequest;
import org.freeplane.plugin.ai.tools.content.NodeContentResponse;
import org.freeplane.plugin.ai.tools.content.NodeContentValueMatcher;
import org.freeplane.plugin.ai.tools.content.NodeStyleContentReader;
import org.freeplane.plugin.ai.tools.content.TagsContent;
import org.freeplane.plugin.ai.tools.content.TagsContentReader;
import org.freeplane.plugin.ai.tools.content.TextualContent;
import org.freeplane.plugin.ai.tools.content.TextualContentReader;

public class NodeContentReader {
    private final TextualContentReader textualContentReader;
    private final AttributesContentReader attributesContentReader;
    private final TagsContentReader tagsContentReader;
    private final IconsContentReader iconsContentReader;
    private final NodeStyleContentReader nodeStyleContentReader;
    private final EditableContentReader editableContentReader;

    public NodeContentReader(TextualContentReader textualContentReader, AttributesContentReader attributesContentReader, TagsContentReader tagsContentReader, IconsContentReader iconsContentReader, NodeStyleContentReader nodeStyleContentReader, EditableContentReader editableContentReader) {
        this.textualContentReader = Objects.requireNonNull(textualContentReader, "textualContentReader");
        this.attributesContentReader = Objects.requireNonNull(attributesContentReader, "attributesContentReader");
        this.tagsContentReader = Objects.requireNonNull(tagsContentReader, "tagsContentReader");
        this.iconsContentReader = Objects.requireNonNull(iconsContentReader, "iconsContentReader");
        this.nodeStyleContentReader = Objects.requireNonNull(nodeStyleContentReader, "nodeStyleContentReader");
        this.editableContentReader = Objects.requireNonNull(editableContentReader, "editableContentReader");
    }

    public NodeContentResponse readNodeContent(NodeModel nodeModel, NodeContentPreset preset) {
        if (nodeModel == null) {
            return null;
        }
        if (preset == NodeContentPreset.BRIEF) {
            String briefText = this.textualContentReader.readBriefText(nodeModel);
            return new NodeContentResponse(briefText, null, null, null, null, null, null, null);
        }
        TextualContent textualContent = this.textualContentReader.readTextualContent(nodeModel, preset);
        AttributesContent attributesContent = this.attributesContentReader.readAttributesContent(nodeModel, preset);
        TagsContent tagsContent = this.tagsContentReader.readTagsContent(nodeModel, preset);
        IconsContent iconsContent = this.iconsContentReader.readIconsContent(nodeModel, preset);
        return new NodeContentResponse(null, textualContent, attributesContent, tagsContent, iconsContent, this.nodeStyleContentReader.readActiveStyles(nodeModel), this.nodeStyleContentReader.readMainStyle(nodeModel), null);
    }

    public NodeContentResponse readNodeContent(NodeModel nodeModel, NodeContentRequest request, NodeContentPreset fallbackPreset) {
        if (nodeModel == null) {
            return null;
        }
        if (request == null) {
            return this.readNodeContent(nodeModel, fallbackPreset);
        }
        TextualContent textualContent = this.textualContentReader.readTextualContent(nodeModel, request.getTextualContentRequest());
        AttributesContent attributesContent = this.attributesContentReader.readAttributesContent(nodeModel, request.getAttributesContentRequest());
        TagsContent tagsContent = this.tagsContentReader.readTagsContent(nodeModel, request.getTagsContentRequest());
        IconsContent iconsContent = this.iconsContentReader.readIconsContent(nodeModel, request.getIconsContentRequest());
        List<String> activeStyles = this.nodeStyleContentReader.readActiveStyles(nodeModel);
        String mainStyle = this.nodeStyleContentReader.readMainStyle(nodeModel);
        EditableContent editableContent = this.editableContentReader.readEditableContent(nodeModel, request.getEditableContentRequest());
        if (textualContent == null && attributesContent == null && tagsContent == null && iconsContent == null && editableContent == null && activeStyles == null && mainStyle == null) {
            return null;
        }
        return new NodeContentResponse(null, textualContent, attributesContent, tagsContent, iconsContent, activeStyles, mainStyle, editableContent);
    }

    public boolean matches(NodeModel nodeModel, NodeContentRequest request, NodeContentValueMatcher valueMatcher) {
        if (nodeModel == null || valueMatcher == null) {
            return false;
        }
        if (request == null) {
            return false;
        }
        if (this.textualContentReader.matches(nodeModel, request.getTextualContentRequest(), valueMatcher)) {
            return true;
        }
        if (this.attributesContentReader.matches(nodeModel, request.getAttributesContentRequest(), valueMatcher)) {
            return true;
        }
        if (this.tagsContentReader.matches(nodeModel, request.getTagsContentRequest(), valueMatcher)) {
            return true;
        }
        return this.iconsContentReader.matches(nodeModel, request.getIconsContentRequest(), valueMatcher);
    }
}

