/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModelDescriptor;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;

public class GenericMetaModelRegistry {
    protected static final Log log = Log.getLog(GenericMetaModelRegistry.class);
    private final Map<String, GenericMetaModelDescriptor> metaModels = new HashMap<String, GenericMetaModelDescriptor>();
    private static final String EXTENSION_ID = "org.jkiss.dbeaver.generic.meta";
    private static volatile GenericMetaModelRegistry instance = null;

    public static synchronized GenericMetaModelRegistry getInstance() {
        if (instance == null) {
            instance = new GenericMetaModelRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private GenericMetaModelRegistry(IExtensionRegistry extensionRegistry) {
        this.metaModels.put("standard", new GenericMetaModelDescriptor());
        List<GenericMetaModelDescriptor> metaModelDescriptors = Stream.of(extensionRegistry.getConfigurationElementsFor(EXTENSION_ID)).map(GenericMetaModelDescriptor::new).toList();
        for (GenericMetaModelDescriptor metaModel : metaModelDescriptors) {
            if (!metaModel.getModelReplacements().isEmpty()) continue;
            if (this.metaModels.putIfAbsent(metaModel.getId(), metaModel) != null) {
                log.debug((Object)("Duplicate meta model ID '" + metaModel.getId() + "' detected:\n\t" + String.valueOf(this.metaModels.get(metaModel.getId()).getContributorBundle()) + "\n\t" + String.valueOf(metaModel.getContributorBundle())));
                continue;
            }
            for (String driverClass : metaModel.getDriverClass()) {
                this.metaModels.putIfAbsent(driverClass, metaModel);
            }
        }
        for (GenericMetaModelDescriptor metaModel : metaModelDescriptors) {
            for (String replaces : metaModel.getModelReplacements()) {
                GenericMetaModelDescriptor replacedMetaModel = this.metaModels.replace(replaces, metaModel);
                if (replacedMetaModel == null) {
                    log.debug((Object)("Meta model '" + metaModel.getId() + "' declares replacement of unknown meta model '" + replaces + "'"));
                    continue;
                }
                for (String driverClass : replacedMetaModel.getDriverClass()) {
                    this.metaModels.put(driverClass, metaModel);
                }
            }
        }
    }

    public GenericMetaModelDescriptor getStandardMetaModel() {
        return this.metaModels.get("standard");
    }

    public GenericMetaModel getMetaModel(DBPDataSourceContainer dataSourceContainer) throws DBException {
        GenericMetaModelDescriptor metaModel = null;
        Object metaModelId = dataSourceContainer.getDriver().getDriverParameter("meta-model");
        if (metaModelId != null && !"standard".equals(metaModelId) && (metaModel = this.metaModels.get(metaModelId.toString())) == null) {
            log.warn((Object)("Meta model '" + String.valueOf(metaModelId) + "' not recognized. Default one will be used"));
        }
        if (metaModel == null) {
            metaModel = this.metaModels.get(dataSourceContainer.getDriver().getDriverClassName());
        }
        if (metaModel == null) {
            metaModel = this.getStandardMetaModel();
        }
        return metaModel.getInstance();
    }
}

