﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GuardDuty {
namespace Model {

/**
 * <p>Contains information about the product code for the EC2
 * instance.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ProductCode">AWS
 * API Reference</a></p>
 */
class ProductCode {
 public:
  AWS_GUARDDUTY_API ProductCode() = default;
  AWS_GUARDDUTY_API ProductCode(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API ProductCode& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The product code information.</p>
   */
  inline const Aws::String& GetCode() const { return m_code; }
  inline bool CodeHasBeenSet() const { return m_codeHasBeenSet; }
  template <typename CodeT = Aws::String>
  void SetCode(CodeT&& value) {
    m_codeHasBeenSet = true;
    m_code = std::forward<CodeT>(value);
  }
  template <typename CodeT = Aws::String>
  ProductCode& WithCode(CodeT&& value) {
    SetCode(std::forward<CodeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The product code type.</p>
   */
  inline const Aws::String& GetProductType() const { return m_productType; }
  inline bool ProductTypeHasBeenSet() const { return m_productTypeHasBeenSet; }
  template <typename ProductTypeT = Aws::String>
  void SetProductType(ProductTypeT&& value) {
    m_productTypeHasBeenSet = true;
    m_productType = std::forward<ProductTypeT>(value);
  }
  template <typename ProductTypeT = Aws::String>
  ProductCode& WithProductType(ProductTypeT&& value) {
    SetProductType(std::forward<ProductTypeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_code;

  Aws::String m_productType;
  bool m_codeHasBeenSet = false;
  bool m_productTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
