/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * Copyright 2025 ROHM Semiconductors.
 *
 * Author: Matti Vaittinen <matti.vaittinen@fi.rohmeurope.com>
 */

#ifndef _MFD_BD72720_H
#define _MFD_BD72720_H

#include <linux/regmap.h>

enum {
	BD72720_BUCK1,
	BD72720_BUCK2,
	BD72720_BUCK3,
	BD72720_BUCK4,
	BD72720_BUCK5,
	BD72720_BUCK6,
	BD72720_BUCK7,
	BD72720_BUCK8,
	BD72720_BUCK9,
	BD72720_BUCK10,
	BD72720_BUCK11,
	BD72720_LDO1,
	BD72720_LDO2,
	BD72720_LDO3,
	BD72720_LDO4,
	BD72720_LDO5,
	BD72720_LDO6,
	BD72720_LDO7,
	BD72720_LDO8,
	BD72720_LDO9,
	BD72720_LDO10,
	BD72720_LDO11,
	BD72720_REGULATOR_AMOUNT,
};

/* BD72720 interrupts */
#define BD72720_INT_LONGPUSH_MASK	BIT(0)
#define BD72720_INT_MIDPUSH_MASK	BIT(1)
#define BD72720_INT_SHORTPUSH_MASK	BIT(2)
#define BD72720_INT_PUSH_MASK		BIT(3)
#define BD72720_INT_HALL_DET_MASK	BIT(4)
#define BD72720_INT_HALL_TGL_MASK	BIT(5)
#define BD72720_INT_WDOG_MASK		BIT(6)
#define BD72720_INT_SWRESET_MASK	BIT(7)
#define BD72720_INT_SEQ_DONE_MASK	BIT(0)
#define BD72720_INT_PGFAULT_MASK	BIT(4)
#define BD72720_INT_BUCK1_DVS_MASK	BIT(0)
#define BD72720_INT_BUCK2_DVS_MASK	BIT(1)
#define BD72720_INT_BUCK3_DVS_MASK	BIT(2)
#define BD72720_INT_BUCK4_DVS_MASK	BIT(3)
#define BD72720_INT_BUCK5_DVS_MASK	BIT(4)
#define BD72720_INT_BUCK6_DVS_MASK	BIT(5)
#define BD72720_INT_BUCK7_DVS_MASK	BIT(6)
#define BD72720_INT_BUCK8_DVS_MASK	BIT(7)
#define BD72720_INT_BUCK9_DVS_MASK	BIT(0)
#define BD72720_INT_BUCK10_DVS_MASK	BIT(1)
#define BD72720_INT_LDO1_DVS_MASK	BIT(4)
#define BD72720_INT_LDO2_DVS_MASK	BIT(5)
#define BD72720_INT_LDO3_DVS_MASK	BIT(6)
#define BD72720_INT_LDO4_DVS_MASK	BIT(7)
#define BD72720_INT_VBUS_RMV_MASK	BIT(0)
#define BD72720_INT_VBUS_DET_MASK	BIT(1)
#define BD72720_INT_VBUS_MON_RES_MASK	BIT(2)
#define BD72720_INT_VBUS_MON_DET_MASK	BIT(3)
#define BD72720_INT_VSYS_MON_RES_MASK	BIT(0)
#define BD72720_INT_VSYS_MON_DET_MASK	BIT(1)
#define BD72720_INT_VSYS_UV_RES_MASK	BIT(2)
#define BD72720_INT_VSYS_UV_DET_MASK	BIT(3)
#define BD72720_INT_VSYS_LO_RES_MASK	BIT(4)
#define BD72720_INT_VSYS_LO_DET_MASK	BIT(5)
#define BD72720_INT_VSYS_OV_RES_MASK	BIT(6)
#define BD72720_INT_VSYS_OV_DET_MASK	BIT(7)
#define BD72720_INT_BAT_ILIM_MASK	BIT(0)
#define BD72720_INT_CHG_DONE_MASK	BIT(1)
#define BD72720_INT_EXTEMP_TOUT_MASK	BIT(2)
#define BD72720_INT_CHG_WDT_EXP_MASK	BIT(3)
#define BD72720_INT_BAT_MNT_OUT_MASK	BIT(4)
#define BD72720_INT_BAT_MNT_IN_MASK	BIT(5)
#define BD72720_INT_CHG_TRNS_MASK	BIT(7)
#define BD72720_INT_VBAT_MON_RES_MASK	BIT(0)
#define BD72720_INT_VBAT_MON_DET_MASK	BIT(1)
#define BD72720_INT_VBAT_SHT_RES_MASK	BIT(2)
#define BD72720_INT_VBAT_SHT_DET_MASK	BIT(3)
#define BD72720_INT_VBAT_LO_RES_MASK	BIT(4)
#define BD72720_INT_VBAT_LO_DET_MASK	BIT(5)
#define BD72720_INT_VBAT_OV_RES_MASK	BIT(6)
#define BD72720_INT_VBAT_OV_DET_MASK	BIT(7)
#define BD72720_INT_BAT_RMV_MASK	BIT(0)
#define BD72720_INT_BAT_DET_MASK	BIT(1)
#define BD72720_INT_DBAT_DET_MASK	BIT(2)
#define BD72720_INT_BAT_TEMP_TRNS_MASK	BIT(3)
#define BD72720_INT_LOBTMP_RES_MASK	BIT(4)
#define BD72720_INT_LOBTMP_DET_MASK	BIT(5)
#define BD72720_INT_OVBTMP_RES_MASK	BIT(6)
#define BD72720_INT_OVBTMP_DET_MASK	BIT(7)
#define BD72720_INT_OCUR1_RES_MASK	BIT(0)
#define BD72720_INT_OCUR1_DET_MASK	BIT(1)
#define BD72720_INT_OCUR2_RES_MASK	BIT(2)
#define BD72720_INT_OCUR2_DET_MASK	BIT(3)
#define BD72720_INT_OCUR3_RES_MASK	BIT(4)
#define BD72720_INT_OCUR3_DET_MASK	BIT(5)
#define BD72720_INT_CC_MON1_DET_MASK	BIT(0)
#define BD72720_INT_CC_MON2_DET_MASK	BIT(1)
#define BD72720_INT_CC_MON3_DET_MASK	BIT(2)
#define BD72720_INT_GPIO1_IN_MASK	BIT(4)
#define BD72720_INT_GPIO2_IN_MASK	BIT(5)
#define BD72720_INT_VF125_RES_MASK	BIT(0)
#define BD72720_INT_VF125_DET_MASK	BIT(1)
#define BD72720_INT_VF_RES_MASK		BIT(2)
#define BD72720_INT_VF_DET_MASK		BIT(3)
#define BD72720_INT_RTC0_MASK		BIT(4)
#define BD72720_INT_RTC1_MASK		BIT(5)
#define BD72720_INT_RTC2_MASK		BIT(6)

enum {
	/*
	 * The IRQs excluding GPIO1 and GPIO2 are ordered in a same way as the
	 * respective IRQ bits in status and mask registers are ordered.
	 *
	 * The BD72720_INT_GPIO1_IN and BD72720_INT_GPIO2_IN are IRQs which can
	 * be used by other devices. Let's have  GPIO1 and GPIO2 as first IRQs
	 * here so we can use the regmap-IRQ with standard device tree xlate
	 * while devices connected to the BD72720 IRQ input pins can refer to
	 * the first two interrupt numbers in their device tree. If we placed
	 * BD72720_INT_GPIO1_IN and BD72720_INT_GPIO2_IN after the CC_MON_DET
	 * interrupts (like they are in the registers), the devices using
	 * BD72720 as an IRQ parent should refer the interrupts starting with
	 * an offset which might not be trivial to understand.
	 */
	BD72720_INT_GPIO1_IN,
	BD72720_INT_GPIO2_IN,
	BD72720_INT_LONGPUSH,
	BD72720_INT_MIDPUSH,
	BD72720_INT_SHORTPUSH,
	BD72720_INT_PUSH,
	BD72720_INT_HALL_DET,
	BD72720_INT_HALL_TGL,
	BD72720_INT_WDOG,
	BD72720_INT_SWRESET,
	BD72720_INT_SEQ_DONE,
	BD72720_INT_PGFAULT,
	BD72720_INT_BUCK1_DVS,
	BD72720_INT_BUCK2_DVS,
	BD72720_INT_BUCK3_DVS,
	BD72720_INT_BUCK4_DVS,
	BD72720_INT_BUCK5_DVS,
	BD72720_INT_BUCK6_DVS,
	BD72720_INT_BUCK7_DVS,
	BD72720_INT_BUCK8_DVS,
	BD72720_INT_BUCK9_DVS,
	BD72720_INT_BUCK10_DVS,
	BD72720_INT_LDO1_DVS,
	BD72720_INT_LDO2_DVS,
	BD72720_INT_LDO3_DVS,
	BD72720_INT_LDO4_DVS,
	BD72720_INT_VBUS_RMV,
	BD72720_INT_VBUS_DET,
	BD72720_INT_VBUS_MON_RES,
	BD72720_INT_VBUS_MON_DET,
	BD72720_INT_VSYS_MON_RES,
	BD72720_INT_VSYS_MON_DET,
	BD72720_INT_VSYS_UV_RES,
	BD72720_INT_VSYS_UV_DET,
	BD72720_INT_VSYS_LO_RES,
	BD72720_INT_VSYS_LO_DET,
	BD72720_INT_VSYS_OV_RES,
	BD72720_INT_VSYS_OV_DET,
	BD72720_INT_BAT_ILIM,
	BD72720_INT_CHG_DONE,
	BD72720_INT_EXTEMP_TOUT,
	BD72720_INT_CHG_WDT_EXP,
	BD72720_INT_BAT_MNT_OUT,
	BD72720_INT_BAT_MNT_IN,
	BD72720_INT_CHG_TRNS,
	BD72720_INT_VBAT_MON_RES,
	BD72720_INT_VBAT_MON_DET,
	BD72720_INT_VBAT_SHT_RES,
	BD72720_INT_VBAT_SHT_DET,
	BD72720_INT_VBAT_LO_RES,
	BD72720_INT_VBAT_LO_DET,
	BD72720_INT_VBAT_OV_RES,
	BD72720_INT_VBAT_OV_DET,
	BD72720_INT_BAT_RMV,
	BD72720_INT_BAT_DET,
	BD72720_INT_DBAT_DET,
	BD72720_INT_BAT_TEMP_TRNS,
	BD72720_INT_LOBTMP_RES,
	BD72720_INT_LOBTMP_DET,
	BD72720_INT_OVBTMP_RES,
	BD72720_INT_OVBTMP_DET,
	BD72720_INT_OCUR1_RES,
	BD72720_INT_OCUR1_DET,
	BD72720_INT_OCUR2_RES,
	BD72720_INT_OCUR2_DET,
	BD72720_INT_OCUR3_RES,
	BD72720_INT_OCUR3_DET,
	BD72720_INT_CC_MON1_DET,
	BD72720_INT_CC_MON2_DET,
	BD72720_INT_CC_MON3_DET,
	BD72720_INT_VF125_RES,
	BD72720_INT_VF125_DET,
	BD72720_INT_VF_RES,
	BD72720_INT_VF_DET,
	BD72720_INT_RTC0,
	BD72720_INT_RTC1,
	BD72720_INT_RTC2,
};

/*
 * BD72720 Registers:
 * The BD72720 has two sets of registers behind two different I2C slave
 * addresses. "Common" registers being behind 0x4b, the charger registers
 * being behind 0x4c.
 */
/* Registers behind I2C slave 0x4b */
enum {
	BD72720_REG_PRODUCT_ID,
	BD72720_REG_MANUFACTURER_ID,
	BD72720_REG_PMIC_REV_NUM,
	BD72720_REG_NVM_REV_NUM,
	BD72720_REG_BOOTSRC		= 0x10,
	BD72720_REG_RESETSRC_1,
	BD72720_REG_RESETSRC_2,
	BD72720_REG_RESETSRC_3,
	BD72720_REG_RESETSRC_4,
	BD72720_REG_RESETSRC_5,
	BD72720_REG_RESETSRC_6,
	BD72720_REG_RESETSRC_7,
	BD72720_REG_POWER_STATE,
	BD72720_REG_PS_CFG,
	BD72720_REG_PS_CTRL_1,
	BD72720_REG_PS_CTRL_2,
	BD72720_REG_RCVCFG,
	BD72720_REG_RCVNUM,
	BD72720_REG_CRDCFG,
	BD72720_REG_REX_CTRL,

	BD72720_REG_BUCK1_ON,
	BD72720_REG_BUCK1_MODE,
	/* Deep idle vsel */
	BD72720_REG_BUCK1_VSEL_DI,
	/* Idle vsel */
	BD72720_REG_BUCK1_VSEL_I,
	/* Suspend vsel */
	BD72720_REG_BUCK1_VSEL_S,
	/* Run boot vsel */
	BD72720_REG_BUCK1_VSEL_RB,
	/* Run0 ... run3 vsel */
	BD72720_REG_BUCK1_VSEL_RB0,
	BD72720_REG_BUCK1_VSEL_RB1,
	BD72720_REG_BUCK1_VSEL_RB2,
	BD72720_REG_BUCK1_VSEL_RB3,

	BD72720_REG_BUCK2_ON,
	BD72720_REG_BUCK2_MODE,
	BD72720_REG_BUCK2_VSEL_DI,
	BD72720_REG_BUCK2_VSEL_I,
	BD72720_REG_BUCK2_VSEL_S,
	/* Run vsel */
	BD72720_REG_BUCK2_VSEL_R,

	BD72720_REG_BUCK3_ON,
	BD72720_REG_BUCK3_MODE,
	BD72720_REG_BUCK3_VSEL_DI,
	BD72720_REG_BUCK3_VSEL_I,
	BD72720_REG_BUCK3_VSEL_S,
	BD72720_REG_BUCK3_VSEL_R,

	BD72720_REG_BUCK4_ON,
	BD72720_REG_BUCK4_MODE,
	BD72720_REG_BUCK4_VSEL_DI,
	BD72720_REG_BUCK4_VSEL_I,
	BD72720_REG_BUCK4_VSEL_S,
	BD72720_REG_BUCK4_VSEL_R,

	BD72720_REG_BUCK5_ON,
	BD72720_REG_BUCK5_MODE,
	BD72720_REG_BUCK5_VSEL,

	BD72720_REG_BUCK6_ON,
	BD72720_REG_BUCK6_MODE,
	BD72720_REG_BUCK6_VSEL,

	BD72720_REG_BUCK7_ON,
	BD72720_REG_BUCK7_MODE,
	BD72720_REG_BUCK7_VSEL,

	BD72720_REG_BUCK8_ON,
	BD72720_REG_BUCK8_MODE,
	BD72720_REG_BUCK8_VSEL,

	BD72720_REG_BUCK9_ON,
	BD72720_REG_BUCK9_MODE,
	BD72720_REG_BUCK9_VSEL,

	BD72720_REG_BUCK10_ON,
	BD72720_REG_BUCK10_MODE,
	BD72720_REG_BUCK10_VSEL,

	BD72720_REG_LDO1_ON,
	BD72720_REG_LDO1_MODE1,
	BD72720_REG_LDO1_MODE2,
	BD72720_REG_LDO1_VSEL_DI,
	BD72720_REG_LDO1_VSEL_I,
	BD72720_REG_LDO1_VSEL_S,
	BD72720_REG_LDO1_VSEL_RB,
	BD72720_REG_LDO1_VSEL_R0,
	BD72720_REG_LDO1_VSEL_R1,
	BD72720_REG_LDO1_VSEL_R2,
	BD72720_REG_LDO1_VSEL_R3,

	BD72720_REG_LDO2_ON,
	BD72720_REG_LDO2_MODE,
	BD72720_REG_LDO2_VSEL_DI,
	BD72720_REG_LDO2_VSEL_I,
	BD72720_REG_LDO2_VSEL_S,
	BD72720_REG_LDO2_VSEL_R,

	BD72720_REG_LDO3_ON,
	BD72720_REG_LDO3_MODE,
	BD72720_REG_LDO3_VSEL_DI,
	BD72720_REG_LDO3_VSEL_I,
	BD72720_REG_LDO3_VSEL_S,
	BD72720_REG_LDO3_VSEL_R,

	BD72720_REG_LDO4_ON,
	BD72720_REG_LDO4_MODE,
	BD72720_REG_LDO4_VSEL_DI,
	BD72720_REG_LDO4_VSEL_I,
	BD72720_REG_LDO4_VSEL_S,
	BD72720_REG_LDO4_VSEL_R,

	BD72720_REG_LDO5_ON,
	BD72720_REG_LDO5_MODE,
	BD72720_REG_LDO5_VSEL,

	BD72720_REG_LDO6_ON,
	BD72720_REG_LDO6_MODE,
	BD72720_REG_LDO6_VSEL,

	BD72720_REG_LDO7_ON,
	BD72720_REG_LDO7_MODE,
	BD72720_REG_LDO7_VSEL,

	BD72720_REG_LDO8_ON,
	BD72720_REG_LDO8_MODE,
	BD72720_REG_LDO8_VSEL,

	BD72720_REG_LDO9_ON,
	BD72720_REG_LDO9_MODE,
	BD72720_REG_LDO9_VSEL,

	BD72720_REG_LDO10_ON,
	BD72720_REG_LDO10_MODE,
	BD72720_REG_LDO10_VSEL,

	BD72720_REG_LDO11_ON,
	BD72720_REG_LDO11_MODE,
	BD72720_REG_LDO11_VSEL,

	BD72720_REG_GPIO1_ON		= 0x8b,
	BD72720_REG_GPIO2_ON,
	BD72720_REG_GPIO3_ON,
	BD72720_REG_GPIO4_ON,
	BD72720_REG_GPIO5_ON,

	BD72720_REG_GPIO1_CTRL,
	BD72720_REG_GPIO2_CTRL,
#define BD72720_GPIO_IRQ_TYPE_MASK	GENMASK(6, 4)
#define BD72720_GPIO_IRQ_TYPE_FALLING	0x0
#define BD72720_GPIO_IRQ_TYPE_RISING	0x1
#define BD72720_GPIO_IRQ_TYPE_BOTH	0x2
#define BD72720_GPIO_IRQ_TYPE_HIGH	0x3
#define BD72720_GPIO_IRQ_TYPE_LOW	0x4
	BD72720_REG_GPIO3_CTRL,
	BD72720_REG_GPIO4_CTRL,
	BD72720_REG_GPIO5_CTRL,
#define BD72720_GPIO_DRIVE_MASK		BIT(1)
#define BD72720_GPIO_HIGH		BIT(0)

	BD72720_REG_EPDEN_CTRL,
	BD72720_REG_GATECNT_CTRL,
	BD72720_REG_LED_CTRL,

	BD72720_REG_PWRON_CFG1,
	BD72720_REG_PWRON_CFG2,

	BD72720_REG_OUT32K,
	BD72720_REG_CONF,
	BD72720_REG_HALL_STAT,

	BD72720_REG_RTC_SEC		= 0xa0,
#define BD72720_REG_RTC_START		BD72720_REG_RTC_SEC
	BD72720_REG_RTC_MIN,
	BD72720_REG_RTC_HOUR,
	BD72720_REG_RTC_WEEK,
	BD72720_REG_RTC_DAY,
	BD72720_REG_RTC_MON,
	BD72720_REG_RTC_YEAR,

	BD72720_REG_RTC_ALM0_SEC,
#define BD72720_REG_RTC_ALM_START	BD72720_REG_RTC_ALM0_SEC
	BD72720_REG_RTC_ALM0_MIN,
	BD72720_REG_RTC_ALM0_HOUR,
	BD72720_REG_RTC_ALM0_WEEK,
	BD72720_REG_RTC_ALM0_MON,
	BD72720_REG_RTC_ALM0_YEAR,

	BD72720_REG_RTC_ALM1_SEC,
	BD72720_REG_RTC_ALM1_MIN,
	BD72720_REG_RTC_ALM1_HOUR,
	BD72720_REG_RTC_ALM1_WEEK,
	BD72720_REG_RTC_ALM1_MON,
	BD72720_REG_RTC_ALM1_YEAR,

	BD72720_REG_RTC_ALM0_EN,
	BD72720_REG_RTC_ALM1_EN,
	BD72720_REG_RTC_ALM2,

	BD72720_REG_INT_LVL1_EN		= 0xc0,
#define BD72720_MASK_LVL1_EN_ALL	GENMASK(7, 0)
	BD72720_REG_INT_PS1_EN,
	BD72720_REG_INT_PS2_EN,
	BD72720_REG_INT_DVS1_EN,
	BD72720_REG_INT_DVS2_EN,
	BD72720_REG_INT_VBUS_EN,
	BD72720_REG_INT_VSYS_EN,
	BD72720_REG_INT_CHG_EN,
	BD72720_REG_INT_BAT1_EN,
	BD72720_REG_INT_BAT2_EN,
	BD72720_REG_INT_IBAT_EN,
	BD72720_REG_INT_ETC1_EN,
	BD72720_REG_INT_ETC2_EN,

	/*
	 * The _STAT registers inform IRQ line state, and are used to ack IRQ.
	 * The _SRC registers below indicate current state of the function
	 * connected to the line.
	 */
	BD72720_REG_INT_LVL1_STAT,
	BD72720_REG_INT_PS1_STAT,
	BD72720_REG_INT_PS2_STAT,
	BD72720_REG_INT_DVS1_STAT,
	BD72720_REG_INT_DVS2_STAT,
	BD72720_REG_INT_VBUS_STAT,
	BD72720_REG_INT_VSYS_STAT,
	BD72720_REG_INT_CHG_STAT,
	BD72720_REG_INT_BAT1_STAT,
	BD72720_REG_INT_BAT2_STAT,
	BD72720_REG_INT_IBAT_STAT,
	BD72720_REG_INT_ETC1_STAT,
	BD72720_REG_INT_ETC2_STAT,

	BD72720_REG_INT_LVL1_SRC,
	BD72720_REG_INT_PS1_SRC,
	BD72720_REG_INT_PS2_SRC,
	BD72720_REG_INT_DVS1_SRC,
	BD72720_REG_INT_DVS2_SRC,
	BD72720_REG_INT_VBUS_SRC,
#define BD72720_MASK_DCIN_DET	BIT(1)
	BD72720_REG_INT_VSYS_SRC,
	BD72720_REG_INT_CHG_SRC,
	BD72720_REG_INT_BAT1_SRC,
	BD72720_REG_INT_BAT2_SRC,
	BD72720_REG_INT_IBAT_SRC,
	BD72720_REG_INT_ETC1_SRC,
	BD72720_REG_INT_ETC2_SRC,
};

/* Register masks */
#define BD72720_MASK_DEEP_IDLE_EN	BIT(0)
#define BD72720_MASK_IDLE_EN		BIT(1)
#define BD72720_MASK_SUSPEND_EN		BIT(2)
#define BD72720_MASK_RUN_B_EN		BIT(3)
#define BD72720_MASK_RUN_0_EN		BIT(4)
#define BD72720_MASK_RUN_1_EN		BIT(5)
#define BD72720_MASK_RUN_2_EN		BIT(6)
#define BD72720_MASK_RUN_3_EN		BIT(7)

#define BD72720_MASK_RAMP_UP_DELAY	GENMASK(7, 6)
#define BD72720_MASK_BUCK_VSEL		GENMASK(7, 0)
#define BD72720_MASK_LDO12346_VSEL	GENMASK(6, 0)
#define BD72720_MASK_LDO_VSEL		GENMASK(7, 0)

#define BD72720_I2C4C_ADDR_OFFSET	0x100

/* Registers behind I2C slave 0x4c */
enum {
	BD72720_REG_CHG_STATE = BD72720_I2C4C_ADDR_OFFSET,
	BD72720_REG_CHG_LAST_STATE,
	BD72720_REG_CHG_VBUS_STAT,
	BD72720_REG_CHG_VSYS_STAT,
	BD72720_REG_CHG_BAT_TEMP_STAT,
	BD72720_REG_CHG_WDT_STAT,
	BD72720_REG_CHG_ILIM_STAT,
	BD72720_REG_CHG_CHG_STAT,
	BD72720_REG_CHG_EN,
	BD72720_REG_CHG_INIT,
	BD72720_REG_CHG_CTRL,
	BD72720_REG_CHG_SET_1,
	BD72720_REG_CHG_SET_2,
	BD72720_REG_CHG_SET_3,
	BD72720_REG_CHG_VPRE,
	BD72720_REG_CHG_VBAT_1,
	BD72720_REG_CHG_VBAT_2,
	BD72720_REG_CHG_VBAT_3,
	BD72720_REG_CHG_VBAT_4,
	BD72720_REG_CHG_BAT_SET_1,
	BD72720_REG_CHG_BAT_SET_2,
	BD72720_REG_CHG_BAT_SET_3,
	BD72720_REG_CHG_IPRE,
	BD72720_REG_CHG_IFST_TERM,
	BD72720_REG_CHG_VSYS_REG,
	BD72720_REG_CHG_VBUS_SET,
	BD72720_REG_CHG_WDT_PRE,
	BD72720_REG_CHG_WDT_FST,
	BD72720_REG_CHG_LED_CTRL,
	BD72720_REG_CHG_CFG_1,
	BD72720_REG_CHG_IFST_1,
	BD72720_REG_CHG_IFST_2,
	BD72720_REG_CHG_IFST_3,
	BD72720_REG_CHG_IFST_4,
	BD72720_REG_CHG_S_CFG_1,
	BD72720_REG_CHG_S_CFG_2,
	BD72720_REG_RS_VBUS,
	BD72720_REG_RS_IBUS,
	BD72720_REG_RS_VSYS,
	BD72720_REG_VSYS_STATE_STAT,	/* 0x27 + offset*/

	BD72720_REG_VM_VBAT_U		= BD72720_I2C4C_ADDR_OFFSET + 0x30,
	BD72720_REG_VM_VBAT_L,
	BD72720_REG_VM_OCV_PRE_U,
	BD72720_REG_VM_OCV_PRE_L,
	BD72720_REG_VM_OCV_PST_U,
	BD72720_REG_VM_OCV_PST_L,
	BD72720_REG_VM_OCV_PWRON_U,
	BD72720_REG_VM_OCV_PWRON_L,
	BD72720_REG_VM_DVBAT_IMP_U,
	BD72720_REG_VM_DVBAT_IMP_L,
	BD72720_REG_VM_SA_VBAT_U,
	BD72720_REG_VM_SA_VBAT_L,
	BD72720_REG_VM_SA_VBAT_MIN_U,
	BD72720_REG_VM_SA_VBAT_MIN_L,
	BD72720_REG_VM_SA_VBAT_MAX_U,
	BD72720_REG_VM_SA_VBAT_MAX_L,
	BD72720_REG_REX_SA_VBAT_U,
	BD72720_REG_REX_SA_VBAT_L,
	BD72720_REG_VM_VSYS_U,
	BD72720_REG_VM_VSYS_L,
	BD72720_REG_VM_SA_VSYS_U,
	BD72720_REG_VM_SA_VSYS_L,
	BD72720_REG_VM_SA_VSYS_MIN_U,
	BD72720_REG_VM_SA_VSYS_MIN_L,
	BD72720_REG_VM_SA_VSYS_MAX_U,
	BD72720_REG_VM_SA_VSYS_MAX_L,
	BD72720_REG_VM_SA2_VSYS_U,
	BD72720_REG_VM_SA2_VSYS_L,
	BD72720_REG_VM_VBUS_U,
#define BD72720_MASK_VDCIN_U	GENMASK(3, 0)
	BD72720_REG_VM_VBUS_L,
	BD72720_REG_VM_BATID_U,
	BD72720_REG_VM_BATID_L,
	BD72720_REG_VM_BATID_NOLOAD_U,
	BD72720_REG_VM_BATID_NOLOAD_L,
	BD72720_REG_VM_BATID_OFS_U,
	BD72720_REG_VM_BATID_OFS_L,
	BD72720_REG_VM_VTH_U,
	BD72720_REG_VM_VTH_L,
	BD72720_REG_VM_VTH_CORR_U,
	BD72720_REG_VM_VTH_CORR_L,
	BD72720_REG_VM_BTMP_U,
	BD72720_REG_VM_BTMP_L,
	BD72720_REG_VM_BTMP_IMP_U,
	BD72720_REG_VM_BTMP_IMP_L,
	BD72720_REG_VM_VF_U,
	BD72720_REG_VM_VF_L,
	BD72720_REG_VM_BATID_TH_U,
	BD72720_REG_VM_BATID_TH_L,
	BD72720_REG_VM_BTMP_OV_THR,
	BD72720_REG_VM_BTMP_OV_DUR,
	BD72720_REG_VM_BTMP_LO_THR,
	BD72720_REG_VM_BTMP_LO_DUR,
	BD72720_REG_ALM_VBAT_TH_U,
	BD72720_REG_ALM_VBAT_TH_L,
	BD72720_REG_ALM_VSYS_TH,
	BD72720_REG_ALM_VBUS_TH,
	BD72720_REG_ALM_VF_TH,
	BD72720_REG_VSYS_MAX,
	BD72720_REG_VSYS_MIN,
	BD72720_REG_VM_VSYS_SA_MINMAX_CTRL,
	BD72720_REG_VM_SA_CFG,		/* 0x6c + offset*/

	BD72720_REG_CC_CURCD_U		= BD72720_I2C4C_ADDR_OFFSET + 0x70,
	BD72720_REG_CC_CURCD_L,
	BD72720_REG_CC_CURCD_IMP_U,
	BD72720_REG_CC_CURCD_IMP_L,
	BD72720_REG_CC_SA_CURCD_U,
	BD72720_REG_CC_SA_CURCD_L,
	BD72720_REG_CC_OCUR_MON,
	BD72720_REG_CC_CCNTD_3,
	BD72720_REG_CC_CCNTD_2,
	BD72720_REG_CC_CCNTD_1,
	BD72720_REG_CC_CCNTD_0,
	BD72720_REG_REX_CCNTD_3,
	BD72720_REG_REX_CCNTD_2,
	BD72720_REG_REX_CCNTD_1,
	BD72720_REG_REX_CCNTD_0,
	BD72720_REG_FULL_CCNTD_3,
	BD72720_REG_FULL_CCNTD_2,
	BD72720_REG_FULL_CCNTD_1,
	BD72720_REG_FULL_CCNTD_0,
	BD72720_REG_CCNTD_CHG_3,
	BD72720_REG_CCNTD_CHG_2,
	BD72720_REG_CC_STAT,
	BD72720_REG_CC_CTRL,
	BD72720_REG_CC_OCUR_THR_1,
	BD72720_REG_CC_OCUR_THR_2,
	BD72720_REG_CC_OCUR_THR_3,
	BD72720_REG_REX_CURCD_TH,
	BD72720_REG_CC_BATCAP1_TH_U,
	BD72720_REG_CC_BATCAP1_TH_L,
	BD72720_REG_CC_BATCAP2_TH_U,
	BD72720_REG_CC_BATCAP2_TH_L,
	BD72720_REG_CC_BATCAP3_TH_U,
	BD72720_REG_CC_BATCAP3_TH_L,
	BD72720_REG_CC_CCNTD_CTRL,
	BD72720_REG_CC_SA_CFG,		/* 0x92 + offset*/
	BD72720_REG_IMPCHK_CTRL		= BD72720_I2C4C_ADDR_OFFSET + 0xa0,
};

#endif /* __LINUX_MFD_BD72720_H */
