#------------------------------------------------------------------------------
# This SPEC file controls the building of custom CrossOver RPM packages.
#
#------------------------------------------------------------------------------


#------------------------------------------------------------------------------
#   Options (see /usr/lib/rpm/macros for documentation)
#------------------------------------------------------------------------------

# Hardcode the compression algorithm to garantee compatibility with RHEL 6+.
# This way we produce backwards compatible packages on systems which use newer
# defaults.
# Check with: rpm -qp --queryformat '%{PAYLOADCOMPRESSOR}\n' xxx.rpm
%define _binary_payload              w7T16.xzdio

# Hardcode the file digest algorithm to MD5 (1) which is the historical
# default. This way we produce backwards compatible packages on systems
# which use newer defaults.
%define _binary_filedigest_algorithm 1


#------------------------------------------------------------------------------
#   Prologue information
#------------------------------------------------------------------------------
Summary         : Run Windows productivity and utility apps like Microsoft Office and games
License         : Proprietary; includes substantial Free Software components.
Name            : @rpm_package@
Version         : 22.1.1
Release         : @release@
# Help upgrades from the 32-bit package to the 64-bit one
Obsoletes       : crossover < 21.0
Provides        : @product_id@5
Group           : Applications/Emulators
ExclusiveArch   : x86_64

BuildRoot	: @buildroot@
Url             : http://www.codeweavers.com
Packager        : CrossOver Packager <info@codeweavers.com>

# The prefix is pretty important; RPM uses this to figure out
# how to make a package relocatable
Prefix          : /opt


#------------------------------------------------------------------------------
#   Generate our own dependency information
#------------------------------------------------------------------------------
Autoreqprov     : No

# For our scripts and GUI.
# Note that we need more Python 3 packages for the GUI but there is no common
# ground between Fedora and openSUSE :-(
Requires        : /bin/sh, /usr/bin/perl, /usr/bin/python3

# For verifying license files
Requires        : /usr/bin/openssl

# Support for 32-bit binaries
Requires        : ld-linux.so.2

# The C library
Requires        : libc.so.6, libc.so.6(GLIBC_2.16), libdl.so.2, libm.so.6

# The gcc support library
Requires        : libgcc_s.so.1

# X11 support for Wine and cxsetup
Requires        : libX11.so.6, libXext.so.6

# Joystick, tablet support and more (winex11.drv/wintab32).
Requires        : libXi.so.6

# Support for TrueType fonts
Requires        : libfreetype.so.6

# Needed for msxml3.dll and wldap32.dll
Requires        : libz.so.1

Requires        : libcups.so.2

# We really need libpng too but cannot depend on it due to the many versions
# out there. Fortunately:
# - It is loaded dynamically and we try the different versions.
# - cups-libs also depends on it which ensures we'll have a 32-bit
#   library to load on 64-bit systems... except on Fedora 19.

# Require some extra libraries that are pretty important for games:
# - OpenGL needed for Direct3D and OpenGL.
# - XRandR otherwise most games won't run correctly in fullscreen or have
#   mouse issues.
Requires        : libGL.so.1, libXrandr.so.2

# Needed by many games for their color cursors.
Requires        : libXcursor.so.1

# On Fedora 27 and earlier libc provides libnsl,
# but on Fedora 28 it no longer does
Requires        : libnsl.so.1



#------------------------------------------------------------------------------
#   Description
#------------------------------------------------------------------------------
%Description
CrossOver integrates with your desktop environment so you can use your
Windows applications like any other native application. This includes starting
them from the desktop and using them to open Windows files and email
attachments. If an anti-virus scanner is available, CrossOver will also
automatically scan these to protect you.

Thanks to CrossTies, CrossOver takes the guesswork out of installing
applications referenced in its compatibility database. This makes it easy to
install Windows productivity applications such as Microsoft Office and
Quicken. CrossOver also takes care of installing any native packages that
may be required to run them.

This also applies to games such as Diablo III, Minecraft Dungeons and modern
Direct3D 11 and 12 games when it's time to relax.


#------------------------------------------------------------------------------
#   Files listing
#------------------------------------------------------------------------------
%files
%defattr(-,root,root)

%docdir            @cx_root@/doc

@dir_list@
@file_list@


%clean
# Override the default clean rule: don't delete anything


%pre
#------------------------------------------------------------------------------
#   Pre install script
#------------------------------------------------------------------------------
set -e

# Setup logging
if [ -n "$CX_LOG" ]
then
    [ "$CX_LOG" = "-" ] || exec 2>>"$CX_LOG"
    echo >&2
    echo "***** `date`" >&2
    echo "Starting: $0 $@" >&2
    set -x
fi

if [ -z "$RPM_INSTALL_PREFIX" ]
then
    RPM_INSTALL_PREFIX=/opt
fi
CX_ROOT="$RPM_INSTALL_PREFIX/@product_id@"
export CX_ROOT

cxgettext()
{
    if [ -x "$CX_ROOT/bin/cxgettext" ] && "$CX_ROOT/bin/cxgettext" "$@"
    then
       return
    fi
    echo "$@"
}

# Keep the check for Loki's .manifest directory to handle upgrades from
# pre-10.0 versions.
if [ -d "$CX_ROOT/.manifest" -o -d "$CX_ROOT/.mojosetup" ]
then
    if [ -n "$DISPLAY" ]
    then
        cxmessage="$CX_ROOT/bin/cxmessage"
        if [ ! -f "$cxmessage" -o ! -x "$cxmessage" ]
        then
            cxmessage="xmessage"
        fi
        "$cxmessage" \
            -title "Unable to install" \
            -buttons "Abort" \
            -default "Abort" \
            "This RPM package cannot be installed on top of a Loki or MojoSetup package." &
    fi
    echo "This CrossOver RPM package cannot be installed on top of a Loki or MojoSetup package." >&2
    exit 1
fi

# If this package is replacing a different package (e.g. a regular package
# replacing a demo), then "$1" will still be 1! So to correctly handle this
# case we need to check if another package provides @product_id@5 already.
# A further issue is that with some rpm versions, the "no package provides
# xxx" message may be printed to stdout so that 'wc -w' may return either 0
# or more than 1.
# Furthermore we still have to check "$1" to handle upgrades from very old
# packages that don't provide @product_id@5.
packages=`rpm -q --whatprovides @product_id@5 2>/dev/null | wc -w`
if [ "$1" != "1" -o "$packages" -eq 1 ]
then
    mode="upgrade"
else
    mode="install"
fi

if [ "$mode" = "install" ]
then
    if [ -z "$CX_PRODUCT_ID" ]
    then
        CX_PRODUCT_ID="cxoffice"
    fi
elif [ -f "$CX_ROOT/.productid" ]
then
    CX_PRODUCT_ID=`cat "$CX_ROOT/.productid"`
else
    CX_PRODUCT_ID="cxoffice"
fi
productid="$CX_PRODUCT_ID"


# This script expects CX_ROOT, productid and mode to be set

# Validate the productid
echo "$productid" | LC_ALL=C egrep '^[a-zA-Z0-9_][a-zA-Z0-9_][a-zA-Z0-9_][a-zA-Z0-9_][a-zA-Z0-9_]*$' >/dev/null
if [ $? -ne 0 ]
then
    echo "The product id '$productid' is not valid" >&2
    exit 1
fi

if [ "$mode" = "upgrade" ]
then
    if [ -f "$CX_ROOT/.productid" ]
    then
        old_productid=`cat "$CX_ROOT/.productid"`
    else
        old_productid="cxoffice"
    fi
    if [ "$productid" != "$old_productid" ]
    then
        echo "An upgrade cannot change the product id" >&2
        exit 1
    fi
fi

# Remove generated files that old packages incorrectly leave around
rm -f "$CX_ROOT"/support/icons/*.png


# RPM only deletes this file after the postinstall script is run!
rm -f "$CX_ROOT/lib/nptl"/libwine.so*


%post
#------------------------------------------------------------------------------
#   Post install script
#------------------------------------------------------------------------------
set -e

# Setup logging
if [ -n "$CX_LOG" ]
then
    [ "$CX_LOG" = "-" ] || exec 2>>"$CX_LOG"
    echo >&2
    echo "***** `date`" >&2
    echo "Starting: $0 $@" >&2
    set -x
fi

if [ -z "$RPM_INSTALL_PREFIX" ]
then
    RPM_INSTALL_PREFIX=/opt
fi
CX_ROOT="$RPM_INSTALL_PREFIX/@product_id@"
export CX_ROOT
package="rpm:@rpm_package@"

# See the %pre comment.
# Note that in this script we know that at least one package provides
# @product_id@5.
packages=`rpm -q --whatprovides @product_id@5 2>/dev/null | wc -w`
if [ "$1" != "1" -o "$packages" -gt 1 ]
then
    mode="upgrade"
else
    mode="install"
fi
oldver=""

if [ "$mode" = "install" ]
then
    if [ -z "$CX_PRODUCT_ID" ]
    then
        CX_PRODUCT_ID="@product_id@"
    fi
elif [ -f "$CX_ROOT/.productid" ]
then
    CX_PRODUCT_ID=`cat "$CX_ROOT/.productid"`
else
    CX_PRODUCT_ID="@product_id@"
fi
productid="$CX_PRODUCT_ID"

# This script expects package, CX_ROOT, productid, mode and oldver to be set


builtin_product_id="cxoffice"
if [ "$mode" = "install" ]
then
    if [ "$productid" != "$builtin_product_id" ]
    then
        echo "$productid" >"$CX_ROOT/.productid"
    else
        rm -f "$CX_ROOT/.productid"
    fi
fi

uid=`perl -e 'print $>'`

unset HOME

# These files are no longer needed (were used by version 4.x)
if [ "$uid" = "0" -a -f "/sbin/conf.d/SuSEconfig.zz$productid-vfolders" ]
then
    rm -f "/sbin/conf.d/SuSEconfig.zz$productid-vfolders"
fi
rm -f "$CX_ROOT/lib/xml/libperl.so.5.8"

# Icons have moved to share/icons
rm -f "$CX_ROOT"/support/*.png

# We don't need the 2007 DST bottle hook anymore
rm -f "$CX_ROOT"/support/scripts.d/??.dst2007patch
rmdir "$CX_ROOT"/support/scripts.d 2>/dev/null || true

# Try to set up the security context if possible (especially for Fedora).
# Do so before potentially trying to upgrade bottles.
setup_selinux()
{
    # Note that this may or may not work depending on obscure system settings.
    # So try chcon on the landmark file and don't abort if that fails.
    if chcon system_u:object_r:bin_t:s0 "$CX_ROOT"/bin/cxmenu
    then
        ( cd "$CX_ROOT"/bin && find * -type d -prune -o -type f \
            -exec chcon system_u:object_r:bin_t:s0 {} \; )
        ( cd "$CX_ROOT"/lib && find * -type d -prune -o -type f \
            -exec chcon system_u:object_r:lib_t:s0 {} \; )
        if chcon system_u:object_r:wine_exec_t:s0 "$CX_ROOT"/bin/wine-preloader
        then
            chcon system_u:object_r:wine_exec_t:s0 "$CX_ROOT"/bin/wineloader
        fi
        if chcon system_u:object_r:textrel_shlib_t:s0 "$CX_ROOT"/lib/wine/ntdll.dll.so
        then
            setype="textrel_shlib_t"
        else
            setype="lib_t"
        fi
        ( cd "$CX_ROOT"/lib/wine && find * -type d -prune -o -type f \
            -exec chcon system_u:object_r:$setype:s0 {} \; )
    fi
}
if [ -z "$CX_LOG" ]
then
    setup_selinux 2>/dev/null
else
    setup_selinux
fi


# Update wineserver symlink as appropriate
if [ -L "$CX_ROOT/bin/wineserver" ]
then
    rm "$CX_ROOT/bin/wineserver"
    if "$CX_ROOT/bin/wineserver64" -v >/dev/null 2>/dev/null
    then
        ln -s wineserver64 "$CX_ROOT/bin/wineserver"
    else
        ln -s wineserver32 "$CX_ROOT/bin/wineserver"
    fi
fi


# Create or upgrade the configuration file and more
if [ -f "$CX_ROOT/.uninstalled" ]
then
    rm -f "$CX_ROOT/.uninstalled"
    install_bottles="--install-bottles"
else
    install_bottles=""
fi
"$CX_ROOT/lib/cxupgrade" --package "$package" --productid "$productid" --old-version "$oldver" $install_bottles
"$CX_ROOT/bin/cxtie" --register

if [ "$mode" = "install" -a "$uid" = "0" ]
then
    chmod 0644 "$CX_ROOT/etc/$productid.conf"
fi

exit 0


%preun
#------------------------------------------------------------------------------
#   Pre uninstallation script
#------------------------------------------------------------------------------
set -e

# Setup logging
if [ -n "$CX_LOG" ]
then
    [ "$CX_LOG" = "-" ] || exec 2>>"$CX_LOG"
    echo >&2
    echo "***** `date`" >&2
    echo "Starting: $0 $@" >&2
    set -x
fi

# See the %pre comment.
# Note that in this script we know that at least one package still provides
# @product_id@5.
packages=`rpm -q --whatprovides @product_id@5 2>/dev/null | wc -w`
if [ "$1" != "0" -o "$packages" -gt 1 ]
then
    # This package is being upgraded or replaced by another
    exit 0
fi

if [ -z "$RPM_INSTALL_PREFIX" ]
then
    RPM_INSTALL_PREFIX=/opt
fi
CX_ROOT="$RPM_INSTALL_PREFIX/@product_id@"
export CX_ROOT

if [ -f "$CX_ROOT/.productid" ]
then
    productid=`cat "$CX_ROOT/.productid"`
else
    productid="@product_id@"
fi

[ -n "$CX_PURGE" ] || CX_PURGE="desktopdata"
export CX_PURGE


# This script expects CX_ROOT and productid to be set
# Note: this script may also be called in case the installation is aborted
builtin_product_id="cxoffice"

if [ -z "$CX_PURGE" ]
then
    CX_PURGE="all"
fi

if [ "$CX_PURGE" = "desktopdata" -o "$CX_PURGE" = "all" ]
then
    "$CX_ROOT/bin/cxtie" --unregister
    scope="managed"
    if [ -x "$CX_ROOT/bin/cxmenu" ]
    then
        "$CX_ROOT/bin/cxmenu" --removeall --pattern "$productid-" --scope $scope --ignorelist ""
    fi
    if [ -x "$CX_ROOT/bin/cxassoc" ]
    then
        "$CX_ROOT/bin/cxassoc" --removeall --pattern "$productid-" --scope $scope --ignorelist ""
    fi
    rm -f "$CX_ROOT"/share/icons/*.png
fi

rm -f "$CX_ROOT/lib/python"/*.pyc
rm -f "$CX_ROOT/lib/wine/winewrapper.exe.so.bak"

# We must delete any file generated at runtime before 'rpm -e'
# tries to delete the installed files and directories.
# This script expects CX_ROOT and productid to be set

if [ -z "$CX_PURGE" ]
then
    CX_PURGE="all"
fi

if [ "$CX_PURGE" = "desktopdata" -o "$CX_PURGE" = "all" ]
then
    rm -rf "$CX_ROOT"/lib/python/__pycache__
    rm -rf "$CX_ROOT"/support/desktopdata
fi

if [ "$CX_PURGE" = "all" ]
then
    rm -f  "$CX_ROOT/etc/$productid".conf*
    rm -f  "$CX_ROOT/etc/license.txt" "$CX_ROOT/etc/license.sig"
    rm -f  "$CX_ROOT"/support/default
    rm -rf "$CX_ROOT"/support/installers
    rm -f  "$CX_ROOT"/.uninstalled

    # Delete bottles.
    ls -d "$CX_ROOT"/support/*/cxbottle.conf 2>/dev/null | while read bottlefile
    do
        dir=`dirname "$bottlefile"`
        rm -rf "$dir"
    done

    rmdir "$CX_ROOT"/support 2>/dev/null || true
    rm -f  "$CX_ROOT/.productid"
elif [ -d "$CX_ROOT" ]
then
    touch "$CX_ROOT/.uninstalled"
fi

exit 0


%postun
#------------------------------------------------------------------------------
#   Post uninstallation script
#------------------------------------------------------------------------------
