# (c) Copyright 2009. CodeWeavers, Inc.

import re

import globtree
import cxlog
import cxobjc
import cxproduct


class CDDetector(cxobjc.Proxy):
    pass


@cxobjc.method(CDDetector, 'findMatchingProfilesForVolume_inProfiles_')
def get_cd_profiles(root_path, profiles):
    show_untested_apps = cxproduct.get_config_boolean('OfficeSetup', 'ShowUntestedApps', True)
    product_profiles = profiles.copy()
    for profile in profiles:
        if not profiles[profile].is_for_current_product \
           or (not profiles[profile].is_ranked and not show_untested_apps):
            product_profiles.pop(profile)

    return get_cd_profiles_for_all_products(root_path, product_profiles)


def get_cd_profiles_for_all_products(root_path, profiles):
    # Cache the FileGlobTree object
    if 'CDFileGlobTree' not in profiles.userdata:
        cd_glob = globtree.FileContentGlobTree()
        for profile in profiles.values():
            if profile.cd_profile:
                for glob in profile.cd_profile.globs:
                    if glob.patterns and glob.patterns != [""]:
                        patterns = glob.patterns
                    else:
                        patterns = ()
                    try:
                        cd_glob.add_content_glob(glob.glob, patterns, profile)
                    except re.error:
                        cxlog.warn("the %s cd glob contains an invalid regular expression" % cxlog.debug_str(profile.appid))

        profiles.userdata.setdefault('CDFileGlobTree', cd_glob)
    cd_glob = profiles.userdata['CDFileGlobTree']

    # globtree requires that the root path ends in / or is ''
    if not root_path.endswith('/'):
        root_path = '%s/' % root_path

    # Search the CD
    result = {}
    for _path, profile in cd_glob.matches(root_path):
        if profile.appid in result:
            continue
        result[profile.appid] = profile

    return result
