/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.codeFragment;

import com.intellij.codeInsight.codeFragment.CodeFragment;
import com.intellij.openapi.util.Pair;
import com.jetbrains.python.psi.types.PyType;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;

@NotNullByDefault
public class PyCodeFragment
extends CodeFragment {
    private final Map<String, Pair<String, PyType>> myInputTypes;
    @Nullable
    private final String myOutputType;
    private final Set<PyType> myOutputTypes;
    private final Set<String> myGlobalWrites;
    private final Set<String> myNonlocalWrites;
    private final boolean myYieldInside;
    private final boolean myAsync;

    public PyCodeFragment(Set<String> input, Set<String> output, Map<String, Pair<String, PyType>> inputTypeNames, @Nullable String outputType, Set<PyType> outputTypes, Set<String> globalWrites, Set<String> nonlocalWrites, boolean returnInside, boolean yieldInside, boolean isAsync) {
        super(input, output, returnInside);
        this.myInputTypes = inputTypeNames;
        this.myOutputType = outputType;
        this.myOutputTypes = outputTypes;
        this.myGlobalWrites = globalWrites;
        this.myNonlocalWrites = nonlocalWrites;
        this.myYieldInside = yieldInside;
        this.myAsync = isAsync;
    }

    @Nullable
    public String getInputTypeName(String varName) {
        Pair<String, PyType> type = this.myInputTypes.get(varName);
        return type == null ? null : (String)type.first;
    }

    @Nullable
    public PyType getInputType(String varName) {
        Pair<String, PyType> type = this.myInputTypes.get(varName);
        return type == null ? null : (PyType)type.second;
    }

    @Nullable
    public String getOutputType() {
        return this.myOutputType;
    }

    public Set<PyType> getOutputTypes() {
        return this.myOutputTypes;
    }

    public Set<String> getGlobalWrites() {
        return this.myGlobalWrites;
    }

    public Set<String> getNonlocalWrites() {
        return this.myNonlocalWrites;
    }

    public boolean isYieldInside() {
        return this.myYieldInside;
    }

    public boolean isAsync() {
        return this.myAsync;
    }
}

