/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text.minimatch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.minimatch.DefaultPathAdapter;
import com.intellij.util.text.minimatch.GlobStar;
import com.intellij.util.text.minimatch.LiteralItem;
import com.intellij.util.text.minimatch.MagicItem;
import com.intellij.util.text.minimatch.MinimatchKt;
import com.intellij.util.text.minimatch.MinimatchOptions;
import com.intellij.util.text.minimatch.ParseContext;
import com.intellij.util.text.minimatch.ParseItem;
import com.intellij.util.text.minimatch.ParseResult;
import com.intellij.util.text.minimatch.PathAdapter;
import com.intellij.util.text.minimatch.PatternListItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0011H\u0002J\u001c\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00170\u0011H\u0002JG\u0010\u0016\u001a.\u0012*\u0012(\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003 \u0018*\u0014\u0012\u000e\b\u0001\u0012\n \u0018*\u0004\u0018\u00010\u00030\u0003\u0018\u00010\u00170\u00170\u00112\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u000bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J#\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\"J\u001b\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010$J\u001e\u0010%\u001a\u00020\u000b2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150\u00112\b\b\u0002\u0010'\u001a\u00020\u000bJ,\u0010(\u001a\u00020\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00150\u00112\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010'\u001a\u00020\u000bH\u0002J\u001a\u0010%\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00032\b\b\u0002\u0010'\u001a\u00020\u000bH\u0007J3\u0010%\u001a\u00020\u000b\"\u0004\b\u0000\u0010+2\u0006\u0010*\u001a\u0002H+2\f\u0010,\u001a\b\u0012\u0004\u0012\u0002H+0-2\b\b\u0002\u0010'\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010.J\u0013\u0010/\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00101\u001a\u000202H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/util/text/minimatch/Minimatch;", "", "pattern", "", "options", "Lcom/intellij/util/text/minimatch/MinimatchOptions;", "<init>", "(Ljava/lang/String;Lcom/intellij/util/text/minimatch/MinimatchOptions;)V", "getOptions", "()Lcom/intellij/util/text/minimatch/MinimatchOptions;", "comment", "", "empty", "negate", "getNegate", "()Z", "set", "", "Lcom/intellij/util/text/minimatch/ParseItem;", "make", "toString", "", "globParts", "", "kotlin.jvm.PlatformType", "([Ljava/lang/String;)Ljava/util/List;", "parse", "Lcom/intellij/util/text/minimatch/ParseResult;", "isSub", "clearStateChar", "", "ctx", "Lcom/intellij/util/text/minimatch/ParseContext;", "braceExpand", "(Ljava/lang/String;Lcom/intellij/util/text/minimatch/MinimatchOptions;)[Ljava/lang/String;", "expand", "(Ljava/lang/String;)[Ljava/lang/String;", "match", "path", "partial", "matchOne", "file", "input", "T", "adapter", "Lcom/intellij/util/text/minimatch/PathAdapter;", "(Ljava/lang/Object;Lcom/intellij/util/text/minimatch/PathAdapter;Z)Z", "equals", "other", "hashCode", "", "intellij.platform.util"})
@SourceDebugExtension(value={"SMAP\nMinimatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Minimatch.kt\ncom/intellij/util/text/minimatch/Minimatch\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 util.kt\ncom/intellij/util/containers/UtilKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,782:1\n60#2,5:783\n60#2,5:788\n60#2,5:811\n60#2,5:823\n60#2,5:828\n60#2,5:833\n60#2,5:838\n60#2,5:843\n60#2,5:859\n60#2,5:864\n60#2,5:869\n60#2,5:874\n60#2,5:879\n60#2,5:884\n60#2,5:889\n60#2,5:894\n60#2,5:899\n60#2,5:904\n60#2,5:909\n60#2,5:914\n60#2,5:919\n60#2,5:924\n264#3,2:793\n247#3,4:795\n266#3,2:802\n247#3,4:806\n247#3,4:816\n11896#4,3:799\n11896#4,3:820\n1634#5,2:804\n1636#5:810\n739#5,9:848\n37#6,2:857\n*S KotlinDebug\n*F\n+ 1 Minimatch.kt\ncom/intellij/util/text/minimatch/Minimatch\n*L\n94#1:783,5\n99#1:788,5\n103#1:811,5\n164#1:823,5\n187#1:828,5\n201#1:833,5\n227#1:838,5\n391#1:843,5\n488#1:859,5\n504#1:864,5\n541#1:869,5\n542#1:874,5\n552#1:879,5\n555#1:884,5\n602#1:889,5\n606#1:894,5\n616#1:899,5\n632#1:904,5\n644#1:909,5\n647#1:914,5\n691#1:919,5\n702#1:924,5\n102#1:793,2\n102#1:795,4\n102#1:802,2\n102#1:806,4\n121#1:816,4\n102#1:799,3\n121#1:820,3\n102#1:804,2\n102#1:810\n434#1:848,9\n434#1:857,2\n*E\n"})
public final class Minimatch {
    @NotNull
    private final MinimatchOptions options;
    private final boolean comment;
    private final boolean empty;
    private final boolean negate;
    @NotNull
    private final List<List<ParseItem>> set;
    @NotNull
    private final String pattern;

    @JvmOverloads
    public Minimatch(@NotNull String pattern, @NotNull MinimatchOptions options) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        Intrinsics.checkNotNullParameter(options, "options");
        this.options = options;
        String normalizedPattern = this.options.getAllowWindowsPaths() ? MinimatchKt.replaceEscapedBackSlash(pattern) : pattern;
        boolean bl = this.comment = !this.options.getNocomment() && StringsKt.startsWith$default((CharSequence)normalizedPattern, '#', false, 2, null);
        if (this.comment) {
            this.pattern = normalizedPattern;
            this.set = CollectionsKt.emptyList();
            this.negate = false;
        } else {
            if (this.options.getNonegate()) {
                this.pattern = normalizedPattern;
                this.negate = false;
            } else {
                String string;
                int negateOffset;
                boolean negate = false;
                for (negateOffset = 0; negateOffset < pattern.length() && pattern.charAt(negateOffset) == '!'; ++negateOffset) {
                    negate = !negate;
                }
                this.negate = negate;
                if (negateOffset > 0) {
                    String string2 = pattern.substring(negateOffset);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                } else {
                    string = pattern;
                }
                this.pattern = string;
            }
            this.set = this.make();
        }
    }

    public /* synthetic */ Minimatch(String string, MinimatchOptions minimatchOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            minimatchOptions = new MinimatchOptions(false, false, false, false, false, false, false, false, false, false, 1023, null);
        }
        this(string, minimatchOptions);
    }

    @NotNull
    public final MinimatchOptions getOptions() {
        return this.options;
    }

    public final boolean getNegate() {
        return this.negate;
    }

    /*
     * WARNING - void declaration
     */
    private final List<List<ParseItem>> make() {
        List list;
        Object object;
        Object[] set = this.braceExpand(this.pattern, this.options);
        Logger $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            object = $this$debug_u24default$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append(this.pattern).append(' ');
            String string = Arrays.toString(set);
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            ((Logger)object).debug(stringBuilder.append(string).toString(), e$iv);
        }
        List<String[]> globParts = this.globParts((String[])set);
        Logger $this$debug_u24default$iv2 = MinimatchKt.access$getLOG$p();
        Throwable e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            object = $this$debug_u24default$iv2;
            boolean bl = false;
            ((Logger)object).debug(this.pattern + ' ' + this.toString(globParts), e$iv2);
        }
        Collection $this$mapSmart$iv = globParts;
        boolean $i$f$mapSmart = false;
        int size$iv = $this$mapSmart$iv.size();
        switch (size$iv) {
            case 1: {
                List list2;
                String[] it = (String[])CollectionsKt.first($this$mapSmart$iv);
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                String[] $this$mapSmart$iv2 = it;
                boolean $i$f$mapSmart2 = false;
                int size$iv2 = $this$mapSmart$iv2.length;
                switch (size$iv2) {
                    case 1: {
                        String it2 = $this$mapSmart$iv2[0];
                        boolean bl2 = false;
                        Intrinsics.checkNotNull(it2);
                        ParseItem parseItem = this.parse(it2, false).getItem();
                        list2 = new SmartList<ParseItem>(parseItem);
                        break;
                    }
                    case 0: {
                        list2 = new SmartList();
                        break;
                    }
                    default: {
                        void $this$mapTo$iv$iv;
                        String[] stringArray = $this$mapSmart$iv2;
                        Collection destination$iv$iv2 = new ArrayList(size$iv2);
                        boolean $i$f$mapTo = false;
                        int it2 = ((void)$this$mapTo$iv$iv).length;
                        for (int i = 0; i < it2; ++i) {
                            void it3;
                            void item$iv$iv;
                            void var21_36 = item$iv$iv = $this$mapTo$iv$iv[i];
                            Collection collection = destination$iv$iv2;
                            boolean bl3 = false;
                            Intrinsics.checkNotNull(it3);
                            collection.add(this.parse((String)it3, false).getItem());
                        }
                        list2 = (List)destination$iv$iv2;
                    }
                }
                List list3 = list2;
                list = new SmartList<List>(list3);
                break;
            }
            case 0: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                void $this$mapTo$iv$iv;
                Iterable iterable = $this$mapSmart$iv;
                Collection destination$iv$iv = new ArrayList(size$iv);
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    List list4;
                    void it;
                    String[] bl = (String[])item$iv$iv;
                    object = destination$iv$iv;
                    boolean $i$a$-mapSmart-Minimatch$make$results$2 = false;
                    Intrinsics.checkNotNull(it);
                    void $this$mapSmart$iv3 = it;
                    boolean $i$f$mapSmart3 = false;
                    int size$iv3 = ((void)$this$mapSmart$iv3).length;
                    switch (size$iv3) {
                        case 1: {
                            void it4 = $this$mapSmart$iv3[0];
                            boolean bl4 = false;
                            Intrinsics.checkNotNull(it4);
                            ParseItem parseItem = this.parse((String)it4, false).getItem();
                            list4 = new SmartList<ParseItem>(parseItem);
                            break;
                        }
                        case 0: {
                            list4 = new SmartList();
                            break;
                        }
                        default: {
                            void $this$mapTo$iv$iv2;
                            void destination$iv$iv2 = $this$mapSmart$iv3;
                            Collection destination$iv$iv3 = new ArrayList(size$iv3);
                            boolean $i$f$mapTo2 = false;
                            int n = ((void)$this$mapTo$iv$iv2).length;
                            for (int i = 0; i < n; ++i) {
                                void it5;
                                void item$iv$iv2;
                                void bl3 = item$iv$iv2 = $this$mapTo$iv$iv2[i];
                                Collection collection = destination$iv$iv3;
                                boolean $i$a$-mapSmart-Minimatch$make$results$1$2 = false;
                                Intrinsics.checkNotNull(it5);
                                collection.add(this.parse((String)it5, false).getItem());
                            }
                            list4 = (List)destination$iv$iv3;
                        }
                    }
                    object.add(list4);
                }
                list = (List)destination$iv$iv;
            }
        }
        List results = list;
        Logger $this$debug_u24default$iv3 = MinimatchKt.access$getLOG$p();
        Throwable e$iv3 = null;
        boolean $i$f$debug3 = false;
        if ($this$debug_u24default$iv3.isDebugEnabled()) {
            object = $this$debug_u24default$iv3;
            boolean bl = false;
            ((Logger)object).debug(this.pattern + ' ' + results, e$iv3);
        }
        return results;
    }

    private final CharSequence toString(List<String[]> globParts) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (Object[] objectArray : globParts) {
            String string = Arrays.toString(objectArray);
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            sb.append(string);
            sb.append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String[]> globParts(String[] set) {
        List list;
        String[] $this$mapSmart$iv = set;
        boolean $i$f$mapSmart = false;
        int size$iv = $this$mapSmart$iv.length;
        switch (size$iv) {
            case 1: {
                String it = $this$mapSmart$iv[0];
                boolean bl = false;
                String[] stringArray = MinimatchKt.access$getSlashSplit$p().split(it, Integer.MAX_VALUE);
                list = new SmartList<String[]>(stringArray);
                break;
            }
            case 0: {
                list = new SmartList();
                break;
            }
            default: {
                void $this$mapTo$iv$iv;
                String[] stringArray = $this$mapSmart$iv;
                Collection destination$iv$iv = new ArrayList(size$iv);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var11_14 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(MinimatchKt.access$getSlashSplit$p().split((CharSequence)it, Integer.MAX_VALUE));
                }
                list = (List)destination$iv$iv;
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final ParseResult parse(String pattern, boolean isSub) {
        int n;
        Logger logger;
        if (!this.options.getNoglobstar() && Intrinsics.areEqual("**", pattern)) {
            return new ParseResult(MinimatchKt.access$getGLOBSTAR$p(), false);
        }
        if (((CharSequence)pattern).length() == 0) {
            return new ParseResult(ParseItem.Empty, false);
        }
        ParseContext ctx = new ParseContext();
        ctx.re = "";
        ctx.hasMagic = this.options.getNocase();
        boolean escaping = false;
        Stack patternListStack = new Stack();
        Stack negativeListStack = new Stack();
        char plType = '\u0000';
        boolean inClass = false;
        int reClassStart = -1;
        int classStart = -1;
        String patternStart = pattern.charAt(0) == '.' ? "" : (this.options.getDot() ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)");
        int n2 = ((CharSequence)pattern).length();
        block23: for (int i = 0; i < n2; ++i) {
            char c = '\u0000';
            c = pattern.charAt(i);
            Logger $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug(pattern + '\t' + i + ' ' + ctx.re + " \"" + c + '\"', e$iv);
            }
            if (escaping && StringsKt.contains$default((CharSequence)"().*{}+?[]^$\\!", c, false, 2, null)) {
                ctx.re = ctx.re + '\\' + c;
                escaping = false;
                continue;
            }
            switch (c) {
                case '/': {
                    throw new IllegalStateException();
                }
                case '\\': {
                    this.clearStateChar(ctx);
                    escaping = true;
                    continue block23;
                }
                case '!': 
                case '*': 
                case '+': 
                case '?': 
                case '@': {
                    Logger $this$debug_u24default$iv22 = MinimatchKt.access$getLOG$p();
                    Throwable e$iv2 = null;
                    boolean $i$f$debug2 = false;
                    if ($this$debug_u24default$iv22.isDebugEnabled()) {
                        logger = $this$debug_u24default$iv22;
                        boolean bl = false;
                        logger.debug(pattern + '\t' + i + ' ' + ctx.re + " \"" + c + "\" <-- stateChar", e$iv2);
                    }
                    if (inClass) {
                        MinimatchKt.access$getLOG$p().debug("  in class");
                        if (c == '!' && i == classStart + 1) {
                            c = '^';
                        }
                        ctx.re = ctx.re + c;
                        continue block23;
                    }
                    $this$debug_u24default$iv22 = MinimatchKt.access$getLOG$p();
                    e$iv2 = null;
                    $i$f$debug2 = false;
                    if ($this$debug_u24default$iv22.isDebugEnabled()) {
                        logger = $this$debug_u24default$iv22;
                        boolean bl = false;
                        logger.debug("call clearStateChar \"" + ctx.stateChar + '\"', e$iv2);
                    }
                    this.clearStateChar(ctx);
                    ctx.stateChar = Character.valueOf(c);
                    if (!this.options.getNoext()) continue block23;
                    this.clearStateChar(ctx);
                    continue block23;
                }
                case '(': {
                    if (inClass) {
                        ctx.re = ctx.re + '(';
                        continue block23;
                    }
                    if (ctx.stateChar == null) {
                        ctx.re = ctx.re + "\\(";
                        continue block23;
                    }
                    Character c2 = ctx.stateChar;
                    Intrinsics.checkNotNull(c2);
                    plType = c2.charValue();
                    patternListStack.push((Object)new PatternListItem(plType, i - 1, ctx.re.length(), 0, 8, null));
                    Character c3 = ctx.stateChar;
                    char $this$debug_u24default$iv2 = '!';
                    ctx.re = ctx.re + (c3 != null && c3.charValue() == $this$debug_u24default$iv2 ? "(?:(?!(?:" : "(?:");
                    Logger $this$debug_u24default$iv22 = MinimatchKt.access$getLOG$p();
                    Throwable e$iv3 = null;
                    boolean $i$f$debug2 = false;
                    if ($this$debug_u24default$iv22.isDebugEnabled()) {
                        logger = $this$debug_u24default$iv22;
                        boolean bl = false;
                        logger.debug("plType \"" + ctx.stateChar + "\" \"" + ctx.re + '\"', e$iv3);
                    }
                    ctx.stateChar = null;
                    continue block23;
                }
                case ')': {
                    if (inClass || patternListStack.isEmpty()) {
                        ctx.re = ctx.re + "\\)";
                        continue block23;
                    }
                    this.clearStateChar(ctx);
                    ctx.hasMagic = true;
                    ctx.re = ctx.re + ')';
                    PatternListItem pl = (PatternListItem)patternListStack.pop();
                    plType = pl.getType();
                    switch (plType) {
                        case '!': {
                            negativeListStack.push((Object)pl);
                            ctx.re = ctx.re + ")[^/]*?)";
                            pl.setReEnd(ctx.re.length());
                            break;
                        }
                        case '*': 
                        case '+': 
                        case '?': {
                            ctx.re = ctx.re + plType;
                        }
                    }
                    continue block23;
                }
                case '|': {
                    if (inClass || patternListStack.size() == 0 || escaping) {
                        ctx.re = ctx.re + "\\|";
                        escaping = false;
                        continue block23;
                    }
                    this.clearStateChar(ctx);
                    ctx.re = ctx.re + '|';
                    continue block23;
                }
                case '[': {
                    this.clearStateChar(ctx);
                    if (inClass) {
                        ctx.re = ctx.re + '\\' + c;
                        continue block23;
                    }
                    inClass = true;
                    classStart = i;
                    reClassStart = ctx.re.length();
                    ctx.re = ctx.re + c;
                    continue block23;
                }
                case ']': {
                    if (i == classStart + 1 || !inClass) {
                        ctx.re = ctx.re + '\\' + c;
                        escaping = false;
                        continue block23;
                    }
                    if (inClass) {
                        String cs;
                        Intrinsics.checkNotNullExpressionValue(pattern.substring(classStart + 1, i), "substring(...)");
                        try {
                            Pattern.compile('[' + cs + ']');
                        }
                        catch (Throwable e) {
                            ParseResult sp = this.parse(cs, true);
                            StringBuilder stringBuilder = new StringBuilder();
                            String string = ctx.re.substring(0, reClassStart);
                            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
                            ctx.re = stringBuilder.append(string).append("\\[").append(sp.getItem().getSource()).append("\\]").toString();
                            ctx.hasMagic = ctx.hasMagic || sp.isB();
                            inClass = false;
                            continue block23;
                        }
                    }
                    ctx.hasMagic = true;
                    inClass = false;
                    ctx.re = ctx.re + c;
                    continue block23;
                }
                default: {
                    this.clearStateChar(ctx);
                    if (escaping) {
                        escaping = false;
                    } else if (StringsKt.contains$default((CharSequence)"().*{}+?[]^$\\!", c, false, 2, null) && (c != '^' || !inClass)) {
                        ctx.re = ctx.re + '\\';
                    }
                    ctx.re = ctx.re + c;
                }
            }
        }
        if (inClass) {
            String string = pattern.substring(classStart + 1);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String cs = string;
            ParseResult sp = this.parse(cs, true);
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = ctx.re.substring(0, reClassStart);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            ctx.re = stringBuilder.append(string2).append("\\[").append(sp.getItem().getSource()).toString();
            boolean bl = ctx.hasMagic = ctx.hasMagic || sp.isB();
        }
        while (!patternListStack.isEmpty()) {
            String string;
            PatternListItem pl = (PatternListItem)patternListStack.pop();
            CharSequence tail = null;
            String string3 = ctx.re.substring(pl.getReStart() + 3);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            tail = string3;
            Pattern p = Pattern.compile("((?:\\\\{2})*)(\\\\?)\\|");
            Matcher m = p.matcher(tail);
            StringBuilder sb = new StringBuilder();
            int lastEnd = 0;
            while (m.find()) {
                String g1 = m.group(1);
                String g2 = m.group(2);
                CharSequence charSequence = g2;
                if (charSequence == null || charSequence.length() == 0) {
                    g2 = "\\";
                }
                sb.append(((Object)((CharSequence)tail).subSequence(lastEnd, m.start())).toString());
                sb.append(g1).append(g1).append(g2).append("|");
                lastEnd = m.end();
            }
            sb.append(tail, lastEnd, ((CharSequence)tail).length());
            tail = sb;
            Logger $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                n = 0;
                logger.debug("tail=" + tail, e$iv);
            }
            switch (pl.getType()) {
                case '*': {
                    string = "[^/]*?";
                    break;
                }
                case '?': {
                    string = "[^/]";
                    break;
                }
                default: {
                    string = "" + '\\' + pl.getType();
                }
            }
            String t = string;
            ctx.hasMagic = true;
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = ctx.re.substring(0, pl.getReStart());
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            ctx.re = stringBuilder.append(string4).append(t).append("\\(").append((Object)tail).toString();
        }
        this.clearStateChar(ctx);
        if (escaping) {
            ctx.re = ctx.re + "\\\\";
        }
        boolean addPatternStart = false;
        switch (ctx.re.charAt(0)) {
            case '(': 
            case '.': 
            case '[': {
                addPatternStart = true;
            }
        }
        while (!negativeListStack.isEmpty()) {
            String nlFirst;
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            String nlBefore;
            PatternListItem nl = (PatternListItem)negativeListStack.pop();
            Intrinsics.checkNotNullExpressionValue(ctx.re.substring(0, nl.getReStart()), "substring(...)");
            Intrinsics.checkNotNullExpressionValue(ctx.re.substring(nl.getReStart(), nl.getReEnd() - 8), "substring(...)");
            String string = ctx.re.substring(nl.getReEnd() - 8, nl.getReEnd());
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            String nlLast = string;
            String string5 = ctx.re.substring(nl.getReEnd());
            Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
            String nlAfter = string5;
            nlLast = nlLast + nlAfter;
            Object e$iv = nlBefore;
            Regex $i$f$debug = new Regex("\\(");
            n = 0;
            e$iv = $i$f$debug.split((CharSequence)e$iv, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String p0 = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)p0).length() == 0) continue;
                    list = CollectionsKt.take($this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            int openParensBefore = thisCollection$iv.toArray(new String[0]).length - 1;
            String cleanAfter = nlAfter;
            int i = 0;
            int n3 = openParensBefore - 1;
            if (i <= n3) {
                while (true) {
                    CharSequence charSequence = cleanAfter;
                    Regex regex = new Regex("\\)[+*?]?");
                    String string6 = "";
                    cleanAfter = regex.replace(charSequence, string6);
                    if (i == n3) break;
                    ++i;
                }
            }
            nlAfter = cleanAfter;
            String dollar = "";
            if (((CharSequence)nlAfter).length() == 0 && !isSub) {
                dollar = "$";
            }
            ctx.re = nlBefore + nlFirst + nlAfter + dollar + nlLast;
        }
        if (!(((CharSequence)ctx.re).length() == 0) && ctx.hasMagic) {
            ctx.re = "(?=.)" + ctx.re;
        }
        if (addPatternStart) {
            ctx.re = patternStart + ctx.re;
        }
        if (isSub) {
            return new ParseResult(new LiteralItem(ctx.re), ctx.hasMagic);
        }
        if (!ctx.hasMagic) {
            return new ParseResult(new LiteralItem(MinimatchKt.globUnescape(pattern)), false);
        }
        return new ParseResult(new MagicItem(ctx.re, this.options), false);
    }

    private final void clearStateChar(ParseContext ctx) {
        if (ctx.stateChar != null) {
            Character c;
            Character c2 = c = ctx.stateChar;
            char c3 = '*';
            if (c2 != null && c2.charValue() == c3) {
                ctx.re = ctx.re + "[^/]*?";
                ctx.hasMagic = true;
            } else {
                Character c4 = c;
                c3 = '?';
                if (c4 != null && c4.charValue() == c3) {
                    ctx.re = ctx.re + "[^/]";
                    ctx.hasMagic = true;
                } else {
                    StringBuilder stringBuilder = new StringBuilder().append(ctx.re).append('\\');
                    Character c5 = ctx.stateChar;
                    Intrinsics.checkNotNull(c5);
                    ctx.re = stringBuilder.append(c5.charValue()).toString();
                }
            }
            Logger $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("clearStateChar \"" + ctx.stateChar + "\" \"" + ctx.re + '\"', e$iv);
            }
            ctx.stateChar = null;
        }
    }

    private final String[] braceExpand(String pattern, MinimatchOptions options) {
        String[] stringArray;
        if (options.getNobrace() || !MinimatchKt.access$getHasBraces$p().matcher(pattern).matches()) {
            String[] stringArray2 = new String[]{pattern};
            stringArray = stringArray2;
        } else {
            stringArray = this.expand(pattern);
        }
        return stringArray;
    }

    private final String[] expand(String pattern) {
        String[] stringArray = new String[]{pattern};
        return stringArray;
    }

    public final boolean match(@NotNull List<? extends CharSequence> path, boolean partial) {
        int i;
        Intrinsics.checkNotNullParameter(path, "path");
        Logger $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(this.pattern + " set " + this.set, e$iv);
        }
        CharSequence filename = null;
        for (i = path.size() - 1; i >= 0 && (filename = path.get(i)).length() == 0; --i) {
        }
        for (i = 0; i < this.set.size(); ++i) {
            List<ParseItem> pattern = this.set.get(i);
            List file = path;
            if (this.options.getMatchBase() && pattern.size() == 1) {
                CharSequence charSequence = filename;
                Intrinsics.checkNotNull(charSequence);
                file = new SmartList<CharSequence>(charSequence);
            }
            if (!this.matchOne(file, pattern, partial)) continue;
            return this.options.getFlipNegate() || !this.negate;
        }
        if (this.options.getFlipNegate()) {
            return false;
        }
        return this.negate;
    }

    public static /* synthetic */ boolean match$default(Minimatch minimatch, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return minimatch.match(list, bl);
    }

    private final boolean matchOne(List<? extends CharSequence> file, List<? extends ParseItem> pattern, boolean partial) {
        int pi;
        Logger logger;
        Logger $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("matchOne\n\tOptions: " + this.options + "\n\tfile: " + file + "\n\tpattern: " + pattern, e$iv);
        }
        $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
        e$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("matchOne " + file.size() + ' ' + pattern.size(), e$iv);
        }
        int fi = 0;
        int fl = file.size();
        int pl = pattern.size();
        for (pi = 0; fi < fl && pi < pl; ++fi, ++pi) {
            ParseItem p = pattern.get(pi);
            CharSequence f = file.get(fi);
            Logger $this$debug_u24default$iv2 = MinimatchKt.access$getLOG$p();
            Throwable e$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("" + pattern + ' ' + p + ' ' + f, e$iv2);
            }
            if (p instanceof GlobStar) {
                $this$debug_u24default$iv2 = MinimatchKt.access$getLOG$p();
                e$iv2 = null;
                $i$f$debug2 = false;
                if ($this$debug_u24default$iv2.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv2;
                    boolean bl = false;
                    logger.debug("GLOBSTAR [" + pattern + ", " + p + ", " + f + ']', e$iv2);
                }
                int fr = 0;
                fr = fi;
                int pr = pi + 1;
                if (pr == pl) {
                    MinimatchKt.access$getLOG$p().debug("** at the end");
                    while (fi < fl) {
                        CharSequence item = file.get(fi);
                        if (Intrinsics.areEqual(item, ".") || Intrinsics.areEqual(item, "..") || !this.options.getDot() && StringsKt.startsWith$default(item, '.', false, 2, null)) {
                            return false;
                        }
                        ++fi;
                    }
                    return true;
                }
                while (fr < fl) {
                    CharSequence swallowee = file.get(fr);
                    Logger $this$debug_u24default$iv3 = MinimatchKt.access$getLOG$p();
                    Throwable e$iv3 = null;
                    boolean $i$f$debug3 = false;
                    if ($this$debug_u24default$iv3.isDebugEnabled()) {
                        logger = $this$debug_u24default$iv3;
                        boolean bl = false;
                        logger.debug("\nglobstar while " + file + ' ' + fr + ' ' + pattern + ' ' + pr + ' ' + swallowee, e$iv3);
                    }
                    if (this.matchOne(file.subList(fr, file.size()), pattern.subList(pr, pattern.size()), partial)) {
                        $this$debug_u24default$iv3 = MinimatchKt.access$getLOG$p();
                        e$iv3 = null;
                        $i$f$debug3 = false;
                        if ($this$debug_u24default$iv3.isDebugEnabled()) {
                            logger = $this$debug_u24default$iv3;
                            boolean bl = false;
                            logger.debug("globstar found match! " + fr + ' ' + fl + ' ' + swallowee, e$iv3);
                        }
                        return true;
                    }
                    if (Intrinsics.areEqual(swallowee, ".") || Intrinsics.areEqual(swallowee, "..") || !this.options.getDot() && StringsKt.startsWith$default(swallowee, '.', false, 2, null)) {
                        $this$debug_u24default$iv3 = MinimatchKt.access$getLOG$p();
                        e$iv3 = null;
                        $i$f$debug3 = false;
                        if (!$this$debug_u24default$iv3.isDebugEnabled()) break;
                        logger = $this$debug_u24default$iv3;
                        boolean bl = false;
                        logger.debug("dot detected! " + file + ' ' + fr + ' ' + pattern + ' ' + pr, e$iv3);
                        break;
                    }
                    MinimatchKt.access$getLOG$p().debug("globstar swallow a segment, and continue");
                    int $this$debug_u24default$iv22 = fr;
                    fr = $this$debug_u24default$iv22 + 1;
                }
                if (partial) {
                    Logger $this$debug_u24default$iv4 = MinimatchKt.access$getLOG$p();
                    Throwable e$iv4 = null;
                    boolean $i$f$debug4 = false;
                    if ($this$debug_u24default$iv4.isDebugEnabled()) {
                        logger = $this$debug_u24default$iv4;
                        boolean bl = false;
                        logger.debug("\n>>> no match, partial? " + file + ' ' + fr + ' ' + pattern + ' ' + pr, e$iv4);
                    }
                    if (fr == fl) {
                        return true;
                    }
                }
                return false;
            }
            if (!p.match(f, this.options)) {
                $this$debug_u24default$iv2 = MinimatchKt.access$getLOG$p();
                e$iv2 = null;
                $i$f$debug2 = false;
                if ($this$debug_u24default$iv2.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv2;
                    boolean bl = false;
                    logger.debug("pattern match " + p + ' ' + f + " false", e$iv2);
                }
                return false;
            }
            $this$debug_u24default$iv2 = MinimatchKt.access$getLOG$p();
            e$iv2 = null;
            $i$f$debug2 = false;
            if (!$this$debug_u24default$iv2.isDebugEnabled()) continue;
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("pattern match " + p + ' ' + f + " true", e$iv2);
        }
        if (fi == fl && pi == pl) {
            return true;
        }
        if (fi == fl) {
            return partial;
        }
        if (pi == pl) {
            return fi == fl - 1 && file.get(fi).length() == 0;
        }
        throw new IllegalStateException("");
    }

    @JvmOverloads
    public final boolean match(@NotNull String input, boolean partial) {
        Intrinsics.checkNotNullParameter(input, "input");
        return this.match(input, DefaultPathAdapter.INSTANCE, partial);
    }

    public static /* synthetic */ boolean match$default(Minimatch minimatch, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return minimatch.match(string, bl);
    }

    @JvmOverloads
    public final <T> boolean match(T input, @NotNull PathAdapter<? super T> adapter, boolean partial) {
        Logger logger;
        Intrinsics.checkNotNullParameter(adapter, "adapter");
        Logger $this$debug_u24default$iv = MinimatchKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("match " + input + ' ' + this.pattern, e$iv);
        }
        if (this.comment) {
            return false;
        }
        List<String> file = adapter.toArray(input, this.options);
        if (this.empty) {
            return file.isEmpty();
        }
        Logger $this$debug_u24default$iv2 = MinimatchKt.access$getLOG$p();
        Throwable e$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug(this.pattern + " split " + file, e$iv2);
        }
        return this.match(file, partial);
    }

    public static /* synthetic */ boolean match$default(Minimatch minimatch, Object object, PathAdapter pathAdapter, boolean bl, int n, Object object2) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return minimatch.match(object, pathAdapter, bl);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(object != null ? object.getClass() : null, this.getClass())) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type com.intellij.util.text.minimatch.Minimatch");
        Minimatch cfr_ignored_0 = (Minimatch)object2;
        if (!Intrinsics.areEqual(this.options, ((Minimatch)other).options)) {
            return false;
        }
        if (this.comment != ((Minimatch)other).comment) {
            return false;
        }
        if (this.empty != ((Minimatch)other).empty) {
            return false;
        }
        if (this.negate != ((Minimatch)other).negate) {
            return false;
        }
        return Intrinsics.areEqual(this.pattern, ((Minimatch)other).pattern);
    }

    public int hashCode() {
        int result = this.options.hashCode();
        result = 31 * result + Boolean.hashCode(this.comment);
        result = 31 * result + Boolean.hashCode(this.empty);
        result = 31 * result + Boolean.hashCode(this.negate);
        result = 31 * result + this.pattern.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return this.pattern;
    }

    @JvmOverloads
    public Minimatch(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        this(pattern, null, 2, null);
    }

    @JvmOverloads
    public final boolean match(@NotNull String input) {
        Intrinsics.checkNotNullParameter(input, "input");
        return Minimatch.match$default(this, input, false, 2, null);
    }

    @JvmOverloads
    public final <T> boolean match(T input, @NotNull PathAdapter<? super T> adapter) {
        Intrinsics.checkNotNullParameter(adapter, "adapter");
        return Minimatch.match$default(this, input, adapter, false, 4, null);
    }
}

