/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import org.apache.hadoop.fs.impl.prefetch.Validate;

public final class BlockData {
    private State[] state;
    private final long fileSize;
    private final int blockSize;
    private final int numBlocks;

    public BlockData(long fileSize, int blockSize) {
        Validate.checkNotNegative(fileSize, "fileSize");
        if (fileSize == 0L) {
            Validate.checkNotNegative(blockSize, "blockSize");
        } else {
            Validate.checkPositiveInteger(blockSize, "blockSize");
        }
        this.fileSize = fileSize;
        this.blockSize = blockSize;
        this.numBlocks = fileSize == 0L ? 0 : (int)(fileSize / (long)blockSize) + (fileSize % (long)blockSize > 0L ? 1 : 0);
        this.state = new State[this.numBlocks];
        for (int b = 0; b < this.numBlocks; ++b) {
            this.setState(b, State.NOT_READY);
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public int getNumBlocks() {
        return this.numBlocks;
    }

    public boolean isLastBlock(int blockNumber) {
        if (this.fileSize == 0L) {
            return false;
        }
        this.throwIfInvalidBlockNumber(blockNumber);
        return blockNumber == this.numBlocks - 1;
    }

    public int getBlockNumber(long offset) {
        this.throwIfInvalidOffset(offset);
        return (int)(offset / (long)this.blockSize);
    }

    public int getSize(int blockNumber) {
        if (this.fileSize == 0L) {
            return 0;
        }
        if (this.isLastBlock(blockNumber)) {
            return (int)(this.fileSize - (long)this.blockSize * (long)(this.numBlocks - 1));
        }
        return this.blockSize;
    }

    public boolean isValidOffset(long offset) {
        return offset >= 0L && offset < this.fileSize;
    }

    public long getStartOffset(int blockNumber) {
        this.throwIfInvalidBlockNumber(blockNumber);
        return (long)blockNumber * (long)this.blockSize;
    }

    public int getRelativeOffset(int blockNumber, long offset) {
        this.throwIfInvalidOffset(offset);
        return (int)(offset - this.getStartOffset(blockNumber));
    }

    public State getState(int blockNumber) {
        this.throwIfInvalidBlockNumber(blockNumber);
        return this.state[blockNumber];
    }

    public void setState(int blockNumber, State blockState) {
        this.throwIfInvalidBlockNumber(blockNumber);
        this.state[blockNumber] = blockState;
    }

    public String getStateString() {
        StringBuilder sb = new StringBuilder();
        int blockNumber = 0;
        while (blockNumber < this.numBlocks) {
            int endBlockNumber;
            State tstate = this.getState(blockNumber);
            for (endBlockNumber = blockNumber; endBlockNumber < this.numBlocks && this.getState(endBlockNumber) == tstate; ++endBlockNumber) {
            }
            sb.append(String.format("[%03d ~ %03d] %s%n", new Object[]{blockNumber, endBlockNumber - 1, tstate}));
            blockNumber = endBlockNumber;
        }
        return sb.toString();
    }

    private void throwIfInvalidBlockNumber(int blockNumber) {
        Validate.checkWithinRange(blockNumber, "blockNumber", 0L, this.numBlocks - 1);
    }

    private void throwIfInvalidOffset(long offset) {
        Validate.checkWithinRange(offset, "offset", 0L, this.fileSize - 1L);
    }

    static enum State {
        NOT_READY,
        QUEUED,
        READY,
        CACHED;

    }
}

