/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverterProvider;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedTypeDocumentConfiguration;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeConfiguration;
import software.amazon.awssdk.enhanced.dynamodb.internal.DynamoDbEnhancedLogger;
import software.amazon.awssdk.enhanced.dynamodb.internal.immutable.ImmutableInfo;
import software.amazon.awssdk.enhanced.dynamodb.internal.immutable.ImmutableIntrospector;
import software.amazon.awssdk.enhanced.dynamodb.internal.immutable.ImmutablePropertyDescriptor;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.BeanAttributeGetter;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.BeanAttributeSetter;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.MetaTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.MetaTableSchemaCache;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.ObjectConstructor;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.ObjectGetterMethod;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.StaticGetterMethod;
import software.amazon.awssdk.enhanced.dynamodb.mapper.BeanTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.ImmutableAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.ImmutableTableSchemaParams;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticImmutableTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.WrappedTableSchema;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.BeanTableSchemaAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbAttribute;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbBean;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbConvertedBy;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbFlatten;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbIgnoreNulls;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbImmutable;
import software.amazon.awssdk.enhanced.dynamodb.mapper.annotations.DynamoDbPreserveEmptyObject;

@SdkPublicApi
@ThreadSafe
public final class ImmutableTableSchema<T>
extends WrappedTableSchema<T, StaticImmutableTableSchema<T, ?>> {
    private static final String ATTRIBUTE_TAG_STATIC_SUPPLIER_NAME = "attributeTagFor";
    private static final Map<Class<?>, ImmutableTableSchema<?>> IMMUTABLE_TABLE_SCHEMA_CACHE = Collections.synchronizedMap(new WeakHashMap());

    private ImmutableTableSchema(StaticImmutableTableSchema<T, ?> wrappedTableSchema) {
        super(wrappedTableSchema);
    }

    public static <T> ImmutableTableSchema<T> create(ImmutableTableSchemaParams<T> params) {
        return IMMUTABLE_TABLE_SCHEMA_CACHE.computeIfAbsent(params.immutableClass(), clz -> ImmutableTableSchema.create(params, new MetaTableSchemaCache()));
    }

    public static <T> ImmutableTableSchema<T> create(Class<T> immutableClass) {
        return ImmutableTableSchema.create((ImmutableTableSchemaParams)ImmutableTableSchemaParams.builder(immutableClass).build());
    }

    private static <T> ImmutableTableSchema<T> create(ImmutableTableSchemaParams<T> params, MetaTableSchemaCache metaTableSchemaCache) {
        ImmutableTableSchema.debugLog(params.immutableClass(), () -> "Creating immutable schema");
        MetaTableSchema<T> metaTableSchema = metaTableSchemaCache.getOrCreate(params.immutableClass());
        ImmutableTableSchema<T> newTableSchema = new ImmutableTableSchema<T>(ImmutableTableSchema.createStaticImmutableTableSchema(params.immutableClass(), params.lookup(), metaTableSchemaCache));
        metaTableSchema.initialize(newTableSchema);
        return newTableSchema;
    }

    static <T> TableSchema<T> recursiveCreate(Class<T> immutableClass, MethodHandles.Lookup lookup, MetaTableSchemaCache metaTableSchemaCache) {
        Optional<MetaTableSchema<T>> metaTableSchema = metaTableSchemaCache.get(immutableClass);
        if (metaTableSchema.isPresent()) {
            if (metaTableSchema.get().isInitialized()) {
                return metaTableSchema.get().concreteTableSchema();
            }
            return metaTableSchema.get();
        }
        return ImmutableTableSchema.create((ImmutableTableSchemaParams)ImmutableTableSchemaParams.builder(immutableClass).lookup(lookup).build(), metaTableSchemaCache);
    }

    private static <T> StaticImmutableTableSchema<T, ?> createStaticImmutableTableSchema(Class<T> immutableClass, MethodHandles.Lookup lookup, MetaTableSchemaCache metaTableSchemaCache) {
        ImmutableInfo<T> immutableInfo = ImmutableIntrospector.getImmutableInfo(immutableClass);
        Class<?> builderClass = immutableInfo.builderClass();
        return ImmutableTableSchema.createStaticImmutableTableSchema(immutableClass, builderClass, immutableInfo, lookup, metaTableSchemaCache);
    }

    private static <T, B> StaticImmutableTableSchema<T, B> createStaticImmutableTableSchema(Class<T> immutableClass, Class<B> builderClass, ImmutableInfo<T> immutableInfo, MethodHandles.Lookup lookup, MetaTableSchemaCache metaTableSchemaCache) {
        Supplier<B> newBuilderSupplier = ImmutableTableSchema.newObjectSupplier(immutableInfo, builderClass, lookup);
        ObjectGetterMethod buildFunction = ObjectGetterMethod.create(builderClass, immutableInfo.buildMethod(), lookup);
        StaticImmutableTableSchema.Builder builder = StaticImmutableTableSchema.builder(immutableClass, builderClass).newItemBuilder(newBuilderSupplier, buildFunction);
        builder.attributeConverterProviders(ImmutableTableSchema.createConverterProvidersFromAnnotation(immutableClass, lookup, immutableClass.getAnnotation(DynamoDbImmutable.class)));
        ArrayList attributes = new ArrayList();
        immutableInfo.propertyDescriptors().forEach(propertyDescriptor -> {
            DynamoDbFlatten dynamoDbFlatten = ImmutableTableSchema.getPropertyAnnotation(propertyDescriptor, DynamoDbFlatten.class);
            if (dynamoDbFlatten != null) {
                builder.flatten(TableSchema.fromClass(propertyDescriptor.getter().getReturnType()), ImmutableTableSchema.getterForProperty(propertyDescriptor, immutableClass, lookup), ImmutableTableSchema.setterForProperty(propertyDescriptor, builderClass, lookup));
            } else {
                AttributeConfiguration beanAttributeConfiguration = ImmutableTableSchema.resolveAttributeConfiguration(propertyDescriptor);
                ImmutableAttribute.Builder attributeBuilder = ImmutableTableSchema.immutableAttributeBuilder(propertyDescriptor, immutableClass, builderClass, lookup, metaTableSchemaCache, beanAttributeConfiguration);
                Optional<AttributeConverter> attributeConverter = ImmutableTableSchema.createAttributeConverterFromAnnotation(propertyDescriptor, lookup);
                attributeConverter.ifPresent(attributeBuilder::attributeConverter);
                ImmutableTableSchema.addTagsToAttribute(attributeBuilder, propertyDescriptor);
                attributes.add(attributeBuilder.build());
            }
        });
        builder.attributes(attributes);
        return builder.build();
    }

    private static List<AttributeConverterProvider> createConverterProvidersFromAnnotation(Class<?> immutableClass, MethodHandles.Lookup lookup, DynamoDbImmutable dynamoDbImmutable) {
        Class<? extends AttributeConverterProvider>[] providerClasses = dynamoDbImmutable.converterProviders();
        return Arrays.stream(providerClasses).peek(c -> ImmutableTableSchema.debugLog(immutableClass, () -> "Adding Converter: " + c.getTypeName())).map(c -> (AttributeConverterProvider)ImmutableTableSchema.newObjectSupplierForClass(c, lookup).get()).collect(Collectors.toList());
    }

    private static <T, B> ImmutableAttribute.Builder<T, B, ?> immutableAttributeBuilder(ImmutablePropertyDescriptor propertyDescriptor, Class<T> immutableClass, Class<B> builderClass, MethodHandles.Lookup lookup, MetaTableSchemaCache metaTableSchemaCache, AttributeConfiguration beanAttributeConfiguration) {
        Type propertyType = propertyDescriptor.getter().getGenericReturnType();
        EnhancedType<?> propertyTypeToken = ImmutableTableSchema.convertTypeToEnhancedType(propertyType, lookup, metaTableSchemaCache, beanAttributeConfiguration);
        return ImmutableAttribute.builder(immutableClass, builderClass, propertyTypeToken).name(ImmutableTableSchema.attributeNameForProperty(propertyDescriptor)).getter(ImmutableTableSchema.getterForProperty(propertyDescriptor, immutableClass, lookup)).setter(ImmutableTableSchema.setterForProperty(propertyDescriptor, builderClass, lookup));
    }

    private static EnhancedType<?> convertTypeToEnhancedType(Type type, MethodHandles.Lookup lookup, MetaTableSchemaCache metaTableSchemaCache, AttributeConfiguration attributeConfiguration) {
        Class clazz = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (List.class.equals((Object)rawType)) {
                EnhancedType<?> enhancedType = ImmutableTableSchema.convertTypeToEnhancedType(parameterizedType.getActualTypeArguments()[0], lookup, metaTableSchemaCache, attributeConfiguration);
                return EnhancedType.listOf(enhancedType);
            }
            if (Map.class.equals((Object)rawType)) {
                EnhancedType<?> enhancedType = ImmutableTableSchema.convertTypeToEnhancedType(parameterizedType.getActualTypeArguments()[1], lookup, metaTableSchemaCache, attributeConfiguration);
                return EnhancedType.mapOf(EnhancedType.of(parameterizedType.getActualTypeArguments()[0]), enhancedType);
            }
            if (rawType instanceof Class) {
                clazz = (Class)rawType;
            }
        } else if (type instanceof Class) {
            clazz = (Class)type;
        }
        if (clazz != null) {
            Consumer<EnhancedTypeDocumentConfiguration.Builder> attrConfiguration = b -> b.preserveEmptyObject(attributeConfiguration.preserveEmptyObject()).ignoreNulls(attributeConfiguration.ignoreNulls());
            if (clazz.getAnnotation(DynamoDbImmutable.class) != null) {
                return EnhancedType.documentOf(clazz, ImmutableTableSchema.recursiveCreate(clazz, lookup, metaTableSchemaCache), attrConfiguration);
            }
            if (clazz.getAnnotation(DynamoDbBean.class) != null) {
                return EnhancedType.documentOf(clazz, BeanTableSchema.recursiveCreate(clazz, lookup, metaTableSchemaCache), attrConfiguration);
            }
        }
        return EnhancedType.of(type);
    }

    private static Optional<AttributeConverter> createAttributeConverterFromAnnotation(ImmutablePropertyDescriptor propertyDescriptor, MethodHandles.Lookup lookup) {
        DynamoDbConvertedBy attributeConverterBean = ImmutableTableSchema.getPropertyAnnotation(propertyDescriptor, DynamoDbConvertedBy.class);
        Optional<Class> optionalClass = Optional.ofNullable(attributeConverterBean).map(DynamoDbConvertedBy::value);
        return optionalClass.map(clazz -> (AttributeConverter)ImmutableTableSchema.newObjectSupplierForClass(clazz, lookup).get());
    }

    private static void addTagsToAttribute(ImmutableAttribute.Builder<?, ?, ?> attributeBuilder, ImmutablePropertyDescriptor propertyDescriptor) {
        ImmutableTableSchema.propertyAnnotations(propertyDescriptor).forEach(annotation -> {
            BeanTableSchemaAttributeTag beanTableSchemaAttributeTag = annotation.annotationType().getAnnotation(BeanTableSchemaAttributeTag.class);
            if (beanTableSchemaAttributeTag != null) {
                StaticAttributeTag staticAttributeTag;
                Method tagMethod;
                Class<?> tagClass = beanTableSchemaAttributeTag.value();
                try {
                    tagMethod = tagClass.getDeclaredMethod(ATTRIBUTE_TAG_STATIC_SUPPLIER_NAME, annotation.annotationType());
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(String.format("Could not find a static method named '%s' on class '%s' that returns an AttributeTag for annotation '%s'", ATTRIBUTE_TAG_STATIC_SUPPLIER_NAME, tagClass, annotation.annotationType()), e);
                }
                if (!Modifier.isStatic(tagMethod.getModifiers())) {
                    throw new RuntimeException(String.format("Could not find a static method named '%s' on class '%s' that returns an AttributeTag for annotation '%s'", ATTRIBUTE_TAG_STATIC_SUPPLIER_NAME, tagClass, annotation.annotationType()));
                }
                try {
                    staticAttributeTag = (StaticAttributeTag)tagMethod.invoke(null, annotation);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(String.format("Could not invoke method to create AttributeTag for annotation '%s' on class '%s'.", annotation.annotationType(), tagClass), e);
                }
                attributeBuilder.addTag(staticAttributeTag);
            }
        });
    }

    private static <T, R> Supplier<R> newObjectSupplier(ImmutableInfo<T> immutableInfo, Class<R> builderClass, MethodHandles.Lookup lookup) {
        if (immutableInfo.staticBuilderMethod().isPresent()) {
            return StaticGetterMethod.create(immutableInfo.staticBuilderMethod().get(), lookup);
        }
        return ImmutableTableSchema.newObjectSupplierForClass(builderClass, lookup);
    }

    private static <R> Supplier<R> newObjectSupplierForClass(Class<R> clazz, MethodHandles.Lookup lookup) {
        try {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            ImmutableTableSchema.debugLog(clazz, () -> "Constructor: " + constructor);
            return ObjectConstructor.create(clazz, constructor, lookup);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Builder class '%s' appears to have no default constructor thus cannot be used with the ImmutableTableSchema", clazz), e);
        }
    }

    private static <T, R> Function<T, R> getterForProperty(ImmutablePropertyDescriptor propertyDescriptor, Class<T> immutableClass, MethodHandles.Lookup lookup) {
        Method readMethod = propertyDescriptor.getter();
        ImmutableTableSchema.debugLog(immutableClass, () -> "Property " + propertyDescriptor.name() + " read method: " + readMethod);
        return BeanAttributeGetter.create(immutableClass, readMethod, lookup);
    }

    private static <T, R> BiConsumer<T, R> setterForProperty(ImmutablePropertyDescriptor propertyDescriptor, Class<T> builderClass, MethodHandles.Lookup lookup) {
        Method writeMethod = propertyDescriptor.setter();
        ImmutableTableSchema.debugLog(builderClass, () -> "Property " + propertyDescriptor.name() + " write method: " + writeMethod);
        return BeanAttributeSetter.create(builderClass, writeMethod, lookup);
    }

    private static String attributeNameForProperty(ImmutablePropertyDescriptor propertyDescriptor) {
        DynamoDbAttribute dynamoDbAttribute = ImmutableTableSchema.getPropertyAnnotation(propertyDescriptor, DynamoDbAttribute.class);
        if (dynamoDbAttribute != null) {
            return dynamoDbAttribute.value();
        }
        return propertyDescriptor.name();
    }

    private static <R extends Annotation> R getPropertyAnnotation(ImmutablePropertyDescriptor propertyDescriptor, Class<R> annotationType) {
        R getterAnnotation = propertyDescriptor.getter().getAnnotation(annotationType);
        R setterAnnotation = propertyDescriptor.setter().getAnnotation(annotationType);
        if (getterAnnotation != null) {
            return getterAnnotation;
        }
        return setterAnnotation;
    }

    private static List<? extends Annotation> propertyAnnotations(ImmutablePropertyDescriptor propertyDescriptor) {
        return Stream.concat(Arrays.stream(propertyDescriptor.getter().getAnnotations()), Arrays.stream(propertyDescriptor.setter().getAnnotations())).collect(Collectors.toList());
    }

    private static AttributeConfiguration resolveAttributeConfiguration(ImmutablePropertyDescriptor propertyDescriptor) {
        boolean shouldPreserveEmptyObject = ImmutableTableSchema.getPropertyAnnotation(propertyDescriptor, DynamoDbPreserveEmptyObject.class) != null;
        boolean ignoreNulls = ImmutableTableSchema.getPropertyAnnotation(propertyDescriptor, DynamoDbIgnoreNulls.class) != null;
        return AttributeConfiguration.builder().preserveEmptyObject(shouldPreserveEmptyObject).ignoreNulls(ignoreNulls).build();
    }

    private static void debugLog(Class<?> beanClass, Supplier<String> logMessage) {
        DynamoDbEnhancedLogger.BEAN_LOGGER.debug(() -> beanClass.getTypeName() + " - " + (String)logMessage.get());
    }

    @SdkTestInternalApi
    static void clearSchemaCache() {
        IMMUTABLE_TABLE_SCHEMA_CACHE.clear();
    }
}

