/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.security;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.security.UserTenants;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GetAccountDetailsResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GetAccountDetailsResponse> {
    @Nonnull
    private final List<String> backendRoles;
    @Nonnull
    private final List<String> customAttributeNames;
    @Nullable
    private final Boolean isHidden;
    @Nullable
    private final Boolean isInternalUser;
    @Nullable
    private final Boolean isReserved;
    @Nonnull
    private final List<String> roles;
    @Nullable
    private final UserTenants tenants;
    @Nullable
    private final String userName;
    @Nullable
    private final String userRequestedTenant;
    public static final JsonpDeserializer<GetAccountDetailsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetAccountDetailsResponse::setupGetAccountDetailsResponseDeserializer);

    private GetAccountDetailsResponse(Builder builder) {
        this.backendRoles = ApiTypeHelper.unmodifiable(builder.backendRoles);
        this.customAttributeNames = ApiTypeHelper.unmodifiable(builder.customAttributeNames);
        this.isHidden = builder.isHidden;
        this.isInternalUser = builder.isInternalUser;
        this.isReserved = builder.isReserved;
        this.roles = ApiTypeHelper.unmodifiable(builder.roles);
        this.tenants = builder.tenants;
        this.userName = builder.userName;
        this.userRequestedTenant = builder.userRequestedTenant;
    }

    public static GetAccountDetailsResponse of(Function<Builder, ObjectBuilder<GetAccountDetailsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<String> backendRoles() {
        return this.backendRoles;
    }

    @Nonnull
    public final List<String> customAttributeNames() {
        return this.customAttributeNames;
    }

    @Nullable
    public final Boolean isHidden() {
        return this.isHidden;
    }

    @Nullable
    public final Boolean isInternalUser() {
        return this.isInternalUser;
    }

    @Nullable
    public final Boolean isReserved() {
        return this.isReserved;
    }

    @Nonnull
    public final List<String> roles() {
        return this.roles;
    }

    @Nullable
    public final UserTenants tenants() {
        return this.tenants;
    }

    @Nullable
    public final String userName() {
        return this.userName;
    }

    @Nullable
    public final String userRequestedTenant() {
        return this.userRequestedTenant;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.backendRoles)) {
            generator.writeKey("backend_roles");
            generator.writeStartArray();
            for (String item0 : this.backendRoles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.customAttributeNames)) {
            generator.writeKey("custom_attribute_names");
            generator.writeStartArray();
            for (String item0 : this.customAttributeNames) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.isHidden != null) {
            generator.writeKey("is_hidden");
            generator.write(this.isHidden.booleanValue());
        }
        if (this.isInternalUser != null) {
            generator.writeKey("is_internal_user");
            generator.write(this.isInternalUser.booleanValue());
        }
        if (this.isReserved != null) {
            generator.writeKey("is_reserved");
            generator.write(this.isReserved.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String item0 : this.roles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.tenants != null) {
            generator.writeKey("tenants");
            this.tenants.serialize(generator, mapper);
        }
        if (this.userName != null) {
            generator.writeKey("user_name");
            generator.write(this.userName);
        }
        if (this.userRequestedTenant != null) {
            generator.writeKey("user_requested_tenant");
            generator.write(this.userRequestedTenant);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGetAccountDetailsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::backendRoles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "backend_roles");
        op.add(Builder::customAttributeNames, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "custom_attribute_names");
        op.add(Builder::isHidden, JsonpDeserializer.booleanDeserializer(), "is_hidden");
        op.add(Builder::isInternalUser, JsonpDeserializer.booleanDeserializer(), "is_internal_user");
        op.add(Builder::isReserved, JsonpDeserializer.booleanDeserializer(), "is_reserved");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(Builder::tenants, UserTenants._DESERIALIZER, "tenants");
        op.add(Builder::userName, JsonpDeserializer.stringDeserializer(), "user_name");
        op.add(Builder::userRequestedTenant, JsonpDeserializer.stringDeserializer(), "user_requested_tenant");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.backendRoles);
        result = 31 * result + Objects.hashCode(this.customAttributeNames);
        result = 31 * result + Objects.hashCode(this.isHidden);
        result = 31 * result + Objects.hashCode(this.isInternalUser);
        result = 31 * result + Objects.hashCode(this.isReserved);
        result = 31 * result + Objects.hashCode(this.roles);
        result = 31 * result + Objects.hashCode(this.tenants);
        result = 31 * result + Objects.hashCode(this.userName);
        result = 31 * result + Objects.hashCode(this.userRequestedTenant);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAccountDetailsResponse other = (GetAccountDetailsResponse)o;
        return Objects.equals(this.backendRoles, other.backendRoles) && Objects.equals(this.customAttributeNames, other.customAttributeNames) && Objects.equals(this.isHidden, other.isHidden) && Objects.equals(this.isInternalUser, other.isInternalUser) && Objects.equals(this.isReserved, other.isReserved) && Objects.equals(this.roles, other.roles) && Objects.equals(this.tenants, other.tenants) && Objects.equals(this.userName, other.userName) && Objects.equals(this.userRequestedTenant, other.userRequestedTenant);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, GetAccountDetailsResponse> {
        @Nullable
        private List<String> backendRoles;
        @Nullable
        private List<String> customAttributeNames;
        @Nullable
        private Boolean isHidden;
        @Nullable
        private Boolean isInternalUser;
        @Nullable
        private Boolean isReserved;
        @Nullable
        private List<String> roles;
        @Nullable
        private UserTenants tenants;
        @Nullable
        private String userName;
        @Nullable
        private String userRequestedTenant;

        public Builder() {
        }

        private Builder(GetAccountDetailsResponse o) {
            this.backendRoles = Builder._listCopy(o.backendRoles);
            this.customAttributeNames = Builder._listCopy(o.customAttributeNames);
            this.isHidden = o.isHidden;
            this.isInternalUser = o.isInternalUser;
            this.isReserved = o.isReserved;
            this.roles = Builder._listCopy(o.roles);
            this.tenants = o.tenants;
            this.userName = o.userName;
            this.userRequestedTenant = o.userRequestedTenant;
        }

        private Builder(Builder o) {
            this.backendRoles = Builder._listCopy(o.backendRoles);
            this.customAttributeNames = Builder._listCopy(o.customAttributeNames);
            this.isHidden = o.isHidden;
            this.isInternalUser = o.isInternalUser;
            this.isReserved = o.isReserved;
            this.roles = Builder._listCopy(o.roles);
            this.tenants = o.tenants;
            this.userName = o.userName;
            this.userRequestedTenant = o.userRequestedTenant;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder backendRoles(List<String> list) {
            this.backendRoles = Builder._listAddAll(this.backendRoles, list);
            return this;
        }

        @Nonnull
        public final Builder backendRoles(String value, String ... values) {
            this.backendRoles = Builder._listAdd(this.backendRoles, value, values);
            return this;
        }

        @Nonnull
        public final Builder customAttributeNames(List<String> list) {
            this.customAttributeNames = Builder._listAddAll(this.customAttributeNames, list);
            return this;
        }

        @Nonnull
        public final Builder customAttributeNames(String value, String ... values) {
            this.customAttributeNames = Builder._listAdd(this.customAttributeNames, value, values);
            return this;
        }

        @Nonnull
        public final Builder isHidden(@Nullable Boolean value) {
            this.isHidden = value;
            return this;
        }

        @Nonnull
        public final Builder isInternalUser(@Nullable Boolean value) {
            this.isInternalUser = value;
            return this;
        }

        @Nonnull
        public final Builder isReserved(@Nullable Boolean value) {
            this.isReserved = value;
            return this;
        }

        @Nonnull
        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        @Nonnull
        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        @Nonnull
        public final Builder tenants(@Nullable UserTenants value) {
            this.tenants = value;
            return this;
        }

        @Nonnull
        public final Builder tenants(Function<UserTenants.Builder, ObjectBuilder<UserTenants>> fn) {
            return this.tenants(fn.apply(new UserTenants.Builder()).build());
        }

        @Nonnull
        public final Builder userName(@Nullable String value) {
            this.userName = value;
            return this;
        }

        @Nonnull
        public final Builder userRequestedTenant(@Nullable String value) {
            this.userRequestedTenant = value;
            return this;
        }

        @Override
        @Nonnull
        public GetAccountDetailsResponse build() {
            this._checkSingleUse();
            return new GetAccountDetailsResponse(this);
        }
    }
}

