/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.beans;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XVclWindowPeer;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.NamedValue;
import com.sun.star.comp.beans.JavaWindowPeerFake;
import com.sun.star.comp.beans.OfficeConnection;
import com.sun.star.comp.beans.OfficeWindow;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Canvas;
import java.awt.Component;

public class LocalOfficeWindow
extends Canvas
implements OfficeWindow,
XEventListener {
    private transient OfficeConnection mConnection;
    private transient XWindowPeer mParentProxy;
    private transient XWindowPeer mWindow;
    private boolean bPeer = false;

    protected LocalOfficeWindow(OfficeConnection officeConnection) {
        this.mConnection = officeConnection;
        this.mConnection.addEventListener(this);
    }

    @Override
    public Component getAWTComponent() {
        return this;
    }

    public synchronized void disposing(EventObject eventObject) {
        this.mWindow = null;
        this.mConnection = null;
    }

    private XToolkit queryAWTToolkit() throws com.sun.star.uno.Exception {
        XComponentContext xComponentContext = this.mConnection.getComponentContext();
        if (xComponentContext == null) {
            throw new RuntimeException("no context");
        }
        XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
        XMultiServiceFactory xMultiServiceFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xMultiComponentFactory);
        Object object = xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit");
        return (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)object);
    }

    private synchronized void aquireSystemWindow() {
        if (!this.bPeer) {
            XVclWindowPeer xVclWindowPeer = (XVclWindowPeer)UnoRuntime.queryInterface(XVclWindowPeer.class, (Object)this.mWindow);
            xVclWindowPeer.setProperty("PluginParent", (Object)this.getWrappedWindowHandle());
            this.bPeer = true;
            XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.mWindow);
            xWindow.setVisible(true);
        }
    }

    private synchronized void releaseSystemWindow() {
        if (this.bPeer) {
            XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.mWindow);
            xWindow.setVisible(false);
            XVclWindowPeer xVclWindowPeer = (XVclWindowPeer)UnoRuntime.queryInterface(XVclWindowPeer.class, (Object)this.mWindow);
            xVclWindowPeer.setProperty("PluginParent", (Object)0L);
            this.bPeer = false;
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.aquireSystemWindow();
        } else {
            this.releaseSystemWindow();
        }
    }

    @Override
    public synchronized XWindowPeer getUNOWindowPeer() {
        if (this.mWindow != null) {
            return this.mWindow;
        }
        try {
            JavaWindowPeerFake javaWindowPeerFake;
            int n = this.getNativeWindowSystemType();
            if (this.isShowing()) {
                javaWindowPeerFake = new JavaWindowPeerFake(this.getWrappedWindowHandle(), n);
                this.bPeer = true;
            } else {
                javaWindowPeerFake = null;
                this.bPeer = false;
            }
            Rectangle rectangle = new Rectangle(0, 0, 20, 20);
            WindowDescriptor windowDescriptor = new WindowDescriptor();
            windowDescriptor.Type = WindowClass.TOP;
            windowDescriptor.Parent = javaWindowPeerFake;
            windowDescriptor.Bounds = rectangle;
            windowDescriptor.WindowServiceName = "workwindow";
            windowDescriptor.WindowAttributes = n == 1 ? 1 : 0;
            this.mWindow = this.queryAWTToolkit().createWindow(windowDescriptor);
            XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.mWindow);
            xWindow.setVisible(this.bPeer);
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        return this.mWindow;
    }

    @Override
    public void removeNotify() {
        try {
            this.releaseSystemWindow();
        }
        catch (Exception exception) {
            System.err.println("LocaleOfficeWindow.removeNotify: Exception in releaseSystemWindow.");
            System.err.println(exception.getMessage());
            exception.printStackTrace(System.err);
        }
        super.removeNotify();
    }

    private native long getNativeWindow();

    private native int getNativeWindowSystemType();

    protected Any getWrappedWindowHandle() {
        String string;
        NamedValue namedValue = new NamedValue("WINDOW", (Object)new Any(new Type(Long.class), (Object)this.getNativeWindow()));
        NamedValue namedValue2 = new NamedValue("XEMBED", (Object)new Any(new Type(Boolean.class), (Object)Boolean.FALSE));
        if (this.getNativeWindowSystemType() == 6 && ((string = System.getProperty("java.vendor")).equals("Sun Microsystems Inc.") || string.equals("Oracle Corporation")) && Boolean.getBoolean("sun.awt.xembedserver")) {
            namedValue2 = new NamedValue("XEMBED", (Object)new Any(new Type(Boolean.class), (Object)Boolean.TRUE));
        }
        return new Any(new Type("[]com.sun.star.beans.NamedValue"), (Object)new NamedValue[]{namedValue, namedValue2});
    }
}

