/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.internal.ParameterMarkerStrategyStandard;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;

public class Oracle12LimitHandler
extends AbstractLimitHandler {
    private boolean bindLimitParametersInReverseOrder;
    private boolean useMaxForLimit;
    private boolean supportOffset;
    public static final Oracle12LimitHandler INSTANCE = new Oracle12LimitHandler();

    Oracle12LimitHandler() {
    }

    @Override
    public String processSql(String sql, Limit limit, QueryOptions queryOptions) {
        return this.processSql(sql, -1, limit, null, queryOptions);
    }

    @Override
    public String processSql(String sql, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, QueryOptions queryOptions) {
        return this.processSql(sql, jdbcParameterCount, queryOptions.getLimit(), parameterMarkerStrategy, queryOptions);
    }

    private String processSql(String sql, int jdbcParameterCount, @Nullable Limit limit, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, QueryOptions queryOptions) {
        boolean hasFirstRow = Oracle12LimitHandler.hasFirstRow(limit);
        boolean hasMaxRows = Oracle12LimitHandler.hasMaxRows(limit);
        if (!hasFirstRow && !hasMaxRows) {
            return sql;
        }
        return this.processSql(sql, hasFirstRow, hasMaxRows, jdbcParameterCount, parameterMarkerStrategy, queryOptions.getLockOptions());
    }

    protected String processSql(String sql, boolean hasFirstRow, boolean hasMaxRows, LockOptions lockOptions) {
        return this.processSql(sql, hasFirstRow, hasMaxRows, -1, null, lockOptions);
    }

    protected String processSql(String sql, boolean hasFirstRow, boolean hasMaxRows, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy, LockOptions lockOptions) {
        if (lockOptions != null) {
            LockMode lockMode = lockOptions.getLockMode();
            switch (lockMode) {
                case PESSIMISTIC_READ: 
                case PESSIMISTIC_WRITE: 
                case UPGRADE_NOWAIT: 
                case PESSIMISTIC_FORCE_INCREMENT: 
                case UPGRADE_SKIPLOCKED: {
                    return this.processSql(sql, this.getForUpdateIndex(sql), hasFirstRow, hasMaxRows, jdbcParameterCount, parameterMarkerStrategy);
                }
            }
            return this.processSqlOffsetFetch(sql, hasFirstRow, hasMaxRows, jdbcParameterCount, parameterMarkerStrategy);
        }
        return this.processSqlOffsetFetch(sql, hasFirstRow, hasMaxRows, jdbcParameterCount, parameterMarkerStrategy);
    }

    protected String processSqlOffsetFetch(String sql, boolean hasFirstRow, boolean hasMaxRows) {
        return this.processSqlOffsetFetch(sql, hasFirstRow, hasMaxRows, -1, null);
    }

    protected String processSqlOffsetFetch(String sql, boolean hasFirstRow, boolean hasMaxRows, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy) {
        Object offsetFetchString;
        int forUpdateLastIndex = this.getForUpdateIndex(sql);
        if (forUpdateLastIndex > -1) {
            return this.processSql(sql, forUpdateLastIndex, hasFirstRow, hasMaxRows);
        }
        this.bindLimitParametersInReverseOrder = false;
        this.useMaxForLimit = false;
        this.supportOffset = true;
        if (ParameterMarkerStrategyStandard.isStandardRenderer(parameterMarkerStrategy)) {
            offsetFetchString = hasFirstRow && hasMaxRows ? " offset ? rows fetch next ? rows only" : (hasFirstRow ? " offset ? rows" : " fetch first ? rows only");
        } else {
            String firstParameter = parameterMarkerStrategy.createMarker(jdbcParameterCount + 1, null);
            if (hasFirstRow && hasMaxRows) {
                String secondParameter = parameterMarkerStrategy.createMarker(jdbcParameterCount + 2, null);
                offsetFetchString = " offset " + firstParameter + " rows fetch next " + secondParameter + " rows only";
            } else {
                offsetFetchString = hasFirstRow ? " offset " + firstParameter + " rows" : " fetch first " + firstParameter + " rows only";
            }
        }
        return this.insertAtEnd((String)offsetFetchString, sql);
    }

    protected String processSql(String sql, int forUpdateIndex, boolean hasFirstRow, boolean hasMaxRows) {
        return this.processSql(sql, forUpdateIndex, hasFirstRow, hasMaxRows, -1, null);
    }

    protected String processSql(String sql, int forUpdateIndex, boolean hasFirstRow, boolean hasMaxRows, int jdbcParameterCount, @Nullable ParameterMarkerStrategy parameterMarkerStrategy) {
        StringBuilder pagingSelect;
        this.bindLimitParametersInReverseOrder = true;
        this.useMaxForLimit = true;
        this.supportOffset = false;
        String forUpdateClause = null;
        boolean isForUpdate = false;
        if (forUpdateIndex > -1) {
            forUpdateClause = sql.substring(forUpdateIndex);
            sql = sql.substring(0, forUpdateIndex - 1);
            isForUpdate = true;
        }
        int forUpdateClauseLength = forUpdateClause == null ? 0 : forUpdateClause.length() + 1;
        if (ParameterMarkerStrategyStandard.isStandardRenderer(parameterMarkerStrategy)) {
            if (hasFirstRow && hasMaxRows) {
                pagingSelect = new StringBuilder(sql.length() + forUpdateClauseLength + 98);
                pagingSelect.append("select * from (select row_.*,rownum rownum_ from (");
                pagingSelect.append(sql);
                pagingSelect.append(") row_ where rownum<=?) where rownum_>?");
            } else if (hasFirstRow) {
                pagingSelect = new StringBuilder(sql.length() + forUpdateClauseLength + 98);
                pagingSelect.append("select * from (");
                pagingSelect.append(sql);
                pagingSelect.append(") row_ where rownum>?");
            } else {
                pagingSelect = new StringBuilder(sql.length() + forUpdateClauseLength + 37);
                pagingSelect.append("select * from (");
                pagingSelect.append(sql);
                pagingSelect.append(") where rownum<=?");
            }
        } else {
            String firstParameter = parameterMarkerStrategy.createMarker(jdbcParameterCount + 1, null);
            if (hasFirstRow && hasMaxRows) {
                String secondParameter = parameterMarkerStrategy.createMarker(jdbcParameterCount + 2, null);
                pagingSelect = new StringBuilder(sql.length() + forUpdateClauseLength + 98);
                pagingSelect.append("select * from (select row_.*,rownum rownum_ from (");
                pagingSelect.append(sql);
                pagingSelect.append(") row_ where rownum<=");
                pagingSelect.append(firstParameter);
                pagingSelect.append(") where rownum_>");
                pagingSelect.append(secondParameter);
            } else if (hasFirstRow) {
                pagingSelect = new StringBuilder(sql.length() + forUpdateClauseLength + 98);
                pagingSelect.append("select * from (");
                pagingSelect.append(sql);
                pagingSelect.append(") row_ where rownum>");
                pagingSelect.append(firstParameter);
            } else {
                pagingSelect = new StringBuilder(sql.length() + forUpdateClauseLength + 37);
                pagingSelect.append("select * from (");
                pagingSelect.append(sql);
                pagingSelect.append(") where rownum<=");
                pagingSelect.append(firstParameter);
            }
        }
        if (isForUpdate) {
            pagingSelect.append(" ");
            pagingSelect.append(forUpdateClause);
        }
        return pagingSelect.toString();
    }

    private int getForUpdateIndex(String sql) {
        int forUpdateLastIndex = sql.toLowerCase(Locale.ROOT).lastIndexOf("for update");
        int lastIndexOfQuote = sql.lastIndexOf(39);
        if (forUpdateLastIndex > -1) {
            if (lastIndexOfQuote == -1) {
                return forUpdateLastIndex;
            }
            if (lastIndexOfQuote > forUpdateLastIndex) {
                return -1;
            }
            return forUpdateLastIndex;
        }
        return forUpdateLastIndex;
    }

    @Override
    public final boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return this.supportOffset;
    }

    @Override
    public boolean bindLimitParametersInReverseOrder() {
        return this.bindLimitParametersInReverseOrder;
    }

    @Override
    public boolean useMaxForLimit() {
        return this.useMaxForLimit;
    }
}

