/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.BinaryTranscoder;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.DefaultTranscoder;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.GlobalMarshallerEncoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.IdentityWrapper;
import org.infinispan.commons.dataconversion.JavaSerializationEncoder;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.TranscoderMarshallerAdapter;
import org.infinispan.commons.dataconversion.UTF8Encoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.encoding.ProtostreamTranscoder;
import org.infinispan.encoding.impl.JavaSerializationTranscoder;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.marshall.core.EncoderRegistryImpl;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;

@DefaultFactoryFor(classes={EncoderRegistry.class})
public class EncoderRegistryFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    @Inject
    @ComponentName(value="org.infinispan.marshaller.internal")
    ComponentRef<StreamingMarshaller> globalMarshaller;
    @Inject
    @ComponentName(value="org.infinispan.marshaller.user")
    Marshaller userMarshaller;
    @Inject
    EmbeddedCacheManager embeddedCacheManager;
    @Inject
    SerializationContextRegistry ctxRegistry;

    @Override
    public Object construct(String componentName) {
        ClassLoader classLoader = this.globalConfiguration.classLoader();
        EncoderRegistryImpl encoderRegistry = new EncoderRegistryImpl();
        ClassAllowList classAllowList = this.embeddedCacheManager.getClassAllowList();
        encoderRegistry.registerEncoder((Encoder)IdentityEncoder.INSTANCE);
        encoderRegistry.registerEncoder((Encoder)UTF8Encoder.INSTANCE);
        encoderRegistry.registerEncoder((Encoder)new JavaSerializationEncoder(classAllowList));
        encoderRegistry.registerEncoder((Encoder)new GlobalMarshallerEncoder((Marshaller)this.globalMarshaller.wired()));
        encoderRegistry.registerTranscoder((Transcoder)new DefaultTranscoder(this.userMarshaller));
        encoderRegistry.registerTranscoder((Transcoder)new BinaryTranscoder(this.userMarshaller));
        encoderRegistry.registerTranscoder((Transcoder)new ProtostreamTranscoder(this.ctxRegistry, classLoader));
        encoderRegistry.registerTranscoder((Transcoder)new JavaSerializationTranscoder(classAllowList));
        encoderRegistry.registerTranscoder((Transcoder)new TranscoderMarshallerAdapter((Marshaller)this.globalMarshaller.wired()));
        encoderRegistry.registerTranscoder((Transcoder)new TranscoderMarshallerAdapter(this.userMarshaller));
        encoderRegistry.registerWrapper((Wrapper)ByteArrayWrapper.INSTANCE);
        encoderRegistry.registerWrapper((Wrapper)IdentityWrapper.INSTANCE);
        return encoderRegistry;
    }
}

