/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.protocol;

import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.protocol.ArtifactResolveType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLProtocolQNames;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLRequestAbstractParser;
import org.keycloak.saml.processing.core.parsers.util.SAMLParserUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;

public class SAMLArtifactResolveParser
extends SAMLRequestAbstractParser<ArtifactResolveType> {
    private static final SAMLArtifactResolveParser INSTANCE = new SAMLArtifactResolveParser();

    private SAMLArtifactResolveParser() {
        super(SAMLProtocolQNames.ARTIFACT_RESOLVE);
    }

    public static SAMLArtifactResolveParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected ArtifactResolveType instantiateElement(XMLEventReader xmlEventReader, StartElement startElement) throws ParsingException {
        SAMLParserUtil.validateAttributeValue(startElement, SAMLProtocolQNames.ATTR_VERSION, "2.0");
        String id = StaxParserUtil.getRequiredAttributeValue(startElement, SAMLProtocolQNames.ATTR_ID);
        XMLGregorianCalendar issueInstant = XMLTimeUtil.parse(StaxParserUtil.getRequiredAttributeValue(startElement, SAMLProtocolQNames.ATTR_ISSUE_INSTANT));
        ArtifactResolveType authnRequest = new ArtifactResolveType(id, issueInstant);
        super.parseBaseAttributes(startElement, authnRequest);
        return authnRequest;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, ArtifactResolveType target, SAMLProtocolQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case ISSUER: 
            case SIGNATURE: 
            case EXTENSIONS: {
                this.parseCommonElements(element, elementDetail, xmlEventReader, (RequestAbstractType)target);
                break;
            }
            case ARTIFACT: {
                StaxParserUtil.advance(xmlEventReader);
                target.setArtifact(StaxParserUtil.getElementText(xmlEventReader));
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

