/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.dev.devservices.ContainerInfo;
import io.quarkus.deployment.dev.devservices.ImageName;
import io.quarkus.deployment.dev.devservices.RunningContainer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class DevServicesComposeProjectBuildItem
extends SimpleBuildItem {
    public static final String COMPOSE_IGNORE = "io.quarkus.devservices.compose.ignore";
    private final String project;
    private final String defaultNetworkId;
    private final Map<String, List<RunningContainer>> composeServices;
    private final Map<String, String> config;

    public DevServicesComposeProjectBuildItem() {
        this(null, null, Collections.emptyMap(), Collections.emptyMap());
    }

    public DevServicesComposeProjectBuildItem(String project, String defaultNetworkId, Map<String, List<RunningContainer>> composeServices, Map<String, String> config) {
        this.project = project;
        this.defaultNetworkId = defaultNetworkId;
        this.composeServices = composeServices;
        this.config = config;
    }

    public String getProject() {
        return this.project;
    }

    public String getDefaultNetworkId() {
        return this.defaultNetworkId;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public Map<String, List<RunningContainer>> getComposeServices() {
        return this.composeServices;
    }

    public Optional<RunningContainer> locate(List<String> imagePartials, int port) {
        return this.locateContainers(imagePartials).filter(r -> Optional.ofNullable(r.containerInfo().exposedPorts()).map(ports -> Arrays.stream(ports).anyMatch(p -> Objects.equals(p.privatePort(), port))).isPresent()).findFirst();
    }

    public List<RunningContainer> locate(List<String> imagePartials) {
        return this.locateContainers(imagePartials).toList();
    }

    public Optional<RunningContainer> locateFirst(List<String> imagePartials) {
        return this.locateContainers(imagePartials).findFirst();
    }

    private Stream<RunningContainer> locateContainers(List<String> imagePartials) {
        return imagePartials.stream().flatMap(imagePartial -> this.composeServices.values().stream().flatMap(Collection::stream).filter(c -> !DevServicesComposeProjectBuildItem.isContainerIgnored(c.containerInfo())).filter(runningContainer -> {
            String imageName = runningContainer.containerInfo().imageName();
            return imageName.contains((CharSequence)imagePartial) || ImageName.parse(imageName).withLibraryPrefix().toString().contains((CharSequence)imagePartial);
        }));
    }

    public static boolean isContainerIgnored(ContainerInfo containerInfo) {
        return Boolean.parseBoolean(containerInfo.labels().get(COMPOSE_IGNORE));
    }
}

