/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.options.JavaInspectionButtons;
import com.intellij.codeInsight.options.JavaInspectionControls;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.packageDependencies.ui.DependencyConfigurable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J-\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInspection/DependencyInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "EditDependencyRulesAction", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nDependencyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyInspection.kt\ncom/intellij/codeInspection/DependencyInspection\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,59:1\n37#2,2:60\n13805#3,2:62\n*S KotlinDebug\n*F\n+ 1 DependencyInspection.kt\ncom/intellij/codeInspection/DependencyInspection\n*L\n41#1:60,2\n33#1:62,2\n*E\n"})
public final class DependencyInspection
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{JavaInspectionControls.button((JavaInspectionButtons.ButtonKind)JavaInspectionButtons.ButtonKind.DEPENDENCY_CONFIGURATION)};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ProblemDescriptor[] problemDescriptorArray;
        DependencyValidationManager validationManager;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                DependencyValidationManager dependencyValidationManager = DependencyValidationManager.getInstance((Project)file.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)dependencyValidationManager, (String)"getInstance(...)");
                validationManager = dependencyValidationManager;
                if (!validationManager.hasRules()) break block5;
                DependencyRule[] dependencyRuleArray = validationManager.getApplicableRules(file);
                Intrinsics.checkNotNullExpressionValue((Object)dependencyRuleArray, (String)"getApplicableRules(...)");
                if (!(((Object[])dependencyRuleArray).length == 0)) break block6;
            }
            return null;
        }
        List problems = (List)new SmartList();
        Map map = FactoryMap.create(arg_0 -> DependencyInspection.checkFile$lambda$1(arg_0 -> DependencyInspection.checkFile$lambda$0(validationManager, file, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"create(...)");
        Map violations = map;
        DependenciesBuilder.analyzeFileDependencies((PsiFile)file, (arg_0, arg_1) -> DependencyInspection.checkFile$lambda$2(violations, problems, manager, isOnTheFly, arg_0, arg_1));
        if (problems.isEmpty()) {
            problemDescriptorArray = null;
        } else {
            Collection $this$toTypedArray$iv = problems;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            problemDescriptorArray = thisCollection$iv.toArray(new ProblemDescriptor[0]);
        }
        return problemDescriptorArray;
    }

    private static final DependencyRule[] checkFile$lambda$0(DependencyValidationManager $validationManager, PsiFile $file, PsiFile dependencyFile) {
        PsiFile psiFile = dependencyFile;
        Intrinsics.checkNotNull((Object)psiFile);
        return $validationManager.getViolatorDependencyRules($file, psiFile);
    }

    private static final DependencyRule[] checkFile$lambda$1(Function1 $tmp0, Object p0) {
        return (DependencyRule[])$tmp0.invoke(p0);
    }

    private static final void checkFile$lambda$2(Map $violations, List $problems, InspectionManager $manager, boolean $isOnTheFly, PsiElement place, PsiElement dependency) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
            PsiFile psiFile = dependency.getContainingFile();
            if (psiFile == null) break block2;
            PsiFile dependencyFile = psiFile;
            boolean bl = false;
            DependencyRule[] dependencyRuleArray = (DependencyRule[])$violations.get(dependencyFile);
            if (dependencyRuleArray != null) {
                DependencyRule[] $this$forEach$iv = dependencyRuleArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    DependencyRule element$iv;
                    DependencyRule dependencyRule = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    Object[] objectArray = new Object[]{dependencyRule.getDisplayText()};
                    String message = JvmAnalysisBundle.message("jvm.inspections.dependency.violator.problem.descriptor", objectArray);
                    EditDependencyRulesAction[] editDependencyRulesActionArray = new EditDependencyRulesAction[]{new EditDependencyRulesAction(dependencyRule)};
                    EditDependencyRulesAction[] fixes = editDependencyRulesActionArray;
                    ProblemDescriptor problemDescriptor = $manager.createProblemDescriptor(place, message, $isOnTheFly, (LocalQuickFix[])fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
                    $problems.add(problemDescriptor);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/codeInspection/DependencyInspection$EditDependencyRulesAction;", "Lcom/intellij/codeInspection/LocalQuickFix;", "myRule", "Lcom/intellij/packageDependencies/DependencyRule;", "<init>", "(Lcom/intellij/packageDependencies/DependencyRule;)V", "getName", "", "getFamilyName", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "intellij.jvm.analysis.impl"})
    private static final class EditDependencyRulesAction
    implements LocalQuickFix {
        @NotNull
        private final DependencyRule myRule;

        public EditDependencyRulesAction(@NotNull DependencyRule myRule) {
            Intrinsics.checkNotNullParameter((Object)myRule, (String)"myRule");
            this.myRule = myRule;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.myRule.getDisplayText()};
            String string = JvmAnalysisBundle.message("jvm.inspections.dependency.edit.rules.text", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JvmAnalysisBundle.message("jvm.inspections.dependency.edit.rules.family", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new DependencyConfigurable(project));
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
            return (IntentionPreviewInfo)new IntentionPreviewInfo.Html(JvmAnalysisBundle.message("jvm.inspections.dependency.intention.description", new Object[0]));
        }
    }
}

