/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.plugin.HashLookupListMode;
import ghidra.feature.fid.service.FidMatchScore;

public class HashMatch
implements FidMatchScore {
    private final FunctionRecord functionRecord;
    private final float primaryFunctionCodeUnitScore;
    private final HashLookupListMode primaryFunctionMatchMode;
    private final float childFunctionCodeUnitScore;
    private final float parentFunctionCodeUnitScore;

    public HashMatch(FunctionRecord functionRecord, float primaryFunctionCodeUnitScore, HashLookupListMode primaryFunctionMatchMode, float childFunctionCodeUnitScore, float parentFunctionCodeUnitScore) {
        this.functionRecord = functionRecord;
        this.primaryFunctionCodeUnitScore = primaryFunctionCodeUnitScore;
        this.primaryFunctionMatchMode = primaryFunctionMatchMode;
        this.childFunctionCodeUnitScore = childFunctionCodeUnitScore;
        this.parentFunctionCodeUnitScore = parentFunctionCodeUnitScore;
    }

    @Override
    public FunctionRecord getFunctionRecord() {
        return this.functionRecord;
    }

    @Override
    public float getPrimaryFunctionCodeUnitScore() {
        return this.primaryFunctionCodeUnitScore;
    }

    @Override
    public HashLookupListMode getPrimaryFunctionMatchMode() {
        return this.primaryFunctionMatchMode;
    }

    @Override
    public float getChildFunctionCodeUnitScore() {
        return this.childFunctionCodeUnitScore;
    }

    @Override
    public float getParentFunctionCodeUnitScore() {
        return this.parentFunctionCodeUnitScore;
    }

    public String toString() {
        return String.format("%.1f - %.1f (%s)/%.1f/%.1f %s", new Object[]{Float.valueOf(this.getOverallScore()), Float.valueOf(this.primaryFunctionCodeUnitScore), this.primaryFunctionMatchMode, Float.valueOf(this.childFunctionCodeUnitScore), Float.valueOf(this.parentFunctionCodeUnitScore), this.functionRecord.toString()});
    }

    @Override
    public float getOverallScore() {
        return this.primaryFunctionCodeUnitScore + this.childFunctionCodeUnitScore + this.parentFunctionCodeUnitScore;
    }
}

