/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.module.TraceObjectSection;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceObjectModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.info.TraceObjectInterfaceUtils;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import ghidra.trace.model.target.schema.TraceObjectSchema;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;

public class DBTraceObjectModule
implements TraceObjectModule,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final ModuleChangeTranslator translator;

    public DBTraceObjectModule(DBTraceObject object) {
        this.object = object;
        this.translator = new ModuleChangeTranslator(this, object, this);
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public TraceSection addSection(long snap, String sectionPath, String sectionName, AddressRange range) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            DBTraceObjectManager manager = this.object.getManager();
            KeyPath sectionKeyList = KeyPath.parse(sectionPath);
            if (!this.object.getCanonicalPath().isAncestor(sectionKeyList)) {
                throw new IllegalArgumentException("Section path must be a successor of this module's path");
            }
            TraceObjectSection traceObjectSection = manager.addSection(sectionPath, sectionName, Lifespan.nowOn(snap), range);
            return traceObjectSection;
        }
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public void setName(Lifespan lifespan, String name) {
        this.object.setValue(lifespan, "_module_name", name);
    }

    @Override
    public void setName(long snap, String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setName(Lifespan.nowOn(snap), name);
        }
    }

    @Override
    public String getName(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_module_name", String.class, "");
    }

    @Override
    public void setRange(Lifespan lifespan, AddressRange range) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(lifespan, "_range", range);
        }
    }

    @Override
    public void setRange(long snap, AddressRange range) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(Lifespan.nowOn(snap), range);
        }
    }

    @Override
    public AddressRange getRange(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            AddressRange addressRange = TraceObjectInterfaceUtils.getValue(this.object, snap, "_range", AddressRange.class, null);
            return addressRange;
        }
    }

    @Override
    public void setBase(long snap, Address base) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(snap, DBTraceUtils.toRange(base, this.getMaxAddress(snap)));
        }
    }

    @Override
    public Address getBase(long snap) {
        AddressRange range = this.getRange(snap);
        return range == null ? null : range.getMinAddress();
    }

    @Override
    public void setMaxAddress(long snap, Address max) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(snap, DBTraceUtils.toRange(this.getBase(snap), max));
        }
    }

    @Override
    public Address getMaxAddress(long snap) {
        AddressRange range = this.getRange(snap);
        return range == null ? null : range.getMaxAddress();
    }

    @Override
    public void setLength(long snap, long length) throws AddressOverflowException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(snap, (AddressRange)new AddressRangeImpl(this.getBase(snap), length));
        }
    }

    @Override
    public long getLength(long snap) {
        AddressRange range = this.getRange(snap);
        return range == null ? 0L : range.getLength();
    }

    @Override
    public Collection<? extends TraceObjectSection> getSections(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Collection collection = this.object.querySuccessorsInterface(Lifespan.at(snap), TraceObjectSection.class, true).collect(Collectors.toSet());
            return collection;
        }
    }

    @Override
    public Collection<? extends TraceSection> getAllSections() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Collection collection = this.object.querySuccessorsInterface(Lifespan.ALL, TraceObjectSection.class, true).collect(Collectors.toSet());
            return collection;
        }
    }

    @Override
    public TraceObjectSection getSectionByName(long snap, String sectionName) {
        PathFilter filter = this.object.getSchema().searchFor(TraceObjectSection.class, true);
        PathFilter applied = filter.applyKeys(PathFilter.Align.LEFT, List.of(sectionName));
        return this.object.getSuccessors(Lifespan.at(snap), applied).map(p -> p.getDestination(this.object).queryInterface(TraceObjectSection.class)).findAny().orElse(null);
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.ALL);
        }
    }

    @Override
    public void remove(long snap) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(Lifespan.nowOn(snap));
        }
    }

    @Override
    public boolean isValid(long snap) {
        return this.object.isAlive(snap);
    }

    @Override
    public boolean isAlive(Lifespan span) {
        return this.object.isAlive(span);
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    protected class ModuleChangeTranslator
    extends DBTraceObjectInterface.Translator<TraceModule> {
        private static final Map<TraceObjectSchema, Set<String>> KEYS_BY_SCHEMA = new WeakHashMap<TraceObjectSchema, Set<String>>();
        private final Set<String> keys;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ModuleChangeTranslator(DBTraceObjectModule this$0, DBTraceObject object, TraceModule iface) {
            super("_range", object, iface);
            TraceObjectSchema schema = object.getSchema();
            Map<TraceObjectSchema, Set<String>> map = KEYS_BY_SCHEMA;
            synchronized (map) {
                this.keys = KEYS_BY_SCHEMA.computeIfAbsent(schema, s -> Set.of(s.checkAliasedAttribute("_range"), s.checkAliasedAttribute("_display")));
            }
        }

        @Override
        protected TraceEvent<TraceModule, Void> getAddedType() {
            return TraceEvents.MODULE_ADDED;
        }

        @Override
        protected TraceEvent<TraceModule, Lifespan> getLifespanChangedType() {
            return TraceEvents.MODULE_LIFESPAN_CHANGED;
        }

        @Override
        protected TraceEvent<TraceModule, Void> getChangedType() {
            return TraceEvents.MODULE_CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return this.keys.contains(key);
        }

        @Override
        protected TraceEvent<TraceModule, Void> getDeletedType() {
            return TraceEvents.MODULE_DELETED;
        }
    }
}

