/*
 * Decompiled with CFR 0.152.
 */
package pdb.symbolserver;

import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import pdb.symbolserver.FindOption;
import pdb.symbolserver.SymbolFileInfo;
import pdb.symbolserver.SymbolFileLocation;
import pdb.symbolserver.SymbolServer;

public abstract class AbstractSymbolServer
implements SymbolServer {
    protected static final String INDEX_TWO_FILENAME = "index2.txt";
    protected static final String PINGME_FILENAME = "pingme.txt";
    protected int storageLevel = -1;

    @Override
    public List<SymbolFileLocation> find(SymbolFileInfo symbolFileInfo, Set<FindOption> options, TaskMonitor monitor) {
        if (StringUtils.isBlank((CharSequence)symbolFileInfo.getName())) {
            Msg.warn((Object)this, (Object)("Unable to search for empty filename: " + String.valueOf(symbolFileInfo)));
            return List.of();
        }
        this.initStorageLevelIfNeeded(monitor);
        try {
            String uniqueFileDir = this.getUniqueFileDir(symbolFileInfo);
            String filePath = this.getFirstExists(uniqueFileDir, monitor, symbolFileInfo.getName(), AbstractSymbolServer.getCompressedFilename(symbolFileInfo));
            return filePath != null ? List.of(new SymbolFileLocation(filePath, this, symbolFileInfo)) : List.of();
        }
        catch (IOException ioe) {
            Msg.warn((Object)this, (Object)("Error searching for " + symbolFileInfo.getName()), (Throwable)ioe);
            return List.of();
        }
    }

    protected int detectStorageLevel(TaskMonitor monitor) {
        return this.exists(INDEX_TWO_FILENAME, monitor) ? 2 : 1;
    }

    protected void initStorageLevelIfNeeded(TaskMonitor monitor) {
        if (this.storageLevel < 0) {
            this.storageLevel = this.detectStorageLevel(monitor);
        }
    }

    protected String getFileDir(String filename) throws IOException {
        switch (this.storageLevel) {
            case 0: {
                return "";
            }
            case 1: {
                return filename + "/";
            }
            case 2: {
                if (filename.length() <= 2) {
                    throw new IOException("Symbol filename too short to store in two-level index: " + filename);
                }
                return filename.substring(0, 2).toLowerCase() + "/" + filename + "/";
            }
        }
        throw new IllegalArgumentException("Unsupported Symbol Server storage level: " + this.storageLevel);
    }

    protected String getUniqueFileDir(SymbolFileInfo symbolFileInfo) throws IOException {
        switch (this.storageLevel) {
            case 0: {
                return "";
            }
            case 1: 
            case 2: {
                String fileRoot = this.getFileDir(symbolFileInfo.getName());
                String uniqueFileDir = fileRoot + symbolFileInfo.getUniqueDirName() + "/";
                return uniqueFileDir;
            }
        }
        throw new IllegalArgumentException("Unsupported Symbol Server storage level: " + this.storageLevel);
    }

    protected String getFirstExists(String subDir, TaskMonitor monitor, String ... filenames) {
        for (String filename : filenames) {
            String pathname = subDir + filename;
            if (!this.exists(pathname, monitor)) continue;
            return pathname;
        }
        return null;
    }

    static String makeCompressedExtension(String fileTypeExtension) {
        return (!fileTypeExtension.isEmpty() ? fileTypeExtension.substring(0, fileTypeExtension.length() - 1) : "") + "_";
    }

    static String getCompressedFilename(SymbolFileInfo symbolFileInfo) {
        return FilenameUtils.getBaseName((String)symbolFileInfo.getName()) + "." + AbstractSymbolServer.makeCompressedExtension(FilenameUtils.getExtension((String)symbolFileInfo.getName()));
    }

    static String getCompressedFilename(String filename) {
        return FilenameUtils.getBaseName((String)filename) + "." + AbstractSymbolServer.makeCompressedExtension(FilenameUtils.getExtension((String)filename));
    }
}

