/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.security;

import ghidra.framework.remote.GhidraPrincipal;
import ghidra.server.UserManager;
import ghidra.server.security.AuthenticationModule;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class Krb5ActiveDirectoryAuthenticationModule
implements AuthenticationModule {
    private boolean allowUserToSpecifyName;
    private String domainName;
    private boolean stripDomainFromUsername = true;
    private static final String SRV_RECORD_TYPE = "SRV";

    public Krb5ActiveDirectoryAuthenticationModule(String domainName, boolean allowUserToSpecifyName) throws IllegalArgumentException {
        this.domainName = domainName;
        this.allowUserToSpecifyName = allowUserToSpecifyName;
        if (domainName == null || domainName.isBlank()) {
            throw new IllegalArgumentException("Missing domain name");
        }
        String loginServer = null;
        try {
            InetSocketAddress dc = Krb5ActiveDirectoryAuthenticationModule.getFirstDomainController(domainName);
            loginServer = dc.getHostName();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (loginServer == null) {
            throw new IllegalArgumentException("No domain controller for " + domainName);
        }
        System.setProperty("java.security.krb5.realm", domainName.toUpperCase());
        System.setProperty("java.security.krb5.kdc", loginServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String authenticate(UserManager userMgr, Subject subject, Callback[] ghidra_callbacks) throws LoginException {
        GhidraPrincipal principal = GhidraPrincipal.getGhidraPrincipal((Subject)subject);
        AtomicReference userName = new AtomicReference();
        NameCallback srcNcb = AuthenticationModule.getFirstCallbackOfType(NameCallback.class, ghidra_callbacks);
        PasswordCallback srcPcb = AuthenticationModule.getFirstCallbackOfType(PasswordCallback.class, ghidra_callbacks);
        try {
            LoginContext lc = new LoginContext("", null, loginmodule_callbacks -> {
                String tmpName;
                String string = tmpName = this.allowUserToSpecifyName && srcNcb != null ? srcNcb.getName() : principal.getName();
                if (this.stripDomainFromUsername && tmpName.contains("\\")) {
                    tmpName = tmpName.replaceFirst("^.*\\\\", "");
                }
                if (tmpName == null || srcPcb == null || tmpName.isBlank()) {
                    throw new IOException("Missing username or password values");
                }
                NameCallback destNcb = AuthenticationModule.getFirstCallbackOfType(NameCallback.class, loginmodule_callbacks);
                PasswordCallback destPcb = AuthenticationModule.getFirstCallbackOfType(PasswordCallback.class, loginmodule_callbacks);
                if (destNcb != null) {
                    destNcb.setName(tmpName);
                }
                if (destPcb != null) {
                    destPcb.setPassword(srcPcb.getPassword());
                }
                userName.set(tmpName);
            }, new JAASConfiguration("com.sun.security.auth.module.Krb5LoginModule"));
            try {
                lc.login();
            }
            catch (LoginException e) {
                if (e instanceof FailedLoginException) {
                    throw e;
                }
                throw new FailedLoginException(e.getMessage());
            }
        }
        finally {
            if (srcPcb != null) {
                srcPcb.clearPassword();
            }
        }
        return (String)userName.get();
    }

    @Override
    public Callback[] getAuthenticationCallbacks() {
        return AuthenticationModule.createSimpleNamePasswordCallbacks(this.allowUserToSpecifyName);
    }

    @Override
    public boolean anonymousCallbacksAllowed() {
        return false;
    }

    @Override
    public boolean isNameCallbackAllowed() {
        return this.allowUserToSpecifyName;
    }

    private static InetSocketAddress getFirstDomainController(String domainName) throws NamingException {
        InitialDirContext ctx = new InitialDirContext();
        Attributes attributes = ctx.getAttributes("dns:/_ldap._tcp.dc._msdcs." + domainName, new String[]{SRV_RECORD_TYPE});
        if (attributes.get(SRV_RECORD_TYPE) == null) {
            return null;
        }
        String srvRec = attributes.get(SRV_RECORD_TYPE).get().toString();
        String[] recParts = srvRec.split("\\s+", -1);
        int port = Integer.parseInt(recParts[2]);
        String host = recParts[3];
        return new InetSocketAddress(host, port);
    }

    private static class JAASConfiguration
    extends Configuration {
        private AppConfigurationEntry staticConfigEntry;
        private Map<String, Object> options = new HashMap<String, Object>();

        public JAASConfiguration(String loginModuleClassName) {
            this.staticConfigEntry = new AppConfigurationEntry(loginModuleClassName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, this.options);
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return new AppConfigurationEntry[]{this.staticConfigEntry};
        }

        public void addOption(String name, Object value) {
            this.options.put(name, value);
        }
    }
}

