/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseShorthandSetter;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.InheritValue;
import io.sf.carte.doc.style.css.property.InitialValue;
import io.sf.carte.doc.style.css.property.KeywordValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RevertValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.UnsetValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.ValueItem;
import io.sf.carte.doc.style.css.property.ValueList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.w3c.dom.DOMException;

class ShorthandSetter
extends BaseShorthandSetter {
    private static CSSValueSyntax imageSyntax = new SyntaxParser().parseSyntax("<image>");
    private boolean priorityImportant = false;
    final ValueFactory valueFactory;
    private final HashMap<String, StyleValue> mypropValue = new HashMap();
    private final List<String> mypropertyList = new ArrayList<String>();
    private final List<Boolean> mypriorities = new ArrayList<Boolean>();
    protected LexicalUnit currentValue = null;
    private final StringBuilder valueBuffer = new StringBuilder(40);
    private final StringBuilder miniValueBuffer = new StringBuilder(40);
    private transient boolean attrTainted;
    private final ArrayList<String> unassignedProperties = new ArrayList(6);

    ShorthandSetter(BaseCSSStyleDeclaration style, String shorthandName) {
        super(style, shorthandName);
        this.valueFactory = style.getValueFactory();
    }

    public boolean isPriorityImportant() {
        return this.priorityImportant;
    }

    String getPriority() {
        return this.priorityImportant ? "important" : null;
    }

    void setPriority(boolean important) {
        this.priorityImportant = important;
    }

    protected boolean isAttrTainted() {
        return this.attrTainted;
    }

    @Override
    public void setAttrTainted(boolean attrTainted) {
        this.attrTainted = attrTainted;
    }

    boolean hasCompatValue() {
        for (LexicalUnit lu = this.currentValue; lu != null; lu = lu.getNextLexicalUnit()) {
            LexicalUnit.LexicalType type = lu.getLexicalUnitType();
            if (type != LexicalUnit.LexicalType.COMPAT_IDENT && type != LexicalUnit.LexicalType.COMPAT_PRIO) continue;
            return true;
        }
        return false;
    }

    void addUnassignedProperty(String propertyName) {
        this.unassignedProperties.add(propertyName);
    }

    List<String> getUnassignedProperties() {
        return this.unassignedProperties;
    }

    boolean scanUnassigned(List<LexicalUnit> unassignedValues) {
        block0: for (LexicalUnit lu : unassignedValues) {
            StyleDeclarationErrorHandler errHandler;
            List<String> unass;
            String property;
            Iterator<String> it;
            if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
                if (!this.isNotValidIdentifier(lu)) continue;
                String sv = lu.getStringValue();
                it = this.getUnassignedProperties().iterator();
                while (it.hasNext()) {
                    property = it.next();
                    if (!property.endsWith("-color") || !sv.endsWith("-color")) continue;
                    this.setSubpropertyValue(property, this.createCSSValue(property, lu));
                    it.remove();
                    continue block0;
                }
            } else if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.FUNCTION) {
                unass = this.getUnassignedProperties();
                it = unass.iterator();
                while (it.hasNext()) {
                    property = it.next();
                    if (!property.endsWith("-color")) continue;
                    for (LexicalUnit param = lu.getParameters(); param != null; param = param.getNextLexicalUnit()) {
                        if (!BaseCSSStyleDeclaration.testColor(param)) continue;
                        this.setSubpropertyValue(property, this.createCSSValue(property, lu));
                        it.remove();
                        continue block0;
                    }
                }
            } else if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                unass = this.getUnassignedProperties();
                it = unass.iterator();
                while (it.hasNext()) {
                    property = it.next();
                    if (property.endsWith("-color")) {
                        if (unass.size() != 1) continue;
                        this.setSubpropertyValue(property, this.createCSSValue(property, lu));
                        it.remove();
                        break block0;
                    }
                    if (!property.endsWith("-image") || unass.size() != 1) continue;
                    this.setSubpropertyValue(property, this.createCSSValue(property, lu));
                    it.remove();
                    break block0;
                }
            }
            if ((errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler()) != null) {
                errHandler.unassignedShorthandValue(this.getShorthandName(), lu.toString());
            }
            return false;
        }
        return true;
    }

    byte scanForCssWideKeywords(LexicalUnit lunit) {
        KeywordValue kwval = this.createKeywordValueSubproperty(lunit);
        if (kwval != null) {
            if (lunit.getNextLexicalUnit() != null) {
                this.reportMixedKeywords(kwval.getCssText());
                return 2;
            }
            this.setSubpropertiesToKeyword(kwval);
            this.initValueString();
            this.appendValueItemString(kwval);
            return 1;
        }
        return 0;
    }

    KeywordValue createKeywordValueSubproperty(LexicalUnit lunit) {
        KeywordValue kwval;
        switch (lunit.getLexicalUnitType()) {
            case INHERIT: {
                kwval = InheritValue.getValue().asSubproperty();
                break;
            }
            case INITIAL: {
                kwval = InitialValue.getValue().asSubproperty();
                break;
            }
            case UNSET: {
                kwval = UnsetValue.getValue().asSubproperty();
                break;
            }
            case REVERT: {
                kwval = RevertValue.getValue().asSubproperty();
                break;
            }
            default: {
                kwval = null;
            }
        }
        return kwval;
    }

    private void reportMixedKeywords(String keyword) {
        StyleDeclarationErrorHandler errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler();
        if (errHandler != null) {
            errHandler.shorthandError(this.getShorthandName(), "Found '" + keyword + "' keyword mixed with other values");
        }
    }

    protected void setSubpropertiesToKeyword(StyleValue keyword) {
        String[] subparray;
        for (String subp : subparray = this.getShorthandSubproperties()) {
            String[] sh;
            if (!this.getShorthandDatabase().isShorthand(subp)) {
                this.styleDeclaration.setProperty(subp, keyword, this.isPriorityImportant());
                continue;
            }
            for (String s : sh = this.getShorthandDatabase().getShorthandSubproperties(subp)) {
                this.styleDeclaration.setProperty(s, keyword, this.isPriorityImportant());
            }
        }
    }

    void setListSubpropertyValue(String pname, ValueList list) {
        if (list.getLength() == 1) {
            StyleValue val = list.item(0);
            if (val.isPrimitiveValue()) {
                ((PrimitiveValue)val).setSubproperty(true);
            } else {
                CSSValue.CssType cat = val.getCssValueType();
                if (cat == CSSValue.CssType.KEYWORD) {
                    val = ((KeywordValue)val).asSubproperty();
                } else if (cat == CSSValue.CssType.LIST) {
                    ((ValueList)val).setSubproperty(true);
                }
            }
            this.setSubpropertyValue(pname, val);
        } else {
            list.setSubproperty(true);
            this.setSubpropertyValue(pname, list);
        }
    }

    protected String[] getShorthandSubproperties() {
        return this.getShorthandDatabase().getShorthandSubproperties(this.getShorthandName());
    }

    protected void nextCurrentValue() {
        if (this.currentValue != null) {
            this.currentValue = this.currentValue.getNextLexicalUnit();
            this.appendValueItemString();
        }
    }

    @Override
    public void init(LexicalUnit shorthandValue, boolean important) {
        this.currentValue = shorthandValue;
        this.setPriority(important);
        this.unassignedProperties.clear();
        this.initValueString();
        this.appendValueItemString();
    }

    protected void resetSubproperties() {
        List<String> props = this.getUnassignedProperties();
        for (String pname : props) {
            String[] longhands;
            if (!this.getShorthandDatabase().isShorthand(pname)) {
                this.setPropertyToDefault(pname);
                continue;
            }
            for (String longhand : longhands = this.getShorthandDatabase().getShorthandSubproperties(pname)) {
                this.setPropertyToDefault(longhand);
            }
        }
    }

    protected void setSubpropertiesToDefault() {
        String[] subp;
        for (String pname : subp = this.getShorthandSubproperties()) {
            String[] longhands;
            if (!this.getShorthandDatabase().isShorthand(pname)) {
                this.setPropertyToDefault(pname);
                continue;
            }
            for (String longhand : longhands = this.getShorthandDatabase().getShorthandSubproperties(pname)) {
                this.setPropertyToDefault(longhand);
            }
        }
    }

    StyleValue defaultPropertyValue(String propertyName) {
        StyleValue cssVal = this.styleDeclaration.defaultPropertyValue(propertyName);
        if (cssVal != null) {
            CSSValue.CssType type = cssVal.getCssValueType();
            if (type == CSSValue.CssType.TYPED) {
                ((PrimitiveValue)cssVal).setSubproperty(true);
            } else if (type == CSSValue.CssType.LIST) {
                ((ValueList)cssVal).setSubproperty(true);
            }
        } else {
            cssVal = InitialValue.getValue().asSubproperty();
        }
        return cssVal;
    }

    void setPropertyToDefault(String pname) {
        StyleValue cssVal = this.defaultPropertyValue(pname);
        this.setProperty(pname, cssVal, this.isPriorityImportant());
    }

    void setDeclarationPropertyToDefault(String propertyName) {
        StyleValue cssVal = this.defaultPropertyValue(propertyName);
        this.styleDeclaration.setProperty(propertyName, cssVal, this.isPriorityImportant());
    }

    protected List<String> subpropertyList() {
        String[] subparray = this.getShorthandSubproperties();
        ArrayList<String> subp = new ArrayList<String>(subparray.length);
        Collections.addAll(subp, subparray);
        return subp;
    }

    @Override
    public boolean assignSubproperties() {
        boolean result = this.draftSubproperties();
        if (result) {
            this.flush();
        }
        return result;
    }

    boolean draftSubproperties() {
        byte kwscan = this.scanForCssWideKeywords(this.currentValue);
        if (kwscan == 1) {
            return true;
        }
        if (kwscan == 2) {
            return false;
        }
        LinkedList<LexicalUnit> unassignedValues = new LinkedList<LexicalUnit>();
        List<String> subp = this.subpropertyList();
        while (this.currentValue != null) {
            boolean assigned = false;
            for (int i = 0; i < subp.size(); ++i) {
                String pname = subp.get(i);
                if (!this.assignSubproperty(pname)) continue;
                subp.remove(i);
                assigned = true;
                break;
            }
            if (assigned) continue;
            unassignedValues.add(this.currentValue);
            this.nextCurrentValue();
        }
        if (!subp.isEmpty()) {
            Iterator<String> it = subp.iterator();
            while (it.hasNext()) {
                this.addUnassignedProperty(it.next());
            }
        }
        if (!unassignedValues.isEmpty() && !this.scanUnassigned(unassignedValues)) {
            return false;
        }
        this.resetSubproperties();
        return true;
    }

    boolean isNotValidIdentifier(LexicalUnit lu) {
        return !lu.getStringValue().equalsIgnoreCase("none");
    }

    protected boolean assignSubproperty(String subproperty) {
        LexicalUnit.LexicalType lutype = this.currentValue.getLexicalUnitType();
        if (lutype == LexicalUnit.LexicalType.IDENT && this.assignIdentifiers(subproperty)) {
            return true;
        }
        if (subproperty.endsWith("-color") ? BaseCSSStyleDeclaration.testColor(this.currentValue) : (subproperty.endsWith("-width") ? ValueFactory.isSizeSACUnit(this.currentValue) : subproperty.endsWith("-image") && this.isImage())) {
            return this.setCurrentValue(subproperty);
        }
        return false;
    }

    boolean isImage() {
        LexicalUnit.LexicalType type = this.currentValue.getLexicalUnitType();
        return type == LexicalUnit.LexicalType.URI || type == LexicalUnit.LexicalType.SRC || type == LexicalUnit.LexicalType.FUNCTION && this.isImageFunctionOrGradientName() || type == LexicalUnit.LexicalType.ELEMENT_REFERENCE || this.currentValue.shallowClone().matches(imageSyntax) == CSSValueSyntax.Match.TRUE;
    }

    private boolean isImageFunctionOrGradientName() {
        String lcfn = this.currentValue.getFunctionName().toLowerCase(Locale.ROOT);
        return lcfn.endsWith("-gradient") || lcfn.equals("image") || lcfn.equals("image-set") || lcfn.equals("cross-fade");
    }

    boolean setCurrentValue(String subproperty) {
        StyleValue cssValue = this.createCSSValue(subproperty, this.currentValue);
        if (cssValue != null) {
            this.setSubpropertyValue(subproperty, cssValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    boolean assignIdentifiers(String subproperty) {
        if (this.testIdentifiers(subproperty)) {
            StyleValue cssValue = this.createCSSValue(subproperty, this.currentValue);
            this.setSubpropertyValue(subproperty, cssValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    boolean testIdentifiers(String subproperty) {
        return this.getShorthandDatabase().isIdentifierValue(subproperty, this.currentValue.getStringValue());
    }

    protected void setSubpropertyValue(String subproperty, StyleValue cssValue) {
        this.setProperty(subproperty, cssValue, this.isPriorityImportant());
    }

    void setSubpropertyValueWListCheck(String property, StyleValue value) {
        ValueList list;
        if (value.getCssValueType() == CSSValue.CssType.LIST && (list = (ValueList)value).getLength() == 1) {
            value = list.item(0);
        }
        this.setSubpropertyValue(property, value);
    }

    void addSubpropertyValue(String subproperty, StyleValue cssValue, boolean commaList) {
        StyleValue cssval = this.getDeclaredCSSValue(subproperty);
        if (cssval == null) {
            this.setSubpropertyValue(subproperty, cssValue);
        } else {
            switch (cssval.getCssValueType()) {
                case LIST: {
                    ((ValueList)cssval).add(cssValue);
                    cssValue = cssval;
                    break;
                }
                default: {
                    ValueList list = commaList ? ValueList.createCSValueList() : ValueList.createWSValueList();
                    list.add(cssval);
                    list.add(cssValue);
                    cssValue = list;
                }
            }
            this.setProperty(subproperty, cssValue, this.isPriorityImportant());
        }
    }

    void setProperty(String subpropertyName, StyleValue cssValue, boolean important) {
        this.mypropertyList.add(subpropertyName);
        this.mypriorities.add(important);
        this.mypropValue.put(subpropertyName, cssValue);
    }

    boolean isPropertySet(String subpropertyName) {
        return this.mypropertyList.contains(subpropertyName);
    }

    StyleValue getDeclaredCSSValue(String propertyName) {
        return this.mypropValue.get(propertyName);
    }

    void flush() {
        int i = 0;
        for (String myproperty : this.mypropertyList) {
            this.styleDeclaration.setProperty(myproperty, this.mypropValue.get(myproperty), (boolean)this.mypriorities.get(i));
            ++i;
        }
        this.mypropertyList.clear();
        this.mypriorities.clear();
        this.mypropValue.clear();
    }

    StyleValue createCSSValue() throws DOMException {
        StyleDeclarationErrorHandler errHandler;
        ValueItem item = this.valueFactory.createCSSValueItem(this.currentValue, true);
        if (item.hasWarnings() && (errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler()) != null) {
            item.handleSyntaxWarnings(errHandler);
        }
        this.currentValue = item.getNextLexicalUnit();
        return item.getCSSValue();
    }

    protected StyleValue createCSSValue(String propertyName, LexicalUnit lunit) throws DOMException {
        return this.createCSSValue(propertyName, lunit, true);
    }

    StyleValue createCSSValue(String propertyName, LexicalUnit lunit, boolean subproperty) throws DOMException {
        StyleDeclarationErrorHandler errHandler;
        ValueItem item = this.valueFactory.createCSSValueItem(lunit, subproperty);
        StyleValue cssVal = item.getCSSValue();
        if (item.hasWarnings() && (errHandler = this.styleDeclaration.getStyleDeclarationErrorHandler()) != null) {
            item.handleSyntaxWarnings(errHandler);
        }
        return cssVal;
    }

    void initValueString() {
        this.valueBuffer.setLength(0);
        this.miniValueBuffer.setLength(0);
    }

    void appendValueItemString(StyleValue cssValue) {
        if (cssValue != null) {
            String cssText = cssValue.getCssText();
            String miniCssText = cssValue.getMinifiedCssText(this.getShorthandName());
            StringBuilder buf = this.getValueItemBuffer();
            StringBuilder minibuf = this.getValueItemBufferMini();
            int len = buf.length();
            if (len != 0) {
                char c = buf.charAt(len - 1);
                if (!this.isDelimiterChar(c, miniCssText)) {
                    minibuf.append(' ');
                }
                buf.append(' ');
            }
            buf.append(cssText);
            minibuf.append(miniCssText);
        }
    }

    protected boolean isDelimiterChar(char c, String cssText) {
        return c == ',' || c == '/';
    }

    void appendValueItemString(String text) {
        this.getValueItemBuffer().append(text);
        this.getValueItemBufferMini().append(text);
    }

    protected void appendValueItemString() {
        if (this.currentValue != null) {
            this.valueFactory.appendValueString(this.getValueItemBuffer(), this.currentValue);
            this.valueFactory.appendMinifiedValueString(this.getValueItemBufferMini(), this.currentValue);
        }
    }

    StringBuilder getValueItemBuffer() {
        return this.valueBuffer;
    }

    StringBuilder getValueItemBufferMini() {
        return this.miniValueBuffer;
    }

    void appendToValueBuffer(StringBuilder buf, StringBuilder minibuf) {
        this.valueBuffer.append((CharSequence)buf);
        this.miniValueBuffer.append((CharSequence)minibuf);
    }

    @Override
    public String getCssText() {
        return this.valueBuffer.toString();
    }

    @Override
    public String getMinifiedCssText() {
        return this.miniValueBuffer.toString();
    }

    @Override
    public ShorthandValue createCSSShorthandValue(LexicalUnit value) {
        return ShorthandValue.createCSSShorthandValue(this.getShorthandDatabase(), this.getShorthandName(), value, this.isPriorityImportant(), this.attrTainted);
    }

    void reportDeclarationError(String propertyName, String message) {
        BaseCSSDeclarationRule prule = this.styleDeclaration.getParentRule();
        if (prule != null) {
            prule.getStyleDeclarationErrorHandler().shorthandError(propertyName, message);
        }
    }
}

