/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;

class PresentationKeyEventDispatcher
implements KeyEventDispatcher,
IFreeplanePropertyListener {
    private final KeyEventDispatcher delegate;
    private final String propertyName;
    private boolean isPresentationRunning;
    private boolean processKeys;

    public PresentationKeyEventDispatcher(String propertyName, KeyEventDispatcher delegate, boolean processKeys) {
        this.propertyName = propertyName;
        this.delegate = delegate;
        this.isPresentationRunning = false;
        this.processKeys = processKeys;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (!this.isPresentationRunning || !this.processKeys) {
            return false;
        }
        return this.delegate.dispatchKeyEvent(e);
    }

    public void activate() {
        this.isPresentationRunning = true;
    }

    public void deactivate() {
        this.isPresentationRunning = false;
    }

    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (this.propertyName.equals(propertyName)) {
            this.processKeys = Boolean.parseBoolean(newValue);
        }
    }

    static PresentationKeyEventDispatcher of(KeyEventDispatcher upDownKeyEventDispatcher, String propertyName) {
        ResourceController resourceController = ResourceController.getResourceController();
        boolean processKeys = ResourceController.getResourceController().getBooleanProperty(propertyName);
        PresentationKeyEventDispatcher presentationKeyEventDispatcher = new PresentationKeyEventDispatcher(propertyName, upDownKeyEventDispatcher, processKeys);
        resourceController.addPropertyChangeListener((IFreeplanePropertyListener)presentationKeyEventDispatcher);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(presentationKeyEventDispatcher);
        resourceController.addPropertyChangeListener((IFreeplanePropertyListener)presentationKeyEventDispatcher);
        return presentationKeyEventDispatcher;
    }
}

