/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;

public abstract class RequestFilterValve
extends ValveBase {
    protected volatile Pattern allow = null;
    protected volatile String allowValue = null;
    protected volatile boolean allowValid = true;
    protected volatile Pattern deny = null;
    protected volatile String denyValue = null;
    protected volatile boolean denyValid = true;
    protected int denyStatus = 403;
    private boolean invalidAuthenticationWhenDeny = false;
    private volatile boolean addConnectorPort = false;
    private volatile boolean usePeerAddress = false;

    public RequestFilterValve() {
        super(true);
    }

    public String getAllow() {
        return this.allowValue;
    }

    public void setAllow(String string) {
        if (string == null || string.isEmpty()) {
            this.allow = null;
            this.allowValue = null;
            this.allowValid = true;
        } else {
            boolean bl = false;
            try {
                this.allowValue = string;
                this.allow = Pattern.compile(string);
                bl = true;
            }
            finally {
                this.allowValid = bl;
            }
        }
    }

    public String getDeny() {
        return this.denyValue;
    }

    public void setDeny(String string) {
        if (string == null || string.isEmpty()) {
            this.deny = null;
            this.denyValue = null;
            this.denyValid = true;
        } else {
            boolean bl = false;
            try {
                this.denyValue = string;
                this.deny = Pattern.compile(string);
                bl = true;
            }
            finally {
                this.denyValid = bl;
            }
        }
    }

    public final boolean isAllowValid() {
        return this.allowValid;
    }

    public final boolean isDenyValid() {
        return this.denyValid;
    }

    public int getDenyStatus() {
        return this.denyStatus;
    }

    public void setDenyStatus(int n) {
        this.denyStatus = n;
    }

    public boolean getInvalidAuthenticationWhenDeny() {
        return this.invalidAuthenticationWhenDeny;
    }

    public void setInvalidAuthenticationWhenDeny(boolean bl) {
        this.invalidAuthenticationWhenDeny = bl;
    }

    public boolean getAddConnectorPort() {
        return this.addConnectorPort;
    }

    public void setAddConnectorPort(boolean bl) {
        this.addConnectorPort = bl;
    }

    public boolean getUsePeerAddress() {
        return this.usePeerAddress;
    }

    public void setUsePeerAddress(boolean bl) {
        this.usePeerAddress = bl;
    }

    @Override
    public abstract void invoke(Request var1, Response var2) throws IOException, ServletException;

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (!this.allowValid || !this.denyValid) {
            throw new LifecycleException(sm.getString("requestFilterValve.configInvalid"));
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (!this.allowValid || !this.denyValid) {
            throw new LifecycleException(sm.getString("requestFilterValve.configInvalid"));
        }
        super.startInternal();
    }

    protected void process(String string, Request request, Response response) throws IOException, ServletException {
        if (this.isAllowed(string)) {
            this.getNext().invoke(request, response);
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)sm.getString("requestFilterValve.deny", new Object[]{request.getRequestURI(), string}));
        }
        this.denyRequest(request, response);
    }

    protected abstract Log getLog();

    protected void denyRequest(Request request, Response response) throws IOException, ServletException {
        Context context;
        if (this.invalidAuthenticationWhenDeny && (context = request.getContext()) != null && context.getPreemptiveAuthentication()) {
            if (request.getCoyoteRequest().getMimeHeaders().getValue("authorization") == null) {
                request.getCoyoteRequest().getMimeHeaders().addValue("authorization").setString("invalid");
            }
            this.getNext().invoke(request, response);
            return;
        }
        response.sendError(this.denyStatus);
    }

    public boolean isAllowed(String string) {
        Pattern pattern = this.deny;
        Pattern pattern2 = this.allow;
        if (pattern != null && pattern.matcher(string).matches()) {
            return false;
        }
        if (pattern2 != null && pattern2.matcher(string).matches()) {
            return true;
        }
        return pattern != null && pattern2 == null;
    }
}

