/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CharAccessor;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CMarshaller;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.ROWID;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CCharAccessor
extends CharAccessor
implements T4CAccessor {
    T4CMAREngine mare;
    boolean underlyingLong;
    private T4CMarshaller marshaller;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;

    T4CCharAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, forBind);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$27, null, stmt, max_len, form, external_type, forBind, _mare);
            }
            this.underlyingLong = false;
            this.marshaller = null;
            this.mare = _mare;
            this.calculateSizeTmpByteArray();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$27, null);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$27, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$27, null, throwable2);
            }
            throw throwable;
        }
    }

    T4CCharAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int maxCodePointLen, int _oacmxl, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, maxCodePointLen);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$28, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$28, null, stmt, max_len, nullable, flags, precision, scale, contflag, total_elems, form, maxCodePointLen, _oacmxl, _definedColumnType, _definedColumnSize, _mare);
            }
            this.underlyingLong = false;
            this.marshaller = null;
            this.mare = _mare;
            this.definedColumnType = _definedColumnType;
            this.definedColumnSize = _definedColumnSize;
            this.calculateSizeTmpByteArray();
            this.oacmxl = _oacmxl;
            if (this.oacmxl == -1) {
                this.underlyingLong = true;
                this.oacmxl = 4000;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$28, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$28, null);
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$28, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$28, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$28, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public T4CMAREngine getMAREngine() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$0, this, new Object[0]);
            }
            T4CMAREngine t4CMAREngine = this.mare;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$0, this, t4CMAREngine);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$0, this, null);
            }
            return t4CMAREngine;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void unmarshalColumnMetadata() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$1, this, new Object[0]);
            }
            if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
                this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processIndicator(int n2) throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$2, this, n2);
            }
            if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
                this.mare.unmarshalSB2();
                this.mare.unmarshalUB2();
            } else if (this.statement.connection.versionNumber < 9200) {
                this.mare.unmarshalSB2();
                if (!this.statement.sqlKind.isPlsqlOrCall()) {
                    this.mare.unmarshalSB2();
                }
            } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
                void size;
                this.mare.processIndicator(size <= 0, (int)size);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    int getPreviousRowProcessed() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            int n2 = this.previousRowProcessed;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$3, this, n2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$3, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmt;
            void dba;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$4, this, byteArray, oracleStatement);
            }
            this.rowData = dba;
            this.mare = ((T4CConnection)stmt.connection).mare;
            this.rowNull = null;
            this.setCapacity(stmt.getFetchSize());
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    void copyRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if (this.isNullByDescribe || this.previousRowProcessed == -1) {
                this.setNull(this.lastRowProcessed, true);
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            } else if (this.lastRowProcessed == 0) {
                if (this.previousRowProcessed == -1) {
                    this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
                }
                long previousOffset = this.getOffset(this.previousRowProcessed);
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                if (!this.isNull(this.previousRowProcessed)) {
                    this.setOffset(this.lastRowProcessed);
                    ((DynamicByteArray)this.rowData).copyLeft(previousOffset, this.getLength(this.previousRowProcessed));
                    this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
                }
            } else if (this.lastCopyRow == this.previousRowProcessed) {
                this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
                this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
                this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
                this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
            } else {
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
            this.previousRowProcessed = this.lastRowProcessed++;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$6, this, new Object[0]);
            }
            boolean bl2 = this.getMarshaller().unmarshalOneRow(this);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$6, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$6, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    int readStreamFromWire(byte[] byArray, int n2, int n3, int[] nArray, boolean[] blArray, boolean[] blArray2, T4CMAREngine t4CMAREngine, T4CTTIoer11 t4CTTIoer11) throws SQLException, IOException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void oer;
            void mare;
            void readAsNonStreamArr;
            void readHeaderArr;
            void escapeSequenceArr;
            void length;
            void offset;
            void buffer;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$7, this, byArray, n2, n3, nArray, blArray, blArray2, t4CMAREngine, t4CTTIoer11);
            }
            int n4 = this.getMarshaller().readStreamFromWire((byte[])buffer, (int)offset, (int)length, (int[])escapeSequenceArr, (boolean[])readHeaderArr, (boolean[])readAsNonStreamArr, (T4CMAREngine)mare, (T4CTTIoer11)oer);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$7, this, n4);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$7, this, null);
            }
            return n4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    NUMBER getNUMBER(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$8, this, n2);
            }
            NUMBER result = null;
            if (this.definedColumnType == 0) {
                result = super.getNUMBER((int)currentRow);
            } else {
                String s2 = this.getString((int)currentRow);
                if (s2 != null) {
                    NUMBER nUMBER = T4CVarcharAccessor.StringToNUMBER(s2.trim());
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$8, this, nUMBER);
                        ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$8, this, null);
                    }
                    return nUMBER;
                }
            }
            NUMBER nUMBER = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$8, this, nUMBER);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$8, this, null);
            }
            return nUMBER;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    DATE getDATE(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$9, this, n2);
            }
            DATE result = null;
            if (this.definedColumnType == 0) {
                result = super.getDATE((int)currentRow);
            } else {
                Date d2 = this.getDate((int)currentRow);
                if (d2 != null) {
                    result = new DATE(d2);
                }
            }
            DATE dATE = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$9, this, dATE);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$9, this, null);
            }
            return dATE;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$10, this, n2);
            }
            TIMESTAMP result = null;
            if (this.definedColumnType == 0) {
                result = super.getTIMESTAMP((int)currentRow);
            } else {
                String s2 = this.getString((int)currentRow);
                if (s2 != null) {
                    int[] nanos = new int[1];
                    Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nanos);
                    Timestamp ts = new Timestamp(cal.getTimeInMillis());
                    ts.setNanos(nanos[0]);
                    result = new TIMESTAMP(ts);
                }
            }
            TIMESTAMP tIMESTAMP = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$10, this, tIMESTAMP);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$10, this, null);
            }
            return tIMESTAMP;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$11, this, n2);
            }
            TIMESTAMPTZ result = null;
            if (this.definedColumnType == 0) {
                result = super.getTIMESTAMPTZ((int)currentRow);
            } else {
                String s2 = this.getString((int)currentRow);
                if (s2 != null) {
                    int[] nanos = new int[1];
                    Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                    Timestamp ts = new Timestamp(cal.getTimeInMillis());
                    ts.setNanos(nanos[0]);
                    result = new TIMESTAMPTZ((Connection)this.statement.connection, ts, cal);
                }
            }
            TIMESTAMPTZ tIMESTAMPTZ = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$11, this, tIMESTAMPTZ);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$11, this, null);
            }
            return tIMESTAMPTZ;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$12, this, n2);
            }
            TIMESTAMPLTZ result = null;
            if (this.definedColumnType == 0) {
                result = super.getTIMESTAMPLTZ((int)currentRow);
            } else {
                String s2 = this.getString((int)currentRow);
                if (s2 != null) {
                    int[] nanos = new int[1];
                    Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                    Timestamp ts = new Timestamp(cal.getTimeInMillis());
                    ts.setNanos(nanos[0]);
                    result = new TIMESTAMPLTZ((Connection)this.statement.connection, ts, cal);
                }
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$12, this, tIMESTAMPLTZ);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$12, this, null);
            }
            return tIMESTAMPLTZ;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    RAW getRAW(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$13, this, n2);
            }
            RAW result = null;
            if (this.definedColumnType == 0) {
                result = super.getRAW((int)currentRow);
            } else if (!this.rowNull[currentRow]) {
                result = this.definedColumnType == -2 || this.definedColumnType == -3 || this.definedColumnType == -4 ? new RAW(this.getBytesFromHexChars((int)currentRow)) : new RAW(super.getBytes((int)currentRow));
            }
            RAW rAW = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$13, this, rAW);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$13, this, null);
            }
            return rAW;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Datum getOracleObject(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, n2);
            }
            if (this.definedColumnType == 0) {
                Datum datum = super.getOracleObject((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, datum);
                    ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, null);
                }
                return datum;
            }
            Datum result = null;
            if (this.rowNull == null) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(21).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, sQLException);
                }
                throw sQLException;
            }
            if (!this.rowNull[currentRow]) {
                switch (this.definedColumnType) {
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: {
                        Datum datum = super.getOracleObject((int)currentRow);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, datum);
                            ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, null);
                        }
                        return datum;
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 16: {
                        NUMBER nUMBER = this.getNUMBER((int)currentRow);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, nUMBER);
                            ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, null);
                        }
                        return nUMBER;
                    }
                    case 91: {
                        DATE dATE = this.getDATE((int)currentRow);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, dATE);
                            ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, null);
                        }
                        return dATE;
                    }
                    case 92: {
                        DATE dATE = this.getDATE((int)currentRow);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, dATE);
                            ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, null);
                        }
                        return dATE;
                    }
                    case 93: {
                        TIMESTAMP tIMESTAMP = this.getTIMESTAMP((int)currentRow);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, tIMESTAMP);
                            ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, null);
                        }
                        return tIMESTAMP;
                    }
                    case -101: {
                        TIMESTAMPTZ tIMESTAMPTZ = this.getTIMESTAMPTZ((int)currentRow);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, tIMESTAMPTZ);
                            ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, null);
                        }
                        return tIMESTAMPTZ;
                    }
                    case -102: {
                        TIMESTAMPLTZ tIMESTAMPLTZ = this.getTIMESTAMPLTZ((int)currentRow);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, tIMESTAMPLTZ);
                            ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, null);
                        }
                        return tIMESTAMPLTZ;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        RAW rAW = this.getRAW((int)currentRow);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, rAW);
                            ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, null);
                        }
                        return rAW;
                    }
                    case -8: {
                        ROWID rOWID = this.getROWID((int)currentRow);
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, rOWID);
                            ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, null);
                        }
                        return rOWID;
                    }
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, sQLException);
                }
                throw sQLException;
            }
            Datum datum = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, datum);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, null);
            }
            return datum;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    byte getByte(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$15, this, n2);
            }
            byte result = 0;
            if (this.definedColumnType == 0) {
                result = super.getByte((int)currentRow);
            } else {
                NUMBER tmp = this.getNUMBER((int)currentRow);
                if (tmp != null) {
                    result = tmp.byteValue();
                }
            }
            byte by = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$15, this, by);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$15, this, null);
            }
            return by;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int getInt(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$16, this, n2);
            }
            int result = 0;
            if (this.definedColumnType == 0) {
                result = super.getInt((int)currentRow);
            } else {
                NUMBER tmp = this.getNUMBER((int)currentRow);
                if (tmp != null) {
                    result = tmp.intValue();
                }
            }
            int n3 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$16, this, n3);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$16, this, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    short getShort(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$17, this, n2);
            }
            short result = 0;
            if (this.definedColumnType == 0) {
                result = super.getShort((int)currentRow);
            } else {
                NUMBER tmp = this.getNUMBER((int)currentRow);
                if (tmp != null) {
                    result = tmp.shortValue();
                }
            }
            short s2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$17, this, s2);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$17, this, null);
            }
            return s2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    long getLong(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$18, this, n2);
            }
            long result = 0L;
            if (this.definedColumnType == 0) {
                result = super.getLong((int)currentRow);
            } else {
                NUMBER tmp = this.getNUMBER((int)currentRow);
                if (tmp != null) {
                    result = tmp.longValue();
                }
            }
            long l2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$18, this, l2);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$18, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    float getFloat(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$19, this, n2);
            }
            float result = 0.0f;
            if (this.definedColumnType == 0) {
                result = super.getFloat((int)currentRow);
            } else {
                NUMBER tmp = this.getNUMBER((int)currentRow);
                if (tmp != null) {
                    result = tmp.floatValue();
                }
            }
            float f2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$19, this, Float.valueOf(f2));
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$19, this, null);
            }
            return f2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    double getDouble(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$20, this, n2);
            }
            double result = 0.0;
            if (this.definedColumnType == 0) {
                result = super.getDouble((int)currentRow);
            } else {
                NUMBER tmp = this.getNUMBER((int)currentRow);
                if (tmp != null) {
                    result = tmp.doubleValue();
                }
            }
            double d2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$20, this, d2);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$20, this, null);
            }
            return d2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Date getDate(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$21, this, n2);
            }
            Date result = null;
            if (this.definedColumnType == 0) {
                result = super.getDate((int)currentRow);
            } else {
                String s2 = this.getString((int)currentRow);
                if (s2 != null) {
                    int[] nanos = new int[1];
                    try {
                        result = new Date(T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCDATEFM"), nanos).getTimeInMillis());
                    }
                    catch (NumberFormatException ex) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)ex).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$21, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$21, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
            }
            Date date = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$21, this, date);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$21, this, null);
            }
            return date;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Timestamp getTimestamp(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$22, this, n2);
            }
            Timestamp result = null;
            if (this.definedColumnType == 0) {
                result = super.getTimestamp((int)currentRow);
            } else {
                String s2 = this.getString((int)currentRow);
                if (s2 != null) {
                    int[] nanos = new int[1];
                    try {
                        Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nanos);
                        result = new Timestamp(cal.getTimeInMillis());
                        result.setNanos(nanos[0]);
                    }
                    catch (NumberFormatException ex) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)ex).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$22, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
            }
            Timestamp timestamp = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$22, this, timestamp);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$22, this, null);
            }
            return timestamp;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Time getTime(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$23, this, n2);
            }
            Time result = null;
            if (this.definedColumnType == 0) {
                result = super.getTime((int)currentRow);
            } else {
                String s2 = this.getString((int)currentRow);
                if (s2 != null) {
                    int[] nanos = new int[1];
                    try {
                        Calendar cal = T4CVarcharAccessor.DATEStringToCalendar(s2, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nanos);
                        result = new Time(cal.getTimeInMillis());
                    }
                    catch (NumberFormatException ex) {
                        SQLException sQLException = (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)ex).fillInStackTrace();
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$23, this, sQLException);
                        }
                        throw sQLException;
                    }
                }
            }
            Time time = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$23, this, time);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$23, this, null);
            }
            return time;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    private final T4CMarshaller getMarshaller() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$24, this, new Object[0]);
            }
            if (this.marshaller == null) {
                this.marshaller = this.describeType == 8 ? T4CMarshaller.LONG : T4CMarshaller.CHAR;
            }
            T4CMarshaller t4CMarshaller = this.marshaller;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$24, this, t4CMarshaller);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$24, this, null);
            }
            return t4CMarshaller;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    Object getObject(int n2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void currentRow;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, n2);
            }
            if (this.definedColumnType == 0) {
                Object object = super.getObject((int)currentRow);
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, object);
                    ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                }
                return object;
            }
            if (this.isUnexpected()) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, sQLException);
                }
                throw sQLException;
            }
            if (this.isNull((int)currentRow)) {
                Object var3_4 = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, var3_4);
                    ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                }
                return null;
            }
            switch (this.definedColumnType) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    String string = this.getString((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, string);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                    }
                    return string;
                }
                case 2: 
                case 3: {
                    BigDecimal bigDecimal = this.getBigDecimal((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, bigDecimal);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                    }
                    return bigDecimal;
                }
                case 4: {
                    Integer n3 = this.getInt((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, n3);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                    }
                    return n3;
                }
                case -6: {
                    Byte by = this.getByte((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, by);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                    }
                    return by;
                }
                case 5: {
                    Short s2 = this.getShort((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, s2);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                    }
                    return s2;
                }
                case -7: 
                case 16: {
                    Boolean bl2 = this.getBoolean((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, bl2);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                    }
                    return bl2;
                }
                case -5: {
                    Long l2 = this.getLong((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, l2);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                    }
                    return l2;
                }
                case 7: {
                    Float f2 = Float.valueOf(this.getFloat((int)currentRow));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, f2);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                    }
                    return f2;
                }
                case 6: 
                case 8: {
                    Double d2 = this.getDouble((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, d2);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                    }
                    return d2;
                }
                case 91: {
                    Date date = this.getDate((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, date);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                    }
                    return date;
                }
                case 92: {
                    Time time = this.getTime((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, time);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                    }
                    return time;
                }
                case 93: {
                    Timestamp timestamp = this.getTimestamp((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, timestamp);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                    }
                    return timestamp;
                }
                case -4: 
                case -3: 
                case -2: {
                    byte[] byArray = this.getBytesFromHexChars((int)currentRow);
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, byArray);
                        ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, null);
                    }
                    return byArray;
                }
            }
            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
            if (bl) {
                ClioSupport.throwing($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, sQLException);
            }
            throw sQLException;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$25, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    AccessorPrototype newPrototype(int n2) {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            AccessorPrototype p2;
            void numRows;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$26, this, n2);
            }
            if (!$assertionsDisabled && numRows < 0) {
                AssertionError assertionError = new AssertionError((Object)("numRows: " + (int)numRows));
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$26, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$26, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            AccessorPrototype accessorPrototype = p2 = new AccessorPrototype((int)numRows, this, this.statement.rowData){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                Accessor newAccessor(OracleStatement stmt) throws SQLException {
                    T4CCharAccessor acc = new T4CCharAccessor(stmt, T4CCharAccessor.this.describeMaxLength, T4CCharAccessor.this.nullable, -1, T4CCharAccessor.this.precision, T4CCharAccessor.this.scale, T4CCharAccessor.this.contflag, -1, T4CCharAccessor.this.formOfUse, T4CCharAccessor.this.describeMaxLengthChars, T4CCharAccessor.this.oacmxl, T4CCharAccessor.this.definedColumnType, T4CCharAccessor.this.definedColumnSize, null);
                    this.initializeRowData(acc);
                    return acc;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(T4CCharAccessor.class, Integer.TYPE, Accessor.class, ByteArray.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("newAccessor", OracleStatement.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                }
            };
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$26, this, accessorPrototype);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$26, this, null);
            }
            return accessorPrototype;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, T4CCharAccessor.class, $$$methodRef$$$26, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$28 = T4CCharAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = T4CCharAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Short.TYPE, Integer.TYPE, Boolean.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = T4CCharAccessor.class.getDeclaredMethod("newPrototype", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = T4CCharAccessor.class.getDeclaredMethod("getObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = T4CCharAccessor.class.getDeclaredMethod("getMarshaller", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = T4CCharAccessor.class.getDeclaredMethod("getTime", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = T4CCharAccessor.class.getDeclaredMethod("getTimestamp", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = T4CCharAccessor.class.getDeclaredMethod("getDate", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = T4CCharAccessor.class.getDeclaredMethod("getDouble", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = T4CCharAccessor.class.getDeclaredMethod("getFloat", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = T4CCharAccessor.class.getDeclaredMethod("getLong", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = T4CCharAccessor.class.getDeclaredMethod("getShort", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = T4CCharAccessor.class.getDeclaredMethod("getInt", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CCharAccessor.class.getDeclaredMethod("getByte", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CCharAccessor.class.getDeclaredMethod("getOracleObject", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CCharAccessor.class.getDeclaredMethod("getRAW", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CCharAccessor.class.getDeclaredMethod("getTIMESTAMPLTZ", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CCharAccessor.class.getDeclaredMethod("getTIMESTAMPTZ", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CCharAccessor.class.getDeclaredMethod("getTIMESTAMP", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CCharAccessor.class.getDeclaredMethod("getDATE", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CCharAccessor.class.getDeclaredMethod("getNUMBER", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CCharAccessor.class.getDeclaredMethod("readStreamFromWire", byte[].class, Integer.TYPE, Integer.TYPE, int[].class, boolean[].class, boolean[].class, T4CMAREngine.class, T4CTTIoer11.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CCharAccessor.class.getDeclaredMethod("unmarshalOneRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CCharAccessor.class.getDeclaredMethod("copyRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CCharAccessor.class.getDeclaredMethod("reinitForResultSetCache", ByteArray.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CCharAccessor.class.getDeclaredMethod("getPreviousRowProcessed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CCharAccessor.class.getDeclaredMethod("processIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CCharAccessor.class.getDeclaredMethod("unmarshalColumnMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CCharAccessor.class.getDeclaredMethod("getMAREngine", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

