/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.spi;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary;
import java.lang.invoke.MethodHandles;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=BackendNativePointerLibrary.class)
final class BackendNativePointerLibraryGen
extends LibraryFactory<BackendNativePointerLibrary> {
    private static final Class<BackendNativePointerLibrary> LIBRARY_CLASS = BackendNativePointerLibraryGen.lazyLibraryClass();
    private static final Message IS_POINTER = new MessageImpl("isPointer", 0, false, Boolean.TYPE, Object.class);
    private static final Message AS_POINTER = new MessageImpl("asPointer", 1, false, Long.TYPE, Object.class);
    private static final BackendNativePointerLibraryGen INSTANCE = new BackendNativePointerLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private BackendNativePointerLibraryGen() {
        super(LIBRARY_CLASS, List.of(IS_POINTER, AS_POINTER));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return BackendNativePointerLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected BackendNativePointerLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected BackendNativePointerLibrary createDelegate(BackendNativePointerLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        BackendNativePointerLibrary lib = (BackendNativePointerLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.isPointer(receiver);
            }
            case 1: {
                return lib.asPointer(receiver);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected BackendNativePointerLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected BackendNativePointerLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<BackendNativePointerLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.nfi.backend.spi.BackendNativePointerLibrary", false, BackendNativePointerLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=BackendNativePointerLibrary.class)
    private static final class Proxy
    extends BackendNativePointerLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isPointer(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_POINTER, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            try {
                return (Long)this.lib.send(receiver_, AS_POINTER, new Object[0]);
            }
            catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=BackendNativePointerLibrary.class)
    private static final class Delegate
    extends BackendNativePointerLibrary {
        @Node.Child
        private BackendNativePointerLibrary delegateLibrary;

        Delegate(BackendNativePointerLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isPointer(Object receiver_) {
            if (BackendNativePointerLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = BackendNativePointerLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((BackendNativePointerLibrary)BackendNativePointerLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isPointer(delegate);
            }
            return this.delegateLibrary.isPointer(receiver_);
        }

        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            if (BackendNativePointerLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = BackendNativePointerLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((BackendNativePointerLibrary)BackendNativePointerLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).asPointer(delegate);
            }
            return this.delegateLibrary.asPointer(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=BackendNativePointerLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch
    implements GenerateAOT.Provider {
        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(BackendNativePointerLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport export : INSTANCE.getAOTExports()) {
                BackendNativePointerLibrary exportLibrary = (BackendNativePointerLibrary)INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = (BackendNativePointerLibrary)this.insert((Node)exportLibrary);
                    continue;
                }
                this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext(exportLibrary, this.next));
            }
            this.aot_ = true;
        }
    }

    @GeneratedBy(value=BackendNativePointerLibrary.class)
    private static abstract class CachedDispatch
    extends BackendNativePointerLibrary {
        @Node.Child
        BackendNativePointerLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(BackendNativePointerLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean var1);

        @Override
        @ExplodeLoop
        public boolean isPointer(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    BackendNativePointerLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isPointer(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    BackendNativePointerLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.asPointer(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.isAOT()) {
                    this.library = null;
                    this.next = null;
                    this.setAOT(false);
                }
                CachedDispatch current = this;
                BackendNativePointerLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (BackendNativePointerLibrary)this.insert((Node)((BackendNativePointerLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        BackendNativePointerLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (BackendNativePointerLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((BackendNativePointerLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=BackendNativePointerLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends BackendNativePointerLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isPointer(Object receiver_) {
            return ((BackendNativePointerLibrary)INSTANCE.getUncached(receiver_)).isPointer(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            return ((BackendNativePointerLibrary)INSTANCE.getUncached(receiver_)).asPointer(receiver_);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=BackendNativePointerLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=BackendNativePointerLibrary.class)
    private static final class Default
    extends LibraryExport<BackendNativePointerLibrary> {
        private Default() {
            super(BackendNativePointerLibrary.class, Object.class, false, false, 0);
        }

        protected BackendNativePointerLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected BackendNativePointerLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=BackendNativePointerLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends BackendNativePointerLibrary
        implements UnadoptableNode {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPointer(receiver);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.asPointer(receiver);
            }
        }

        @GeneratedBy(value=BackendNativePointerLibrary.class)
        private static final class Cached
        extends BackendNativePointerLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public boolean isPointer(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.isPointer(this.dynamicDispatch_.cast(receiver));
            }

            @Override
            public long asPointer(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return super.asPointer(this.dynamicDispatch_.cast(receiver));
            }
        }
    }

    @GeneratedBy(value=BackendNativePointerLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(BackendNativePointerLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=BackendNativePointerLibrary.class)
    private static final class CachedToUncachedDispatch
    extends BackendNativePointerLibrary {
        private CachedToUncachedDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isPointer(Object receiver_) {
            assert (BackendNativePointerLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((BackendNativePointerLibrary)INSTANCE.getUncached(receiver_)).isPointer(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            assert (BackendNativePointerLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((BackendNativePointerLibrary)INSTANCE.getUncached(receiver_)).asPointer(receiver_);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

